/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.Log;
import com.t4login.api.accounts.Account;
import com.t4login.messages.Message;
import com.t4login.messages.MsgAccountDetails;
import com.t4login.messages.MsgAccountUpdate2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccountDataSnapshot {
    private static final String TAG = "AccountDataSnapshot";
    public final Account Account;
    public MsgAccountDetails msgAccountDetails;
    public MsgAccountUpdate2 msgAccountUpdate2;
    public static final AccountDataSnapshot Empty = new AccountDataSnapshot();

    private AccountDataSnapshot() {
        this.Account = null;
    }

    AccountDataSnapshot(Account acct, AccountDataSnapshot prev) {
        this(acct, prev, new ArrayList<Message>());
    }

    AccountDataSnapshot(Account acct, AccountDataSnapshot prev, Message msg) {
        this(acct, prev, Collections.singletonList(msg));
    }

    AccountDataSnapshot(Account acct, AccountDataSnapshot prev, List<Message> messages) {
        this.Account = acct;
        if (prev != null) {
            this.msgAccountDetails = prev.msgAccountDetails;
            this.msgAccountUpdate2 = prev.msgAccountUpdate2;
        }
        block4: for (Message msg : messages) {
            switch (msg.getMessageType()) {
                case AccountDetails: 
                case AccountDetails2: {
                    this.msgAccountDetails = (MsgAccountDetails)msg;
                    break;
                }
                case AccountUpdate2: {
                    this.msgAccountUpdate2 = (MsgAccountUpdate2)msg;
                    if (!acct.isComplete() || !acct.getUPLEnabled()) continue block4;
                    break;
                }
                default: {
                    Log.e(TAG, "Unknown message type: " + String.valueOf((Object)msg.getMessageType()));
                }
            }
        }
    }
}

