/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.api.Market;
import com.t4login.api.OrderPull;
import com.t4login.api.OrderRevise;
import com.t4login.api.OrderSubmit;
import com.t4login.api.OrderSubmitAction;
import com.t4login.api.PriceFormatter;
import com.t4login.api.SubmitResult;
import com.t4login.api.T4HostService;
import com.t4login.api.accounts.Account;
import com.t4login.api.accounts.AccountDataSnapshot;
import com.t4login.api.accounts.IAccountDataHandler;
import com.t4login.api.accounts.Order;
import com.t4login.api.accounts.Position;
import com.t4login.api.accounts.Trade;
import com.t4login.api.currencies.Currency;
import com.t4login.application.settings.AppSettings;
import com.t4login.connection.IMessageHandler;
import com.t4login.definitions.AccountBuffer;
import com.t4login.definitions.AccountMode;
import com.t4login.definitions.AccountStatus;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.messages.Message;
import com.t4login.messages.MsgAccountCurrency;
import com.t4login.messages.MsgAccountDayChange;
import com.t4login.messages.MsgAccountDetails;
import com.t4login.messages.MsgAccountNotify;
import com.t4login.messages.MsgAccountPosition2;
import com.t4login.messages.MsgAccountSnapshot;
import com.t4login.messages.MsgAccountSubscribe;
import com.t4login.messages.MsgAccountUpdate2;
import com.t4login.messages.MsgApplicationSignal;
import com.t4login.messages.MsgLoginResponse2;
import com.t4login.messages.MsgOrderHistory2;
import com.t4login.messages.MsgOrderPerformance3;
import com.t4login.messages.MsgOrderPull2;
import com.t4login.messages.MsgOrderRevision2;
import com.t4login.messages.MsgOrderSubmission2;
import com.t4login.messages.MsgOrderUpdateMultiD;
import com.t4login.messages.application.MsgServiceStateChange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AccountData {
    private static final String TAG = "AccountData";
    private static final String SETTINGS_KEY_ACTIVEACCOUNTID = "active_account_id";
    private final T4HostService mT4Service;
    private List<IAccountDataHandler> mAccountDataHandlers = new CopyOnWriteArrayList<IAccountDataHandler>();
    private ConcurrentHashMap<String, Account> mAccounts = new ConcurrentHashMap(10, 0.9f, 1);
    private final Hashtable<String, Currency> mCurrencies = new Hashtable();

    public AccountData(T4HostService s) {
        this.mT4Service = s;
        s.registerMessageHandler(new IMessageHandler(){

            @Override
            public void onMessage(Message msg) {
                AccountData.this.onMessage(msg);
            }
        });
    }

    private Boolean manageOrderChangeAlerts() {
        return true;
    }

    public void registerForAccountData(IAccountDataHandler handler) {
        if (!this.mAccountDataHandlers.contains(handler)) {
            Log.d(TAG, "registerForAccountData(), Registering account data handler '" + handler.getDescription() + "'");
            this.mAccountDataHandlers.add(handler);
        } else {
            Log.d(TAG, "registerForAccountData(), Account data handler '" + handler.getDescription() + "' already registered!");
        }
    }

    public void unregisterForAccountData(IAccountDataHandler handler) {
        if (this.mAccountDataHandlers.contains(handler)) {
            Log.d(TAG, "unregisterForAccountData(), Unregistering account data handler '" + handler.getDescription() + "'");
            this.mAccountDataHandlers.remove(handler);
        } else {
            Log.d(TAG, "unregisterForAccountData(), Account data handler '" + handler.getDescription() + "' not registered!");
        }
    }

    public int getAccountCount() {
        return this.mAccounts.size();
    }

    public List<Account> getAccounts() {
        ArrayList<Account> accounts = new ArrayList<Account>(this.mAccounts.values());
        Collections.sort(accounts);
        return accounts;
    }

    public Account getAccount(String accountID) {
        return this.mAccounts.get(accountID);
    }

    public boolean areAccountsLoaded() {
        for (Account acct : this.mAccounts.values()) {
            if (acct.isComplete()) continue;
            return false;
        }
        return true;
    }

    public int getAccountsLoaded() {
        int loaded = 0;
        for (Account acct : this.mAccounts.values()) {
            if (!acct.isComplete()) continue;
            ++loaded;
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position getPosition(String accountID, String marketID) {
        Account account = this.mAccounts.get(accountID);
        if (account != null) {
            Account account2 = account;
            synchronized (account2) {
                return account.getPosition(marketID, false);
            }
        }
        return null;
    }

    public void Initialize() {
        Log.e(TAG, "Initialize(), Initializing AccountData.");
        for (Account acct : this.mAccounts.values()) {
            acct.setSubscribed(false);
            this.subscribeAccount(acct);
        }
    }

    public void Disconnected() {
    }

    private void subscribeAccount(Account acct) {
        if (acct != null && !acct.isSubscribed()) {
            acct.setSubscribed(true);
            Log.d(TAG, "Subscribing account '" + acct.getAccountID() + "'");
            MsgAccountSubscribe msg = new MsgAccountSubscribe();
            msg.Subscribe = AccountBuffer.Buffered;
            msg.Accounts.add(new MsgAccountSubscribe.Account(acct.getAccountID(), acct.getLastOrderUpdate()));
            this.mT4Service.sendMessage(msg);
        }
    }

    private void unSubscribeAccount(Account acct) {
        if (acct != null && acct.isSubscribed()) {
            acct.setSubscribed(false);
            Log.d(TAG, "Un-subscribing account '" + acct.getAccountID() + "'");
            MsgAccountSubscribe msg = new MsgAccountSubscribe();
            msg.Subscribe = AccountBuffer.NoSubscription;
            msg.Accounts.add(new MsgAccountSubscribe.Account(acct.getAccountID(), acct.getLastOrderUpdate()));
            this.mT4Service.sendMessage(msg);
        }
    }

    private void onMessage(Message msg) {
        switch (msg.getMessageType()) {
            case LoginResponse2: {
                this.processLoginResponse((MsgLoginResponse2)msg);
                break;
            }
            case SignalMessage: {
                this.processApplicationSignal((MsgApplicationSignal)msg);
                break;
            }
            case AccountDetails: 
            case AccountDetails2: {
                this.processAccountDetails((MsgAccountDetails)msg);
                break;
            }
            case AccountUpdate2: {
                this.processAccountUpdate2((MsgAccountUpdate2)msg);
                break;
            }
            case AccountPosition2: {
                this.processAccountPosition2((MsgAccountPosition2)msg);
                break;
            }
            case AccountDayChange: {
                this.processAccountDayChange((MsgAccountDayChange)msg);
                break;
            }
            case AccountNotify: {
                this.processAccountNotify((MsgAccountNotify)msg);
                break;
            }
            case AccountSnapshot: {
                this.processAccountSnapshot((MsgAccountSnapshot)msg);
                break;
            }
            case OrderUpdateMultiD: {
                this.processOrderUpdateMulti((MsgOrderUpdateMultiD)msg);
                break;
            }
            case OrderHistory2: {
                this.processOrderHistory2((MsgOrderHistory2)msg);
                break;
            }
            case OrderPerformance3: {
                this.processOrderPerformance3((MsgOrderPerformance3)msg);
                break;
            }
            case AccountCurrency: {
                this.processAccountCurrency((MsgAccountCurrency)msg);
                break;
            }
        }
    }

    private void processLoginResponse(MsgLoginResponse2 msg) {
        Log.d(TAG, "processLoginResponse(), Msg: " + msg.toString());
        ConcurrentHashMap<String, Account> accounts = new ConcurrentHashMap<String, Account>(msg.Accounts.size(), 0.9f, 1);
        for (MsgLoginResponse2.Account account : msg.Accounts) {
            Account acct = new Account(account.AccountID, account.AccountNumber, account.AccountName, account.DisplayName, account.Mode);
            accounts.put(account.AccountID, acct);
        }
        if (this.mAccounts.size() > 0) {
            for (Map.Entry entry : this.mAccounts.entrySet()) {
                accounts.putIfAbsent((String)entry.getKey(), (Account)entry.getValue());
            }
        }
        this.mAccounts = accounts;
    }

    private void processApplicationSignal(MsgApplicationSignal msg) {
        switch (msg.getSignal()) {
            case ServiceStateChange: {
                MsgServiceStateChange ssmsg = (MsgServiceStateChange)msg;
                switch (ssmsg.getNewState()) {
                    case Connected: {
                        this.Initialize();
                        break;
                    }
                    case Disconnected: {
                        for (Account acct : this.mAccounts.values()) {
                            acct.setSubscribed(false);
                        }
                        break;
                    }
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAccountDetails(MsgAccountDetails msg) {
        Account acct = this.getOrCreateAccount(msg.AccountID, msg.Account, msg.AccountName, msg.DisplayName, msg.Mode);
        Log.d(TAG, "processAccountDetails(), Updated account details: " + msg.toString());
        Account account = acct;
        synchronized (account) {
            MsgAccountUpdate2 updateMsg;
            AccountDataSnapshot snapShot = acct.processAccountDetails(msg);
            if (acct.isComplete() && (updateMsg = snapShot.msgAccountUpdate2) != null && updateMsg.Status == AccountStatus.NotAccessible && acct.isSubscribed()) {
                acct.setSubscribed(false);
                this.subscribeAccount(acct);
            }
            if (acct.isComplete()) {
                for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                    cb.onAccountDetails(acct);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAccountUpdate2(MsgAccountUpdate2 msg) {
        Account acct = this.mAccounts.get(msg.AccountID);
        if (acct == null) {
            Log.e(TAG, "Account '" + msg.AccountID + "' not found.");
        } else {
            Account account = acct;
            synchronized (account) {
                acct.processAccountUpdate(msg);
                if (acct.isComplete()) {
                    for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                        cb.onAccountUpdate(acct, false);
                    }
                    if (msg.Status == AccountStatus.NotAccessible || msg.Status == AccountStatus.Unknown) {
                        acct.setComplete(false);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAccountPosition2(MsgAccountPosition2 msg) {
        Account acct = this.mAccounts.get(msg.AccountID);
        if (acct == null) {
            Log.e(TAG, "processAccountPosition2(), Account '" + msg.AccountID + "' not found.");
        } else {
            Account account = acct;
            synchronized (account) {
                Position pos = acct.getPosition(msg.MarketID);
                pos.processAccountPosition(msg);
                if (acct.isComplete()) {
                    for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                        cb.onPositionUpdate(acct, pos);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAccountDayChange(MsgAccountDayChange msg) {
        Account acct = this.mAccounts.get(msg.AccountID);
        if (acct == null) {
            Log.e(TAG, "processAccountDayChange(), Account '" + msg.AccountID + "' not found.");
        } else {
            Account account = acct;
            synchronized (account) {
                Position pos = acct.getPosition(msg.MarketID, false);
                if (pos != null) {
                    List<Order> removedOrders = pos.processPositionDayChange(msg);
                    for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                        cb.onPositionDayChange(acct, pos, removedOrders);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAccountNotify(MsgAccountNotify msg) {
        Account acct = this.mAccounts.get(msg.AccountID);
        if (acct == null) {
            Log.e(TAG, "processAccountNotify(), Account '" + msg.AccountID + "' not found.");
        } else {
            Account account = acct;
            synchronized (account) {
                for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                    cb.onAccountNotify(acct, msg.Text, msg.Important);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAccountComplete(Account acct) {
        Log.d(TAG, "processAccountComplete(), Account '" + acct.getAccountID() + "' complete.");
        Account account = acct;
        synchronized (account) {
            acct.setComplete(true);
            for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                cb.onAccountDetails(acct);
            }
            for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                cb.onAccountUpdate(acct, false);
            }
            for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                cb.onAccountComplete(acct);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAccountSnapshot(MsgAccountSnapshot msg) {
        Account acct = this.mAccounts.get(msg.AccountID);
        if (acct == null) {
            Log.e(TAG, "processAccountSnapshot(), Account '" + msg.AccountID + "' not found.");
        } else {
            Account account = acct;
            synchronized (account) {
                for (Message acctMsg : msg.Messages) {
                    this.onMessage(acctMsg);
                }
                this.processAccountComplete(acct);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOrderUpdateMulti(MsgOrderUpdateMultiD msg) {
        Account acct = this.mAccounts.get(msg.AccountID);
        if (acct == null) {
            Log.e(TAG, "processOrderUpdateMulti(), Account '" + msg.AccountID + "' not found.");
        } else {
            Account account = acct;
            synchronized (account) {
                ArrayList<Order> ordersAdded = new ArrayList<Order>();
                ArrayList<Order> ordersUpdated = new ArrayList<Order>();
                ArrayList<Trade> tradesAdded = new ArrayList<Trade>();
                acct.processOrderUpdate(msg, ordersAdded, ordersUpdated, tradesAdded);
                if (acct.isComplete()) {
                    String cbDescription;
                    int nHandlers;
                    if (ordersAdded.size() > 0) {
                        nHandlers = this.mAccountDataHandlers.size();
                        for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                            cbDescription = cb.getDescription();
                            cb.onOrderAdded(acct, acct.getPosition(msg.MarketID), ordersAdded);
                        }
                    }
                    if (ordersUpdated.size() > 0) {
                        nHandlers = this.mAccountDataHandlers.size();
                        for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                            cbDescription = cb.getDescription();
                            cb.onOrderUpdate(acct, acct.getPosition(msg.MarketID), ordersUpdated);
                        }
                    }
                    if (tradesAdded.size() > 0) {
                        nHandlers = this.mAccountDataHandlers.size();
                        for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                            cbDescription = cb.getDescription();
                            cb.onTrades(acct, acct.getPosition(msg.MarketID), tradesAdded);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOrderHistory2(MsgOrderHistory2 msg) {
        Account acct = this.mAccounts.get(msg.AccountID);
        if (acct == null) {
            Log.e(TAG, "processOrderHistory2(), Account '" + msg.AccountID + "' not found.");
        } else {
            Account account = acct;
            synchronized (account) {
                Order order = acct.processOrderHistory(msg);
                if (order != null) {
                    for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                        cb.onOrderHistory(acct, acct.getPosition(msg.MarketID), order);
                    }
                }
            }
        }
    }

    private void processOrderPerformance3(MsgOrderPerformance3 msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAccountCurrency(MsgAccountCurrency msg) {
        Hashtable<String, Currency> hashtable = this.mCurrencies;
        synchronized (hashtable) {
            this.mCurrencies.put(msg.Currency, new Currency(msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Currency getCurrency(String curr) {
        Hashtable<String, Currency> hashtable = this.mCurrencies;
        synchronized (hashtable) {
            Currency currency = this.mCurrencies.get(curr);
            if (currency == null) {
                currency = new Currency(curr);
                this.mCurrencies.put(curr, currency);
            }
            return currency;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitNewOrder(OrderSubmitAction orderSubmitAction) {
        Account account = this.getAccount(orderSubmitAction.AccountID);
        if (account != null) {
            Account account2 = account;
            synchronized (account2) {
                Position position = account.getPosition(orderSubmitAction.Market.getMarketID(), true);
                MsgOrderSubmission2 submissionMsg = position.createNewOrder(orderSubmitAction);
                this.mT4Service.sendMessage(submissionMsg);
                Object summary = Order.getOrderTypeDisplay(submissionMsg, new PriceFormatter(this){

                    @Override
                    public String formatPrice(Market market, Price price) {
                        return PriceFormat.convertPriceToDisplayFormat(price, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay);
                    }
                }, orderSubmitAction.Market);
                summary = (String)summary + " x" + orderSubmitAction.Volume;
                orderSubmitAction.setSubmitResult(SubmitResult.SubmitSuccess, (String)summary);
                Log.d(TAG, "submitNewOrder(), Submitted new limit order " + orderSubmitAction.Volume + " limit " + orderSubmitAction.Volume + "@" + String.valueOf(orderSubmitAction.LimitPrice));
                ArrayList<Order> ordersAdded = new ArrayList<Order>();
                ordersAdded.add(orderSubmitAction.getOrder());
                for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                    cb.onOrderAdded(account, position, ordersAdded);
                }
            }
        } else {
            orderSubmitAction.setSubmitResult(SubmitResult.SubmitFailed, "Account not found.");
            Log.e(TAG, "submitNewOrder(), Account '" + orderSubmitAction.AccountID + "' not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitNewOrder(OrderSubmit orderSubmit) {
        Account account = this.getAccount(orderSubmit.get((int)0).AccountID);
        if (account != null) {
            Account account2 = account;
            synchronized (account2) {
                Position position = account.getPosition(orderSubmit.get((int)0).Market.getMarketID(), true);
                MsgOrderSubmission2 submissionMsg = position.createNewOrder(orderSubmit);
                this.mT4Service.sendMessage(submissionMsg);
                ArrayList<Order> ordersAdded = new ArrayList<Order>();
                for (int i = 0; i < orderSubmit.count(); ++i) {
                    OrderSubmitAction orderSubmitAction = orderSubmit.get(i);
                    Object summary = Order.getOrderTypeDisplay(submissionMsg, i, new PriceFormatter(this){

                        @Override
                        public String formatPrice(Market market, Price price) {
                            return PriceFormat.convertPriceToDisplayFormat(price, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay);
                        }
                    }, orderSubmitAction.Market);
                    summary = (String)summary + " x" + orderSubmitAction.Volume;
                    orderSubmitAction.setSubmitResult(SubmitResult.SubmitSuccess, (String)summary);
                    Log.d(TAG, "submitNewOrder(), Submitted new order: " + (String)summary);
                    ordersAdded.add(orderSubmitAction.getOrder());
                }
                orderSubmit.setSubmitResult(SubmitResult.SubmitSuccess);
                for (IAccountDataHandler cb : this.mAccountDataHandlers) {
                    cb.onOrderAdded(account, position, ordersAdded);
                }
            }
        } else {
            orderSubmit.setSubmitResult(SubmitResult.SubmitFailed, "Account not found.");
            Log.e(TAG, "submitNewOrder(), Account '" + orderSubmit.get((int)0).AccountID + "' not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviseOrders(OrderRevise orderRevise) {
        Account account = this.getAccount(orderRevise.AccountID);
        if (account != null) {
            Account account2 = account;
            synchronized (account2) {
                Position position = account.getPosition(orderRevise.Market.getMarketID(), true);
                List<MsgOrderRevision2> revisionMsgs = position.reviseOrders(orderRevise);
                for (MsgOrderRevision2 revisionMsg : revisionMsgs) {
                    boolean res = this.mT4Service.sendMessage(revisionMsg);
                    if (res) {
                        orderRevise.setSubmitResult(SubmitResult.SubmitSuccess);
                        Log.d(TAG, "reviseOrders(), Submitted order revision.");
                        continue;
                    }
                    orderRevise.setSubmitResult(SubmitResult.SubmitSuccess);
                    Log.d(TAG, "reviseOrders(), Submission failed.");
                }
            }
        } else {
            orderRevise.setSubmitResult(SubmitResult.SubmitFailed, Resource.localizeString("order_pull_failed_accountnotfound"));
            Log.e(TAG, "reviseOrders(), Account '" + orderRevise.AccountID + "' not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullOrders(OrderPull pull) {
        Account account = this.getAccount(pull.AccountID);
        if (account != null) {
            boolean pullSubmitted = false;
            String msg = "";
            ArrayList<String> pulledOrderIDs = new ArrayList<String>();
            Account account2 = account;
            synchronized (account2) {
                Position position = account.getPosition(pull.Market.getMarketID(), true);
                if (pull.OrderIDs.size() == 0) {
                    List<MsgOrderPull2> pullMsgs = position.pullOrders(pull.AccountID, pull.Market, pull.Side, pull.Price);
                    for (MsgOrderPull2 pullMsg : pullMsgs) {
                        if (pullMsg.Orders.size() <= 0) continue;
                        this.mT4Service.sendMessage(pullMsg);
                        pullSubmitted = true;
                        for (MsgOrderPull2.Order pullOrder : pullMsg.Orders) {
                            pulledOrderIDs.add(pullOrder.UniqueID);
                        }
                        Log.d(TAG, "pullOrders(), Pull " + String.valueOf(pull.Side) + " orders @" + String.valueOf(pull.Price));
                    }
                } else {
                    List<MsgOrderPull2> pullMsgs = position.pullOrders(pull.AccountID, pull.Market, pull.OrderIDs);
                    for (MsgOrderPull2 pullMsg : pullMsgs) {
                        if (pullMsg.Orders.size() <= 0) continue;
                        this.mT4Service.sendMessage(pullMsg);
                        pullSubmitted = true;
                        for (MsgOrderPull2.Order pullOrder : pullMsg.Orders) {
                            pulledOrderIDs.add(pullOrder.UniqueID);
                        }
                        Log.d(TAG, "pullOrders(), Pull " + String.valueOf(pull.Side) + " orders @" + String.valueOf(pull.Price));
                    }
                }
            }
            if (pullSubmitted) {
                pull.setSubmissionResult(SubmitResult.SubmitSuccess, msg, pulledOrderIDs);
            } else {
                pull.setSubmissionResult(SubmitResult.NotSubmitted, msg, pulledOrderIDs);
            }
        } else {
            Log.e(TAG, "pullOrders(), Account '" + pull.AccountID + "' not found.");
            pull.setSubmissionResult(SubmitResult.SubmitFailed, Resource.localizeString("order_pull_failed_accountnotfound"), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullOrders(String accountID, Market market) {
        Account account = this.getAccount(accountID);
        if (account != null) {
            Account account2 = account;
            synchronized (account2) {
                Position position = account.getPosition(market.getMarketID(), true);
                List<MsgOrderPull2> pullMsgs = position.pullOrders(accountID, market);
                for (MsgOrderPull2 pullMsg : pullMsgs) {
                    if (pullMsg.Orders.size() <= 0) continue;
                    this.mT4Service.sendMessage(pullMsg);
                }
            }
        } else {
            Log.e(TAG, "pullOrders(), Account '" + accountID + "' not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullOrder(String accountID, String marketID, String orderID) {
        Account account = this.getAccount(accountID);
        if (account != null) {
            Account account2 = account;
            synchronized (account2) {
                Position position = account.getPosition(marketID, true);
                MsgOrderPull2 pullMsg = position.pullOrder(orderID);
                if (pullMsg != null && pullMsg.Orders.size() > 0) {
                    this.mT4Service.sendMessage(pullMsg);
                } else {
                    Log.e(TAG, "pullOrder(), Order '" + orderID + "' not found.");
                }
            }
        } else {
            Log.e(TAG, "pullOrder(), Account '" + accountID + "' not found.");
        }
    }

    private Account getOrCreateAccount(String acctID, String acctNumber, String acctName, String displayName, AccountMode mode) {
        Account acct = this.mAccounts.get(acctID);
        if (acct == null) {
            acct = new Account(acctID, acctNumber, acctName, displayName, mode);
            this.mAccounts.put(acctID, acct);
        }
        return acct;
    }
}

