/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api.accounts;

import com.t4login.api.accounts.AccountDataSnapshot;
import com.t4login.api.accounts.Order;
import com.t4login.api.accounts.Position;
import com.t4login.api.accounts.Trade;
import com.t4login.application.settings.AccountDisplayType;
import com.t4login.definitions.AccountEnabled;
import com.t4login.definitions.AccountMode;
import com.t4login.messages.MsgAccountDetails;
import com.t4login.messages.MsgAccountUpdate2;
import com.t4login.messages.MsgOrderHistory2;
import com.t4login.messages.MsgOrderUpdateMultiD;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class Account
implements Comparable<Account> {
    public final String mAccountID;
    public final String mAccountNumber;
    public final String mAccountName;
    public final String mDisplayName;
    public final AccountMode mMode;
    private MsgAccountDetails mDetails;
    private AccountDataSnapshot mSnapshot;
    private long mLastOrderUpdate = 0L;
    private final ConcurrentHashMap<String, Position> mPositions = new ConcurrentHashMap(50, 0.9f, 1);
    private boolean mEnableUPL = true;
    private boolean mSubscribed = false;
    private boolean mComplete = false;

    public String getAccountID() {
        if (this.mDetails == null) {
            return this.mAccountID;
        }
        return this.mDetails.AccountID;
    }

    public String getAccountNumber() {
        if (this.mDetails == null) {
            return this.mAccountNumber;
        }
        return this.mDetails.Account;
    }

    public String getAccountName() {
        if (this.mDetails == null) {
            return this.mAccountName;
        }
        return this.mDetails.AccountName;
    }

    public Account(String acctID, String acctNumber, String acctName, String acctDisplayName, AccountMode acctMode) {
        this.mAccountID = acctID;
        this.mAccountNumber = acctNumber;
        this.mAccountName = acctName;
        this.mDisplayName = acctDisplayName;
        this.mMode = acctMode;
    }

    public String toString() {
        return this.getAccountNumber() + " " + this.getDisplayName();
    }

    public AccountDataSnapshot getSnapshot() {
        return this.mSnapshot;
    }

    public MsgAccountDetails getAccountDetailsMessage() {
        return this.mDetails;
    }

    public MsgAccountUpdate2 getAccountUpdateMessage() {
        if (this.mSnapshot != null) {
            return this.mSnapshot.msgAccountUpdate2;
        }
        return null;
    }

    public AccountEnabled getAccountEnabled() {
        if (this.mDetails != null) {
            return this.mDetails.Enabled;
        }
        return AccountEnabled.Disabled;
    }

    public Position getPosition(String marketID) {
        return this.getPosition(marketID, true);
    }

    public Position getPosition(String marketID, boolean create) {
        Position pos;
        if (create) {
            pos = new Position(this.mAccountID, marketID);
            Position existingPos = this.mPositions.putIfAbsent(marketID, pos);
            if (existingPos != null) {
                pos = existingPos;
            }
        } else {
            pos = this.mPositions.get(marketID);
        }
        return pos;
    }

    public int getPositionCount() {
        return this.mPositions.size();
    }

    public Iterable<Position> getPositions() {
        return this.mPositions.values();
    }

    public long getLastOrderUpdate() {
        return this.mLastOrderUpdate;
    }

    public boolean isSubscribed() {
        return this.mSubscribed;
    }

    public void setSubscribed(boolean subscribed) {
        this.mSubscribed = subscribed;
        this.mComplete = false;
    }

    public boolean isComplete() {
        return this.mComplete;
    }

    public AccountDataSnapshot setComplete(boolean complete) {
        this.mComplete = complete;
        if (this.mEnableUPL) {
            AccountDataSnapshot snapShot;
            this.mSnapshot = snapShot = new AccountDataSnapshot(this, this.mSnapshot);
            return snapShot;
        }
        return this.mSnapshot;
    }

    public boolean getUPLEnabled() {
        return this.mEnableUPL;
    }

    public void setUPLEnabled(boolean value) {
        this.mEnableUPL = value;
    }

    public AccountDataSnapshot processAccountDetails(MsgAccountDetails msg) {
        AccountDataSnapshot snapShot;
        this.mDetails = msg;
        this.mSnapshot = snapShot = new AccountDataSnapshot(this, this.mSnapshot, msg);
        return snapShot;
    }

    public AccountDataSnapshot processAccountUpdate(MsgAccountUpdate2 msg) {
        AccountDataSnapshot snapShot;
        this.mSnapshot = snapShot = new AccountDataSnapshot(this, this.mSnapshot, msg);
        return snapShot;
    }

    public void processOrderUpdate(MsgOrderUpdateMultiD msg, List<Order> ordersAdded, List<Order> ordersUpdated, List<Trade> tradesAdded) {
        Position position = this.getPosition(msg.MarketID, true);
        this.mLastOrderUpdate = position.processOrderUpdate(msg, ordersAdded, ordersUpdated, tradesAdded);
    }

    public Order processOrderHistory(MsgOrderHistory2 msg) {
        Position position = this.getPosition(msg.MarketID, true);
        return position.processOrderHistory(msg);
    }

    public String getDisplayName() {
        if (this.mDetails == null) {
            if (this.mDisplayName != null && !this.mDisplayName.isEmpty()) {
                return this.mDisplayName;
            }
            return this.mAccountName;
        }
        if (this.mDetails.DisplayName != null && !this.mDetails.DisplayName.isEmpty()) {
            return this.mDetails.DisplayName;
        }
        return this.mDetails.AccountName;
    }

    public String getAccountDisplay(AccountDisplayType displayType) {
        switch (displayType) {
            case AccountNumber: {
                return this.getAccountNumber();
            }
            case AccountName: {
                return this.getDisplayName();
            }
        }
        return this.getAccountNumber() + " - " + this.getDisplayName();
    }

    public AccountMode getAccountMode() {
        if (this.mDetails != null) {
            return this.mDetails.Mode;
        }
        return this.mMode;
    }

    public boolean getUsePLForMargin() {
        if (this.mDetails != null) {
            return this.mDetails.UsePLForMargin;
        }
        return false;
    }

    public boolean getUsePremium() {
        return this.mDetails != null && (this.mDetails.Mode == AccountMode.ByMarket || this.mDetails.Mode == AccountMode.ByContract);
    }

    public int getWideMarket() {
        if (this.mDetails != null) {
            return this.mDetails.WideMarket;
        }
        return 0;
    }

    @Override
    public int compareTo(Account other) {
        String a = this.getDisplayName();
        String b = other.getDisplayName();
        return a.compareTo(b);
    }
}

