/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import java.util.HashMap;
import java.util.Map;

public enum ValidationType {
    Volume(3),
    StopWrongSide(4),
    StopPriceNeeded(5),
    StopPriceNotNeeded(6),
    LimitPriceNeeded(7),
    LimitPriceNotNeeded(8),
    TimeType(9),
    MaxShow(10),
    PriceType(13),
    Activation(16),
    TrailPriceNotNeeded(19),
    LimitInstantFill(20),
    OCOVolumesNotEqual(50),
    OCORequiresTwoOrders(51),
    OCORequiresStopAndLimit(52),
    OCOOrdersBuySell(53),
    OCOOrdersTimeType(54),
    OCOActivationOrder(55),
    AOCORequiresTriggerAndOCO(70),
    AOCOTriggerRequired(71),
    AOCOVolumesMustBeZero(73),
    AOCOTriggerBuySell(74),
    AOCOActivationOrder(75),
    AOCOOrdersTimeType(76),
    SparkTriggerRequired(90),
    SparkActivationOrder(91),
    SparkUnderMinLegs(92),
    SparkOverMaxLegs(93),
    AccountDisabled(200),
    AccountDeleted(201),
    AccountMaxClipSizeExceeded(202),
    SpreaderMarketNotAvailable(300),
    SpreaderLegmarketUnavailable(301),
    SpreaderLegMarketDoesNotSupportICOrders(302);

    private final int value;
    private static Map<Integer, ValidationType> map;

    private ValidationType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ValidationType get(int value) {
        return map.get(value);
    }

    static {
        map = new HashMap<Integer, ValidationType>();
        for (ValidationType t : ValidationType.values()) {
            map.put(t.getValue(), t);
        }
    }
}

