/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.settings.PositionNotificationTapAction;
import com.t4login.connection.ServerType;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.LoginMode;
import com.t4login.definitions.SimpleSignInMethod;
import com.t4login.util.SortUtil;
import java.security.Signature;
import org.json.JSONException;
import org.json.JSONObject;

public class UserLogin
implements Comparable<UserLogin> {
    public static final String TAG = "UserLogin";
    public static final int RECENT_LOGIN = 0;
    public static final int NEW_LOGIN = 1;
    public static final UserLogin NewLogin = new UserLogin();
    public final ServerType Server;
    public final String Firm;
    public final String UserName;
    public final SimpleSignInMethod SSIMethod;
    public final int Type;
    public LoginMode Mode = LoginMode.Login;
    public NDateTime LastUsed = NDateTime.MinValue;
    public boolean NoPromptSSI = false;
    public final String Password;
    public final String NewPassword;
    public final Signature Signature;
    public String DisplayAccountID;
    public String DisplayMarketID;
    public PositionNotificationTapAction DisplayAction = PositionNotificationTapAction.RecentFills;
    public String EULASignature;

    public UserLogin(ServerType s, String f, String un, SimpleSignInMethod ssi, String pw, String eulaSignature, String newPw, LoginMode loginMode) {
        this.Server = s;
        this.Firm = f;
        this.UserName = un.substring(0, Math.min(90, un.length()));
        this.SSIMethod = ssi;
        this.Password = pw != null ? pw : "";
        this.EULASignature = eulaSignature;
        this.NewPassword = newPw != null ? newPw : "";
        this.Signature = null;
        this.Type = 0;
        this.Mode = loginMode;
        this.DisplayAccountID = "";
        this.DisplayMarketID = "";
        this.DisplayAction = PositionNotificationTapAction.RecentFills;
    }

    public UserLogin(ServerType s, String f, String un, SimpleSignInMethod ssi, Signature sig) {
        this.Server = s;
        this.Firm = f;
        this.UserName = un.substring(0, Math.min(90, un.length()));
        this.SSIMethod = ssi;
        this.Password = "";
        this.NewPassword = "";
        this.Signature = sig;
        this.Type = 0;
        this.DisplayAccountID = "";
        this.DisplayMarketID = "";
        this.DisplayAction = PositionNotificationTapAction.RecentFills;
    }

    public UserLogin(UserLogin login, String pw, String newPw) {
        this.Server = login.Server;
        this.Firm = login.Firm;
        this.UserName = login.UserName;
        this.SSIMethod = login.SSIMethod;
        this.Password = pw != null ? pw : "";
        this.NewPassword = newPw != null ? newPw : "";
        this.Signature = null;
        this.Type = login.Type;
        this.DisplayAccountID = "";
        this.DisplayMarketID = "";
        this.DisplayAction = PositionNotificationTapAction.RecentFills;
    }

    public UserLogin(UserLogin login, Signature signature) {
        this.Server = login.Server;
        this.Firm = login.Firm;
        this.UserName = login.UserName;
        this.SSIMethod = login.SSIMethod;
        this.Password = login.Password;
        this.NewPassword = login.NewPassword;
        this.Signature = signature;
        this.Type = login.Type;
        this.DisplayAccountID = "";
        this.DisplayMarketID = "";
        this.DisplayAction = PositionNotificationTapAction.RecentFills;
    }

    public UserLogin(ServerType s, String f, String un, String pw) {
        this(s, f, un, SimpleSignInMethod.None, pw, "", "", LoginMode.Login);
    }

    public UserLogin(ServerType s, String f, String un) {
        this(s, f, un, SimpleSignInMethod.None, "", "", "", LoginMode.Login);
    }

    private UserLogin() {
        this.Server = ServerType.Unknown;
        this.Firm = "";
        this.UserName = "";
        this.SSIMethod = SimpleSignInMethod.None;
        this.Password = "";
        this.NewPassword = "";
        this.Signature = null;
        this.Type = 1;
        this.DisplayAccountID = "";
        this.DisplayMarketID = "";
        this.DisplayAction = PositionNotificationTapAction.RecentFills;
    }

    public String toString() {
        if (this.Type == 1) {
            return Resource.localizeString("recent_account_list_new_login");
        }
        return this.Server.getAbbrDescr() + "   " + this.Firm + "/" + this.UserName;
    }

    public String toJSONString() {
        try {
            JSONObject loginObject = new JSONObject();
            loginObject.put("Server", (Object)this.Server.getAbbrDescr());
            loginObject.put("Firm", (Object)this.Firm);
            loginObject.put("UserName", (Object)this.UserName);
            loginObject.put("SSIMethod", (Object)this.SSIMethod.toString());
            loginObject.put("CreateAccountFlag", this.Type);
            loginObject.put("Mode", (Object)this.Mode);
            loginObject.put("LastUsed", (Object)this.LastUsed.toString());
            loginObject.put("NoPromptSSI", this.NoPromptSSI);
            loginObject.put("Password", (Object)(this.Password != null ? "****" : ""));
            loginObject.put("NewPassword", (Object)(this.NewPassword != null ? "****" : ""));
            loginObject.put("Signature", (Object)(this.Signature != null ? "****" : ""));
            loginObject.put("DisplayAccountID", (Object)this.DisplayAccountID);
            loginObject.put("DisplayMarketID", (Object)this.DisplayMarketID);
            loginObject.put("DisplayAction", (Object)this.DisplayAction.toString());
            return loginObject.toString(4);
        }
        catch (JSONException jex) {
            Log.e(TAG, "toJSON(), Error: " + jex.toString());
            return "{}";
        }
    }

    @Override
    public int compareTo(UserLogin another) {
        int comp = 0;
        comp = SortUtil.compare(this.Type, another.Type);
        if (comp == 0) {
            comp = SortUtil.compare(this.Server.getServerType(), another.Server.getServerType());
        }
        if (comp == 0) {
            comp = SortUtil.compare(this.Server.getValue(), another.Server.getValue());
        }
        if (comp == 0) {
            comp = this.Firm.compareToIgnoreCase(another.Firm);
        }
        if (comp == 0) {
            comp = this.UserName.compareToIgnoreCase(another.UserName);
        }
        return comp;
    }
}

