/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Host;
import com.t4login.IRemoteApi;
import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.api.IRecentLoginData;
import com.t4login.api.IUserDataHandler;
import com.t4login.api.T4HostService;
import com.t4login.api.User;
import com.t4login.api.UserLogin;
import com.t4login.api.user.notification.NotificationConfig;
import com.t4login.api.usersettings.AppSettingsParser;
import com.t4login.api.usersettings.ChartProfilesSettingsParser;
import com.t4login.api.usersettings.ContextSettingsParser;
import com.t4login.api.usersettings.QuoteBoardLayoutParser;
import com.t4login.api.usersettings.UserSettingsXmlParser;
import com.t4login.application.ConfigContext;
import com.t4login.application.ContextSettings;
import com.t4login.application.chart.settings.ChartProfiles;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.serialization.ConfigSerializer;
import com.t4login.application.configuration.serialization.XmlSerializerDelayedWrapper;
import com.t4login.application.quoteboard.settings.QuoteBoardLayout;
import com.t4login.application.settings.AppSettings;
import com.t4login.connection.IMessageHandler;
import com.t4login.connection.ServerType;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.LoginMode;
import com.t4login.definitions.SimpleSignInMethod;
import com.t4login.definitions.ThreeState;
import com.t4login.messages.Message;
import com.t4login.messages.MsgApplicationSignal;
import com.t4login.messages.MsgChangePassword;
import com.t4login.messages.MsgChangePasswordResponse;
import com.t4login.messages.MsgIdentityStatusUpdate;
import com.t4login.messages.MsgLogin;
import com.t4login.messages.MsgLoginResponse2;
import com.t4login.messages.MsgUserMessagingToken;
import com.t4login.messages.MsgUserSettings;
import com.t4login.messages.application.MsgServiceStateChange;
import com.t4login.util.Base64;
import com.t4login.util.Pair;
import com.t4login.util.Xml;
import java.io.StringWriter;
import java.security.Signature;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class UserData {
    private static final String TAG = "UserData";
    public static final int SETTINGS_VERSION = 10;
    public static final SimpleDateFormat TIMESTAMP_FORMAT = NDateTime.createDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final T4HostService mT4Service;
    private final ServerType mServerType;
    private final String mFirm;
    private final User mUser;
    private String mBaseURL = "";
    private String mContactDetail = "";
    private boolean mDisableSavingSettings = true;
    public NDateTime mLastConfigurationSettingsChange = NDateTime.MinValue;
    public NDateTime mLastContextSettingsChange = NDateTime.MinValue;
    public NDateTime mLastQuoteBoardLayoutChange = NDateTime.MinValue;
    public NDateTime mLastChartProfileChange = NDateTime.MinValue;
    private NDateTime mLastSettingsSavedTime = NDateTime.MinValue;
    private final List<IUserDataHandler> mUserDataHandlers = new CopyOnWriteArrayList<IUserDataHandler>();
    private List<Pair<String, String>> mRetainedUserSettings = null;
    private final IMessageHandler mMessageHandler = new IMessageHandler(){

        @Override
        public void onMessage(Message msg) {
            UserData.this.onMessage(msg);
        }
    };
    private Configurable.ConfigurationChangedHandler mConfigurationChangedHandler = new Configurable.ConfigurationChangedHandler(){

        @Override
        public void onConfigurationChanged(boolean restored) {
            if (!restored) {
                Log.d(UserData.TAG, "UserData.onConfigurationChanged(), Configuration settings changed, saving to server.");
                UserData.this.mLastConfigurationSettingsChange = UserData.this.mT4Service.getRemoteTime();
                UserData.this.saveSettingsToServer();
            }
        }
    };
    private ContextSettings.ContextSettingsChangedHandler mContextSettingsChangedHandler = new ContextSettings.ContextSettingsChangedHandler(this){

        @Override
        public ContextSettings.ContextType getContextType() {
            return ContextSettings.ContextType.Persistent;
        }

        @Override
        public void onContextSettingsChanged(List<Pair<String, String>> updated, List<String> removed) {
            IRemoteApi remoteApi = Host.getRemoteApi();
            if (remoteApi != null) {
                remoteApi.updateUserContextSettings(updated, removed);
            } else {
                Log.e(UserData.TAG, "UserData.onContextSettingsChanged(), Remote API is not available.");
            }
        }
    };
    private Configurable.ConfigurationChangedHandler mQuoteBoardLayoutChangedHandler = new Configurable.ConfigurationChangedHandler(){

        @Override
        public void onConfigurationChanged(boolean restored) {
            if (!restored) {
                Log.d(UserData.TAG, "UserData.onConfigurationChanged(), Quote board layout changed, saving to server.");
                UserData.this.mLastQuoteBoardLayoutChange = UserData.this.mT4Service.getRemoteTime();
                UserData.this.saveSettingsToServer();
            }
        }
    };
    private Configurable.ConfigurationChangedHandler mChartProfileChangedHandler = new Configurable.ConfigurationChangedHandler(){

        @Override
        public void onConfigurationChanged(boolean restored) {
            if (!restored) {
                Log.d(UserData.TAG, "UserData.onConfigurationChanged(), Chart profile changed, saving to server.");
                UserData.this.mLastChartProfileChange = UserData.this.mT4Service.getRemoteTime();
                UserData.this.saveSettingsToServer();
            }
        }
    };
    private static final Lock mSettingsLock = new ReentrantLock();
    private Pattern xmlPattern = Pattern.compile("^\\s*<.*$", 32);
    private static final String RECENT_LOGINS_FILE = "recents";

    public UserData(T4HostService s, UserLogin login) {
        this.mT4Service = s;
        this.mServerType = login.Server;
        this.mFirm = login.Firm;
        this.mUser = new User(login);
        s.registerMessageHandler(this.mMessageHandler);
        AppSettings.registerForConfigurationChanges(this.mConfigurationChangedHandler);
        ContextSettings.registerForContextSettingsChanges(this.mContextSettingsChangedHandler);
        QuoteBoardLayout.registerForConfigurationChanges(this.mQuoteBoardLayoutChangedHandler);
        ChartProfiles.registerForConfigurationChanges(this.mChartProfileChangedHandler);
    }

    public void registerForUserData(IUserDataHandler handler) {
        if (!this.mUserDataHandlers.contains(handler)) {
            this.mUserDataHandlers.add(handler);
        }
    }

    public void unregisterForUserData(IUserDataHandler handler) {
        this.mUserDataHandlers.remove(handler);
    }

    public void destroy() {
        if (this.mT4Service != null) {
            this.mT4Service.unregisterMessageHandler(this.mMessageHandler);
        }
        AppSettings.unregisterForConfigurationChanges(this.mConfigurationChangedHandler);
        ContextSettings.unregisterForContextSettingsChanges(this.mContextSettingsChangedHandler);
        QuoteBoardLayout.unregisterForConfigurationChanges(this.mQuoteBoardLayoutChangedHandler);
    }

    public boolean getDisableUserSettingsSaving() {
        return this.mDisableSavingSettings;
    }

    public void setDisableUserSettingsSaving(boolean disable) {
        this.mDisableSavingSettings = disable;
    }

    private boolean isInRole(String role) {
        if (this.mUser != null) {
            return this.mUser.isInRole(role);
        }
        return false;
    }

    public boolean inRoleAdministrator() {
        return this.isInRole("Administrator");
    }

    public boolean inRoleRiskOrAdministrator() {
        return this.isInRole("RiskManager") || this.isInRole("Administrator");
    }

    public boolean inRoleAllAccounts() {
        return this.isInRole("AllAccounts") || this.inRoleRiskOrAdministrator();
    }

    public boolean inRoleParentFirm() {
        return this.isInRole("ParentFirm") || this.inRoleRiskOrAdministrator();
    }

    public boolean inRoleTimeEntry() {
        return this.isInRole("TimeEntry");
    }

    public boolean inRolePitTrades() {
        return this.isInRole("PitTrades");
    }

    public boolean inRoleBasicCharting() {
        return this.isInRole("BasicCharting") || this.inRoleCharting();
    }

    public boolean inRoleCharting() {
        return this.isInRole("Charting");
    }

    public boolean inRoleMarketProfile() {
        return this.isInRole("MarketProfile");
    }

    public boolean inRoleNews() {
        return this.isInRole("News");
    }

    public boolean inRoleStrategy() {
        return this.isInRole("Strategy");
    }

    public boolean inRoleANTS1() {
        return this.isInRole("ANTS1") || this.inRoleANTS2();
    }

    public boolean inRoleANTS2() {
        return this.isInRole("ANTS2") || this.inRoleANTS3();
    }

    public boolean inRoleANTS3() {
        return this.isInRole("ANTS3");
    }

    public boolean inRoleANTSAuto1() {
        return this.isInRole("ANTSAuto1") || this.inRoleANTSAuto2();
    }

    public boolean inRoleANTSAuto2() {
        return this.isInRole("ANTSAuto2") || this.inRoleANTSAuto3();
    }

    public boolean inRoleANTSAuto3() {
        return this.isInRole("ANTSAuto3");
    }

    public boolean isSimOver2Weeks() {
        return this.getServerType() == ServerType.Simulator && this.isInRole("Over2Weeks") && !this.isInRole("LinkedToLive");
    }

    public void setSupportDetails(String baseURL, String contactDetail) {
        this.mBaseURL = baseURL;
        this.mContactDetail = contactDetail;
    }

    public String getBaseURL() {
        return this.mBaseURL;
    }

    public String getContactDetail() {
        return this.mContactDetail;
    }

    public ServerType getServerType() {
        return this.mServerType;
    }

    public String getFirm() {
        return this.mFirm;
    }

    public String getUserName() {
        return this.mUser.getUserName();
    }

    public LoginMode getLoginMode() {
        return this.mUser.getLoginMode();
    }

    public User getUser() {
        return this.mUser;
    }

    public String getBiometricKeyName(String packageName) {
        return packageName + "." + this.getServerType().name() + "." + this.getFirm() + "." + this.getUserName() + ".key";
    }

    public UserLogin getUserLogin() {
        List<UserLogin> recentLogins = UserData.getRecentLogins();
        for (UserLogin l : recentLogins) {
            if (l.Server.getValue() != this.mServerType.getValue() || !l.Firm.equalsIgnoreCase(this.mFirm) || !l.UserName.equalsIgnoreCase(this.mUser.getUserName())) continue;
            return l;
        }
        return null;
    }

    public static boolean getPromptUserToSetupSSI(UserLogin login) {
        List<UserLogin> recentLogins = UserData.getRecentLogins();
        if (recentLogins == null) {
            recentLogins = new ArrayList<UserLogin>();
        }
        login.LastUsed = NDateTime.now();
        for (int i = 0; i < recentLogins.size(); ++i) {
            UserLogin rl = recentLogins.get(i);
            if (rl.compareTo(login) != 0) continue;
            return !rl.NoPromptSSI;
        }
        Log.e(TAG, "getPromptUserToSetupSSI(), Not found! User: " + String.valueOf(login));
        return false;
    }

    public static void setPromptUserToSetupSSI(UserLogin login, boolean prompt) {
        List<UserLogin> recentLogins = UserData.getRecentLogins();
        if (recentLogins != null && login != null) {
            boolean found = false;
            for (int i = 0; i < recentLogins.size(); ++i) {
                UserLogin rl = recentLogins.get(i);
                if (rl.compareTo(login) != 0) continue;
                rl.NoPromptSSI = !prompt;
                found = true;
                break;
            }
            if (found) {
                UserData.saveRecentLogins(recentLogins);
                Log.d(TAG, "setPromptUserToSetupSSI(), Saved. User: " + String.valueOf(login) + ", Prompt: " + prompt);
            } else {
                Log.e(TAG, "setPromptUserToSetupSSI(), Not found! User: " + String.valueOf(login));
            }
        }
    }

    public boolean getShouldPromptUserAboutPositionUpdateNotifications() {
        MsgUserMessagingToken msgToken;
        return this.mUser != null && (msgToken = this.mUser.getUserMessagingToken()) != null && (!msgToken.MessaginToken.equals(Host.getMessagingToken()) || msgToken.DeliverPositionUpdates.equals(ThreeState.NotSpecified));
    }

    public void updateNotificationConfig(NotificationConfig config) {
        this.getUser().setUserNotificationConfig(config);
        this.enablePositionUdpdateNotifications(this.getUser().getUserMessagingToken().DeliverPositionUpdates.equals(ThreeState.True));
    }

    public void enablePositionUdpdateNotifications(boolean enable) {
        this.enablePositionUdpdateNotifications(enable, null);
    }

    public void enablePositionUdpdateNotifications(boolean enable, NotificationConfig initialConfig) {
        MsgUserMessagingToken msgToken = new MsgUserMessagingToken();
        msgToken.UserID = this.getUser().getUserID();
        msgToken.DeviceID = Host.getUniqueDeviceID();
        msgToken.MessaginToken = Host.getMessagingToken();
        msgToken.MessagingPKey = Host.getMessagingPKey();
        msgToken.DeliverPositionUpdates = ThreeState.valueOf(enable);
        MsgUserMessagingToken msgResponse = this.getUser().getUserMessagingToken();
        if (msgResponse != null && msgResponse.ConfigJSON.length() > 0) {
            msgToken.DeliverUserAlerts = msgResponse.DeliverUserAlerts;
            msgToken.ConfigJSON = msgResponse.ConfigJSON;
        }
        if (enable && initialConfig != null) {
            JSONObject initialConfigJSONObject = initialConfig.buildJSON();
            msgToken.ConfigJSON = initialConfigJSONObject.toString();
        }
        Log.d(TAG, "registerUserMessagingToken(), msg: " + String.valueOf(msgToken));
        this.mT4Service.sendMessage(msgToken);
    }

    public boolean getIsSimOverTwoWeeks() {
        return this.mServerType == ServerType.Simulator && this.mUser.isInRole("Over2Weeks") && !this.mUser.isInRole("LinkedToLive");
    }

    public boolean getAllowEventBasedContracts() {
        return this.mUser.isInRole("EBC");
    }

    public void saveSettingsToServer() {
        if (this.mDisableSavingSettings) {
            return;
        }
        if (!this.hasUnSavedSettings()) {
            Log.d(TAG, "saveSettingsToServer(), Settings are unchanged since " + this.mLastSettingsSavedTime.toString("MM/dd/yyyy HH:mm:ss.SSS") + ". Omitting save.");
            return;
        }
        if (this.mT4Service.getServiceState() == T4HostService.ServiceState.Connected) {
            this.doSaveSettingsToServer();
        } else {
            this.doSaveSettingsLocally();
        }
    }

    public void waitForPendingSettingsToSave() {
        try {
            if (mSettingsLock.tryLock(4000L, TimeUnit.MILLISECONDS)) {
                mSettingsLock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void retainUserSettings(List<Pair<String, String>> settings) {
        this.mRetainedUserSettings = settings;
    }

    public void restoreUserSettings_t4(MsgUserSettings msg, String defaultSettings) {
        UserSettingsXmlParser parser;
        String localSettings = Host.getLocalSavedSettings(this.mUser.getUserID());
        NDateTime localSettingsTimeStamp = UserSettingsXmlParser.parseTimeStamp(localSettings);
        NDateTime serverSettingsTimeStamp = UserSettingsXmlParser.parseTimeStamp(msg.Settings);
        if (localSettingsTimeStamp != null && serverSettingsTimeStamp != null && localSettingsTimeStamp.compareTo(serverSettingsTimeStamp) > 0) {
            Log.e(TAG, "restoreUserSettings(), Locally saved user settings are newer than server settings. Using locally saved settings. Local: " + localSettingsTimeStamp.toString(TIMESTAMP_FORMAT) + ", Server: " + serverSettingsTimeStamp.toString(TIMESTAMP_FORMAT));
            msg.Settings = localSettings;
        }
        AppSettings.instance.resetToDefaults();
        ContextSettings.persistent.clear();
        int versionParsed = -1;
        if (msg.Settings != null && !msg.Settings.isEmpty()) {
            parser = new UserSettingsXmlParser();
            parser.registerSettingParser("AppSettings", new AppSettingsParser()).registerSettingParser("ChartProfiles", new ChartProfilesSettingsParser()).registerSettingParser("context_settings", new ContextSettingsParser()).registerSettingParser("QuoteBoardLayout", new QuoteBoardLayoutParser());
            versionParsed = parser.parse(msg);
            this.retainUserSettings(parser.getRetainedSettings());
        }
        if (versionParsed < 0) {
            msg.Settings = defaultSettings;
            parser = new UserSettingsXmlParser();
            parser.registerSettingParser("AppSettings", new AppSettingsParser()).registerSettingParser("ChartProfiles", new ChartProfilesSettingsParser()).registerSettingParser("context_settings", new ContextSettingsParser()).registerSettingParser("QuoteBoardLayout", new QuoteBoardLayoutParser());
            versionParsed = parser.parse(msg);
            this.setDisableUserSettingsSaving(false);
        } else if (versionParsed > 10) {
            this.setDisableUserSettingsSaving(true);
        } else {
            this.setDisableUserSettingsSaving(false);
        }
    }

    public void restoreUserSettings(MsgUserSettings msg, String defaultSettings) {
        UserSettingsXmlParser parser;
        ContextSettings.persistent.clear();
        Log.d(TAG, "restoreUserSettings(), All saved application/context state cleared.");
        IRemoteApi remoteAPI = Host.getRemoteApi();
        if (remoteAPI != null) {
            Map<String, String> remoteContextSettings = remoteAPI.getUserContextSettings();
            Log.d(TAG, "restoreUserSettings(), Retrieved user context settings from remote API. n: %d", remoteContextSettings.size());
            remoteContextSettings.entrySet().stream().forEach(x -> Log.d(TAG, "restoreUserSettings(),    KEY: %s, VALUE: %s", x.getKey(), x.getValue()));
            ContextSettings.persistent.setTo(remoteContextSettings);
        } else {
            Log.e(TAG, "restoreUserSettings(), Remote API settings are unavailable.");
        }
        String localSettings = Host.getLocalSavedSettings(this.mUser.getUserID());
        NDateTime localSettingsTimeStamp = UserSettingsXmlParser.parseTimeStamp(localSettings);
        NDateTime serverSettingsTimeStamp = UserSettingsXmlParser.parseTimeStamp(msg.Settings);
        if (localSettingsTimeStamp != null && serverSettingsTimeStamp != null && localSettingsTimeStamp.compareTo(serverSettingsTimeStamp) > 0) {
            Log.e(TAG, "restoreUserSettings(), Locally saved user settings are newer than server settings. Using locally saved settings. Local: " + localSettingsTimeStamp.toString(TIMESTAMP_FORMAT) + ", Server: " + serverSettingsTimeStamp.toString(TIMESTAMP_FORMAT));
            msg.Settings = localSettings;
        }
        AppSettings.instance.resetToDefaults();
        int versionParsed = -1;
        if (msg.Settings != null && !msg.Settings.isEmpty()) {
            parser = new UserSettingsXmlParser();
            parser.registerSettingParser("AppSettings", new AppSettingsParser()).registerSettingParser("ChartProfiles", new ChartProfilesSettingsParser());
            parser.registerSettingParser("QuoteBoardLayout", new QuoteBoardLayoutParser());
            Log.d(TAG, "restoreUserSettings(), Registered QuoteBoardLayoutParser");
            if (!ContextSettings.persistent.getBoolean("CONTEXT_SETTINGS_RELOCATED", false)) {
                Log.d(TAG, "restoreUserSettings(), CONTEXT_SETTINGS_RELOCATED not set. Will restore user context settings from the server settings.");
                parser.registerSettingParser("context_settings", new ContextSettingsParser());
                ContextSettings.persistent.beginBatchUpdate();
            }
            versionParsed = parser.parse(msg);
            if (!ContextSettings.persistent.getBoolean("CONTEXT_SETTINGS_RELOCATED", false)) {
                ContextSettings.persistent.endBatchUpdate(true);
                if (versionParsed >= 0) {
                    ContextSettings.persistent.saveBoolean("CONTEXT_SETTINGS_RELOCATED", true);
                }
            }
            this.retainUserSettings(parser.getRetainedSettings());
        }
        if (versionParsed < 0) {
            msg.Settings = defaultSettings;
            parser = new UserSettingsXmlParser();
            parser.registerSettingParser("AppSettings", new AppSettingsParser()).registerSettingParser("ChartProfiles", new ChartProfilesSettingsParser());
            parser.registerSettingParser("QuoteBoardLayout", new QuoteBoardLayoutParser());
            Log.d(TAG, "restoreUserSettings(), Registered QuoteBoardLayoutParser");
            if (!ContextSettings.persistent.getBoolean("CONTEXT_SETTINGS_RELOCATED", false)) {
                Log.d(TAG, "restoreUserSettings(), CONTEXT_SETTINGS_RELOCATED not set. Will restore user context settings from the server settings.");
                parser.registerSettingParser("context_settings", new ContextSettingsParser());
                ContextSettings.persistent.beginBatchUpdate();
            }
            versionParsed = parser.parse(msg);
            if (!ContextSettings.persistent.getBoolean("CONTEXT_SETTINGS_RELOCATED", false)) {
                ContextSettings.persistent.endBatchUpdate(true);
                if (versionParsed >= 0) {
                    ContextSettings.persistent.saveBoolean("CONTEXT_SETTINGS_RELOCATED", true);
                }
            }
            this.setDisableUserSettingsSaving(false);
        } else if (versionParsed > 10) {
            this.setDisableUserSettingsSaving(true);
        } else {
            this.setDisableUserSettingsSaving(false);
        }
    }

    private boolean hasUnSavedSettings() {
        return this.mLastConfigurationSettingsChange.compareTo(this.mLastSettingsSavedTime) > 0 || this.mLastContextSettingsChange.compareTo(this.mLastSettingsSavedTime) > 0 || this.mLastQuoteBoardLayoutChange.compareTo(this.mLastSettingsSavedTime) > 0 || this.mLastChartProfileChange.compareTo(this.mLastSettingsSavedTime) > 0;
    }

    private void doSaveSettingsToServer() {
        if (mSettingsLock.tryLock()) {
            try {
                String settings = this.buildUserSettings();
                if (settings.length() > 0) {
                    this.mLastSettingsSavedTime = this.mT4Service.getRemoteTime();
                    Log.d(TAG, "doSaveSettingsToServer(), Saving to server: %s", settings);
                    MsgUserSettings msg = new MsgUserSettings();
                    msg.UserID = this.mUser.getUserID();
                    msg.Settings = settings;
                    msg.Filename = "Android";
                    this.mT4Service.sendMessage(msg);
                } else {
                    Log.e(TAG, "doSaveSettingsToServer(), Failed to save user settings to the server.");
                }
            }
            catch (Exception ex) {
                Log.e(TAG, "doSaveSettingsToServer(), Error.", ex);
            }
            finally {
                mSettingsLock.unlock();
            }
        }
    }

    private void doSaveSettingsLocally() {
        if (mSettingsLock.tryLock()) {
            try {
                String settings = this.buildUserSettings();
                if (settings.length() > 0) {
                    Log.d(TAG, "doSaveSettingsLocally(), Settings saved locally: %s", settings);
                    Host.saveLocalSettings(this.mUser.getUserID(), settings);
                } else {
                    Log.e(TAG, "doSaveSettingsLocally(), Failed to save user settings to the server.");
                }
            }
            catch (Exception ex) {
                Log.e(TAG, "doSaveSettingsLocally(), Error.", ex);
            }
            finally {
                mSettingsLock.unlock();
            }
        }
    }

    private String buildUserSettings() {
        try {
            StringBuilder b = new StringBuilder();
            NDateTime now = this.mT4Service.getRemoteTime();
            String dt = "dt=\"" + now.toString(TIMESTAMP_FORMAT) + "\"";
            b.append("<t4android v=\"10\" " + dt + ">");
            XmlSerializerDelayedWrapper s = new XmlSerializerDelayedWrapper(Xml.newSerializer());
            StringWriter w = new StringWriter();
            try {
                s.setOutput(w);
                ConfigSerializer configSer = new ConfigSerializer(ConfigContext.Default);
                configSer.serializeConfigSettings(s, AppSettings.instance, "AppSettings", false);
                s.endDocument();
            }
            catch (Exception ex) {
                Log.e(TAG, "buildUserSettings(), Error serializing configurable: " + String.valueOf(ex));
            }
            b.append(w.toString());
            XmlSerializerDelayedWrapper delayedWrapper = new XmlSerializerDelayedWrapper(Xml.newSerializer());
            StringWriter stringWriter2 = new StringWriter();
            try {
                delayedWrapper.setOutput(stringWriter2);
                QuoteBoardLayout.saveToXML(delayedWrapper);
                delayedWrapper.endDocument();
            }
            catch (Exception ex) {
                Log.e(TAG, "buildUserSettings(), Error serializing quote board layout: " + String.valueOf(ex));
            }
            b.append(stringWriter2.toString());
            XmlSerializerDelayedWrapper s2 = new XmlSerializerDelayedWrapper(Xml.newSerializer());
            StringWriter w2 = new StringWriter();
            try {
                s2.setOutput(w2);
                ChartProfiles.saveChartProfilesToXML(s2);
                s2.endDocument();
            }
            catch (Exception ex) {
                Log.e(TAG, "buildUserSettings(), Error serializing chart profiles: " + String.valueOf(ex));
            }
            b.append(w2.toString());
            if (this.mRetainedUserSettings != null) {
                for (Pair<String, String> retainedSetting : this.mRetainedUserSettings) {
                    b.append((String)retainedSetting.second);
                }
            }
            b.append("</t4android>");
            return b.toString();
        }
        catch (Exception ex) {
            Log.e(TAG, "buildUserSettings(), Error.", ex);
            return "";
        }
    }

    private String getSettingType(Object value) {
        if (value instanceof String) {
            String sVal = (String)value;
            Matcher xmlMatcher = this.xmlPattern.matcher(sVal);
            if (xmlMatcher.matches()) {
                return "x";
            }
            return "s";
        }
        if (value instanceof Integer) {
            return "i";
        }
        if (value instanceof Double) {
            return "d";
        }
        if (value instanceof Float) {
            return "f";
        }
        if (value instanceof Boolean) {
            return "b";
        }
        if (value instanceof Long) {
            return "l";
        }
        if (value instanceof Set) {
            return "m";
        }
        return "";
    }

    public void requestUserSettings() {
        MsgUserSettings msg = new MsgUserSettings();
        msg.UserID = this.mUser.getUserID();
        msg.Settings = "";
        msg.Filename = "Android";
        this.mT4Service.sendMessage(msg);
    }

    private void onMessage(Message msg) {
        switch (msg.getMessageType()) {
            case LoginResponse2: {
                this.processLoginResponse((MsgLoginResponse2)msg);
                break;
            }
            case ChangePasswordResponse: {
                this.processPasswordChangeResponse((MsgChangePasswordResponse)msg);
                break;
            }
            case UserSettings: {
                this.processUserSettings((MsgUserSettings)msg);
                break;
            }
            case UserMessagingToken: {
                if (this.mUser == null) break;
                this.mUser.processUserMessagingTokenResponse((MsgUserMessagingToken)msg);
                break;
            }
            case IdentityStatusUpdate: {
                if (this.mUser == null) break;
                this.mUser.processIdentityStatusUpdate((MsgIdentityStatusUpdate)msg);
                for (IUserDataHandler cb : this.mUserDataHandlers) {
                    cb.onIdentityStatusUpdate(this.mUser);
                }
                break;
            }
            case SignalMessage: {
                MsgApplicationSignal signalMsg = (MsgApplicationSignal)msg;
                block8 : switch (signalMsg.getSignal()) {
                    case ServiceStateChange: {
                        MsgServiceStateChange ssmsg = (MsgServiceStateChange)msg;
                        switch (ssmsg.getNewState()) {
                            case Connected: {
                                break block8;
                            }
                        }
                    }
                }
                break;
            }
        }
    }

    private void processLoginResponse(MsgLoginResponse2 msg) {
        this.mUser.processLoginResponse(msg);
    }

    private void processPasswordChangeResponse(MsgChangePasswordResponse msg) {
        this.mUser.processPasswordChangeResponse(msg);
    }

    private void processUserSettings(MsgUserSettings msg) {
    }

    private void requestUserMessagingTokenOnLogin() {
        if (!this.mUser.getUserID().isEmpty()) {
            MsgUserMessagingToken msgToken = new MsgUserMessagingToken();
            msgToken.UserID = this.mUser.getUserID();
            msgToken.DeviceID = Host.getUniqueDeviceID();
            msgToken.MessaginToken = Host.getMessagingToken();
            msgToken.MessagingPKey = Host.getMessagingPKey();
            this.mT4Service.sendMessage(msgToken);
        }
    }

    public void setSignature(Signature signature) {
        this.mUser.setSignature(signature);
    }

    public void getLoginDetail(MsgLogin login, byte[] ssiChallenge) {
        this.mUser.getLoginDetail(login, ssiChallenge, this.getBiometricKeyName(Host.getApplicationID()));
        login.Firm = this.mFirm;
        login.AppName = Host.getApplicationName(this.mServerType);
        login.AppLicense = Host.getApplicationLicense(this.mServerType);
        login.APISystem = 4;
    }

    public void getLoginDetailWithSignature(MsgLogin login, byte[] signature) {
        this.mUser.getLoginDetail(login, null, this.getBiometricKeyName(Host.getApplicationID()));
        login.Password = Base64.encodeBytes(signature);
        login.SSIMethod = SimpleSignInMethod.Bio;
        login.Firm = this.mFirm;
        login.AppName = Host.getApplicationName(this.mServerType);
        login.AppLicense = Host.getApplicationLicense(this.mServerType);
        login.APISystem = 4;
    }

    public String changePassword(String oldPassword, String newPassword) {
        MsgChangePassword msg = this.mUser.changePassword(oldPassword, newPassword);
        if (msg == null) {
            return Resource.localizeString("pwdchg_error_not_connected");
        }
        this.mT4Service.sendMessage(msg);
        return "";
    }

    public static List<UserLogin> getRecentLogins() {
        IRecentLoginData recentLoginFile = Host.createRecentLoginData();
        return recentLoginFile.getRecentLogins();
    }

    public static void saveRecentLogins(List<UserLogin> recentLogins) {
        ArrayList<UserLogin> saveLogins = new ArrayList<UserLogin>();
        for (UserLogin l : recentLogins) {
            if (l.Type != 0) continue;
            saveLogins.add(l);
        }
        IRecentLoginData recentLoginFile = Host.createRecentLoginData();
        recentLoginFile.saveRecentLogins(saveLogins);
    }
}

