/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Log;
import com.t4login.api.UserLogin;
import com.t4login.api.user.notification.NotificationConfig;
import com.t4login.application.ConfigContext;
import com.t4login.application.configuration.UserRole;
import com.t4login.connection.ServerType;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.AutoPullType;
import com.t4login.definitions.IdentityResult;
import com.t4login.definitions.IdentityStatus;
import com.t4login.definitions.LiveAccountRejectReason;
import com.t4login.definitions.LoginMode;
import com.t4login.definitions.LoginResult;
import com.t4login.definitions.SimpleSignInMethod;
import com.t4login.messages.MsgChangePassword;
import com.t4login.messages.MsgChangePasswordResponse;
import com.t4login.messages.MsgIdentityStatusUpdate;
import com.t4login.messages.MsgLogin;
import com.t4login.messages.MsgLoginResponse2;
import com.t4login.messages.MsgUserMessagingToken;
import com.t4login.util.Base64;
import com.t4login.util.CryptoUtil;
import java.io.IOException;
import java.security.Signature;
import java.security.SignatureException;

public class User {
    public static final String TAG = "User";
    private UserLogin mUserLogin;
    private String mUserID;
    private String mRoles;
    private boolean mFirstLogin = true;
    private LoginResult mLoginResult = LoginResult.Unknown;
    private NDateTime mPwdExpiryDate;
    private AutoPullType mAutoPull;
    private MsgUserMessagingToken mMsgUserMessagingToken = null;
    private MsgIdentityStatusUpdate mMsgIdentityStatusUpdate = null;

    public User(UserLogin login) {
        this.mUserLogin = login;
    }

    public User(String userName, String password, String newPassword) {
        this.mUserLogin = new UserLogin(ServerType.Unknown, "", userName, SimpleSignInMethod.None, password, "", newPassword, LoginMode.Login);
    }

    public void setSignature(Signature signature) {
        this.mUserLogin = new UserLogin(this.mUserLogin, signature);
    }

    public String getUserName() {
        return this.mUserLogin.UserName;
    }

    public String getPassword() {
        return this.mUserLogin.Password;
    }

    public String getEULASignature() {
        return this.mUserLogin.EULASignature;
    }

    public LoginMode getLoginMode() {
        return this.mUserLogin.Mode;
    }

    public SimpleSignInMethod getSimpleSignInMethod() {
        return this.mUserLogin.SSIMethod;
    }

    public String getNewPassword() {
        return this.mUserLogin.NewPassword;
    }

    private byte[] signSSIChallenge(byte[] challenge, String biometricKeyName) {
        if (this.mUserLogin.Signature != null) {
            try {
                this.mUserLogin.Signature.update(challenge);
                byte[] derSignature = this.mUserLogin.Signature.sign();
                byte[] signature = new byte[]{};
                try {
                    signature = CryptoUtil.decodeECDSADERSignature(derSignature);
                }
                catch (IOException e) {
                    Log.e(TAG, "signSSIChallenge(), Error decoding EDCSA signature from DER format.", e);
                }
                return signature;
            }
            catch (SignatureException e) {
                Log.e(TAG, "Error signing SSI challenge.", e);
            }
        }
        return null;
    }

    public String getUserID() {
        return this.mUserID;
    }

    public boolean isInRole(String role) {
        if (this.mRoles != null && !this.mUserLogin.UserName.isEmpty()) {
            return this.mRoles.indexOf("|" + role.trim() + "|") >= 0;
        }
        return false;
    }

    public void getLoginDetail(MsgLogin msg, byte[] ssiChallenge, String biometricKeyName) {
        msg.UserName = this.mUserLogin.UserName;
        if (this.mUserLogin.SSIMethod == SimpleSignInMethod.Bio && this.mUserLogin.Signature != null) {
            byte[] signed;
            msg.Password = ssiChallenge != null && ssiChallenge.length > 0 ? ((signed = this.signSSIChallenge(ssiChallenge, biometricKeyName)) != null ? Base64.encodeBytes(signed) : Base64.encodeBytes(ssiChallenge)) : "";
            msg.SSIMethod = this.mUserLogin.SSIMethod;
        } else {
            msg.Password = this.mUserLogin.Password;
            msg.EULASignature = this.mUserLogin.EULASignature;
            msg.NewPassword = !this.mUserLogin.NewPassword.isEmpty() && !this.mUserLogin.NewPassword.equals(this.mUserLogin.Password) ? this.mUserLogin.NewPassword : "";
            msg.SSIMethod = this.mUserLogin.SSIMethod;
            msg.Mode = this.mUserLogin.Mode;
            if (!this.mUserLogin.Mode.equals(LoginMode.Login)) {
                msg.CreateAccount = true;
            }
        }
        msg.FirstLogin = this.mFirstLogin;
    }

    public LoginResult getLoginResult() {
        return this.mLoginResult;
    }

    public NDateTime getPwdExpiryDate() {
        return this.mPwdExpiryDate;
    }

    public AutoPullType getAutoPullType() {
        return this.mAutoPull;
    }

    public IdentityStatus getIdentityStatus() {
        if (this.mMsgIdentityStatusUpdate != null) {
            return this.mMsgIdentityStatusUpdate.IdentityStatus;
        }
        return IdentityStatus.NotStarted;
    }

    public IdentityResult getIdentityResult() {
        if (this.mMsgIdentityStatusUpdate != null && this.mMsgIdentityStatusUpdate.IdentityStatus == IdentityStatus.Complete) {
            return this.mMsgIdentityStatusUpdate.IdentityResult;
        }
        return IdentityResult.Unknown;
    }

    public LiveAccountRejectReason getIdentityRejectReason() {
        if (this.mMsgIdentityStatusUpdate != null && this.mMsgIdentityStatusUpdate.IdentityStatus == IdentityStatus.Complete) {
            return this.mMsgIdentityStatusUpdate.RejectReason;
        }
        return LiveAccountRejectReason.Unknown;
    }

    public void resetLoginAttempt(String password, String newPassword) {
        this.mUserLogin = new UserLogin(this.mUserLogin, password, newPassword);
        this.mLoginResult = LoginResult.Unknown;
    }

    public MsgChangePassword changePassword(String oldPassword, String newPassword) {
        if (this.mLoginResult == LoginResult.Success) {
            this.mUserLogin = new UserLogin(this.mUserLogin, this.mUserLogin.Password, newPassword);
            MsgChangePassword msg = new MsgChangePassword();
            msg.UserID = this.mUserID;
            msg.Password = oldPassword;
            msg.NewPassword = newPassword;
            return msg;
        }
        return null;
    }

    public void processLoginResponse(MsgLoginResponse2 msg) {
        this.mUserID = msg.UserID;
        this.mRoles = msg.Roles;
        this.mLoginResult = msg.Result;
        this.mPwdExpiryDate = msg.PwdExpiresAt;
        this.mAutoPull = msg.AutoPull;
        if (msg.Result == LoginResult.Success && !this.mUserID.isEmpty()) {
            if (!this.mUserLogin.NewPassword.isEmpty()) {
                this.mUserLogin = new UserLogin(this.mUserLogin, this.mUserLogin.NewPassword, "");
            }
            this.mFirstLogin = false;
            this.mUserLogin.Mode = LoginMode.Login;
        }
        if (this.isInRole("Charting")) {
            ConfigContext.Default.setUserRole(UserRole.Standard);
        } else if (this.isInRole("BasicCharting")) {
            ConfigContext.Default.setUserRole(UserRole.Basic);
        } else {
            ConfigContext.Default.setUserRole(UserRole.NotAllowed);
        }
        this.mMsgUserMessagingToken = null;
    }

    public void processPasswordChangeResponse(MsgChangePasswordResponse msg) {
        if (msg.Result == LoginResult.Success && !this.mUserLogin.NewPassword.isEmpty()) {
            this.mUserLogin = new UserLogin(this.mUserLogin, this.mUserLogin.NewPassword, "");
        }
    }

    public MsgUserMessagingToken getUserMessagingToken() {
        return this.mMsgUserMessagingToken;
    }

    public NotificationConfig getUserNotificationConfig() {
        if (this.mMsgUserMessagingToken != null && this.mMsgUserMessagingToken.Success && this.mMsgUserMessagingToken.ConfigJSON.length() > 0) {
            return NotificationConfig.fromJSON(this.mMsgUserMessagingToken.ConfigJSON);
        }
        return new NotificationConfig();
    }

    public void setUserNotificationConfig(NotificationConfig config) {
        if (this.mMsgUserMessagingToken != null && this.mMsgUserMessagingToken.Success) {
            this.mMsgUserMessagingToken.ConfigJSON = config.buildJSON().toString();
        }
    }

    public void processUserMessagingTokenResponse(MsgUserMessagingToken msg) {
        this.mMsgUserMessagingToken = msg;
        if (this.mMsgUserMessagingToken.ConfigJSON == null || this.mMsgUserMessagingToken.ConfigJSON.length() == 0) {
            NotificationConfig defaultConfig = new NotificationConfig();
            this.mMsgUserMessagingToken.ConfigJSON = defaultConfig.buildJSON().toString();
        }
    }

    public void processIdentityStatusUpdate(MsgIdentityStatusUpdate msg) {
        this.mMsgIdentityStatusUpdate = msg;
    }
}

