/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Log;
import com.t4login.datetime.DayOfWeek;
import com.t4login.datetime.NDateTime;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TradeDate {
    private static final String TAG = "tradeDate";
    private final NDateTime mDayChangeTime;
    private final Map<DayOfWeek, NDateTime> mChangeTimeWeekDays = new HashMap<DayOfWeek, NDateTime>();
    private final Map<NDateTime, NDateTime> mChangeTimeDays = new HashMap<NDateTime, NDateTime>();
    private final Set<DayOfWeek> mNonTradingWeekDays = new HashSet<DayOfWeek>();
    private final Set<NDateTime> mNonTradingDays = new HashSet<NDateTime>();
    private static final SimpleDateFormat ExceptionDateFormat = NDateTime.createDateFormat("yyyyMMdd");
    private static final SimpleDateFormat ExceptionTimeFormat = NDateTime.createDateFormat("HH:mm");

    public TradeDate(NDateTime dayChangeTime, String exceptions) {
        this.mDayChangeTime = dayChangeTime;
        for (String exception : exceptions.split(";")) {
            String[] parts = exception.split("=");
            if (parts.length == 2) {
                if (parts[0].equalsIgnoreCase("mon")) {
                    this.parseExceptionWeekDay(parts[1], DayOfWeek.Monday);
                    continue;
                }
                if (parts[0].equalsIgnoreCase("tue")) {
                    this.parseExceptionWeekDay(parts[1], DayOfWeek.Tuesday);
                    continue;
                }
                if (parts[0].equalsIgnoreCase("wed")) {
                    this.parseExceptionWeekDay(parts[1], DayOfWeek.Wednesday);
                    continue;
                }
                if (parts[0].equalsIgnoreCase("thu")) {
                    this.parseExceptionWeekDay(parts[1], DayOfWeek.Thursday);
                    continue;
                }
                if (parts[0].equalsIgnoreCase("fri")) {
                    this.parseExceptionWeekDay(parts[1], DayOfWeek.Friday);
                    continue;
                }
                if (parts[0].equalsIgnoreCase("sat")) {
                    this.parseExceptionWeekDay(parts[1], DayOfWeek.Saturday);
                    continue;
                }
                if (parts[0].equalsIgnoreCase("sun")) {
                    this.parseExceptionWeekDay(parts[1], DayOfWeek.Sunday);
                    continue;
                }
                NDateTime exDate = TradeDate.toDate(parts[0]);
                if (exDate == null) continue;
                this.parseExceptionDay(parts[1], exDate);
                continue;
            }
            Log.e(TAG, "TradeDate(), Exception is in invalid format: '" + exceptions + "'");
        }
    }

    private static NDateTime toDate(String val) {
        return NDateTime.from(val, ExceptionDateFormat);
    }

    private static NDateTime toTime(String val) {
        String[] parts = val.split(":");
        if (parts.length == 2) {
            try {
                Integer hour = Integer.parseInt(parts[0]);
                Integer minute = Integer.parseInt(parts[1]);
                return new NDateTime(2000, 1, 1, hour, minute, 0);
            }
            catch (NumberFormatException nex) {
                return null;
            }
        }
        return null;
    }

    private void parseExceptionWeekDay(String exception, DayOfWeek dayOfWeek) {
        if (exception.startsWith("N")) {
            this.mNonTradingWeekDays.add(dayOfWeek);
        } else {
            NDateTime exTime = TradeDate.toTime(exception);
            if (exTime != null) {
                this.mChangeTimeWeekDays.put(dayOfWeek, exTime);
            }
        }
    }

    private void parseExceptionDay(String exception, NDateTime day) {
        if (exception.startsWith("N")) {
            this.mNonTradingDays.add(day);
        } else {
            NDateTime exTime = TradeDate.toTime(exception);
            if (exTime != null) {
                this.mChangeTimeDays.put(day, exTime);
            }
        }
    }

    public NDateTime getTradeDate(NDateTime time) {
        NDateTime tradeDate = time.getDate();
        NDateTime dayChangeTime = this.mDayChangeTime;
        if (this.mChangeTimeDays.size() > 0 && this.mChangeTimeDays.containsKey(time.getDate())) {
            dayChangeTime = this.mChangeTimeDays.get(time.getDate());
        } else if (this.mChangeTimeWeekDays.size() > 0 && this.mChangeTimeWeekDays.containsKey((Object)time.getDayOfWeek())) {
            dayChangeTime = this.mChangeTimeWeekDays.get((Object)time.getDayOfWeek());
        }
        if (time.compareTo(time.getDate().Add(dayChangeTime.getTimeOfDay())) > 0) {
            tradeDate = tradeDate.AddDays(1.0);
        }
        try {
            boolean chg = true;
            while (chg) {
                chg = false;
                if (this.mNonTradingDays.size() > 0 && this.mNonTradingDays.contains(tradeDate)) {
                    tradeDate = tradeDate.AddDays(1.0);
                    chg = true;
                    continue;
                }
                if (this.mNonTradingWeekDays.size() <= 0 || !this.mNonTradingWeekDays.contains((Object)tradeDate.getDayOfWeek())) continue;
                tradeDate = tradeDate.AddDays(1.0);
                chg = true;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "getTradeDate(), Error.", ex);
        }
        return tradeDate;
    }
}

