/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.api.FirmData;
import com.t4login.api.GetServersResponse;
import com.t4login.api.GetServersXml;
import com.t4login.api.IAlertManager;
import com.t4login.api.LoginResponse;
import com.t4login.api.MarketData;
import com.t4login.api.Password;
import com.t4login.api.UserData;
import com.t4login.api.UserLogin;
import com.t4login.api.accounts.AccountData;
import com.t4login.api.chartdata.ChartData;
import com.t4login.connection.ConnectionClass;
import com.t4login.connection.ConnectionConfig;
import com.t4login.connection.ConnectionConfigXmlParser;
import com.t4login.connection.IHostConnection;
import com.t4login.connection.IMessageHandler;
import com.t4login.connection.ServerType;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.definitions.IdentityResult;
import com.t4login.definitions.IdentityStatus;
import com.t4login.definitions.LoginResult;
import com.t4login.definitions.SimpleSignInMethod;
import com.t4login.definitions.TwoFactorAuthorizationType;
import com.t4login.messages.ChartDataRequestMessage;
import com.t4login.messages.ChartDataResponseMessage;
import com.t4login.messages.Message;
import com.t4login.messages.MessageType;
import com.t4login.messages.Msg2FactorAuthentication;
import com.t4login.messages.MsgLoginResponse2;
import com.t4login.messages.MsgNotification;
import com.t4login.messages.application.MsgChartDataFlush;
import com.t4login.messages.application.MsgChartDataRequestFailed;
import com.t4login.messages.application.MsgCheckSubscriptions;
import com.t4login.messages.application.MsgLoginFailed;
import com.t4login.messages.application.MsgServiceStateChange;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class T4HostService {
    private static final String TAG = "T4Android.T4HostService";
    private static final String CHECK_SUBSCRIPTION_TIMER_NAME = "T4Android.T4HostService.CheckSubscriptionTimer";
    private static final int CHECK_SUBSCRIPTION_TIMER_PERIOD_MILLISECONDS = 15000;
    private static final String CHART_DATA_FLUSH_TIMER_NAME = "T4Android.T4HostService.ChartDataFlushTimer";
    private static final int CHART_DATA_FLUSH_TIMER_MILLISECONDS = 20;
    private final List<ConnectionConfig> executeAndQuoteConnections = new ArrayList<ConnectionConfig>();
    private final List<ConnectionConfig> chartServerConnections = new ArrayList<ConnectionConfig>();
    private IHostConnection mConnection = null;
    private ServiceState mServiceState = ServiceState.Created;
    private final List<IMessageHandler> messageHandlers = new CopyOnWriteArrayList<IMessageHandler>();
    private final List<IHostServiceHandler> mHostServiceHandlers = new CopyOnWriteArrayList<IHostServiceHandler>();
    private Msg2FactorAuthentication mPending2FactorAuthentication = null;
    private final ChartConnectionManager mChartConnection = new ChartConnectionManager();
    private Timer checkSubscriptionTimer = null;
    private Timer chartDataFlushTimer = null;
    private UserData mUserData;
    private final MarketData mMarketData;
    private final ChartData mChartData;
    private final AccountData mAccountData;
    private final FirmData mFirmData;
    private final IAlertManager mAlertManager;
    private LoginResponse mLastLoginResponse = null;
    private final NDateTime mInactiveSince = null;
    private final boolean mNotifiedInactive = false;
    private final IHostConnection.HostConnectionHandler mConnectionHandler = new IHostConnection.HostConnectionHandler(){

        @Override
        public void message(IHostConnection conn, Message msg) {
            T4HostService.this.onMessage(msg);
        }

        @Override
        public void loggedIn(IHostConnection conn, boolean firstLogin) {
            T4HostService.this.setServiceState(ServiceState.Connected, true);
        }

        @Override
        public void disconnected(IHostConnection conn, String reason) {
            if (T4HostService.this.mServiceState != ServiceState.Sleeping) {
                T4HostService.this.setServiceState(ServiceState.Disconnected);
            }
        }
    };

    public T4HostService() {
        this.mMarketData = new MarketData(this);
        this.mChartData = new ChartData(this);
        this.mAccountData = new AccountData(this);
        this.mFirmData = new FirmData(this);
        this.mAlertManager = Host.createAlertManager(this);
        Log.d(TAG, "T4HostService()");
    }

    public void initialize(Host.HostInterface hostInterface) {
        Host.registerHostInterface(hostInterface);
        this.checkSubscriptionTimer = new Timer(CHECK_SUBSCRIPTION_TIMER_NAME, true);
        this.checkSubscriptionTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                T4HostService.this.onCheckSubscriptionTimer();
            }
        }, 15000L, 15000L);
        this.chartDataFlushTimer = new Timer(CHART_DATA_FLUSH_TIMER_NAME, true);
        this.chartDataFlushTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                T4HostService.this.onChartDataFlushTimer();
            }
        }, 20L, 20L);
    }

    public void start(UserLogin login) {
        this.mUserData = new UserData(this, login);
        this.setServiceState(ServiceState.Started);
    }

    public void submit2FAToken(String token) {
        if (this.mPending2FactorAuthentication == null) {
            Log.e(TAG, "submit2FAToken(), There is no pending 2FA request.");
            return;
        }
        this.mPending2FactorAuthentication.AuthorizationType = TwoFactorAuthorizationType.Forever;
        this.mPending2FactorAuthentication.AuthorizationToken = token;
        this.sendMessage(this.mPending2FactorAuthentication);
    }

    public LoginResponse getLastLoginResponse() {
        return this.mLastLoginResponse;
    }

    public boolean isDeviceAuthorized() {
        return this.mLastLoginResponse != null && this.mLastLoginResponse.getLoginResult() == LoginResult.Success && this.mLastLoginResponse.message.DeviceAuthorized;
    }

    public boolean isUserIdentityComplete() {
        return this.mUserData.getUser().getIdentityStatus() == IdentityStatus.Complete;
    }

    public IdentityStatus getUserIdentityStatus() {
        return this.mUserData.getUser().getIdentityStatus();
    }

    public IdentityResult getUserIdentityResult() {
        return this.mUserData.getUser().getIdentityResult();
    }

    public void registerMessageHandler(IMessageHandler handler) {
        if (!this.messageHandlers.contains(handler)) {
            this.messageHandlers.add(handler);
        }
    }

    public void unregisterMessageHandler(IMessageHandler handler) {
        this.messageHandlers.remove(handler);
    }

    public void registerHostServiceHandler(IHostServiceHandler handler) {
        if (!this.mHostServiceHandlers.contains(handler)) {
            this.mHostServiceHandlers.add(handler);
        }
    }

    public void unregisterHostServiceHandler(IHostServiceHandler handler) {
        this.mHostServiceHandlers.remove(handler);
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public MarketData getMarketData() {
        return this.mMarketData;
    }

    public ChartData getChartData() {
        return this.mChartData;
    }

    public AccountData getAccountData() {
        return this.mAccountData;
    }

    public FirmData getFirmData() {
        return this.mFirmData;
    }

    public IAlertManager getAlertManager() {
        return this.mAlertManager;
    }

    public NDateTime getRemoteTime() {
        if (this.mConnection != null) {
            return this.mConnection.getRemoteTime();
        }
        return NDateTime.now();
    }

    public NDateTime getRemoteTime(NDateTime time) {
        if (this.mConnection != null) {
            return this.mConnection.getRemoteTime(time);
        }
        return time;
    }

    public String getCacheFilename() {
        if (this.mUserData != null) {
            return this.mUserData.getServerType().name() + "-cache-md.db";
        }
        return "";
    }

    private void onCheckSubscriptionTimer() {
        if (this.checkInactivityTime()) {
            return;
        }
        this.publishMessage(MsgCheckSubscriptions.instance);
    }

    private void onChartDataFlushTimer() {
        this.publishMessage(MsgChartDataFlush.instance);
    }

    private boolean checkInactivityTime() {
        return false;
    }

    public void beginConnect() {
        if (this.mServiceState == ServiceState.Started && this.mLastLoginResponse == null) {
            this.setServiceState(ServiceState.Connecting);
            connectSocket connect = new connectSocket(this.mUserData);
            new Thread(connect).start();
        } else {
            Log.e(TAG, "beginConnect(), Unable to connect because this service instance was previously connected. ServiceState: " + String.valueOf((Object)this.mServiceState) + ", last login response: " + String.valueOf(this.mLastLoginResponse));
        }
    }

    public void beginConnect(Signature signature) {
        this.mUserData.setSignature(signature);
        if (this.mServiceState == ServiceState.Started && this.mLastLoginResponse == null) {
            this.setServiceState(ServiceState.Connecting);
            connectSocket connect = new connectSocket(this.mUserData);
            new Thread(connect).start();
        } else {
            Log.e(TAG, "beginConnect(), Unable to connect because this service instance was previously connected. ServiceState: " + String.valueOf((Object)this.mServiceState) + ", last login response: " + String.valueOf(this.mLastLoginResponse));
        }
    }

    public void sleep() {
        if (this.mServiceState == ServiceState.Connected) {
            if (this.checkSubscriptionTimer != null) {
                this.checkSubscriptionTimer.cancel();
            }
            if (this.chartDataFlushTimer != null) {
                this.chartDataFlushTimer.cancel();
            }
            this.setServiceState(ServiceState.Sleeping);
            this.mChartConnection.disconnect();
            this.mConnection.stop();
            this.mConnection = null;
        }
    }

    public void resume() {
        if (this.mServiceState == ServiceState.Sleeping) {
            this.checkSubscriptionTimer = new Timer(CHECK_SUBSCRIPTION_TIMER_NAME, true);
            this.checkSubscriptionTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    T4HostService.this.onCheckSubscriptionTimer();
                }
            }, 15000L, 15000L);
            this.chartDataFlushTimer = new Timer(CHART_DATA_FLUSH_TIMER_NAME, true);
            this.chartDataFlushTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    T4HostService.this.onChartDataFlushTimer();
                }
            }, 20L, 20L);
            this.setServiceState(ServiceState.Connecting);
            connectSocket connect = new connectSocket(this.mUserData);
            new Thread(connect).start();
        } else {
            Log.e(TAG, "resume(), Resume called, but service is not sleeping. ServiceState: " + String.valueOf((Object)this.mServiceState) + ", last login response: " + String.valueOf(this.mLastLoginResponse));
        }
    }

    public ServiceState getServiceState() {
        return this.mServiceState;
    }

    private void setServiceState(ServiceState newState) {
        this.setServiceState(newState, false);
    }

    private void setServiceState(ServiceState newState, boolean firstLogin) {
        ServiceState prevState = this.mServiceState;
        this.mServiceState = newState;
        Log.d(TAG, "setServiceState(), Service state change from " + String.valueOf((Object)prevState) + " to " + String.valueOf((Object)newState));
        if (prevState == ServiceState.Connected && newState != ServiceState.Connected) {
            this.mUserData.saveSettingsToServer();
        }
        this.publishMessage(new MsgServiceStateChange(prevState, newState, firstLogin));
        for (IHostServiceHandler handler : this.mHostServiceHandlers) {
            try {
                handler.onServiceStateChanged(newState);
            }
            catch (Exception ex) {
                Log.e(TAG, "Host service handler threw an exception.", ex);
            }
        }
    }

    private void publishMessage(Message msg) {
        for (IMessageHandler handler : this.messageHandlers) {
            try {
                handler.onMessage(msg);
            }
            catch (Exception ex) {
                Log.e(TAG, "Message handler threw an exception. Message: %s, Exception: %s", msg, ex);
            }
        }
    }

    private void beginPublishMessage(Message msg) {
        new Thread(() -> this.publishMessage(msg)).start();
    }

    public void destroy() {
        Log.d(TAG, "onDestroy(), Logging out.");
        this.mMarketData.destroy();
        this.mChartConnection.destroy();
        if (this.mAlertManager != null) {
            this.mAlertManager.destroy();
        }
        if (this.checkSubscriptionTimer != null) {
            this.checkSubscriptionTimer.cancel();
        }
        if (this.chartDataFlushTimer != null) {
            this.chartDataFlushTimer.cancel();
        }
        this.setServiceState(ServiceState.Stopped);
        try {
            if (this.mUserData != null) {
                this.mUserData.waitForPendingSettingsToSave();
            }
            if (this.mConnection != null && this.mConnection.isConnected()) {
                MsgLoginResponse2 logout = new MsgLoginResponse2();
                logout.UserID = "";
                logout.Result = LoginResult.Logout;
                this.mConnection.sendMessage(logout);
            }
            if (this.mConnection != null) {
                Thread t = new Thread(() -> {
                    this.mConnection.stop();
                    this.mConnection = null;
                });
                t.start();
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "onDestroy(), Error.", ex);
        }
        if (this.mUserData != null) {
            this.mUserData.destroy();
        }
        Log.d(TAG, "onDestroy(), Logged out.");
    }

    public boolean sendMessage(Message message) {
        if (this.mConnection != null && (this.mConnection.isConnected() || message.getMessageType() == MessageType.TwoFactorAuthentication)) {
            return this.mConnection.sendMessage(message);
        }
        Log.e(TAG, "sendMessage(), No connection to send message. State: " + String.valueOf((Object)this.getServiceState()) + ", Message: " + String.valueOf(message));
        return false;
    }

    public void sendChartDataRequest(Message message) {
        ChartDataRequestMessage chartReq = (ChartDataRequestMessage)((Object)message);
        if (chartReq != null) {
            if (this.mUserData != null) {
                Log.d(TAG, "sendChartDataRequest() Chart connections: %d", this.chartServerConnections.size());
                if (this.chartServerConnections.size() == 0) {
                    Log.d(TAG, "sendChartDataRequest() Refreshing chart connection list.");
                    UserData ud = this.getUserData();
                    ServerType serverType = ud.getServerType();
                    GetServersResponse servers = GetServersXml.getServers(ud.getFirm(), ud.getUserName(), serverType, "");
                    if (servers != null) {
                        this.chartServerConnections.addAll(servers.chartDataConnections.stream().map(c -> {
                            String[] addressParts = c.hostAddress.split(":");
                            ConnectionConfig cfg = new ConnectionConfig(ConnectionClass.ChartData, c.hostAddress, addressParts[0], Integer.parseInt(addressParts[1]), c.type, Integer.parseInt(c.timer), Integer.parseInt(c.maxPendingHeartbeats));
                            return cfg;
                        }).collect(Collectors.toList()));
                    }
                }
                if (this.chartServerConnections.size() > 0) {
                    if (this.mUserData.inRoleBasicCharting()) {
                        this.mChartConnection.requestChartData(message);
                    } else {
                        Log.e(TAG, "sendChartDataRequest(), Request failed: User not in charting role.");
                        failMsg = new MsgChartDataRequestFailed(chartReq.getRequestID(), MsgChartDataRequestFailed.FailureReason.NotInRole);
                        this.beginPublishMessage(failMsg);
                    }
                } else {
                    Log.e(TAG, "sendChartDataRequest(), Request failed: No chart connection configurations.");
                    failMsg = new MsgChartDataRequestFailed(chartReq.getRequestID(), MsgChartDataRequestFailed.FailureReason.NoConnections);
                    this.beginPublishMessage(failMsg);
                }
            } else {
                Log.e(TAG, "sendChartDataRequest(), Request failed: Not connected or logged in.");
                MsgChartDataRequestFailed failMsg = new MsgChartDataRequestFailed(chartReq.getRequestID(), MsgChartDataRequestFailed.FailureReason.NotConnected);
                this.beginPublishMessage(failMsg);
            }
        } else {
            Log.e(TAG, "Message is not a ChartDataRequestMessage: " + String.valueOf(message));
        }
    }

    public void onMessage(Message msg) {
        this.processMessage(msg);
    }

    private void processMessage(Message msg) {
        switch (msg.getMessageType()) {
            case TwoFactorAuthentication: {
                this.processTwoFactorAuthenticationRequest((Msg2FactorAuthentication)msg);
                break;
            }
            case LoginResponse2: {
                this.processLoginResponse((MsgLoginResponse2)msg);
                break;
            }
            case Notification: {
                this.processNotification((MsgNotification)msg);
                break;
            }
            default: {
                this.publishMessage(msg);
            }
        }
    }

    private void processTwoFactorAuthenticationRequest(Msg2FactorAuthentication msg) {
        this.mPending2FactorAuthentication = msg;
        for (IHostServiceHandler handler : this.mHostServiceHandlers) {
            try {
                handler.on2FATokenRequest();
            }
            catch (Exception ex) {
                Log.e(TAG, "Host service handler threw an exception.", ex);
            }
        }
    }

    private void processLoginResponse(MsgLoginResponse2 msg) {
        Log.d(TAG, "processLoginResponse(), Result: " + String.valueOf(msg.Result));
        this.mLastLoginResponse = new LoginResponse(msg);
        if (msg.Result == LoginResult.Success) {
            this.publishMessage(msg);
            for (Message piggyBackMsg : msg.Messages) {
                this.publishMessage(piggyBackMsg);
            }
            Password.setComplexity(msg.PwdComplexity);
        } else {
            if (msg.Result == LoginResult.PasswordExpired) {
                Password.setComplexity(msg.PwdComplexity);
            }
            this.publishMessage(msg);
            Log.e(TAG, "Login Failed: " + String.valueOf(msg.Result));
            this.setServiceState(ServiceState.LoginFailed);
            if (this.mConnection != null) {
                this.mConnection.stop();
                this.mConnection = null;
            }
        }
        for (IHostServiceHandler handler : this.mHostServiceHandlers) {
            try {
                handler.onLoginResponse(this.mLastLoginResponse);
            }
            catch (Exception ex) {
                Log.e(TAG, "Host service handler threw an exception.", ex);
            }
        }
    }

    private void processNotification(MsgNotification msg) {
        for (IHostServiceHandler handler : this.mHostServiceHandlers) {
            try {
                handler.onNotification(msg);
            }
            catch (Exception ex) {
                Log.e(TAG, "Host service handler threw an exception.", ex);
            }
        }
        this.publishMessage(msg);
    }

    public static Set<SimpleSignInMethod> getAvailableSSIMethods(String firm, String userName, ServerType srvType, String deviceID) {
        String userNameEnc;
        String firmEnc;
        try {
            firmEnc = URLEncoder.encode(firm, "utf-8");
            userNameEnc = URLEncoder.encode(userName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e(TAG, "getAvailableSSIMethods(), Failed URL encoding firm or user name.");
            return new HashSet<SimpleSignInMethod>();
        }
        String path = "Servers/GetServers.aspx";
        for (int attempt = 0; attempt < 3; ++attempt) {
            String[] urls;
            String yy = String.format(Locale.US, "%s?firm=%s&user=%s&app=%s&sys=%d&dev=%s", path, firmEnc, userNameEnc, Host.getApplicationName(srvType), srvType.getServerType(), deviceID);
            for (String s : urls = srvType.getUrls()) {
                String url = s + "/" + yy;
                url = url + String.format(Locale.ENGLISH, "&dt=%d", System.currentTimeMillis());
                Log.d(TAG, "getAvailableSSIMethods(), url: " + url);
                try {
                    URLConnection conn = new URL(url).openConnection();
                    ConnectionConfigXmlParser parser = new ConnectionConfigXmlParser();
                    parser.parse(conn.getInputStream());
                    if (parser.getSSISupported()) {
                        return parser.getSSI();
                    }
                    return new HashSet<SimpleSignInMethod>();
                }
                catch (Exception ex) {
                    Log.e(TAG, "getAvailableSSIMethods(), Failed attempt " + (attempt + 1) + " of 3. Error.", ex);
                }
            }
        }
        return new HashSet<SimpleSignInMethod>();
    }

    public static enum ServiceState {
        Created,
        Started,
        Connecting,
        Connected,
        Sleeping,
        Disconnected,
        LoginFailed,
        Stopped;

    }

    private class ChartConnectionManager {
        private static final String CHART_DATA_TIMER = "T4Host.ChartConnectionManager.ChartConnectionTimer";
        private IHostConnection mChartConnection = null;
        private final ConcurrentLinkedQueue<Message> mOutgoingRequestQueue = new ConcurrentLinkedQueue();
        private Timer mConnectionTimer = null;
        private NDateTime mLastDataTime = null;
        private final Object lock = new Object();
        private boolean isDestroyed = false;
        private final IHostConnection.HostConnectionHandler mChartDataConnectionHandler = new IHostConnection.HostConnectionHandler(){

            @Override
            public void message(IHostConnection conn, Message msg) {
                ChartConnectionManager.this.mLastDataTime = NDateTime.now();
                ChartConnectionManager.this.onChartDataMessage(msg);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loggedIn(IHostConnection conn, boolean firstLogin) {
                Object object = ChartConnectionManager.this.lock;
                synchronized (object) {
                    ChartConnectionManager.this.mLastDataTime = NDateTime.now();
                    while (!ChartConnectionManager.this.mOutgoingRequestQueue.isEmpty()) {
                        Message reqMsg = ChartConnectionManager.this.mOutgoingRequestQueue.poll();
                        Log.d(T4HostService.TAG, "mChartDataConnectionHandler.loggedIn(), Sending chart data request: " + reqMsg.toString());
                        ChartConnectionManager.this.mChartConnection.sendMessage(reqMsg);
                    }
                    ChartConnectionManager.this.mConnectionTimer = new Timer(ChartConnectionManager.CHART_DATA_TIMER, true);
                    ChartConnectionManager.this.mConnectionTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            ChartConnectionManager.this.onChartConnectionTimer();
                        }
                    }, 1000L, 1000L);
                }
            }

            @Override
            public void disconnected(IHostConnection conn, String reason) {
            }
        };

        private ChartConnectionManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            if (this.isDestroyed) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                this.isDestroyed = true;
                try {
                    if (this.mChartConnection != null && this.mChartConnection.isConnected()) {
                        MsgLoginResponse2 logout = new MsgLoginResponse2();
                        logout.UserID = "";
                        logout.Result = LoginResult.Logout;
                        if (this.mChartConnection != null) {
                            this.mChartConnection.sendMessage(logout);
                        }
                        Thread t = new Thread(() -> {
                            this.mChartConnection.stop();
                            this.mChartConnection.setConnectionHandler(null);
                            this.mChartConnection = null;
                        });
                        t.start();
                    }
                }
                catch (Exception ex) {
                    Log.e(T4HostService.TAG, "ChartConnectionManager.destroy(), Error.", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestChartData(Message req) {
            if (this.isDestroyed) {
                return;
            }
            String reqID = "?";
            if (req instanceof ChartDataRequestMessage) {
                reqID = ((ChartDataRequestMessage)((Object)req)).getRequestID();
            }
            Object object = this.lock;
            synchronized (object) {
                this.mLastDataTime = NDateTime.now();
                if (this.mChartConnection == null) {
                    Log.d(T4HostService.TAG, "ChartConnectionManager.requestChartData(), [" + reqID + "], Not connected to chart server. Queuing request while connection is opened.");
                    this.mOutgoingRequestQueue.add(req);
                    this.mChartConnection = Host.createConnection("ChartData", T4HostService.this.mUserData, T4HostService.this.chartServerConnections, this.mChartDataConnectionHandler);
                    if (this.mChartConnection != null) {
                        this.mChartConnection.beginStart();
                    }
                } else if (!this.mChartConnection.isConnected()) {
                    Log.d(T4HostService.TAG, "ChartConnectionManager.requestChartData(), [" + reqID + "], Not logged into chart server. Queuing request during log in.");
                    this.mOutgoingRequestQueue.add(req);
                } else {
                    Log.d(T4HostService.TAG, "ChartConnectionManager.requestChartData(), [" + reqID + "], Sending request to chart server.");
                    this.mChartConnection.sendMessage(req);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            if (this.isDestroyed) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.mChartConnection != null) {
                    this.mChartConnection.stop();
                    this.mChartConnection.setConnectionHandler(null);
                    this.mChartConnection = null;
                }
                if (this.mConnectionTimer != null) {
                    this.mConnectionTimer.cancel();
                    this.mConnectionTimer = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onChartConnectionTimer() {
            if (this.isDestroyed) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.mChartConnection != null) {
                    NTimeSpan inactiveDuration = NDateTime.now().Subtract(this.mLastDataTime);
                    long secondsInactive = (long)inactiveDuration.getTotalSeconds();
                    if (secondsInactive >= 60L) {
                        this.mConnectionTimer.cancel();
                        this.mConnectionTimer = null;
                        Log.d(T4HostService.TAG, "onChartConnectionTimer(), Closing chart data connection after " + secondsInactive + " seconds of inactivity.");
                        this.mChartConnection.stop();
                        this.mChartConnection.setConnectionHandler(null);
                        this.mChartConnection = null;
                    }
                } else if (this.mConnectionTimer != null) {
                    this.mConnectionTimer.cancel();
                    this.mConnectionTimer = null;
                }
            }
        }

        private void onChartDataMessage(Message msg) {
            if (msg instanceof ChartDataResponseMessage) {
                T4HostService.this.publishMessage(msg);
            } else if (msg.getMessageType() != MessageType.LoginResponse2) {
                Log.v(T4HostService.TAG, "onChartDataMessage(), Non-chart data message: " + String.valueOf(msg));
            }
        }
    }

    class connectSocket
    implements Runnable {
        private final UserData ud;

        public connectSocket(UserData userData) {
            this.ud = userData;
        }

        @Override
        public void run() {
            T4HostService.this.executeAndQuoteConnections.clear();
            T4HostService.this.chartServerConnections.clear();
            ServerType serverType = this.ud.getServerType();
            if (!serverType.equals((Object)ServerType.Unknown)) {
                GetServersResponse servers = this.ud.getLoginMode().IsCreateAccount() ? GetServersXml.getServers(this.ud.getFirm(), serverType) : GetServersXml.getServers(this.ud.getFirm(), this.ud.getUserName(), serverType, "");
                Log.d(T4HostService.TAG, "connectSocket.run(), url: %s, connections: %d, support details: %d", servers.url, servers.connections.size(), servers.support.size());
                String culture = Locale.getDefault().toString().replace('_', '-');
                this.ud.setSupportDetails(servers.url, servers.support.getOrDefault(culture, ""));
                if (servers.message.length() > 0) {
                    Log.e(T4HostService.TAG, "Bad credentials");
                    T4HostService.this.publishMessage(new MsgLoginFailed(MsgLoginFailed.FailureReason.BadCredentials, Resource.localizeString("login_failed_message")));
                    return;
                }
                if (servers.connections.size() == 0) {
                    Log.e(T4HostService.TAG, "Connection configuration not found");
                    T4HostService.this.publishMessage(new MsgLoginFailed(MsgLoginFailed.FailureReason.APIUnavailable, Resource.localizeString("t4_unavailable")));
                    return;
                }
                T4HostService.this.executeAndQuoteConnections.addAll(servers.connections.stream().map(c -> {
                    String[] addressParts = c.hostAddress.split(":");
                    ConnectionConfig cfg = new ConnectionConfig(ConnectionClass.ExecuteAndQuote, c.hostAddress, addressParts[0], Integer.parseInt(addressParts[1]), c.type, Integer.parseInt(c.timer), Integer.parseInt(c.maxPendingHeartbeats));
                    return cfg;
                }).collect(Collectors.toList()));
                T4HostService.this.chartServerConnections.addAll(servers.chartDataConnections.stream().map(c -> {
                    String[] addressParts = c.hostAddress.split(":");
                    ConnectionConfig cfg = new ConnectionConfig(ConnectionClass.ChartData, c.hostAddress, addressParts[0], Integer.parseInt(addressParts[1]), c.type, Integer.parseInt(c.timer), Integer.parseInt(c.maxPendingHeartbeats));
                    return cfg;
                }).collect(Collectors.toList()));
            } else {
                Log.e(T4HostService.TAG, "connectSocket.run(), Error. Unknown server type.");
            }
            Collections.shuffle(T4HostService.this.executeAndQuoteConnections);
            T4HostService.this.mConnection = Host.createConnection("Execute and Quote", T4HostService.this.mUserData, T4HostService.this.executeAndQuoteConnections, T4HostService.this.mConnectionHandler);
            if (T4HostService.this.mConnection != null) {
                T4HostService.this.mConnection.start();
            }
        }
    }

    public static interface IHostServiceHandler {
        public boolean isActiveUI();

        public void onServiceStateChanged(ServiceState var1);

        public void onLoginResponse(LoginResponse var1);

        public void on2FATokenRequest();

        public void onNotification(MsgNotification var1);
    }
}

