/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.definitions.DepthBuffer;
import com.t4login.definitions.DepthLevels;
import com.t4login.definitions.util.MarketUtil;

public class SubscriptionLevel {
    public final String MarketID;
    private DepthBuffer depthBuffer = DepthBuffer.NoSubscription;
    private DepthLevels depthLevels = DepthLevels.BestOnly;
    private boolean mboSubscribed = false;

    public SubscriptionLevel(String marketid) {
        this.MarketID = marketid;
    }

    public void update(DepthBuffer buffer, DepthLevels levels, boolean mbo) {
        this.depthBuffer = MarketUtil.depthSubscribeAtLeast(buffer, this.depthBuffer);
        this.depthLevels = MarketUtil.depthSubscribeAtLeast(levels, this.depthLevels);
        this.mboSubscribed |= mbo;
    }

    public DepthBuffer getDepthBuffer() {
        return this.depthBuffer;
    }

    public DepthLevels getDepthLevels() {
        return this.depthLevels;
    }

    public boolean getMBOSubscribed() {
        return this.mboSubscribed;
    }

    public String toString() {
        return String.format("[%s], Buffer/Levels: %s/%s, MBO: %b", this.MarketID, this.depthBuffer, this.depthLevels, this.mboSubscribed);
    }
}

