/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.Price;

public final class PriceVolume {
    public final Price Price;
    public final int Volume;
    public static final PriceVolume Empty = new PriceVolume(null, 0);

    public PriceVolume(Price prc, int vol) {
        this.Price = prc;
        this.Volume = vol;
    }

    public boolean isEmpty() {
        return this.Price == null || this.Volume == 0;
    }

    public PriceVolume roundDown(IMarketConversion market) {
        if (this.Price == null) {
            return this;
        }
        return new PriceVolume(this.Price.roundDown(market), this.Volume);
    }

    public PriceVolume roundUp(IMarketConversion market) {
        if (this.Price == null) {
            return this;
        }
        return new PriceVolume(this.Price.roundUp(market), this.Volume);
    }

    public String toString() {
        if (this.Price != null) {
            return String.format("%d@%s", this.Volume, this.Price.toString());
        }
        return "<empty>";
    }
}

