/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Resource;
import java.util.Locale;

public class Password {
    private static boolean sComplexity = true;

    private Password() {
    }

    public static void setComplexity(boolean complexity) {
        sComplexity = complexity;
    }

    public static boolean getComplexity() {
        return sComplexity;
    }

    public static String checkComplexity(String pwd, String un) {
        String p = pwd.trim();
        if (sComplexity) {
            if (p.length() < 8) {
                return Resource.localizeString("pwdchg_warn_complexity_length");
            }
            if (!Password.checkCategories(p, 0)) {
                return Resource.localizeString("pwdchg_warn_complexity_cats_complex");
            }
            if (!Password.checkUsername(p, un)) {
                return Resource.localizeString("pwdchg_warn_complexity_username_fragments");
            }
            if (!Password.checkRepeating(p)) {
                return Resource.localizeString("pwdchg_warn_complexity_repeating_fragments");
            }
        } else {
            if (p.length() < 8) {
                return Resource.localizeString("pwdchg_warn_complexity_length");
            }
            if (!Password.checkCategories(p, 2)) {
                return Resource.localizeString("pwdchg_warn_complexity_cats");
            }
            if (!Password.checkUsername(p, un)) {
                return Resource.localizeString("pwdchg_warn_complexity_username_fragments");
            }
            if (!Password.checkRepeating(p)) {
                return Resource.localizeString("pwdchg_warn_complexity_repeating_fragments");
            }
        }
        return "";
    }

    public static String checkComplexityBasic(String pwd, String un) {
        String p = pwd.trim();
        if (p.length() < 8) {
            return Resource.localizeString("pwdchg_warn_complexity_length");
        }
        if (!Password.checkCategories(p, 2)) {
            return Resource.localizeString("pwdchg_warn_complexity_cats_complex");
        }
        return "";
    }

    private static boolean checkCategories(String pwd, int nZerosAllowed) {
        int upper = 0;
        int lower = 0;
        int numeric = 0;
        int special = 0;
        for (int i = 0; i < pwd.length(); ++i) {
            char c = pwd.charAt(i);
            if (Character.isUpperCase(c)) {
                ++upper;
                continue;
            }
            if (Character.isLowerCase(c)) {
                ++lower;
                continue;
            }
            if (Character.isDigit(c)) {
                ++numeric;
                continue;
            }
            ++special;
        }
        int zero = 0;
        if (upper == 0) {
            ++zero;
        }
        if (lower == 0) {
            ++zero;
        }
        if (numeric == 0) {
            ++zero;
        }
        if (special == 0) {
            ++zero;
        }
        return zero <= nZerosAllowed;
    }

    private static boolean checkUsername(String pwd, String un) {
        String p = pwd.toUpperCase(Locale.getDefault());
        String u = un.toUpperCase(Locale.getDefault());
        for (int i = 0; i < u.length() - 3; ++i) {
            if (p.indexOf(u.substring(i, i + 2)) < 0) continue;
            return false;
        }
        return true;
    }

    private static boolean checkRepeating(String pwd) {
        String p = pwd.toUpperCase(Locale.getDefault());
        for (int i = 0; i < p.length() - 3; ++i) {
            if (p.indexOf(p.substring(i, i + 3), i + 1) < 0) continue;
            return false;
        }
        return true;
    }
}

