/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.api.Market;
import com.t4login.api.OrderAction;
import com.t4login.api.accounts.Order;
import com.t4login.definitions.ActivationType;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.OrderSource;
import com.t4login.definitions.OrderSourceMethod;
import com.t4login.definitions.PriceType;
import com.t4login.definitions.TimeType;
import com.t4login.definitions.priceconversion.Price;
import java.io.Serializable;

public class OrderSubmitAction
extends OrderAction
implements Serializable {
    public final String AccountID;
    public final Market Market;
    public final BuySell Side;
    public final PriceType PriceType;
    public TimeType TimeType;
    public int Volume;
    public int MaxShow;
    public final Price LimitPrice;
    public final Price StopPrice;
    public final Price TrailPrice;
    public ActivationType Activation;
    public OrderSource Source = OrderSource.JavaAPI;
    public OrderSourceMethod Method = OrderSourceMethod.Unknown;
    public String Tag = "";
    public Order mOrder = null;

    public OrderSubmitAction(String accountid, Market market, BuySell buySell, PriceType priceType, TimeType timeType, int volume, int maxShow, Price limitPrice, Price stopPrice, Price trailPrice, String tag) {
        this.AccountID = accountid;
        this.Market = market;
        this.Side = buySell;
        this.PriceType = priceType;
        this.TimeType = timeType;
        this.Volume = volume;
        this.MaxShow = maxShow;
        this.LimitPrice = limitPrice;
        this.StopPrice = stopPrice;
        this.TrailPrice = trailPrice;
        this.Activation = ActivationType.Immediate;
        this.Tag = tag;
    }

    public Order getOrder() {
        return this.mOrder;
    }

    public void setOrder(Order order) {
        this.mOrder = order;
    }

    @Override
    public boolean requiresTicket() {
        return false;
    }

    @Override
    public boolean getReadyToValidate() {
        return true;
    }

    @Override
    public Market getMarket() {
        return this.Market;
    }

    @Override
    public BuySell getSide() {
        return this.Side;
    }

    @Override
    public PriceType getPriceType() {
        return this.PriceType;
    }

    @Override
    public TimeType getTimeType() {
        return this.TimeType;
    }

    @Override
    public int getVolume() {
        return this.Volume;
    }

    @Override
    public int getMaxShow() {
        return this.MaxShow;
    }

    @Override
    public Price getLimitPrice() {
        return this.LimitPrice;
    }

    @Override
    public Price getStopPrice() {
        return this.StopPrice;
    }

    @Override
    public Price getTrailPrice() {
        return this.TrailPrice;
    }

    @Override
    public ActivationType getActivationType() {
        return this.Activation;
    }

    @Override
    public String getTag() {
        return this.Tag;
    }

    public boolean isStop() {
        return this.PriceType.equals(com.t4login.definitions.PriceType.StopLimit) || this.PriceType.equals(com.t4login.definitions.PriceType.StopMarket) || this.PriceType.equals(com.t4login.definitions.PriceType.StopSameLimit);
    }

    public boolean isLimit() {
        return this.PriceType.equals(com.t4login.definitions.PriceType.Limit) || this.PriceType.equals(com.t4login.definitions.PriceType.MarketIfTouched) || this.PriceType.equals(com.t4login.definitions.PriceType.Hit) || this.PriceType.equals(com.t4login.definitions.PriceType.Join);
    }
}

