/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.api.Market;
import com.t4login.api.MarketDataSnapshot;
import com.t4login.api.OrderSubmitAction;
import com.t4login.api.SubmitResult;
import com.t4login.api.ValidationMessage;
import com.t4login.api.ValidationType;
import com.t4login.definitions.ActivationType;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.OrderLink;
import com.t4login.definitions.OrderSource;
import com.t4login.definitions.OrderSourceMethod;
import com.t4login.definitions.PriceType;
import com.t4login.definitions.TimeType;
import com.t4login.definitions.priceconversion.Price;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OrderSubmit
implements Serializable {
    private List<OrderSubmitAction> mOrders = new ArrayList<OrderSubmitAction>();
    public OrderLink Link = OrderLink.None;
    public OrderSource Source = OrderSource.JavaAPI;
    public OrderSourceMethod Method = OrderSourceMethod.Unknown;
    private List<ValidationMessage> mValidationMessages = new ArrayList<ValidationMessage>();
    private SubmitResult mSubmitResult = SubmitResult.NotSubmitted;
    private String mSubmitMsg = "";

    public OrderSubmit() {
    }

    public OrderSubmit(OrderSource source, OrderSourceMethod method) {
        this.Source = source;
        this.Method = method;
    }

    public int count() {
        return this.mOrders.size();
    }

    public OrderSubmitAction get(int index) {
        return this.mOrders.get(index);
    }

    public OrderSubmitAction add(String accountid, Market market, BuySell buySell, PriceType priceType, TimeType timeType, int volume, int maxShow, Price limitPrice, Price stopPrice, Price trailPrice) {
        OrderSubmitAction submit = new OrderSubmitAction(accountid, market, buySell, priceType, timeType, volume, maxShow, limitPrice, stopPrice, trailPrice, "");
        this.mOrders.add(submit);
        return submit;
    }

    public OrderSubmitAction add(String accountid, Market market, BuySell buySell, PriceType priceType, TimeType timeType, int volume, int maxShow, Price limitPrice, Price stopPrice, Price trailPrice, String tag) {
        OrderSubmitAction submit = new OrderSubmitAction(accountid, market, buySell, priceType, timeType, volume, maxShow, limitPrice, stopPrice, trailPrice, tag);
        this.mOrders.add(submit);
        return submit;
    }

    public void add(OrderSubmitAction action) {
        this.mOrders.add(action);
    }

    public void replace(OrderSubmitAction action, int index) {
        this.mOrders.remove(index);
        this.mOrders.add(index, action);
    }

    public boolean volumeOnlyValidation() {
        if (this.mValidationMessages.size() == 1 && this.mValidationMessages.get(0).getValidationType() == ValidationType.Volume) {
            return true;
        }
        if (this.mValidationMessages.size() == 0) {
            boolean volumeOnly = true;
            for (int i = 0; i < this.mOrders.size(); ++i) {
                volumeOnly &= this.mOrders.get(i).volumeOnlyValidation();
            }
            return volumeOnly;
        }
        return false;
    }

    public boolean validate(MarketDataSnapshot snapshot) {
        this.mValidationMessages.clear();
        if (this.Link.equals(OrderLink.OCO)) {
            return this.validateOCO(snapshot);
        }
        if (this.Link.equals(OrderLink.AutoOCO) || this.Link.equals(OrderLink.AutoOCOp)) {
            return this.validateAutoOCO(snapshot);
        }
        if (this.Link.equals(OrderLink.AutoOCOm) || this.Link.equals(OrderLink.AutoOCOmp)) {
            return this.validateAutoOCOm(snapshot);
        }
        boolean valid = true;
        for (int i = 0; i < this.mOrders.size(); ++i) {
            valid &= this.mOrders.get(i).validate(snapshot);
        }
        return valid;
    }

    public String getValidationMessage() {
        if (this.mValidationMessages.size() > 0) {
            return this.mValidationMessages.get(0).getValidationMessage();
        }
        for (OrderSubmitAction action : this.mOrders) {
            String msg = action.getValidationMessage();
            if (msg == null || msg.isEmpty()) continue;
            return msg;
        }
        return "";
    }

    public boolean validateOCO(MarketDataSnapshot snapshot) {
        boolean isValid = false;
        if (this.mOrders.size() == 2) {
            OrderSubmitAction action1 = this.mOrders.get(0);
            OrderSubmitAction action2 = this.mOrders.get(1);
            if (!(action1.isStop() && action2.isLimit() || action1.isLimit() && action2.isStop())) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.OCORequiresStopAndLimit, "order_validation_oco_ocorequiresstopandlimit"));
            }
            if (!action1.Side.equals(action2.Side)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.OCORequiresStopAndLimit, "order_validation_oco_ocoordersbuysell"));
            }
            if (action1.Volume != action2.Volume) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.OCORequiresStopAndLimit, "order_validation_oco_ocovolumesnotequal"));
            }
            if (!action1.TimeType.equals(action2.TimeType)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.OCORequiresStopAndLimit, "order_validation_oco_ocoorderstimetype_not_same"));
            }
            if (!action1.TimeType.equals(TimeType.GoodTillCancelled) && !action1.TimeType.equals(TimeType.Normal)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.OCORequiresStopAndLimit, "order_validation_oco_ocoorderstimetype_gtc_or_normal"));
            }
            if (!action1.Activation.equals(ActivationType.Immediate) || !action2.Activation.equals(ActivationType.Immediate)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.OCORequiresStopAndLimit, "order_validation_oco_ocoactivationorder"));
            }
            isValid = this.mValidationMessages.size() == 0;
            isValid &= action1.validate(snapshot);
            isValid &= action2.validate(snapshot);
        } else {
            this.mValidationMessages.add(new ValidationMessage(ValidationType.OCORequiresTwoOrders, "order_validation_oco_ocorequirestwoorders"));
        }
        return isValid;
    }

    public boolean validateAutoOCO(MarketDataSnapshot snapshot) {
        if (this.mOrders.size() == 3) {
            return this.validateAutoOCO3(snapshot);
        }
        if (this.mOrders.size() == 2) {
            return this.validateAutoOCO2(snapshot);
        }
        this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCORequiresTriggerAndOCO, "order_validation_autooco_aocorequirestriggerandoco"));
        return false;
    }

    private boolean validateAutoOCO2(MarketDataSnapshot snapshot) {
        boolean isValid = false;
        if (this.mOrders.size() == 2) {
            OrderSubmitAction action1 = this.mOrders.get(0);
            OrderSubmitAction action2 = this.mOrders.get(1);
            if (action1.Activation.equals(ActivationType.Hold) || !action2.Activation.equals(ActivationType.Hold)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCOTriggerRequired, "order_validation_autooco_aocotriggerrequired"));
            }
            if (action1.Side.equals(action2.Side)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCOTriggerBuySell, "order_validation_autooco_aocotriggerbuysell"));
            }
            if (action1.TimeType.equals(TimeType.GoodTillCancelled) && !action2.TimeType.equals(TimeType.GoodTillCancelled)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCOOrdersTimeType, "order_validation_autooco_aocoorderstimetype"));
            }
            if (action2.Volume != 0) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCOVolumesMustBeZero, "order_validation_autooco_aocovolumesmustbezero"));
            }
            if (!action2.TimeType.equals(TimeType.GoodTillCancelled) && !action2.TimeType.equals(TimeType.Normal)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.OCOOrdersTimeType, "order_validation_autooco_ocoorderstimetype_gtc_or_normal"));
            }
            if (!action2.Activation.equals(ActivationType.Hold)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCOActivationOrder, "order_validation_autooco_aocoactivationorder"));
            }
            isValid = this.mValidationMessages.size() == 0;
            isValid &= action1.validate(snapshot);
            isValid &= action2.validate(snapshot);
        } else {
            this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCORequiresTriggerAndOCO, "order_validation_autooco_aocorequirestriggerandoco"));
        }
        return isValid;
    }

    private boolean validateAutoOCO3(MarketDataSnapshot snapshot) {
        boolean isValid = false;
        if (this.mOrders.size() == 3) {
            OrderSubmitAction action1 = this.mOrders.get(0);
            OrderSubmitAction action2 = this.mOrders.get(1);
            OrderSubmitAction action3 = this.mOrders.get(2);
            if (action1.Activation.equals(ActivationType.Hold) || !action2.Activation.equals(ActivationType.Hold) || !action3.Activation.equals(ActivationType.Hold)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCOTriggerRequired, "order_validation_autooco_aocotriggerrequired"));
            }
            if (action1.Side.equals(action2.Side)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCOTriggerBuySell, "order_validation_autooco_aocotriggerbuysell"));
            }
            if (action1.TimeType.equals(TimeType.GoodTillCancelled) && !action2.TimeType.equals(TimeType.GoodTillCancelled)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCOOrdersTimeType, "order_validation_autooco_aocoorderstimetype"));
            }
            if (!(action2.isStop() && action3.isLimit() || action2.isLimit() && action3.isStop())) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.OCORequiresStopAndLimit, "order_validation_autooco_ocorequiresstopandlimit"));
            }
            if (!action2.Side.equals(action3.Side)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.OCOOrdersBuySell, "order_validation_autooco_ocoordersbuysell"));
            }
            if (action2.Volume != 0 || action3.Volume != 0) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCOVolumesMustBeZero, "order_validation_autooco_aocovolumesmustbezero"));
            }
            if (!action2.TimeType.equals(action3.TimeType)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.OCOOrdersTimeType, "order_validation_autooco_ocoorderstimetype"));
            }
            if (!action2.TimeType.equals(TimeType.GoodTillCancelled) && !action2.TimeType.equals(TimeType.Normal)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.OCOOrdersTimeType, "order_validation_autooco_ocoorderstimetype_gtc_or_normal"));
            }
            if (!action2.Activation.equals(ActivationType.Hold) || !action3.Activation.equals(ActivationType.Hold)) {
                this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCOActivationOrder, "order_validation_autooco_aocoactivationorder"));
            }
            isValid = this.mValidationMessages.size() == 0;
            isValid &= action1.validate(snapshot);
            isValid &= action2.validate(snapshot);
            isValid &= action3.validate(snapshot);
        } else {
            this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCORequiresTriggerAndOCO, "order_validation_autooco_aocorequirestriggerandoco"));
        }
        return isValid;
    }

    public boolean validateAutoOCOm(MarketDataSnapshot snapshot) {
        this.mValidationMessages.add(new ValidationMessage(ValidationType.AOCOActivationOrder, "order_validation_not_implemented"));
        return false;
    }

    public void setSubmitResult(SubmitResult result) {
        this.mSubmitResult = result;
        this.mSubmitMsg = "";
    }

    public void setSubmitResult(SubmitResult result, String msg) {
        this.mSubmitResult = result;
        this.mSubmitMsg = msg;
    }

    public SubmitResult getSubmitResult() {
        return this.mSubmitResult;
    }

    public String getSubmitMessage() {
        if (this.mSubmitMsg != null || !this.mSubmitMsg.isEmpty()) {
            return this.mSubmitMsg;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mOrders.size(); ++i) {
            sb.append(this.mOrders.get(i).getSubmitMessage());
            if (i >= this.mOrders.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

