/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.api.Market;
import com.t4login.api.MarketDataSnapshot;
import com.t4login.api.OrderAction;
import com.t4login.api.accounts.Order;
import com.t4login.definitions.ActivationType;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.PriceType;
import com.t4login.definitions.TimeType;
import com.t4login.definitions.priceconversion.Price;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OrderRevise
extends OrderAction
implements Serializable {
    public final String AccountID;
    public final Market Market;
    public List<Revision> Revisions = new ArrayList<Revision>();

    public OrderRevise(String accountid, Market market) {
        this.AccountID = accountid;
        this.Market = market;
    }

    public String getFullOrderTypeSummary() {
        if (this.Revisions.size() > 0) {
            int workingVolume = 0;
            int totalFillVolume = 0;
            for (Revision rev : this.Revisions) {
                workingVolume += rev.Order.getWorkingVolume();
                totalFillVolume += rev.Order.getTotalFillVolume();
            }
            Revision rev = this.Revisions.get(0);
            Price newLimitTicks = rev.NewLimitPrice;
            Price newStopTicks = rev.NewStopPrice;
            String summ = Order.getFullOrderTypeSummary(this.Market, rev.Order.getSide(), rev.Order.getPriceType(), rev.Order.getTimeType(), workingVolume, newLimitTicks, newStopTicks, totalFillVolume);
            return summ;
        }
        return "";
    }

    @Override
    public boolean requiresTicket() {
        return false;
    }

    @Override
    public boolean getReadyToValidate() {
        return this.Revisions.size() > 0;
    }

    @Override
    public Market getMarket() {
        return this.Market;
    }

    @Override
    public BuySell getSide() {
        return this.Revisions.get((int)0).Order.getSide();
    }

    @Override
    public PriceType getPriceType() {
        return this.Revisions.get((int)0).Order.getPriceType();
    }

    @Override
    public TimeType getTimeType() {
        return this.Revisions.get((int)0).Order.getTimeType();
    }

    @Override
    public int getVolume() {
        return this.Revisions.get((int)0).NewVolume;
    }

    @Override
    public int getMaxShow() {
        if (this.Revisions.get((int)0).NewMaxShow != null) {
            return this.Revisions.get((int)0).NewMaxShow;
        }
        return 0;
    }

    @Override
    public Price getLimitPrice() {
        return this.Revisions.get((int)0).NewLimitPrice;
    }

    @Override
    public Price getStopPrice() {
        return this.Revisions.get((int)0).NewStopPrice;
    }

    @Override
    public Price getTrailPrice() {
        return this.Revisions.get((int)0).NewTrailPrice;
    }

    @Override
    public ActivationType getActivationType() {
        return this.Revisions.get((int)0).Order.getActivationType();
    }

    @Override
    public String getTag() {
        return this.Revisions.get((int)0).Order.getTag();
    }

    @Override
    public boolean validate(MarketDataSnapshot snapshot) {
        boolean valid = super.validate(snapshot);
        if (this.Revisions.size() > 0) {
            for (Revision linkedRev : this.Revisions.get((int)0).LinkedOrders) {
                OrderRevise linkedOrderRevision = new OrderRevise(this.AccountID, this.Market);
                linkedOrderRevision.Revisions.add(linkedRev);
                boolean res = linkedOrderRevision.validate(snapshot);
                if (!res) {
                    this.mValidationMessages.addAll(linkedOrderRevision.mValidationMessages);
                }
                valid &= res;
            }
        }
        return valid;
    }

    public static class Revision
    implements Serializable {
        public transient Order Order;
        public final String OrderID;
        public Integer NewVolume;
        public Integer NewMaxShow;
        public Price NewLimitPrice;
        public Price NewStopPrice;
        public Price NewTrailPrice;
        public boolean PullOrder;
        public List<Revision> LinkedOrders = new ArrayList<Revision>();

        public Revision(Order order) {
            this.Order = order;
            this.OrderID = order.getUniqueID();
        }
    }
}

