/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.api.Market;
import com.t4login.api.SubmitResult;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.priceconversion.Price;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OrderPull
implements Serializable {
    public final String AccountID;
    public final Market Market;
    public final List<String> OrderIDs = new ArrayList<String>();
    public final BuySell Side;
    public final Price Price;
    private transient List<String> mPulledOrderIDs = new ArrayList<String>();
    private transient SubmitResult mSubmitResult = SubmitResult.NotSubmitted;
    private transient String mSubmitMsg = "";

    public OrderPull(String accountid, Market market, BuySell buySell, Price price) {
        this.AccountID = accountid;
        this.Market = market;
        this.Side = buySell;
        this.Price = price;
    }

    public OrderPull(String accountid, Market market, String orderid) {
        this.AccountID = accountid;
        this.Market = market;
        this.OrderIDs.add(orderid);
        this.Side = BuySell.Undefined;
        this.Price = null;
    }

    public OrderPull(String accountid, Market market) {
        this.AccountID = accountid;
        this.Market = market;
        this.Side = BuySell.Undefined;
        this.Price = null;
    }

    public void setSubmissionResult(SubmitResult res, String msg, List<String> orderIDs) {
        this.mSubmitResult = res;
        this.mSubmitMsg = msg;
        if (orderIDs != null) {
            this.mPulledOrderIDs = Collections.unmodifiableList(orderIDs);
        }
    }

    public List<String> getPulledOrderIDs() {
        return this.mPulledOrderIDs;
    }

    public SubmitResult getSubmitResult() {
        return this.mSubmitResult;
    }

    public String getSubmitMessage() {
        return this.mSubmitMsg;
    }
}

