/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.api.Market;
import com.t4login.api.MarketDataSnapshot;
import com.t4login.api.PriceVolume;
import com.t4login.api.SubmitResult;
import com.t4login.api.ValidationMessage;
import com.t4login.api.ValidationType;
import com.t4login.definitions.ActivationType;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.OrderType;
import com.t4login.definitions.PriceType;
import com.t4login.definitions.TimeType;
import com.t4login.definitions.priceconversion.Price;
import java.util.ArrayList;
import java.util.List;

public abstract class OrderAction {
    protected List<ValidationMessage> mValidationMessages = null;
    private SubmitResult mSubmitResult = SubmitResult.NotSubmitted;
    private String mSubmitMsg = "";

    public abstract boolean requiresTicket();

    public abstract boolean getReadyToValidate();

    public abstract Market getMarket();

    public abstract BuySell getSide();

    public abstract PriceType getPriceType();

    public abstract TimeType getTimeType();

    public abstract int getVolume();

    public abstract int getMaxShow();

    public abstract Price getLimitPrice();

    public abstract Price getStopPrice();

    public abstract Price getTrailPrice();

    public abstract ActivationType getActivationType();

    public abstract String getTag();

    public SubmitResult getSubmitResult() {
        return this.mSubmitResult;
    }

    public String getSubmitMessage() {
        return this.mSubmitMsg;
    }

    public void setSubmitResult(SubmitResult result) {
        this.mSubmitResult = result;
        this.mSubmitMsg = "";
    }

    public void setSubmitResult(SubmitResult result, String msg) {
        this.mSubmitResult = result;
        this.mSubmitMsg = msg;
    }

    public String getValidationMessage() {
        if (this.mValidationMessages != null && this.mValidationMessages.size() > 0) {
            return this.mValidationMessages.get(0).getValidationMessage();
        }
        return "";
    }

    public boolean volumeOnlyValidation() {
        return this.mValidationMessages.size() == 1 && this.mValidationMessages.get(0).getValidationType() == ValidationType.Volume;
    }

    public boolean validate(MarketDataSnapshot snapshot) {
        PriceType priceType;
        TimeType timeType;
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        ArrayList<ValidationMessage> validationWarningMessages = new ArrayList<ValidationMessage>();
        if (!this.getReadyToValidate()) {
            validationMessages.add(new ValidationMessage(ValidationType.Volume, "order_validation_incomplete"));
            this.mValidationMessages = validationMessages;
            return false;
        }
        if (this.getActivationType().equals(ActivationType.Hold)) {
            if (this.getVolume() != 0) {
                validationMessages.add(new ValidationMessage(ValidationType.Volume, "order_validation_held_volume_nonzero"));
            }
        } else if (this.getVolume() <= 0 && !this.getPriceType().equals(PriceType.RFQ) && !this.getPriceType().equals(PriceType.Flatten)) {
            validationMessages.add(new ValidationMessage(ValidationType.Volume, "order_validation_volume_zero"));
        } else {
            int volincr = this.getMarket().getVolumeIncrement();
            if (volincr != 0 && this.getVolume() % volincr != 0) {
                validationMessages.add(new ValidationMessage(ValidationType.Volume, "order_validation_volume_exchg_incr", Integer.toString(volincr)));
            }
        }
        if ((timeType = this.getTimeType()).equals(TimeType.CompleteVolume)) {
            if (!this.getMarket().isOrderTypeSupported(OrderType.CompleteVolume)) {
                validationMessages.add(new ValidationMessage(ValidationType.TimeType, "order_validation_timetype_completevolume", this.getMarket().getDescription()));
            }
        } else if (timeType.equals(TimeType.GoodTillCancelled)) {
            if (!this.getMarket().isOrderTypeSupported(OrderType.GoodTillCancelled)) {
                validationMessages.add(new ValidationMessage(ValidationType.TimeType, "order_validation_timetype_goodtillcancelled", this.getMarket().getDescription()));
            }
        } else if (timeType.equals(TimeType.ImmediateAndCancel)) {
            if (!this.getMarket().isOrderTypeSupported(OrderType.ImmediateAndCancel)) {
                validationMessages.add(new ValidationMessage(ValidationType.TimeType, "order_validation_timetype_immediateandcancel", this.getMarket().getDescription()));
            }
        } else if (timeType.equals(TimeType.MarketOnClose)) {
            if (!this.getMarket().isOrderTypeSupported(OrderType.MarketOnClose)) {
                validationMessages.add(new ValidationMessage(ValidationType.TimeType, "order_validation_timetype_marketonclose", this.getMarket().getDescription()));
            }
            if (this.getPriceType() != PriceType.Market) {
                validationMessages.add(new ValidationMessage(ValidationType.TimeType, "order_validation_timetype_marketonclose_notmarketorder", this.getMarket().getDescription()));
            }
        } else if (timeType.equals(TimeType.MarketOnOpen)) {
            if (!this.getMarket().isOrderTypeSupported(OrderType.MarketOnOpen)) {
                validationMessages.add(new ValidationMessage(ValidationType.TimeType, "order_validation_timetype_marketonopen", this.getMarket().getDescription()));
            }
            if (this.getPriceType() != PriceType.Market) {
                validationMessages.add(new ValidationMessage(ValidationType.TimeType, "order_validation_timetype_marketonopen_notmarketorder", this.getMarket().getDescription()));
            }
        } else if (timeType.equals(TimeType.Normal)) {
            if (this.getMarket().isOrderTypeSupported(OrderType.NoDayOrders)) {
                validationMessages.add(new ValidationMessage(ValidationType.TimeType, "order_validation_timetype_normal", this.getMarket().getDescription()));
            }
        } else if (timeType == TimeType.Undefined) {
            validationMessages.add(new ValidationMessage(ValidationType.TimeType, "order_validation_timetype_notspecified", this.getMarket().getDescription()));
        }
        if ((priceType = this.getPriceType()).equals(PriceType.Market)) {
            if (this.getLimitPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.LimitPriceNotNeeded, "order_validation_pricetype_limitpriceonmarketorder"));
            }
            if (this.getStopPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.StopPriceNotNeeded, "order_validation_pricetype_stoppriceonmarketorder"));
            }
            if (this.getTrailPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.TrailPriceNotNeeded, "order_validation_pricetype_trailtpriceonmarketorder"));
            }
        } else if (priceType.equals(PriceType.Limit)) {
            if (this.getLimitPrice() == null) {
                validationMessages.add(new ValidationMessage(ValidationType.LimitPriceNeeded, "order_validation_pricetype_nolimitpriceonlimitorder"));
            } else {
                validationWarningMessages.addAll(this.checkLimitPrice(snapshot));
            }
            if (this.getStopPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.StopPriceNotNeeded, "order_validation_pricetype_stoppriceonllimitorder"));
            }
        } else if (priceType.equals(PriceType.MarketIfTouched)) {
            if (this.getLimitPrice() == null) {
                validationMessages.add(new ValidationMessage(ValidationType.LimitPriceNeeded, "order_validation_pricetype_nolimitpriceonmarketiftouchedorder"));
            } else {
                validationWarningMessages.addAll(this.checkLimitPrice(snapshot));
            }
            if (this.getStopPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.StopPriceNotNeeded, "order_validation_pricetype_stoppriceonlmarketiftouchedorder"));
            }
        } else if (priceType.equals(PriceType.Hit)) {
            if (this.getLimitPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.LimitPriceNotNeeded, "order_validation_pricetype_limitpriceonhitorder"));
            }
            if (this.getStopPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.StopPriceNotNeeded, "order_validation_pricetype_stoppriceonhitorder"));
            }
            if (this.getTrailPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.TrailPriceNotNeeded, "order_validation_pricetype_trailtpriceonhitorder"));
            }
        } else if (priceType.equals(PriceType.Join)) {
            if (this.getLimitPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.LimitPriceNotNeeded, "order_validation_pricetype_limitpriceonjoinorder"));
            }
            if (this.getStopPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.StopPriceNotNeeded, "order_validation_pricetype_stoppriceonjoinorder"));
            }
            if (this.getTrailPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.TrailPriceNotNeeded, "order_validation_pricetype_trailtpriceonjoinorder"));
            }
        } else if (priceType.equals(PriceType.Pit)) {
            if (this.getLimitPrice() == null) {
                validationMessages.add(new ValidationMessage(ValidationType.LimitPriceNeeded, "order_validation_pricetype_nolimitpriceonpitorder"));
            }
            if (this.getStopPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.StopPriceNotNeeded, "order_validation_pricetype_stoppriceonpitorder"));
            }
            if (this.getTrailPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.TrailPriceNotNeeded, "order_validation_pricetype_trailtpriceonpitorder"));
            }
        } else if (priceType.equals(PriceType.StopLimit)) {
            if (this.getLimitPrice() == null) {
                validationMessages.add(new ValidationMessage(ValidationType.LimitPriceNeeded, "order_validation_pricetype_nolimitpriceonstoplimitorder"));
            }
            if (this.getStopPrice() == null) {
                validationMessages.add(new ValidationMessage(ValidationType.StopPriceNeeded, "order_validation_pricetype_nostoppriceonstoplimitorder"));
            } else {
                validationMessages.addAll(this.checkStopPrice(snapshot));
            }
        } else if (priceType.equals(PriceType.StopMarket)) {
            if (this.getLimitPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.LimitPriceNotNeeded, "order_validation_pricetype_limitpriceonstopmarketorder"));
            }
            if (this.getStopPrice() == null) {
                validationMessages.add(new ValidationMessage(ValidationType.StopPriceNeeded, "order_validation_pricetype_nostoppriceonstopmarketorder"));
            } else {
                validationMessages.addAll(this.checkStopPrice(snapshot));
            }
        } else if (priceType.equals(PriceType.StopSameLimit)) {
            if (this.getLimitPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.LimitPriceNotNeeded, "order_validation_pricetype_limitpriceonstopsamelimitorder"));
            }
            if (this.getStopPrice() == null) {
                validationMessages.add(new ValidationMessage(ValidationType.StopPriceNeeded, "order_validation_pricetype_nostoppriceonstopsamelimitorder"));
            } else {
                validationMessages.addAll(this.checkStopPrice(snapshot));
            }
        } else if (priceType.equals(PriceType.OvernightPosition)) {
            validationMessages.add(new ValidationMessage(ValidationType.PriceType, "order_validation_pricetype_noovernightpositionorders"));
        } else if (priceType.equals(PriceType.BackOfficePosition)) {
            validationMessages.add(new ValidationMessage(ValidationType.PriceType, "order_validation_pricetype_nobackofficepositionorders"));
        } else if (priceType.equals(PriceType.Flatten)) {
            if (this.getLimitPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.LimitPriceNotNeeded, "order_validation_pricetype_limitpriceonflattenorder"));
            }
            if (this.getStopPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.StopPriceNotNeeded, "order_validation_pricetype_stoppriceonflattenorder"));
            }
            if (this.getTrailPrice() != null) {
                validationMessages.add(new ValidationMessage(ValidationType.TrailPriceNotNeeded, "order_validation_pricetype_trailtpriceonflattenorder"));
            }
        } else if (priceType.equals(PriceType.Undefined)) {
            validationMessages.add(new ValidationMessage(ValidationType.PriceType, "order_validation_pricetype_nopricetypespecified"));
        }
        if (this.getMaxShow() < 0) {
            validationMessages.add(new ValidationMessage(ValidationType.MaxShow, "order_validation_maxshow_negative"));
        } else if (this.getMaxShow() > 0 && !this.getMarket().isOrderTypeSupported(OrderType.MaxShow)) {
            validationMessages.add(new ValidationMessage(ValidationType.MaxShow, "order_validation_maxshow_notsupported", this.getMarket().getDescription()));
        }
        this.mValidationMessages = validationMessages;
        return validationMessages.size() == 0;
    }

    private List<ValidationMessage> checkStopPrice(MarketDataSnapshot snapshot) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        Price activationPrice = null;
        if (this.getActivationType().equals(ActivationType.Immediate) || this.getActivationType().equals(ActivationType.Triggered)) {
            Price lastTradePrice = null;
            PriceVolume bestBidImplTicks = null;
            PriceVolume bestOfferImplTicks = null;
            if (snapshot != null) {
                lastTradePrice = snapshot.LastTradePrice();
                bestBidImplTicks = snapshot.bestBidWithImplied();
                bestOfferImplTicks = snapshot.bestOfferWithImplied();
            }
            if (this.getSide().equals(BuySell.Buy)) {
                if (lastTradePrice != null) {
                    if (this.getStopPrice().compareTo(lastTradePrice) < 0) {
                        validationMessages.add(new ValidationMessage(ValidationType.StopWrongSide, "order_validation_stopprice_buystopnotatorabovelasttrade"));
                    }
                } else if (bestBidImplTicks != null && bestBidImplTicks.Price != null && this.getStopPrice().compareTo(bestBidImplTicks.Price) < 0) {
                    validationMessages.add(new ValidationMessage(ValidationType.StopWrongSide, "order_validation_stopprice_buystopnotatorabovebestbid"));
                }
            } else if (lastTradePrice != null) {
                if (this.getStopPrice().compareTo(lastTradePrice) > 0) {
                    validationMessages.add(new ValidationMessage(ValidationType.StopWrongSide, "order_validation_stopprice_sellstopnotatorabovelasttrade"));
                }
            } else if (bestBidImplTicks != null && bestOfferImplTicks.Price != null && this.getStopPrice().compareTo(bestOfferImplTicks.Price) > 0) {
                validationMessages.add(new ValidationMessage(ValidationType.StopWrongSide, "order_validation_stopprice_sellstopnotatorabovebestoffer"));
            }
        } else if (this.getActivationType().equals(ActivationType.AtOrAboveTradeTicks) || this.getActivationType().equals(ActivationType.AtOrBelowTradeTicks)) {
            if (this.getSide().equals(BuySell.Buy)) {
                if (activationPrice != null && this.getStopPrice().compareTo(activationPrice) < 0) {
                    validationMessages.add(new ValidationMessage(ValidationType.StopWrongSide, "order_validation_stopprice_buystopmustbeatoraboveactiviationprice"));
                }
            } else if (activationPrice != null && this.getStopPrice().compareTo(activationPrice) > 0) {
                validationMessages.add(new ValidationMessage(ValidationType.StopWrongSide, "order_validation_stopprice_sellstopmustbeatorbelowactiviationprice"));
            }
        }
        return validationMessages;
    }

    private List<ValidationMessage> checkLimitPrice(MarketDataSnapshot snapshot) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        Price activationPrice = null;
        if (this.getActivationType().equals(ActivationType.Immediate) || this.getActivationType().equals(ActivationType.Triggered)) {
            if (this.getSide().equals(BuySell.Buy)) {
                PriceVolume bestOfferTicks = null;
                PriceVolume bestOfferImplTicks = null;
                if (snapshot != null) {
                    bestOfferTicks = snapshot.bestOffer();
                    bestOfferImplTicks = snapshot.bestOfferWithImplied();
                }
                if (bestOfferTicks != null && bestOfferTicks.Price != null) {
                    if (this.getLimitPrice().compareTo(bestOfferTicks.Price) >= 0) {
                        validationMessages.add(new ValidationMessage(ValidationType.LimitInstantFill, "order_validation_limitprice_buylimitinstantfill"));
                    }
                } else if (bestOfferImplTicks != null && bestOfferImplTicks.Price != null && this.getLimitPrice().compareTo(bestOfferImplTicks.Price) >= 0) {
                    validationMessages.add(new ValidationMessage(ValidationType.LimitInstantFill, "order_validation_limitprice_buylimitinstantfill"));
                }
            } else {
                PriceVolume bestBidTicks = null;
                PriceVolume bestBidImplTicks = null;
                if (snapshot != null) {
                    bestBidTicks = snapshot.bestBid();
                    bestBidImplTicks = snapshot.bestBidWithImplied();
                }
                if (bestBidTicks != null && bestBidTicks.Price != null) {
                    if (this.getLimitPrice().compareTo(bestBidTicks.Price) <= 0) {
                        validationMessages.add(new ValidationMessage(ValidationType.LimitInstantFill, "order_validation_limitprice_selllimitinstantfill"));
                    }
                } else if (bestBidImplTicks != null && bestBidImplTicks.Price != null && this.getLimitPrice().compareTo(bestBidImplTicks.Price) <= 0) {
                    validationMessages.add(new ValidationMessage(ValidationType.LimitInstantFill, "order_validation_limitprice_selllimitinstantfill"));
                }
            }
        } else if (this.getActivationType().equals(ActivationType.AtOrAboveTradeTicks) || this.getActivationType().equals(ActivationType.AtOrBelowTradeTicks)) {
            if (this.getSide().equals(BuySell.Buy)) {
                if (activationPrice != null && this.getStopPrice().compareTo(activationPrice) >= 0) {
                    validationMessages.add(new ValidationMessage(ValidationType.LimitInstantFill, "order_validation_limitprice_buylimitinstantfill"));
                }
            } else if (activationPrice != null && this.getStopPrice().compareTo(activationPrice) <= 0) {
                validationMessages.add(new ValidationMessage(ValidationType.LimitInstantFill, "order_validation_limitprice_selllimitinstantfill"));
            }
        }
        return validationMessages;
    }
}

