/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Host;
import com.t4login.api.Market;
import com.t4login.api.MarketDataSnapshot;
import com.t4login.application.settings.PriceDisplayMode;
import com.t4login.definitions.DepthBuffer;
import com.t4login.definitions.DepthLevels;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.definitions.util.MarketUtil;
import com.t4login.messages.Message;
import com.t4login.messages.MessageType;
import com.t4login.messages.MsgMarketSnapshotD;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class MarketSubscription {
    private static final String TAG = "MarketSubscription";
    private Market market;
    private Map<Price, String> mDisplayPrices = new HashMap<Price, String>();
    private PriceDisplayMode mDisplayPricesFormat = PriceDisplayMode.PriceFormatAndDecimal;
    private DepthBuffer mSubscriptionBuffer = DepthBuffer.NoSubscription;
    private DepthLevels mSubscriptionLevels = DepthLevels.BestOnly;
    private boolean mMBOSubscription = false;
    private volatile MarketDataSnapshot snapshot;

    public MarketSubscription(Market mkt) {
        this.market = mkt;
        this.snapshot = new MarketDataSnapshot(this.market);
    }

    public String toString() {
        return String.format("[%s], Buffer/Levels: %s/%s, MBO: %b", this.market.getMarketID(), this.mSubscriptionBuffer, this.mSubscriptionLevels, this.mMBOSubscription);
    }

    public Market getMarket() {
        return this.market;
    }

    public void updateMarket(Market mkt) {
        this.market = mkt;
        this.mDisplayPrices = new HashMap<Price, String>();
    }

    public synchronized MarketDataSnapshot updateSnapshot(Message msg) {
        if (msg != null && msg.getMessageType() == MessageType.MarketSnapshotD) {
            MsgMarketSnapshotD snapmsg = (MsgMarketSnapshotD)msg;
            this.snapshot = new MarketDataSnapshot(this.market, this.snapshot, snapmsg.Messages, this.mSubscriptionBuffer.getIsTradeFeed(), Host.getMarketDataOptions());
        } else {
            this.snapshot = new MarketDataSnapshot(this.market, this.snapshot, msg, this.mSubscriptionBuffer.getIsTradeFeed(), Host.getMarketDataOptions());
        }
        return this.snapshot;
    }

    public MarketDataSnapshot getSnapshot() {
        return this.snapshot;
    }

    public EnumSet<SubscriptionChange> updateSubscriptionLevels(DepthBuffer bufferLevel, DepthLevels depthLevel, boolean mbo) {
        boolean newMBO;
        EnumSet<SubscriptionChange> change = EnumSet.noneOf(SubscriptionChange.class);
        DepthBuffer newBuffer = MarketUtil.depthSubscribeAtLeast(bufferLevel, this.mSubscriptionBuffer);
        DepthLevels newLevels = MarketUtil.depthSubscribeAtLeast(depthLevel, this.mSubscriptionLevels);
        if (!this.mSubscriptionBuffer.equals(newBuffer) || !this.mSubscriptionLevels.equals(newLevels)) {
            this.mSubscriptionBuffer = newBuffer;
            this.mSubscriptionLevels = newLevels;
            change.add(SubscriptionChange.Depth);
        }
        if (this.mMBOSubscription != (newMBO = this.mMBOSubscription | mbo)) {
            this.mMBOSubscription = newMBO;
            change.add(SubscriptionChange.MBO);
        }
        return change;
    }

    public EnumSet<SubscriptionChange> setSubscriptionLevels(DepthBuffer bufferLevel, DepthLevels depthLevel, boolean mbo) {
        EnumSet<SubscriptionChange> change = EnumSet.noneOf(SubscriptionChange.class);
        if (!this.mSubscriptionBuffer.equals(bufferLevel) || !this.mSubscriptionLevels.equals(depthLevel)) {
            this.mSubscriptionBuffer = bufferLevel;
            this.mSubscriptionLevels = depthLevel;
            change.add(SubscriptionChange.Depth);
        }
        if (this.mMBOSubscription != mbo) {
            this.mMBOSubscription = mbo;
            change.add(SubscriptionChange.MBO);
        }
        return change;
    }

    public DepthBuffer getDepthBuffer() {
        return this.mSubscriptionBuffer;
    }

    public DepthLevels getDepthLevels() {
        return this.mSubscriptionLevels;
    }

    public boolean getMBOSubscribed() {
        return this.mMBOSubscription;
    }

    public String getFormattedDisplayPrice(Price price, PriceDisplayMode mode) {
        Map<Price, String> prcMap;
        String fmt;
        if (mode != this.mDisplayPricesFormat) {
            this.mDisplayPrices = new HashMap<Price, String>();
            this.mDisplayPricesFormat = mode;
        }
        if ((fmt = (prcMap = this.mDisplayPrices).get(price)) == null) {
            fmt = PriceFormat.convertPriceToDisplayFormat(price, (IPriceFormatArgs)this.market, mode);
            prcMap.put(price, fmt);
        }
        return fmt;
    }

    public void clearCachedValues() {
        this.mDisplayPrices = new HashMap<Price, String>();
    }

    public static enum SubscriptionChange {
        Depth,
        MBO;

    }
}

