/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.StrategyType;
import java.text.SimpleDateFormat;

public class MarketPickerGroup
implements Cloneable {
    public final StrategyType StrategyType;
    public final int ExpiryDate;
    public final int MarketCount;
    private static final SimpleDateFormat ExpiryDateFormat = NDateTime.createDateFormat("MMMyy");

    public MarketPickerGroup(StrategyType st, int exp, int count) {
        this.StrategyType = st;
        this.ExpiryDate = exp;
        this.MarketCount = count;
    }

    public String getDescription() {
        if (this.ExpiryDate == 0) {
            return this.StrategyType.getDescription();
        }
        int year = this.ExpiryDate / 10000;
        int month = this.ExpiryDate / 100 - year * 100;
        NDateTime expdt = new NDateTime(year, month, 1);
        return this.StrategyType.getDescription() + " " + expdt.toString(ExpiryDateFormat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketPickerGroup that = (MarketPickerGroup)o;
        if (this.ExpiryDate != that.ExpiryDate) {
            return false;
        }
        return this.StrategyType == that.StrategyType;
    }

    public int hashCode() {
        int result = this.StrategyType.hashCode();
        result = 31 * result + this.ExpiryDate;
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "MarketPickerGroup{StrategyType=" + String.valueOf(this.StrategyType) + ", ExpiryDate=" + this.ExpiryDate + ", MarketCount=" + this.MarketCount + "}";
    }
}

