/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.api.Market;
import com.t4login.definitions.ContinuationType;
import com.t4login.definitions.ContractMonths;
import java.util.Arrays;
import java.util.Locale;

public final class MarketID {
    public static final String VOLUME_CONTINUATION_MARKETID = "VOLUME_CONTINUATION";
    public static final String EXPIRY_CONTINUATION_MARKETID = "EXPIRY_CONTINUATION";
    public final String ExchangeID;
    public final String ContractID;
    public final String MarketID;
    public final ContinuationType ContinuationType;
    public final int RolloverDays;
    public final int ForwardMonths;
    public final ContractMonths[] ExpiryMonths;
    public static final MarketID Empty = new MarketID("", "", "");

    public static MarketID create(Market market) {
        return new MarketID(market.getExchangeID(), market.getContractID(), market.getMarketID());
    }

    public MarketID(String eid, String cid, String mid) {
        this.ExchangeID = eid;
        this.ContractID = cid;
        this.MarketID = mid;
        this.ContinuationType = com.t4login.definitions.ContinuationType.Volume;
        this.RolloverDays = 0;
        this.ForwardMonths = 0;
        this.ExpiryMonths = new ContractMonths[0];
    }

    public MarketID(String eid, String cid) {
        this.ExchangeID = eid;
        this.ContractID = cid;
        this.MarketID = "";
        this.ContinuationType = com.t4login.definitions.ContinuationType.Volume;
        this.RolloverDays = 0;
        this.ForwardMonths = 0;
        this.ExpiryMonths = new ContractMonths[0];
    }

    public MarketID(String eid, String cid, ContinuationType continutationType, int rolloverDays, int forwardMonths, ContractMonths[] expiryMonths) {
        this.ExchangeID = eid;
        this.ContractID = cid;
        this.MarketID = "";
        this.ContinuationType = continutationType;
        this.RolloverDays = rolloverDays;
        this.ForwardMonths = forwardMonths;
        this.ExpiryMonths = expiryMonths;
    }

    public boolean isEmpty() {
        return this.ExchangeID == null || this.ExchangeID.isEmpty();
    }

    public String toString() {
        if (this.MarketID != null && this.MarketID.length() > 0) {
            return "MarketID{ExchangeID='" + this.ExchangeID + "', ContractID='" + this.ContractID + "', MarketID='" + this.MarketID + "'}";
        }
        if (this.ContinuationType.equals(com.t4login.definitions.ContinuationType.Volume)) {
            return "MarketID{ExchangeID='" + this.ExchangeID + "', ContractID='" + this.ContractID + "', Market By Volume";
        }
        return String.format(Locale.US, "MarketID(%s, %s, NE-%d+%d", this.ExchangeID, this.ContractID, this.RolloverDays, this.ForwardMonths);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketID other = (MarketID)o;
        if (this.ContractID != null ? !this.ContractID.equals(other.ContractID) : other.ContractID != null) {
            return false;
        }
        if (this.ExchangeID != null ? !this.ExchangeID.equals(other.ExchangeID) : other.ExchangeID != null) {
            return false;
        }
        if (this.MarketID != null && this.MarketID.length() > 0) {
            return this.MarketID.equals(other.MarketID);
        }
        if (!this.ContinuationType.equals(other.ContinuationType)) {
            return false;
        }
        if (!this.ContinuationType.equals(com.t4login.definitions.ContinuationType.Volume)) {
            if (this.RolloverDays != other.RolloverDays) {
                return false;
            }
            if (this.ForwardMonths != other.ForwardMonths) {
                return false;
            }
            if (!Arrays.equals(this.ExpiryMonths, other.ExpiryMonths)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.ExchangeID != null ? this.ExchangeID.hashCode() : 0;
        result = 31 * result + (this.ContractID != null ? this.ContractID.hashCode() : 0);
        result = 31 * result + (this.MarketID != null ? this.MarketID.hashCode() : 0);
        if (this.MarketID == null || this.MarketID.length() == 0) {
            result = 31 * result + this.ContinuationType.hashCode();
            result = 31 * result + this.RolloverDays;
            result = 31 * result + this.ForwardMonths;
            result = 31 * result + this.ExpiryMonths.hashCode();
        }
        return result;
    }
}

