/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.api.LegMarket;
import com.t4login.api.Market;
import com.t4login.api.MarketData;
import com.t4login.application.settings.AppSettings;
import com.t4login.application.settings.ExpiryDisplayMode;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.StrategyType;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.messages.MsgMarketDetails;
import java.util.HashMap;
import java.util.Map;

public class MarketFormatter {
    private static final String[] ContractPrefixes = new String[]{"LV", "SIM", "DV", "D-30m", "D-12h", "D-1d", "D-2d", "D-3d", "D-4d", "D-5d"};
    private Map<String, String> mFormattedExpiries = new HashMap<String, String>();

    public MarketFormatter() {
    }

    public MarketFormatter(boolean enableCache) {
        if (!enableCache) {
            this.mFormattedExpiries = null;
        }
    }

    public void clear() {
        this.mFormattedExpiries.clear();
    }

    public String getFormattedMarketExpiryDescription(Market market, MarketData marketData) {
        String descr = null;
        if (this.mFormattedExpiries != null && (descr = this.mFormattedExpiries.get(market.getMarketID())) != null) {
            return descr;
        }
        descr = market.Msg.StrategyType.equals(StrategyType.None) || market.Msg.StrategyType.equals(StrategyType.VolatilityQuotedOption) ? MarketFormatter.getOutrightExpiryDescription(market) : (market.Msg.StrategyType.equals(StrategyType.Strip) || market.Msg.StrategyType.equals(StrategyType.AveragePriceStrip) || market.Msg.StrategyType.equals(StrategyType.UnbalancedStrip) || market.Msg.StrategyType.equals(StrategyType.BalancedStrip) ? this.getStripExpiryDescription(market) : (market.Msg.StrategyType.equals(StrategyType.AveragePriceStripSpread) ? this.getStripSpreadExpiryDescription(market) : (market.Msg.StrategyType.equals(StrategyType.MonthVsPack) ? this.getMonthVsPackDescription(market) : (market.Msg.StrategyType.equals(StrategyType.Pack) || market.Msg.StrategyType.equals(StrategyType.Bundle) ? this.getPackDescription(market) : (market.Msg.StrategyType.equals(StrategyType.PackSpread) || market.Msg.StrategyType.equals(StrategyType.BundleSpread) ? this.getPackSpreadDescription(market) : (market.Msg.StrategyType.equals(StrategyType.PackButterfly) ? this.getPackButterflyDescription(market) : (market.Msg.StrategyType.equals(StrategyType.Crush) ? this.getCrushDescription(market) : this.getSimpleSpreadExpiryDescription(market))))))));
        if (this.mFormattedExpiries != null) {
            this.mFormattedExpiries.put(market.getMarketID(), descr);
        }
        return descr;
    }

    public String getFormattedMarketDescription(Market market, MarketData marketData) {
        return market.Contract.getDescription() + " " + this.getFormattedMarketExpiryDescription(market, marketData);
    }

    public static String getFormattedContractDescription(String contractID, String baseDescr, String clearingCode, boolean delayedExchange) {
        String prefix = null;
        Object descr = null;
        for (String pfx : ContractPrefixes) {
            if (!baseDescr.startsWith(pfx + ":")) continue;
            prefix = pfx;
            descr = baseDescr.replace(pfx + ":", "");
            break;
        }
        if (descr == null) {
            descr = baseDescr;
        }
        switch (AppSettings.instance.MarketData.ContractDisplay) {
            case ClearingCode: {
                if (clearingCode != null && clearingCode.length() > 0) {
                    descr = clearingCode;
                    break;
                }
                descr = contractID;
                break;
            }
            case ContractID: {
                descr = contractID;
                break;
            }
        }
        if (prefix != null && prefix.length() > 0) {
            descr = prefix + ":" + (String)descr;
        }
        if (delayedExchange) {
            return "\u00ab" + (String)descr;
        }
        return descr;
    }

    private static String getOutrightExpiryDescription(Market market) {
        StringBuilder sb = new StringBuilder();
        String expiryDescr = MarketFormatter.getExpiryDescription(market.Msg.ExpiryDate);
        sb.append(expiryDescr);
        String details = MarketFormatter.getContractTypeDetails(market);
        if (details != null && details.length() > 0) {
            MarketFormatter.appendGap(sb);
            sb.append(details);
        }
        return sb.toString();
    }

    private static String getExpiryDescription(int expiryDate) {
        StringBuilder sb = new StringBuilder();
        String expiryDateStr = Integer.toString(expiryDate);
        String yearStr = expiryDateStr.substring(0, 4);
        String monthStr = expiryDateStr.substring(4, 6);
        String dayStr = expiryDateStr.substring(6, 8);
        dayStr = dayStr.replaceFirst("^0+", "");
        if (AppSettings.instance.MarketData.ExpiryDisplay.equals(ExpiryDisplayMode.MonthCodeAnd2DigitYear) || AppSettings.instance.MarketData.ExpiryDisplay.equals(ExpiryDisplayMode.MonthCodeAnd1DigitYear)) {
            if (AppSettings.instance.MarketData.ExpiryDisplay.equals(ExpiryDisplayMode.MonthCodeAnd2DigitYear)) {
                sb.append(dayStr);
                sb.append(MarketFormatter.getMonthCode(Integer.valueOf(monthStr)));
                sb.append(expiryDateStr, 2, 4);
            } else {
                sb.append(dayStr);
                sb.append(MarketFormatter.getMonthCode(Integer.valueOf(monthStr)));
                sb.append(expiryDateStr, 3, 4);
            }
        } else {
            NDateTime exp = new NDateTime(Integer.valueOf(yearStr), Integer.valueOf(monthStr), 1);
            sb.append(dayStr);
            sb.append(exp.toString("MMMyy"));
        }
        return sb.toString();
    }

    private static void appendGap(StringBuilder sb) {
        char lastChar;
        if (sb.length() > 0 && (lastChar = sb.charAt(sb.length() - 1)) != ' ' && lastChar != '(' && lastChar != ')' && lastChar != '+' && lastChar != '-' && lastChar != 'x') {
            sb.append(" ");
        }
    }

    private String getSimpleSpreadExpiryDescription(Market market) {
        StringBuilder sb = new StringBuilder();
        sb.append(market.Msg.StrategyType.getAbbreviation());
        MarketFormatter.appendGap(sb);
        for (int i = 0; i < market.Msg.Legs.size(); ++i) {
            this.addMarketLeg(market, i, sb);
        }
        if (market.Msg.StrategyRatio > 0.0) {
            sb.append(" r");
            sb.append(market.Msg.StrategyRatio);
        }
        return sb.toString();
    }

    private static String getContractTypeDetails(Market market) {
        if (market.Msg.StrikePrice != null) {
            Comparable<Market> underlyingMarket;
            Comparable<Market> comparable = underlyingMarket = market.UnderlyingMarket != null ? market.UnderlyingMarket : market;
            if (market.Msg.ContractType == ContractType.Option) {
                return PriceFormat.convertPriceToDisplayFormat(market.Msg.StrikePrice, underlyingMarket, AppSettings.instance.MarketData.StrikePriceDisplay, PriceFormat.PriceType.StrikePrice);
            }
            if (market.Msg.ContractType == ContractType.OptionCall) {
                return PriceFormat.convertPriceToDisplayFormat(market.Msg.StrikePrice, underlyingMarket, AppSettings.instance.MarketData.StrikePriceDisplay, PriceFormat.PriceType.StrikePrice) + "C";
            }
            if (market.Msg.ContractType == ContractType.OptionPut) {
                return PriceFormat.convertPriceToDisplayFormat(market.Msg.StrikePrice, underlyingMarket, AppSettings.instance.MarketData.StrikePriceDisplay, PriceFormat.PriceType.StrikePrice) + "P";
            }
        }
        if (market.Msg.Details != null && market.Msg.Details.length() > 0) {
            return market.Msg.Details;
        }
        return "";
    }

    private static String getContractTypeDetails(LegMarket legMarket) {
        if (legMarket.StrikePrice != null) {
            LegMarket underlyingMarket;
            LegMarket legMarket2 = underlyingMarket = legMarket.UnderlyingMarket != null ? legMarket.UnderlyingMarket : legMarket;
            if (legMarket.ContractType == ContractType.Option) {
                return PriceFormat.convertPriceToDisplayFormat(legMarket.StrikePrice, underlyingMarket, AppSettings.instance.MarketData.StrikePriceDisplay, PriceFormat.PriceType.StrikePrice);
            }
            if (legMarket.ContractType == ContractType.OptionCall) {
                return PriceFormat.convertPriceToDisplayFormat(legMarket.StrikePrice, underlyingMarket, AppSettings.instance.MarketData.StrikePriceDisplay, PriceFormat.PriceType.StrikePrice) + "C";
            }
            if (legMarket.ContractType == ContractType.OptionPut) {
                return PriceFormat.convertPriceToDisplayFormat(legMarket.StrikePrice, underlyingMarket, AppSettings.instance.MarketData.StrikePriceDisplay, PriceFormat.PriceType.StrikePrice) + "P";
            }
        }
        if (legMarket.Details != null && legMarket.Details.length() > 0) {
            return legMarket.Details;
        }
        return "";
    }

    private static String getMonthCode(int month) {
        switch (month) {
            case 1: {
                return "F";
            }
            case 2: {
                return "G";
            }
            case 3: {
                return "H";
            }
            case 4: {
                return "J";
            }
            case 5: {
                return "K";
            }
            case 6: {
                return "M";
            }
            case 7: {
                return "N";
            }
            case 8: {
                return "Q";
            }
            case 9: {
                return "U";
            }
            case 10: {
                return "V";
            }
            case 11: {
                return "X";
            }
        }
        return "Z";
    }

    private String getStripExpiryDescription(Market market) {
        StringBuilder sb = new StringBuilder();
        sb.append(market.Msg.StrategyType.getAbbreviation());
        MarketFormatter.appendGap(sb);
        sb.append(this.getStripDefinedDescription(market, 0, market.LegMarkets.length));
        return sb.toString();
    }

    private String getStripSpreadExpiryDescription(Market market) {
        MsgMarketDetails.LegItem firstLegItem = market.Msg.Legs.get(0);
        int secondStripLegIndex = -1;
        for (int i = 1; i < market.Msg.Legs.size(); ++i) {
            MsgMarketDetails.LegItem legItem = market.Msg.Legs.get(i);
            if (legItem.Group == firstLegItem.Group) continue;
            secondStripLegIndex = i;
            break;
        }
        if (secondStripLegIndex < 0) {
            return this.getSimpleSpreadExpiryDescription(market);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(market.Msg.StrategyType.getAbbreviation());
        MarketFormatter.appendGap(sb);
        sb.append(this.getStripDefinedDescription(market, 0, secondStripLegIndex));
        sb.append(this.getStripDefinedDescription(market, secondStripLegIndex, market.Msg.Legs.size() - secondStripLegIndex));
        return sb.toString();
    }

    private String getStripDefinedDescription(Market market, int firstLegIndex, int nLegs) {
        MsgMarketDetails.LegItem firstLegItem = market.Msg.Legs.get(firstLegIndex);
        LegMarket firstLegMarket = market.LegMarkets[firstLegIndex];
        boolean stripD = true;
        boolean stripM = true;
        boolean stripQ = true;
        boolean stripH = true;
        boolean stripY = true;
        if (firstLegMarket.ExpiryDate % 100 == 0) {
            stripD = false;
        } else {
            stripM = false;
            stripQ = false;
            stripH = false;
            stripY = false;
        }
        if (Math.abs(firstLegItem.Volume) != 1) {
            stripD = false;
            stripM = false;
            stripQ = false;
            stripH = false;
            stripY = false;
        }
        NDateTime lastExpiry = MarketFormatter.getExpiryDate(firstLegMarket.ExpiryDate);
        NDateTime expiryDate = NDateTime.MinValue;
        for (int i = firstLegIndex + 1; i < firstLegIndex + nLegs; ++i) {
            MsgMarketDetails.LegItem legItem = market.Msg.Legs.get(i);
            LegMarket legMarket = market.LegMarkets[i];
            if (!(legItem.Volume == firstLegItem.Volume && legMarket.ExchangeID.equals(firstLegMarket.ExchangeID) && legMarket.ContractID.equals(firstLegMarket.ContractID) && legMarket.Details.equals(firstLegMarket.Details))) {
                stripD = false;
                stripM = false;
                stripQ = false;
                stripH = false;
                stripY = false;
                break;
            }
            expiryDate = MarketFormatter.getExpiryDate(legMarket.ExpiryDate);
            if (legMarket.ExpiryDate % 100 != 0) {
                stripM = false;
                stripQ = false;
                stripH = false;
                stripY = false;
                if (!lastExpiry.AddDays(1.0).equals(expiryDate)) {
                    stripD = false;
                    break;
                }
            } else {
                stripD = false;
                if (!lastExpiry.AddMonths(1).equals(expiryDate)) {
                    stripM = false;
                    break;
                }
                if (!lastExpiry.AddMonths(3).equals(expiryDate)) {
                    stripQ = false;
                    break;
                }
                if (!lastExpiry.AddMonths(6).equals(expiryDate)) {
                    stripH = false;
                    break;
                }
                if (!lastExpiry.AddMonths(12).equals(expiryDate)) {
                    stripY = false;
                    break;
                }
            }
            lastExpiry = expiryDate;
        }
        if (stripD) {
            return this.getStripDescription(market, firstLegIndex, nLegs, "d");
        }
        if (stripM) {
            return this.getStripDescription(market, firstLegIndex, nLegs, "m");
        }
        if (stripQ) {
            return this.getStripDescription(market, firstLegIndex, nLegs, "q");
        }
        if (stripH) {
            return this.getStripDescription(market, firstLegIndex, nLegs, "h");
        }
        if (stripY) {
            return this.getStripDescription(market, firstLegIndex, nLegs, "y");
        }
        return this.getSimpleSpreadExpiryDescription(market, firstLegIndex, nLegs);
    }

    public static NDateTime getExpiryDate(int expiryDate) {
        String expiryDateStr = Integer.toString(expiryDate);
        String yearStr = expiryDateStr.substring(0, 4);
        int year = Integer.parseInt(yearStr);
        String monthStr = expiryDateStr.substring(4, 6);
        int month = Integer.parseInt(monthStr);
        String dayStr = expiryDateStr.substring(6, 8);
        int day = Math.max(1, Integer.parseInt(dayStr));
        return new NDateTime(year, month, day);
    }

    private String getStripDescription(Market market, int firstLegIndex, int nLegs, String differential) {
        MsgMarketDetails.LegItem firstLegItem = market.Msg.Legs.get(firstLegIndex);
        LegMarket firstLegMarket = market.LegMarkets[firstLegIndex];
        StringBuilder sb = new StringBuilder();
        if (firstLegItem.Volume > 0) {
            sb.append("+");
        } else if (firstLegItem.Volume < 0) {
            sb.append("-");
        }
        if (firstLegItem.Volume > 1 || firstLegItem.Volume < -1) {
            sb.append(Math.abs(firstLegItem.Volume)).append("x");
        }
        MarketFormatter.appendGap(sb);
        sb.append(MarketFormatter.getExpiryDescription(firstLegMarket.ExpiryDate));
        String details = MarketFormatter.getContractTypeDetails(firstLegMarket);
        if (details.length() > 0) {
            MarketFormatter.appendGap(sb);
            sb.append(details);
        }
        if (nLegs > 0) {
            sb.append(":").append(nLegs).append(differential);
        }
        return sb.toString();
    }

    private String getSimpleSpreadExpiryDescription(Market market, int firstLegIndex, int nLegs) {
        StringBuilder sb = new StringBuilder();
        for (int i = firstLegIndex; i < firstLegIndex + nLegs; ++i) {
            this.addMarketLeg(market, i, sb);
        }
        if (market.Msg.StrategyRatio > 0.0) {
            sb.append(" r");
            sb.append(market.Msg.StrategyRatio);
        }
        return sb.toString();
    }

    private String getMonthVsPackDescription(Market market) {
        int nYears = (market.LegMarkets.length - 1) / 4;
        if (nYears == 0 || nYears * 4 != market.LegMarkets.length - 1) {
            return this.getSimpleSpreadExpiryDescription(market);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(market.Msg.StrategyType.getAbbreviation());
        MarketFormatter.appendGap(sb);
        this.addMarketLeg(market, 0, sb);
        this.addPackDescription(market, 1, nYears, sb);
        return sb.toString();
    }

    private String getPackDescription(Market market) {
        int nYears = market.LegMarkets.length / 4;
        if (nYears == 0 || nYears * 4 != market.LegMarkets.length) {
            return this.getSimpleSpreadExpiryDescription(market);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(market.Msg.StrategyType.getAbbreviation());
        MarketFormatter.appendGap(sb);
        this.addPackDescription(market, 0, nYears, sb);
        return sb.toString();
    }

    private String getPackSpreadDescription(Market market) {
        int nYears = market.LegMarkets.length / 8;
        if (nYears == 0 || nYears * 8 != market.LegMarkets.length) {
            return this.getSimpleSpreadExpiryDescription(market);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(market.Msg.StrategyType.getAbbreviation());
        MarketFormatter.appendGap(sb);
        this.addPackDescription(market, 0, nYears, sb);
        this.addPackDescription(market, market.LegMarkets.length / 2, nYears, sb);
        return sb.toString();
    }

    private String getPackButterflyDescription(Market market) {
        int nYears = market.LegMarkets.length / 12;
        if (nYears == 0 || nYears * 12 != market.LegMarkets.length) {
            return this.getSimpleSpreadExpiryDescription(market);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(market.Msg.StrategyType.getAbbreviation());
        MarketFormatter.appendGap(sb);
        this.addPackDescription(market, 0, nYears, sb);
        this.addPackDescription(market, market.LegMarkets.length / 3, nYears, sb);
        this.addPackDescription(market, market.LegMarkets.length * 2 / 3, nYears, sb);
        return sb.toString();
    }

    private String getCrushDescription(Market market) {
        if (market.Msg.ExpiryDate == market.LegMarkets[0].ExpiryDate && market.Msg.ExpiryDate == market.LegMarkets[1].ExpiryDate && market.Msg.ExpiryDate == market.LegMarkets[2].ExpiryDate) {
            return MarketFormatter.getExpiryDescription(market.Msg.ExpiryDate);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MarketFormatter.getExpiryDescription(market.LegMarkets[0].ExpiryDate));
        MarketFormatter.appendGap(sb);
        sb.append(MarketFormatter.getExpiryDescription(market.LegMarkets[1].ExpiryDate));
        MarketFormatter.appendGap(sb);
        sb.append(MarketFormatter.getExpiryDescription(market.LegMarkets[2].ExpiryDate));
        return sb.toString();
    }

    private void addPackDescription(Market market, int legIndex, int nYears, StringBuilder sb) {
        String details;
        MsgMarketDetails.LegItem legItem = market.Msg.Legs.get(legIndex);
        LegMarket legMarket = market.LegMarkets[legIndex];
        if (legItem.Volume > 0) {
            sb.append("+");
        } else if (legItem.Volume < 0) {
            sb.append("-");
        }
        if (legItem.Volume > 1 || legItem.Volume < -1) {
            sb.append(Math.abs(legItem.Volume)).append("x");
        }
        if (legIndex == 0 || legMarket.ExpiryDate != market.LegMarkets[0].ExpiryDate) {
            MarketFormatter.appendGap(sb);
            sb.append(MarketFormatter.getExpiryDescription(legMarket.ExpiryDate));
        }
        if ((details = MarketFormatter.getContractTypeDetails(legMarket)).length() > 0) {
            if (legIndex != 0) {
                String firstLegDetails = MarketFormatter.getContractTypeDetails(market.LegMarkets[0]);
                if (!details.equals(firstLegDetails)) {
                    MarketFormatter.appendGap(sb);
                    sb.append(details);
                }
            } else {
                MarketFormatter.appendGap(sb);
                sb.append(details);
            }
        }
        if (nYears > 0) {
            sb.append(":");
            sb.append(nYears);
            sb.append("y");
        }
    }

    private void addMarketLeg(Market market, int legIndex, StringBuilder sb) {
        String details;
        MsgMarketDetails.LegItem legItem = market.Msg.Legs.get(legIndex);
        LegMarket legMarket = market.LegMarkets[legIndex];
        if (legItem.Volume > 0) {
            sb.append("+");
        } else if (legItem.Volume < 0) {
            sb.append("-");
        }
        if (legItem.Volume > 1 || legItem.Volume < -1) {
            sb.append(Math.abs(legItem.Volume)).append("x");
        }
        if (!legMarket.ContractID.equals(market.getContractID()) || !legMarket.ContractID.equals(market.LegMarkets[0].ContractID)) {
            String legContractDescr = MarketFormatter.getFormattedContractDescription(legMarket.ContractID, legMarket.ContractDescription, legMarket.ClearingCode, market.Contract.Exchange.getIsDelayed());
            sb.append(legContractDescr);
        }
        if (legIndex == 0 || legMarket.ExpiryDate != market.LegMarkets[0].ExpiryDate) {
            MarketFormatter.appendGap(sb);
            sb.append(MarketFormatter.getExpiryDescription(legMarket.ExpiryDate));
        }
        if ((details = MarketFormatter.getContractTypeDetails(legMarket)).length() > 0) {
            if (legIndex != 0) {
                String firstLegDetails = MarketFormatter.getContractTypeDetails(market.LegMarkets[0]);
                if (!details.equals(firstLegDetails)) {
                    MarketFormatter.appendGap(sb);
                    sb.append(details);
                }
            } else {
                MarketFormatter.appendGap(sb);
                sb.append(details);
            }
        }
        if (!(legIndex != 0 && legItem.Delta.equals(market.Msg.Legs.get((int)0).Delta) && legItem.Price.equals(market.Msg.Legs.get((int)0).Price) || legItem.Delta.length() <= 0 || legItem.Price.length() <= 0)) {
            MarketFormatter.appendGap(sb);
            sb.append("d");
            sb.append(legItem.Delta);
            sb.append("@");
            Price deltaPrice = Price.of(legItem.Price);
            sb.append(PriceFormat.convertPriceToDisplayFormat(deltaPrice, (IPriceFormatArgs)legMarket, AppSettings.instance.MarketData.PriceDisplay));
        }
    }
}

