/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Log;
import com.t4login.MarketDataOptions;
import com.t4login.api.Market;
import com.t4login.api.MarketDataChange;
import com.t4login.api.PriceVolume;
import com.t4login.api.marketbyorder.MarketByOrder;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.DepthBuffer;
import com.t4login.definitions.DepthLevels;
import com.t4login.definitions.ImpliedPriceType;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.OrderType;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.messages.Message;
import com.t4login.messages.MsgMarketByOrderSnapshot;
import com.t4login.messages.MsgMarketByOrderUpdate;
import com.t4login.messages.MsgMarketDepthD;
import com.t4login.messages.MsgMarketDepthTradeD;
import com.t4login.messages.MsgMarketHighLowD;
import com.t4login.messages.MsgMarketPriceLimitsD;
import com.t4login.messages.MsgMarketSettlementD;
import com.t4login.messages.MsgMarketTradeHistoryD;
import com.t4login.messages.MsgMarketTradeVolumeD;
import com.t4login.util.ValueCompare;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.StreamSupport;

public final class MarketDataSnapshot {
    private static final String TAG = "MarketDataSnapshot";
    public final Market Market;
    private MsgMarketDepthD msgMarketDepth2;
    private LastTradeData lastTrade;
    private MsgMarketSettlementD msgMarketSettlement;
    private MsgMarketHighLowD msgMarketHighLow2;
    private MsgMarketPriceLimitsD msgMarketPriceLimits;
    private MsgMarketTradeVolumeD msgMarketTradeVolume;
    private MsgMarketTradeHistoryD msgMarketTradeHistory;
    private MarketByOrder marketByOrder;
    public static final MarketDataSnapshot Empty = new MarketDataSnapshot();

    private MarketDataSnapshot() {
        this.Market = com.t4login.api.Market.Empty;
        this.lastTrade = new LastTradeData();
        this.msgMarketDepth2 = new MsgMarketDepthD();
        this.msgMarketSettlement = new MsgMarketSettlementD();
        this.msgMarketHighLow2 = new MsgMarketHighLowD();
        this.msgMarketPriceLimits = new MsgMarketPriceLimitsD();
        this.msgMarketTradeVolume = new MsgMarketTradeVolumeD();
        this.msgMarketTradeHistory = new MsgMarketTradeHistoryD();
        this.marketByOrder = new MarketByOrder();
    }

    public MarketDataSnapshot(Market market) {
        this.Market = market;
        this.lastTrade = new LastTradeData();
        this.msgMarketDepth2 = new MsgMarketDepthD();
        this.msgMarketSettlement = new MsgMarketSettlementD();
        this.msgMarketHighLow2 = new MsgMarketHighLowD();
        this.msgMarketPriceLimits = new MsgMarketPriceLimitsD();
        this.msgMarketTradeVolume = new MsgMarketTradeVolumeD();
        this.msgMarketTradeHistory = new MsgMarketTradeHistoryD();
        this.marketByOrder = new MarketByOrder();
    }

    public MarketDataSnapshot(Market market, List<Message> msgs, boolean tradeFeed, MarketDataOptions options) {
        this(market, null, msgs, tradeFeed, options);
    }

    public MarketDataSnapshot(Market market, MarketDataSnapshot prev, Message msg, boolean tradeFeed, MarketDataOptions options) {
        this(market, prev, MarketDataSnapshot.ListOf(msg), tradeFeed, options);
    }

    public MarketDataSnapshot(Market market, MarketDataSnapshot prev, List<Message> msgs, boolean tradeFeed, MarketDataOptions options) {
        this.Market = market;
        if (prev != null) {
            this.msgMarketDepth2 = prev.msgMarketDepth2;
            this.lastTrade = prev.lastTrade;
            this.msgMarketSettlement = prev.msgMarketSettlement;
            this.msgMarketHighLow2 = prev.msgMarketHighLow2;
            this.msgMarketPriceLimits = prev.msgMarketPriceLimits;
            this.msgMarketTradeVolume = prev.msgMarketTradeVolume;
            this.msgMarketTradeHistory = prev.msgMarketTradeHistory;
            this.marketByOrder = prev.marketByOrder;
        } else {
            this.lastTrade = new LastTradeData();
            this.msgMarketSettlement = new MsgMarketSettlementD();
            this.msgMarketHighLow2 = new MsgMarketHighLowD();
            this.msgMarketPriceLimits = new MsgMarketPriceLimitsD();
            this.msgMarketTradeHistory = new MsgMarketTradeHistoryD();
            this.msgMarketTradeVolume = new MsgMarketTradeVolumeD();
            this.marketByOrder = new MarketByOrder();
        }
        block12: for (Message msg : msgs) {
            switch (msg.getMessageType()) {
                case MarketDepthD: {
                    this.msgMarketDepth2 = (MsgMarketDepthD)msg;
                    if (this.msgMarketDepth2.DepthTrade == null) continue block12;
                    if (this.lastTrade.TotalTradedVolume == 0 || this.msgMarketDepth2.DepthMode.Mode == MarketMode.PreOpen) {
                        this.lastTrade = new LastTradeData(this.msgMarketDepth2);
                        if (options.supportsTradeHistory()) {
                            this.msgMarketTradeHistory = MarketDataSnapshot.updateTradeHistory(this.msgMarketTradeHistory, this.lastTrade);
                        }
                        if (!options.supportsTradeVolumeProfile()) continue block12;
                        this.msgMarketTradeVolume = MarketDataSnapshot.updateTradeVolume(this.msgMarketTradeVolume, this.lastTrade);
                        continue block12;
                    }
                    if (tradeFeed) continue block12;
                    if (this.msgMarketDepth2.DepthTrade.TotalTradedVolume < this.lastTrade.TotalTradedVolume && this.msgMarketDepth2.Time.compareTo(this.lastTrade.Time) < 0) {
                        this.lastTrade = new LastTradeData(this.msgMarketDepth2);
                        if (options.supportsTradeHistory()) {
                            this.msgMarketTradeHistory = MarketDataSnapshot.updateTradeHistory(this.msgMarketTradeHistory, this.lastTrade);
                        }
                        if (!options.supportsTradeVolumeProfile()) continue block12;
                        this.msgMarketTradeVolume = MarketDataSnapshot.updateTradeVolume(this.msgMarketTradeVolume, this.lastTrade);
                        continue block12;
                    }
                    if (this.msgMarketDepth2.DepthMode.Mode == MarketMode.Undefined) continue block12;
                    this.lastTrade = new LastTradeData(this.lastTrade, this.msgMarketDepth2);
                    if (options.supportsTradeHistory()) {
                        this.msgMarketTradeHistory = MarketDataSnapshot.updateTradeHistory(this.msgMarketTradeHistory, this.lastTrade);
                    }
                    if (!options.supportsTradeVolumeProfile()) continue block12;
                    this.msgMarketTradeVolume = MarketDataSnapshot.updateTradeVolume(this.msgMarketTradeVolume, this.lastTrade);
                    continue block12;
                }
                case MarketDepthTradeD: {
                    MsgMarketDepthTradeD msgtrd = (MsgMarketDepthTradeD)msg;
                    if (this.lastTrade.TotalTradedVolume >= msgtrd.TotalTradedVolume) continue block12;
                    this.lastTrade = new LastTradeData(this.lastTrade, msgtrd);
                    if (options.supportsTradeHistory()) {
                        this.msgMarketTradeHistory = MarketDataSnapshot.updateTradeHistory(this.msgMarketTradeHistory, this.lastTrade);
                    }
                    if (!options.supportsTradeVolumeProfile()) continue block12;
                    this.msgMarketTradeVolume = MarketDataSnapshot.updateTradeVolume(this.msgMarketTradeVolume, this.lastTrade);
                    continue block12;
                }
                case MarketSettlementD: {
                    this.msgMarketSettlement = (MsgMarketSettlementD)msg;
                    continue block12;
                }
                case MarketHighLowD: {
                    this.msgMarketHighLow2 = (MsgMarketHighLowD)msg;
                    continue block12;
                }
                case MarketPriceLimitsD: {
                    this.msgMarketPriceLimits = (MsgMarketPriceLimitsD)msg;
                    continue block12;
                }
                case MarketTradeVolumeD: {
                    this.msgMarketTradeVolume = (MsgMarketTradeVolumeD)msg;
                    continue block12;
                }
                case MarketTradeHistoryD: {
                    this.msgMarketTradeHistory = (MsgMarketTradeHistoryD)msg;
                    continue block12;
                }
                case MarketByOrderSnapshot: {
                    if (!options.aggregateMBOIntoSnapshot()) continue block12;
                    this.marketByOrder = this.marketByOrder.processSnapshot((MsgMarketByOrderSnapshot)msg);
                    continue block12;
                }
                case MarketByOrderUpdate: {
                    if (!options.aggregateMBOIntoSnapshot()) continue block12;
                    this.marketByOrder = this.marketByOrder.processUpdate((MsgMarketByOrderUpdate)msg);
                    continue block12;
                }
                case MarketByOrderReject: {
                    if (!options.aggregateMBOIntoSnapshot()) continue block12;
                    this.marketByOrder = new MarketByOrder();
                    continue block12;
                }
            }
            Log.e(TAG, "Unknown message type: " + String.valueOf((Object)msg.getMessageType()));
        }
    }

    public boolean isEmpty() {
        return this.Market.getMarketID().isEmpty();
    }

    public boolean isReady() {
        return !this.isEmpty() && this.msgMarketDepth2 != null && this.msgMarketDepth2.DepthMode != null;
    }

    private static MsgMarketTradeHistoryD updateTradeHistory(MsgMarketTradeHistoryD msgHistory, LastTradeData newTrade) {
        if (newTrade.LastTradePrice == null) {
            return msgHistory;
        }
        MsgMarketTradeHistoryD hist = new MsgMarketTradeHistoryD();
        hist.MarketID = msgHistory.MarketID;
        hist.TradeDate = msgHistory.TradeDate;
        hist.History.addAll(msgHistory.History);
        Price newPrice = newTrade.LastTradePrice;
        if (hist.History.size() > 0) {
            if (hist.History.get((int)0).Price.equals(newPrice)) {
                hist.History.set(0, new MsgMarketTradeHistoryD.TradeHistory(newPrice, hist.History.get((int)0).Volume + newTrade.LastTradeVolume, newTrade.Time));
            } else {
                hist.History.add(0, new MsgMarketTradeHistoryD.TradeHistory(newPrice, newTrade.LastTradeVolume, newTrade.Time));
                while (hist.History.size() > 100) {
                    hist.History.remove(hist.History.size() - 1);
                }
            }
        } else {
            hist.History.add(new MsgMarketTradeHistoryD.TradeHistory(newPrice, newTrade.LastTradeVolume, newTrade.Time));
        }
        return hist;
    }

    private static MsgMarketTradeVolumeD updateTradeVolume(MsgMarketTradeVolumeD msgVolume, LastTradeData newTrade) {
        if (newTrade.LastTradePrice == null) {
            return msgVolume;
        }
        MsgMarketTradeVolumeD vol = new MsgMarketTradeVolumeD();
        vol.MarketID = msgVolume.MarketID;
        vol.TradeDate = msgVolume.TradeDate;
        ((ArrayList)vol.Volume).ensureCapacity(msgVolume.Volume.size());
        Price newPrice = newTrade.LastTradePrice;
        boolean found = false;
        for (MsgMarketTradeVolumeD.TradeVolume volumeItem : msgVolume.Volume) {
            if (!found && volumeItem.Price.equals(newPrice)) {
                vol.Volume.add(new MsgMarketTradeVolumeD.TradeVolume(newPrice, volumeItem.Volume + newTrade.LastTradeVolume, newTrade.Time));
                found = true;
                continue;
            }
            vol.Volume.add(volumeItem);
        }
        if (!found) {
            vol.Volume.add(new MsgMarketTradeVolumeD.TradeVolume(newPrice, newTrade.LastTradeVolume, newTrade.Time));
        }
        return vol;
    }

    private static List<Message> ListOf(Message msg) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        if (msg != null) {
            msgs.add(msg);
        }
        return msgs;
    }

    public EnumSet<MarketDataChange> getChanges(MarketDataSnapshot snapshot) {
        EnumSet<MarketDataChange> changes = EnumSet.noneOf(MarketDataChange.class);
        if (snapshot == null || !this.Market.getMarketID().equals(snapshot.Market.getMarketID())) {
            return EnumSet.allOf(MarketDataChange.class);
        }
        if (this.msgMarketDepth2 != null && this.msgMarketDepth2.DepthMode != null && (snapshot.msgMarketDepth2 == null || this.msgMarketDepth2 != snapshot.msgMarketDepth2)) {
            if (snapshot.msgMarketDepth2 == null || snapshot.msgMarketDepth2.DepthMode == null || this.msgMarketDepth2.DepthMode.Mode != snapshot.msgMarketDepth2.DepthMode.Mode) {
                changes.add(MarketDataChange.Mode);
            }
            changes.add(MarketDataChange.Depth);
        }
        if (this.marketByOrder != null && snapshot.marketByOrder != null && !this.marketByOrder.getLastUpdateTime().equals(snapshot.marketByOrder.getLastUpdateTime())) {
            changes.add(MarketDataChange.Depth);
        }
        if (this.lastTrade != snapshot.lastTrade) {
            if (ValueCompare.Compare(this.lastTrade.LastTradePrice, snapshot.lastTrade.LastTradePrice) != 0 || ValueCompare.Compare(this.lastTrade.LastTradePriceSpd, snapshot.lastTrade.LastTradePriceSpd) != 0) {
                changes.add(MarketDataChange.LastTradePrice);
                changes.add(MarketDataChange.NetChange);
            }
            if (this.lastTrade.LastTradeVolume != snapshot.lastTrade.LastTradeVolume || this.lastTrade.LastTradeVolumeSpd != snapshot.lastTrade.LastTradeVolumeSpd) {
                changes.add(MarketDataChange.LastTradeVolume);
            }
            if (this.lastTrade.LastTradeTotalVolume != snapshot.lastTrade.LastTradeTotalVolume || this.lastTrade.LastTradeTotalVolumeSpd != snapshot.lastTrade.LastTradeTotalVolumeSpd) {
                changes.add(MarketDataChange.LastTradeVolume);
            }
            if (this.lastTrade.TotalTradedVolume != snapshot.lastTrade.TotalTradedVolume) {
                changes.add(MarketDataChange.TotalTradedVolume);
            }
        }
        if (!(this.msgMarketSettlement == snapshot.msgMarketSettlement || this.msgMarketSettlement != null && this.msgMarketSettlement.SettlementPrice != null && this.msgMarketSettlement.SettlementPrice.equals(snapshot.msgMarketSettlement.SettlementPrice) && this.msgMarketSettlement.SettlementHeldPrice.equals(snapshot.msgMarketSettlement.SettlementHeldPrice))) {
            changes.add(MarketDataChange.SettlementPrice);
            changes.add(MarketDataChange.NetChange);
        }
        if (this.msgMarketHighLow2 != null && snapshot.msgMarketHighLow2 != null) {
            if (this.msgMarketHighLow2 != snapshot.msgMarketHighLow2) {
                if (this.msgMarketHighLow2.HighPrice == null || !this.msgMarketHighLow2.HighPrice.equals(snapshot.msgMarketHighLow2.HighPrice)) {
                    changes.add(MarketDataChange.HighPrice);
                }
                if (this.msgMarketHighLow2.LowPrice == null || !this.msgMarketHighLow2.LowPrice.equals(snapshot.msgMarketHighLow2.LowPrice)) {
                    changes.add(MarketDataChange.LowPrice);
                }
                if (this.msgMarketHighLow2.OpenPrice == null || !this.msgMarketHighLow2.OpenPrice.equals(snapshot.msgMarketHighLow2.OpenPrice)) {
                    changes.add(MarketDataChange.OpenPrice);
                }
            }
        } else if (this.msgMarketHighLow2 != null ^ snapshot.msgMarketHighLow2 != null) {
            changes.add(MarketDataChange.HighPrice);
            changes.add(MarketDataChange.LowPrice);
            changes.add(MarketDataChange.OpenPrice);
        }
        if (this.msgMarketPriceLimits != snapshot.msgMarketPriceLimits) {
            changes.add(MarketDataChange.PriceLimits);
        }
        if (this.msgMarketTradeVolume != snapshot.msgMarketTradeVolume) {
            changes.add(MarketDataChange.TradeVolume);
        }
        if (this.msgMarketTradeHistory != snapshot.msgMarketTradeHistory) {
            changes.add(MarketDataChange.TradeHistory);
        }
        return changes;
    }

    public boolean hasDepth() {
        return this.msgMarketDepth2 != null;
    }

    public MsgMarketDepthD marketDepthMessage() {
        return this.msgMarketDepth2;
    }

    public DepthBuffer getChangeBuffer() {
        if (this.msgMarketDepth2 != null) {
            return this.msgMarketDepth2.ChangeBuffer;
        }
        return DepthBuffer.NoSubscription;
    }

    public DepthLevels getChangeLevel() {
        if (this.msgMarketDepth2 != null) {
            return this.msgMarketDepth2.ChangeLevel;
        }
        return DepthLevels.Undefined;
    }

    public MsgMarketTradeHistoryD tradeHistoryMessage() {
        return this.msgMarketTradeHistory;
    }

    public MsgMarketTradeVolumeD tradeVolumeMessage() {
        return this.msgMarketTradeVolume;
    }

    public MarketMode getMarketMode() {
        if (this.msgMarketDepth2 != null && this.msgMarketDepth2.DepthMode != null) {
            return this.msgMarketDepth2.DepthMode.Mode;
        }
        return MarketMode.Undefined;
    }

    public Price LastTradePrice() {
        if (this.lastTrade.LastTradeVolume > 0) {
            return this.lastTrade.LastTradePrice;
        }
        return null;
    }

    public Price SettlementPrice() {
        if (this.msgMarketSettlement.SettlementTime != null) {
            return this.msgMarketSettlement.SettlementPrice;
        }
        return null;
    }

    public Integer LastTradeVolume() {
        return this.lastTrade.LastTradeVolume;
    }

    public Integer LastTradeTotalVolume() {
        return this.lastTrade.LastTradeTotalVolume;
    }

    public Price LastTradePriceTicksSpd() {
        if (this.lastTrade.LastTradeTotalVolumeSpd > 0) {
            return this.lastTrade.LastTradePriceSpd;
        }
        return null;
    }

    public Integer LastTradeVolumeSpd() {
        return this.lastTrade.LastTradeVolumeSpd;
    }

    public Integer LastTradeTotalVolumeSpd() {
        return this.lastTrade.LastTradeTotalVolumeSpd;
    }

    public Price getNetChange(boolean lastTradeSpread, boolean useHeldSettlement) {
        Price settlement;
        Price lastTradePrice = lastTradeSpread ? this.LastTradePriceTicksSpd() : this.LastTradePrice();
        if (lastTradePrice != null && this.msgMarketSettlement != null && !this.msgMarketSettlement.MarketID.isEmpty() && (settlement = useHeldSettlement ? this.msgMarketSettlement.SettlementHeldPrice : this.msgMarketSettlement.SettlementPrice) != null) {
            return lastTradePrice.subtract(settlement);
        }
        return null;
    }

    public BigDecimal getNetChangePercent(boolean lastTradeSpread, boolean useHeldSettlement) {
        Price lastTradePrice = lastTradeSpread ? this.LastTradePriceTicksSpd() : this.LastTradePrice();
        if (lastTradePrice != null && this.msgMarketSettlement != null && !this.msgMarketSettlement.MarketID.isEmpty()) {
            Price settlement = useHeldSettlement ? this.msgMarketSettlement.SettlementHeldPrice : this.msgMarketSettlement.SettlementPrice;
            if (settlement != null && settlement.equals(Price.Zero)) {
                return BigDecimal.ZERO;
            }
            if (settlement != null) {
                return new BigDecimal(100).multiply(lastTradePrice.getDecimalValue().subtract(settlement.getDecimalValue()).divide(settlement.getDecimalValue().abs(), 18, 6));
            }
        }
        return null;
    }

    public Integer TotalTradedVolume() {
        return this.lastTrade.TotalTradedVolume;
    }

    public List<DepthItem> getBids() {
        if (this.marketByOrder.getOrderCount() > 0) {
            return StreamSupport.stream(this.marketByOrder.getBids().getValues().spliterator(), false).map(lvl -> new DepthItem(lvl.getPrice(), lvl.getVolume(), lvl.getOrderCount())).toList();
        }
        return this.msgMarketDepth2.Depth.Bids.stream().map(b -> new DepthItem(b.Price, b.Volume, b.NumOfOrders)).toList();
    }

    public List<DepthItem> getImpliedBids() {
        return this.msgMarketDepth2.Depth.ImpliedBids.stream().map(b -> new DepthItem(b.Price, b.Volume, b.NumOfOrders)).toList();
    }

    public List<DepthItem> getOffers() {
        if (this.marketByOrder.getOrderCount() > 0) {
            return StreamSupport.stream(this.marketByOrder.getOffers().getValues().spliterator(), false).map(lvl -> new DepthItem(lvl.getPrice(), lvl.getVolume(), lvl.getOrderCount())).toList();
        }
        return this.msgMarketDepth2.Depth.Offers.stream().map(b -> new DepthItem(b.Price, b.Volume, b.NumOfOrders)).toList();
    }

    public List<DepthItem> getImpliedOffers() {
        return this.msgMarketDepth2.Depth.ImpliedOffers.stream().map(b -> new DepthItem(b.Price, b.Volume, b.NumOfOrders)).toList();
    }

    public PriceVolume bestBid() {
        if (this.msgMarketDepth2 != null && this.msgMarketDepth2.Depth != null && this.msgMarketDepth2.Depth.Bids.size() > 0) {
            return new PriceVolume(this.msgMarketDepth2.Depth.Bids.get((int)0).Price, this.msgMarketDepth2.Depth.Bids.get((int)0).Volume);
        }
        return PriceVolume.Empty;
    }

    public PriceVolume bestOffer() {
        if (this.msgMarketDepth2 != null && this.msgMarketDepth2.Depth != null && this.msgMarketDepth2.Depth.Offers.size() > 0) {
            return new PriceVolume(this.msgMarketDepth2.Depth.Offers.get((int)0).Price, this.msgMarketDepth2.Depth.Offers.get((int)0).Volume);
        }
        return PriceVolume.Empty;
    }

    public PriceVolume bestImpliedBid() {
        if (this.msgMarketDepth2 != null && this.msgMarketDepth2.Depth != null && this.msgMarketDepth2.Depth.ImpliedBids.size() > 0) {
            return new PriceVolume(this.msgMarketDepth2.Depth.ImpliedBids.get((int)0).Price, this.msgMarketDepth2.Depth.ImpliedBids.get((int)0).Volume);
        }
        return PriceVolume.Empty;
    }

    public PriceVolume bestImpliedOffer() {
        if (this.msgMarketDepth2 != null && this.msgMarketDepth2.Depth != null && this.msgMarketDepth2.Depth.ImpliedOffers.size() > 0) {
            return new PriceVolume(this.msgMarketDepth2.Depth.ImpliedOffers.get((int)0).Price, this.msgMarketDepth2.Depth.ImpliedOffers.get((int)0).Volume);
        }
        return PriceVolume.Empty;
    }

    public PriceVolume bestBidWithImplied() {
        PriceVolume bid = this.bestBid();
        PriceVolume implbid = this.bestImpliedBid();
        if (implbid.Price == null) {
            return bid;
        }
        if (bid.Price == null) {
            return implbid;
        }
        int cv = bid.Price.compareTo(implbid.Price);
        if (cv > 0) {
            return bid;
        }
        if (cv < 0) {
            return implbid;
        }
        if (implbid.Volume != 0) {
            return new PriceVolume(implbid.Price, bid.Volume + Math.max(implbid.Volume, 0));
        }
        return new PriceVolume(implbid.Price, bid.Volume);
    }

    public PriceVolume bestOfferWithImplied() {
        PriceVolume offer = this.bestOffer();
        PriceVolume imploffer = this.bestImpliedOffer();
        if (imploffer.Price == null) {
            return offer;
        }
        if (offer.Price == null) {
            return imploffer;
        }
        int cv = offer.Price.compareTo(imploffer.Price);
        if (cv < 0) {
            return offer;
        }
        if (cv > 0) {
            return imploffer;
        }
        if (imploffer.Volume != 0) {
            return new PriceVolume(imploffer.Price, offer.Volume + Math.max(imploffer.Volume, 0));
        }
        return new PriceVolume(imploffer.Price, offer.Volume);
    }

    public PriceVolume bestBidWithMatchingImplied() {
        if (this.Market.isOrderTypeSupported(OrderType.ImpliedMatching)) {
            return this.bestBidWithImplied();
        }
        return this.bestBid();
    }

    public PriceVolume bestOfferWithMatchingImplied() {
        if (this.Market.isOrderTypeSupported(OrderType.ImpliedMatching)) {
            return this.bestOfferWithImplied();
        }
        return this.bestOffer();
    }

    public Price getBidValue(BigDecimal wideMarket) {
        Price bestBid = this.bestBidWithMatchingImplied().Price;
        Price bestOffer = this.bestOfferWithMatchingImplied().Price;
        Price lastTradePrice = this.LastTradePrice();
        Price settlementPrice = this.SettlementPrice();
        if (wideMarket.compareTo(BigDecimal.ZERO) >= 0) {
            if (bestBid != null && bestOffer != null) {
                Price spread = bestOffer.subtract(bestBid);
                BigDecimal spreadCash = PriceFormat.convertPriceToCashValue(spread, this.Market);
                if (spreadCash.compareTo(wideMarket) > 0) {
                    if (lastTradePrice != null && lastTradePrice.compareTo(bestBid) > 0) {
                        return lastTradePrice;
                    }
                    if (settlementPrice != null && settlementPrice.compareTo(bestBid) > 0) {
                        return settlementPrice;
                    }
                }
            } else {
                if (lastTradePrice != null) {
                    return lastTradePrice;
                }
                return settlementPrice;
            }
        }
        if (bestBid != null) {
            return bestBid;
        }
        if (lastTradePrice != null) {
            return lastTradePrice;
        }
        return settlementPrice;
    }

    public Price getOfferValue(BigDecimal wideMarket) {
        Price bestBid = this.bestBidWithMatchingImplied().Price;
        Price bestOffer = this.bestOfferWithMatchingImplied().Price;
        Price lastTradePrice = this.LastTradePrice();
        Price settlementPrice = this.SettlementPrice();
        if (wideMarket.compareTo(BigDecimal.ZERO) >= 0) {
            if (bestBid != null && bestOffer != null) {
                Price spread = bestOffer.subtract(bestBid);
                BigDecimal spreadCash = PriceFormat.convertPriceToCashValue(spread, this.Market);
                if (spreadCash.compareTo(wideMarket) > 0) {
                    if (lastTradePrice != null && lastTradePrice.compareTo(bestOffer) < 0) {
                        return lastTradePrice;
                    }
                    if (settlementPrice != null && settlementPrice.compareTo(bestOffer) < 0) {
                        return settlementPrice;
                    }
                }
            } else {
                if (lastTradePrice != null) {
                    return lastTradePrice;
                }
                return settlementPrice;
            }
        }
        if (bestOffer != null) {
            return bestOffer;
        }
        if (lastTradePrice != null) {
            return lastTradePrice;
        }
        return settlementPrice;
    }

    public Price getTradeValue() {
        Price tradeValue = this.LastTradePrice();
        if (tradeValue == null && this.msgMarketSettlement.SettlementTime != null && this.msgMarketSettlement.SettlementPrice != null) {
            tradeValue = this.msgMarketSettlement.SettlementPrice;
        }
        return tradeValue;
    }

    public PriceVolume getDisplayBestBid(Market market, ImpliedPriceType impprctyp) {
        if (market.isOrderTypeSupported(OrderType.ImpliedMatching) && impprctyp != ImpliedPriceType.None || impprctyp == ImpliedPriceType.All) {
            return this.bestBidWithImplied();
        }
        return this.bestBid();
    }

    public PriceVolume getDisplayBestOffer(Market market, ImpliedPriceType impprctyp) {
        if (market.isOrderTypeSupported(OrderType.ImpliedMatching) && impprctyp != ImpliedPriceType.None || impprctyp == ImpliedPriceType.All) {
            return this.bestOfferWithImplied();
        }
        return this.bestOffer();
    }

    public PriceVolume getDisplayLastTrade(boolean lastTradeCumulativeVolume, boolean lastTradeSpread) {
        int volume;
        Price price;
        if (lastTradeSpread) {
            price = this.lastTrade.LastTradePriceSpd;
            volume = this.lastTrade.LastTradeVolumeSpd;
            if (lastTradeCumulativeVolume) {
                volume = this.lastTrade.LastTradeTotalVolumeSpd;
            }
        } else {
            price = this.lastTrade.LastTradePrice;
            volume = this.lastTrade.LastTradeVolume;
            if (lastTradeCumulativeVolume) {
                volume = this.lastTrade.LastTradeTotalVolume;
            }
        }
        if (price != null) {
            return new PriceVolume(price, volume);
        }
        return PriceVolume.Empty;
    }

    public Price getDisplaySettlement(boolean useHeldSettlement) {
        if (this.msgMarketSettlement != null && this.msgMarketSettlement.SettlementTime != null && this.msgMarketSettlement.SettlementTime.compareTo(NDateTime.MinValue) > 0) {
            if (useHeldSettlement) {
                return this.msgMarketSettlement.SettlementHeldPrice;
            }
            return this.msgMarketSettlement.SettlementPrice;
        }
        return null;
    }

    public Price getHighPrice() {
        if (this.msgMarketHighLow2 != null && !this.msgMarketHighLow2.MarketID.isEmpty() && this.msgMarketHighLow2.Time.compareTo(NDateTime.MinValue) > 0) {
            return this.msgMarketHighLow2.HighPrice;
        }
        return null;
    }

    public Price getLowPrice() {
        if (this.msgMarketHighLow2 != null && !this.msgMarketHighLow2.MarketID.isEmpty() && this.msgMarketHighLow2.Time.compareTo(NDateTime.MinValue) > 0) {
            return this.msgMarketHighLow2.LowPrice;
        }
        return null;
    }

    public Price getOpenPrice() {
        if (this.msgMarketHighLow2 != null && !this.msgMarketHighLow2.MarketID.isEmpty() && this.msgMarketHighLow2.Time.compareTo(NDateTime.MinValue) > 0) {
            return this.msgMarketHighLow2.OpenPrice;
        }
        return null;
    }

    public Price getHighPriceLimit() {
        if (this.msgMarketPriceLimits != null) {
            return this.msgMarketPriceLimits.HighPrice;
        }
        return null;
    }

    public Price getLowPriceLimit() {
        if (this.msgMarketPriceLimits != null) {
            return this.msgMarketPriceLimits.LowPrice;
        }
        return null;
    }

    public int getOpenInterest() {
        if (this.msgMarketSettlement != null) {
            return this.msgMarketSettlement.OpenInterest;
        }
        return 0;
    }

    public NDateTime getOpenInterestTime() {
        if (this.msgMarketSettlement != null) {
            return this.msgMarketSettlement.OpenInterestTime;
        }
        return NDateTime.MinValue;
    }

    public NDateTime getOpenInterestTradeDate() {
        if (this.msgMarketSettlement != null) {
            return this.msgMarketSettlement.OpenInterestTradeDate;
        }
        return NDateTime.MinValue;
    }

    public int getPreviousOpenInterest() {
        if (this.msgMarketSettlement != null) {
            return this.msgMarketSettlement.PrevOpenInterest;
        }
        return 0;
    }

    public NDateTime getPreviousOpenInterestTime() {
        if (this.msgMarketSettlement != null) {
            return this.msgMarketSettlement.PrevOpenInterestTime;
        }
        return NDateTime.MinValue;
    }

    public NDateTime getPreviousOpenInterestTradeDate() {
        if (this.msgMarketSettlement != null) {
            return this.msgMarketSettlement.PrevOpenInterestTradeDate;
        }
        return NDateTime.MinValue;
    }

    public MarketByOrder getMarketByOrder() {
        return this.marketByOrder;
    }

    private static class LastTradeData {
        public final NDateTime Time;
        public final Price LastTradePrice;
        public final int LastTradeVolume;
        public final int LastTradeTotalVolume;
        public final Price LastTradePriceSpd;
        public final int LastTradeVolumeSpd;
        public final int LastTradeTotalVolumeSpd;
        public final int TotalTradedVolume;

        public LastTradeData() {
            this.Time = NDateTime.MinValue;
            this.LastTradePrice = null;
            this.LastTradeVolume = 0;
            this.LastTradeTotalVolume = 0;
            this.LastTradePriceSpd = null;
            this.LastTradeVolumeSpd = 0;
            this.LastTradeTotalVolumeSpd = 0;
            this.TotalTradedVolume = 0;
        }

        public LastTradeData(LastTradeData prev, MsgMarketDepthTradeD msg) {
            if (msg.DueToSpread) {
                this.LastTradePriceSpd = msg.LastTradePrice;
                this.LastTradeVolumeSpd = msg.LastTradeVolume;
                this.LastTradeTotalVolumeSpd = prev.LastTradePriceSpd == msg.LastTradePrice ? prev.LastTradeTotalVolumeSpd + msg.LastTradeVolume : msg.LastTradeVolume;
                if (prev.LastTradeTotalVolume > 0) {
                    this.LastTradePrice = prev.LastTradePrice;
                    this.LastTradeVolume = prev.LastTradeVolume;
                    this.LastTradeTotalVolume = prev.LastTradeTotalVolume;
                } else {
                    this.LastTradePrice = msg.LastTradePrice;
                    this.LastTradeVolume = msg.LastTradeVolume;
                    this.LastTradeTotalVolume = msg.LastTradeVolume;
                }
            } else {
                this.LastTradePrice = msg.LastTradePrice;
                this.LastTradeVolume = msg.LastTradeVolume;
                this.LastTradePriceSpd = msg.LastTradePrice;
                this.LastTradeVolumeSpd = msg.LastTradeVolume;
                this.LastTradeTotalVolumeSpd = prev.LastTradePriceSpd == msg.LastTradePrice ? prev.LastTradeTotalVolumeSpd + msg.LastTradeVolume : msg.LastTradeVolume;
                this.LastTradeTotalVolume = prev.LastTradePrice == msg.LastTradePrice ? prev.LastTradeTotalVolume + msg.LastTradeVolume : msg.LastTradeVolume;
            }
            this.Time = msg.Time;
            this.TotalTradedVolume = msg.TotalTradedVolume;
        }

        public LastTradeData(LastTradeData prev, MsgMarketDepthD msg) {
            if (msg.DepthTrade.TotalTradedVolume > prev.TotalTradedVolume) {
                this.Time = msg.Time;
                this.LastTradePrice = msg.DepthTrade.LastTradePrice;
                this.LastTradeVolume = Math.max(msg.DepthTrade.LastTradeVolume, msg.DepthTrade.TotalTradedVolume - prev.TotalTradedVolume);
                this.LastTradeTotalVolume = msg.DepthTrade.LastTradeTotalVolume;
                this.LastTradePriceSpd = msg.DepthTrade.LastTradeSpdPrice;
                this.LastTradeVolumeSpd = Math.max(msg.DepthTrade.LastTradeSpdVolume, msg.DepthTrade.TotalTradedVolume - prev.TotalTradedVolume);
                this.LastTradeTotalVolumeSpd = msg.DepthTrade.LastTradeSpdTotalVolume;
                this.TotalTradedVolume = msg.DepthTrade.TotalTradedVolume;
            } else {
                this.Time = msg.Time;
                this.LastTradePrice = prev.LastTradePrice;
                this.LastTradeVolume = prev.LastTradeVolume;
                this.LastTradeTotalVolume = prev.LastTradeTotalVolume;
                this.LastTradePriceSpd = prev.LastTradePriceSpd;
                this.LastTradeVolumeSpd = prev.LastTradeVolumeSpd;
                this.LastTradeTotalVolumeSpd = prev.LastTradeTotalVolumeSpd;
                this.TotalTradedVolume = prev.TotalTradedVolume;
            }
        }

        public LastTradeData(MsgMarketDepthD msg) {
            this.Time = msg.Time;
            this.LastTradePrice = msg.DepthTrade.LastTradePrice;
            this.LastTradeVolume = msg.DepthTrade.LastTradeVolume;
            this.LastTradeTotalVolume = msg.DepthTrade.LastTradeTotalVolume;
            this.LastTradePriceSpd = msg.DepthTrade.LastTradeSpdPrice;
            this.LastTradeVolumeSpd = msg.DepthTrade.LastTradeSpdVolume;
            this.LastTradeTotalVolumeSpd = msg.DepthTrade.LastTradeSpdTotalVolume;
            this.TotalTradedVolume = msg.DepthTrade.TotalTradedVolume;
        }
    }

    public static class DepthItem {
        public final Price price;
        public final int volume;
        public final int orderCount;

        public DepthItem(Price price, int volume, int orders) {
            this.price = price;
            this.volume = volume;
            this.orderCount = orders;
        }

        public Price getPrice() {
            return this.price;
        }

        public int getVolume() {
            return this.volume;
        }
    }
}

