/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.api.Contract;
import com.t4login.api.Exchange;
import com.t4login.api.IAsyncHandler;
import com.t4login.api.IMarketDataHandler;
import com.t4login.api.LegMarket;
import com.t4login.api.MBOSnapshot;
import com.t4login.api.MBOUpdate;
import com.t4login.api.Market;
import com.t4login.api.MarketCacheUpdateTimes;
import com.t4login.api.MarketDataSnapshot;
import com.t4login.api.MarketDepthTrade;
import com.t4login.api.MarketFormatter;
import com.t4login.api.MarketID;
import com.t4login.api.MarketPickerGroup;
import com.t4login.api.MarketPickerListHandler;
import com.t4login.api.MarketPickerMarket;
import com.t4login.api.MarketSubscription;
import com.t4login.api.OrderSubmit;
import com.t4login.api.StrikeMarkets;
import com.t4login.api.SubscriptionLevel;
import com.t4login.api.T4HostService;
import com.t4login.api.UDSSubmit;
import com.t4login.api.chartdata.ChartDataHandler;
import com.t4login.application.chart.SessionTimeRange;
import com.t4login.application.chart.chartdata.DataLoadArgs;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.settings.AppSettings;
import com.t4login.application.settings.PriceDisplayMode;
import com.t4login.connection.IMessageHandler;
import com.t4login.connection.ServerType;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.ChartDataRequestApplication;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.DepthBuffer;
import com.t4login.definitions.DepthLevels;
import com.t4login.definitions.LoginResult;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.OrderSourceMethod;
import com.t4login.definitions.PriceType;
import com.t4login.definitions.StrategyType;
import com.t4login.definitions.TimeType;
import com.t4login.definitions.UDSStatus;
import com.t4login.definitions.chartdata.ChartDataType;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.messages.Message;
import com.t4login.messages.MessageType;
import com.t4login.messages.MsgApplicationSignal;
import com.t4login.messages.MsgChartAggregatedDataRequest;
import com.t4login.messages.MsgChartDataBatchRequest;
import com.t4login.messages.MsgContractDetails2;
import com.t4login.messages.MsgContractDetailsMulti;
import com.t4login.messages.MsgContractRequest;
import com.t4login.messages.MsgCreateUDS;
import com.t4login.messages.MsgCreateUDSResponse;
import com.t4login.messages.MsgLoginResponse2;
import com.t4login.messages.MsgMarketByOrderReject;
import com.t4login.messages.MsgMarketByOrderSnapshot;
import com.t4login.messages.MsgMarketByOrderSubscribe;
import com.t4login.messages.MsgMarketByOrderUpdate;
import com.t4login.messages.MsgMarketDepthD;
import com.t4login.messages.MsgMarketDepthSubscribe;
import com.t4login.messages.MsgMarketDepthSubscribeReject;
import com.t4login.messages.MsgMarketDepthTradeD;
import com.t4login.messages.MsgMarketDetails;
import com.t4login.messages.MsgMarketDetailsMulti;
import com.t4login.messages.MsgMarketHighLowD;
import com.t4login.messages.MsgMarketIdent;
import com.t4login.messages.MsgMarketPriceLimitsD;
import com.t4login.messages.MsgMarketSettlementD;
import com.t4login.messages.MsgMarketSnapshotD;
import com.t4login.messages.MsgMarketTradeHistoryD;
import com.t4login.messages.MsgMarketTradeVolumeD;
import com.t4login.messages.application.MsgServiceStateChange;
import com.t4login.remoteservices.model.MarketResponse;
import com.t4login.remoteservices.services.T4MarketsService;
import com.t4login.util.EventBuffer;
import com.t4login.util.Pair;
import com.t4login.util.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MarketData {
    private static final String TAG = "MarketData";
    private final T4HostService service;
    private final T4MarketsService marketsService;
    private final List<IMarketDataHandler> marketDataHandlers = new CopyOnWriteArrayList<IMarketDataHandler>();
    private final ConcurrentMap<String, MarketSubscription> marketSubscriptions = new ConcurrentHashMap<String, MarketSubscription>(50, 0.9f, 1);
    private final List<ChartDataHandler> chartDataHandlers = new CopyOnWriteArrayList<ChartDataHandler>();
    private final Map<String, Exchange> cachedExchanges = new ConcurrentHashMap<String, Exchange>();
    private final Map<String, Contract> cachedContracts = new ConcurrentHashMap<String, Contract>(50, 0.9f, 1);
    private final ConcurrentHashMap<String, Market> mMarketCache = new ConcurrentHashMap(50, 0.9f, 1);
    private final ConcurrentHashMap<OutrightMarket, Market> mOutrightMarketCache = new ConcurrentHashMap(50, 0.9f, 1);
    private final Map<Integer, String> marketIDs = new HashMap<Integer, String>();
    private final MarketFormatter mMarketFormatter = new MarketFormatter();
    private final Set<Pair<String, String>> mPendingMarketLists = new HashSet<Pair<String, String>>();
    MarketCacheUpdateTimes mMarketCacheUpdateTimes = null;
    private final Map<String, UDSSubmit> pendingUDSRequests = new Hashtable<String, UDSSubmit>();
    private final EventBuffer<String> contractsLoadedEventBuffer = new EventBuffer(this::onContractsLoaded, 400);
    private Configurable.ConfigurationChangedHandler mConfigurationChangedHandler = new Configurable.ConfigurationChangedHandler(){

        @Override
        public void onConfigurationChanged(boolean restored) {
            if (!restored) {
                Log.d(MarketData.TAG, "MarketData.onConfigurationChanged(), Configuration settings changed, clearing cached market descriptions.");
                MarketData.this.mMarketFormatter.clear();
            }
        }
    };
    HashSet<String> mPendingExchangeContracts = null;
    private HashSet<String> mUserExchanges = new HashSet();

    public MarketData(T4HostService s) {
        this.service = s;
        this.marketsService = new T4MarketsService(s);
        this.service.registerMessageHandler(new IMessageHandler(){

            @Override
            public void onMessage(Message msg) {
                MarketData.this.onMessage(msg);
            }
        });
        AppSettings.registerForConfigurationChanges(this.mConfigurationChangedHandler);
    }

    void destroy() {
        this.marketsService.destroy();
        this.contractsLoadedEventBuffer.destroy();
    }

    public T4HostService getService() {
        return this.service;
    }

    public void registerForMarketData(IMarketDataHandler handler) {
        if (!this.marketDataHandlers.contains(handler)) {
            this.marketDataHandlers.add(handler);
        }
    }

    public void unregisterForMarketData(IMarketDataHandler handler) {
        if (this.marketDataHandlers.contains(handler)) {
            this.marketDataHandlers.remove(handler);
        }
    }

    public void registerForChartData(ChartDataHandler handler) {
        if (!this.chartDataHandlers.contains(handler)) {
            this.chartDataHandlers.add(handler);
        }
    }

    public void unregisterForChartData(ChartDataHandler handler) {
        if (this.chartDataHandlers.contains(handler)) {
            this.chartDataHandlers.remove(handler);
        }
    }

    public MarketDataSnapshot getMarketDataSnapshot(String marketID) {
        MarketDataSnapshot snapshot = null;
        MarketSubscription sub = (MarketSubscription)this.marketSubscriptions.get(marketID);
        if (sub != null) {
            snapshot = sub.getSnapshot();
        }
        return snapshot;
    }

    public MarketDataSnapshot getMarketDataSnapshot(MarketID marketID) {
        MarketDataSnapshot snapshot = null;
        MarketSubscription sub = (MarketSubscription)this.marketSubscriptions.get(marketID.MarketID);
        if (sub != null) {
            snapshot = sub.getSnapshot();
        }
        return snapshot;
    }

    public void getUnderlyingContract(final Contract optionContract, final IAsyncHandler<Contract> handler) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                handler.onComplete(MarketData.this.getUnderlyingContractSync(optionContract));
            }
        });
        thread.start();
    }

    public Contract getUnderlyingContractSync(Contract optionContract) {
        if (!(optionContract.getContractType().equals(ContractType.Option) && optionContract.getContractType().equals(ContractType.Option) && optionContract.getContractType().equals(ContractType.Option))) {
            return null;
        }
        NDateTime serverTime = this.service.getRemoteTime();
        Optional<Contract> underlyingValue = optionContract.Msg.Relations.stream().filter(r -> r.contractType.equals(ContractType.Future) && r.startDate.compareTo(serverTime) < 0 && r.endDate.compareTo(serverTime) > 0 && r.priority >= 5).map(r -> this.getContract(r.exchangeID, r.contractID)).filter(Objects::nonNull).findFirst();
        if (underlyingValue.isPresent()) {
            return underlyingValue.get();
        }
        return null;
    }

    public void getUnderlyingMarket(Contract optionContract, int expiry, final IAsyncHandler<Market> handler) {
        this.getOptionContractStrikeMarkets(optionContract, expiry, new IAsyncHandler<List<StrikeMarkets>>(){

            @Override
            public void onComplete(List<StrikeMarkets> result) {
                Optional<String> underlyingMarketId;
                if (result != null && (underlyingMarketId = result.stream().findFirst().map(s -> s.CallMarket.Msg.UnderlyingMarketID)).isPresent()) {
                    Market underlyingMarket = MarketData.this.getMarket(underlyingMarketId.get());
                    handler.onComplete(underlyingMarket);
                    return;
                }
                handler.onComplete(null);
            }

            @Override
            public void onError(Exception ex) {
                handler.onError(ex);
            }
        });
    }

    public List<Contract> getRelatedOptionContracts(Contract contract) {
        ArrayList<Contract> relatedContracts = new ArrayList<Contract>();
        for (Contract.Relation relation : contract.getOptionRelations()) {
            Contract relatedContract = this.getContract(relation.ExchangeID, relation.ContractID);
            if (relatedContract == null) continue;
            relatedContracts.add(relatedContract);
        }
        return relatedContracts;
    }

    public void getOptionContractStrikeMarkets(Contract optionContract, int expiry, IAsyncHandler<List<StrikeMarkets>> handler) {
        String exchangeID = optionContract.getExchangeID();
        String contractID = optionContract.getContractID();
        Market firstMarket = this.getFirstMarket(exchangeID, contractID);
        Contract underlyingContract = this.getUnderlyingContractSync(optionContract);
        Market underlyingMarket = Market.Empty;
        if (underlyingContract != null) {
            if (firstMarket != null) {
                underlyingMarket = this.getMarket(underlyingContract.getExchangeID(), underlyingContract.getContractID(), firstMarket.Msg.UnderlyingMarketID, true);
            }
            if (underlyingMarket == null) {
                underlyingMarket = Market.Empty;
            }
        }
        Market finalUnderlyingMarket = underlyingMarket;
        MarketPickerGroup group = new MarketPickerGroup(StrategyType.None, expiry, 0);
        List<MarketPickerMarket> marketPickerMarkets = this.marketsService.requestMarketPickerList(exchangeID, contractID, group);
        List strikeMarkets = marketPickerMarkets.stream().map(pm -> {
            Market m = this.getMarket(pm.MarketID);
            if (m == null) {
                m = this.getMarket(exchangeID, contractID, pm.MarketID);
            }
            return m;
        }).filter(Objects::nonNull).collect(Collectors.groupingBy(mkt -> mkt.getStrikePrice(), Collectors.toList())).entrySet().stream().map(sg -> {
            Optional<Market> callMarket = ((List)sg.getValue()).stream().filter(m -> m.getContractType().equals(ContractType.OptionCall)).findAny();
            Optional<Market> putMarket = ((List)sg.getValue()).stream().filter(m -> m.getContractType().equals(ContractType.OptionPut)).findAny();
            if (callMarket.isPresent() && putMarket.isPresent()) {
                StrikeMarkets sm = new StrikeMarkets();
                sm.Contract = optionContract;
                sm.Expiry = expiry;
                sm.StrikePrice = (Price)sg.getKey();
                sm.CallMarket = callMarket.get();
                sm.PutMarket = putMarket.get();
                sm.UnderlyingMarket = finalUnderlyingMarket;
                return sm;
            }
            return null;
        }).filter(Objects::nonNull).sorted(Comparator.comparing(m -> m.StrikePrice)).collect(Collectors.toList());
        handler.onComplete(strikeMarkets);
    }

    private void onMessage(Message msg) {
        switch (msg.getMessageType()) {
            case LoginResponse2: {
                this.processLoginExchanges((MsgLoginResponse2)msg);
                break;
            }
            case SignalMessage: {
                this.processApplicationSignal((MsgApplicationSignal)msg);
                break;
            }
            case ContractDetailsMulti: {
                this.processContractDetailsMulti((MsgContractDetailsMulti)msg);
                break;
            }
            case MarketDetailsMulti: {
                this.processMarketDetailsMulti((MsgMarketDetailsMulti)msg);
                break;
            }
            case MarketDetails: {
                this.processMarketDetails((MsgMarketDetails)msg);
                break;
            }
            case MarketDepthSubscribeReject: {
                this.processMarketDepthSubscribeReject((MsgMarketDepthSubscribeReject)msg);
                break;
            }
            case MarketDepthD: {
                MsgMarketDepthD depthmsg = (MsgMarketDepthD)msg;
                if (depthmsg.MarketID == null || depthmsg.MarketID.equals("")) {
                    depthmsg.MarketID = this.marketIDs.get(depthmsg.MarketIdent);
                }
                this.processMarketData(depthmsg.MarketID, msg);
                break;
            }
            case MarketDepthTradeD: {
                MsgMarketDepthTradeD trademsg = (MsgMarketDepthTradeD)msg;
                this.processMarketData(trademsg.MarketID, msg);
                break;
            }
            case MarketSettlementD: {
                MsgMarketSettlementD settlmsg = (MsgMarketSettlementD)msg;
                if (settlmsg.MarketID == null || settlmsg.MarketID.equals("")) {
                    settlmsg.MarketID = this.marketIDs.get(settlmsg.MarketIdent);
                }
                this.processMarketData(settlmsg.MarketID, msg);
                break;
            }
            case MarketHighLowD: {
                MsgMarketHighLowD highlowmsg = (MsgMarketHighLowD)msg;
                if (highlowmsg.MarketID == null || highlowmsg.MarketID.isEmpty()) {
                    highlowmsg.MarketID = this.marketIDs.get(highlowmsg.MarketIdent);
                }
                this.processMarketData(highlowmsg.MarketID, msg);
                break;
            }
            case MarketPriceLimitsD: {
                MsgMarketPriceLimitsD lmtmsg = (MsgMarketPriceLimitsD)msg;
                this.processMarketData(lmtmsg.MarketID, msg);
                break;
            }
            case MarketTradeVolumeD: {
                MsgMarketTradeVolumeD tradevolmsg = (MsgMarketTradeVolumeD)msg;
                this.processMarketData(tradevolmsg.MarketID, msg);
                break;
            }
            case MarketTradeHistoryD: {
                MsgMarketTradeHistoryD tradehistmsg = (MsgMarketTradeHistoryD)msg;
                this.processMarketData(tradehistmsg.MarketID, msg);
                break;
            }
            case MarketSnapshotD: {
                MsgMarketSnapshotD snapmsg = (MsgMarketSnapshotD)msg;
                block31: for (Message cmsg : snapmsg.Messages) {
                    switch (cmsg.getMessageType()) {
                        case MarketDepthD: {
                            ((MsgMarketDepthD)cmsg).MarketID = snapmsg.MarketID;
                            continue block31;
                        }
                        case MarketDepthTradeD: {
                            ((MsgMarketDepthTradeD)cmsg).MarketID = snapmsg.MarketID;
                            continue block31;
                        }
                        case MarketSettlementD: {
                            ((MsgMarketSettlementD)cmsg).MarketID = snapmsg.MarketID;
                            continue block31;
                        }
                        case MarketHighLowD: {
                            ((MsgMarketHighLowD)cmsg).MarketID = snapmsg.MarketID;
                            continue block31;
                        }
                        case MarketPriceLimitsD: {
                            ((MsgMarketPriceLimitsD)cmsg).MarketID = snapmsg.MarketID;
                            continue block31;
                        }
                        case MarketTradeVolumeD: {
                            ((MsgMarketTradeVolumeD)cmsg).MarketID = snapmsg.MarketID;
                            continue block31;
                        }
                        case MarketTradeHistoryD: {
                            ((MsgMarketTradeHistoryD)cmsg).MarketID = snapmsg.MarketID;
                            continue block31;
                        }
                    }
                    Log.e(TAG, "onMessage(), Unhandled message: " + cmsg.getMessageType().toString());
                }
                this.processMarketData(snapmsg.MarketID, msg);
                break;
            }
            case MarketByOrderReject: {
                MsgMarketByOrderReject mboRejMsg = (MsgMarketByOrderReject)msg;
                if (mboRejMsg.MarketID == null || mboRejMsg.MarketID.equals("")) {
                    mboRejMsg.MarketID = this.marketIDs.get(mboRejMsg.MarketIdent);
                }
                this.processMarketData(mboRejMsg.MarketID, msg);
                this.processMarketByOrderReject(mboRejMsg);
                break;
            }
            case MarketByOrderSnapshot: {
                MsgMarketByOrderSnapshot mboSnapMsg = (MsgMarketByOrderSnapshot)msg;
                if (mboSnapMsg.MarketID == null || mboSnapMsg.MarketID.equals("")) {
                    mboSnapMsg.MarketID = this.marketIDs.get(mboSnapMsg.MarketIdent);
                }
                this.processMarketData(mboSnapMsg.MarketID, msg);
                this.processMarketByOrderSnapshot(mboSnapMsg);
                break;
            }
            case MarketByOrderUpdate: {
                MsgMarketByOrderUpdate mboUpdateMsg = (MsgMarketByOrderUpdate)msg;
                if (mboUpdateMsg.MarketID == null || mboUpdateMsg.MarketID.equals("")) {
                    mboUpdateMsg.MarketID = this.marketIDs.get(mboUpdateMsg.MarketIdent);
                }
                this.processMarketData(mboUpdateMsg.MarketID, msg);
                this.processMarketByOrderUpdate(mboUpdateMsg);
                break;
            }
            case MarketIdent: {
                MsgMarketIdent identmsg = (MsgMarketIdent)msg;
                this.marketIDs.put(identmsg.MarketIdent, identmsg.MarketID);
                break;
            }
            case ChartDataBatch: 
            case ChartContractData: {
                this.processChartDataResponse(msg);
                break;
            }
            case CreateUDSResponse: {
                this.processCreateUDSResponse((MsgCreateUDSResponse)msg);
            }
        }
    }

    private void processApplicationSignal(MsgApplicationSignal msg) {
        block0 : switch (msg.getSignal()) {
            case CheckSubscriptions: {
                this.onCheckSubscriptions();
                break;
            }
            case ServiceStateChange: {
                MsgServiceStateChange ssmsg = (MsgServiceStateChange)msg;
                switch (ssmsg.getNewState()) {
                    case Connected: {
                        this.checkContracts();
                        if (!ssmsg.getIsFirstLogin()) break block0;
                        this.resubscribeAllMarkets();
                        break block0;
                    }
                }
                break;
            }
            case ChartDataRequestFailed: {
                this.processChartDataResponse(msg);
                break;
            }
        }
    }

    private void onCheckSubscriptions() {
        HashMap<String, SubscriptionLevel> levels = new HashMap<String, SubscriptionLevel>();
        for (String string : this.marketSubscriptions.keySet()) {
            levels.put(string, new SubscriptionLevel(string));
        }
        if (!Host.isDebugMode()) {
            for (IMarketDataHandler iMarketDataHandler : this.marketDataHandlers) {
                iMarketDataHandler.onCheckSubscriptions(levels);
            }
        } else {
            for (IMarketDataHandler iMarketDataHandler : this.marketDataHandlers) {
                HashMap<String, SubscriptionLevel> newLevels = new HashMap<String, SubscriptionLevel>();
                for (String marketid : this.marketSubscriptions.keySet()) {
                    newLevels.put(marketid, new SubscriptionLevel(marketid));
                }
                Log.v(TAG, "onCheckSubscriptions(), Check subscriptions from: " + iMarketDataHandler.getDescription());
                iMarketDataHandler.onCheckSubscriptions(newLevels);
                for (SubscriptionLevel sub : newLevels.values()) {
                    SubscriptionLevel sublevel;
                    if (sub.getDepthBuffer() != DepthBuffer.NoSubscription) {
                        Log.v(TAG, "onCheckSubscriptions(), " + iMarketDataHandler.getDescription() + ", Subscription: " + String.valueOf(sub));
                    }
                    if ((sublevel = levels.get(sub.MarketID)) == null) continue;
                    sublevel.update(sub.getDepthBuffer(), sub.getDepthLevels(), sub.getMBOSubscribed());
                }
            }
        }
        ArrayList<String> unsubscribedMarkets = new ArrayList<String>();
        for (String marketid : levels.keySet()) {
            MarketSubscription subscription = (MarketSubscription)this.marketSubscriptions.get(marketid);
            if (subscription == null) continue;
            SubscriptionLevel level = levels.get(marketid);
            Log.v(TAG, marketid + " => [" + String.valueOf(level.getDepthBuffer()) + ", " + String.valueOf(level.getDepthLevels()) + "]");
            EnumSet<MarketSubscription.SubscriptionChange> subscriptionChange = subscription.setSubscriptionLevels(level.getDepthBuffer(), level.getDepthLevels(), level.getMBOSubscribed());
            if (subscriptionChange.contains((Object)MarketSubscription.SubscriptionChange.Depth)) {
                Log.v(TAG, "NEW: " + marketid + " => [" + String.valueOf(level.getDepthBuffer()) + ", " + String.valueOf(level.getDepthLevels()) + "]");
                this.sendSubscriptionRequest(subscription.getMarket(), subscription.getDepthBuffer(), subscription.getDepthLevels());
                if (subscription.getDepthBuffer() == DepthBuffer.NoSubscription) {
                    MsgMarketDepthD depthmsg = new MsgMarketDepthD();
                    depthmsg.MarketID = subscription.getMarket().getMarketID();
                    depthmsg.Numerator = 1;
                    depthmsg.Depth = new MsgMarketDepthD.DepthData();
                    depthmsg.DepthTrade = new MsgMarketDepthD.TradeData();
                    depthmsg.DepthMode = new MsgMarketDepthD.ModeData();
                    depthmsg.IncludedDepthLevels = DepthLevels.All;
                    depthmsg.ChangeLevel = DepthLevels.BestOnly;
                    depthmsg.ChangeBuffer = DepthBuffer.All;
                    depthmsg.Time = NDateTime.MinValue;
                    depthmsg.DepthMode.Mode = MarketMode.Undefined;
                    this.processMarketData(depthmsg.MarketID, depthmsg);
                    unsubscribedMarkets.add(marketid);
                }
            }
            if (!subscriptionChange.contains((Object)MarketSubscription.SubscriptionChange.MBO)) continue;
            this.sendMBOSubscriptionRequest(subscription.getMarket(), subscription.getMBOSubscribed());
            if (subscription.getMBOSubscribed()) continue;
            MsgMarketByOrderSnapshot mboSnapshot = new MsgMarketByOrderSnapshot();
            mboSnapshot.MarketID = subscription.getMarket().getMarketID();
            mboSnapshot.Mode = MarketMode.Undefined;
            mboSnapshot.Time = NDateTime.MinValue;
            this.processMarketByOrderSnapshot(mboSnapshot);
        }
        for (String unsub : unsubscribedMarkets) {
            this.marketSubscriptions.remove(unsub);
        }
        if (Host.isDebugMode()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (MarketSubscription sub : this.marketSubscriptions.values()) {
                stringBuilder.append(sub.toString()).append("\r\n");
            }
            Log.v(TAG, "onCheckSubscriptions(), Subscriptions: \r\n" + stringBuilder.toString());
        }
    }

    private void processLoginExchanges(MsgLoginResponse2 msg) {
        if (msg.Result != LoginResult.Success) {
            return;
        }
        this.saveLoginExchanges(msg);
    }

    private void checkContracts() {
        Thread marketRequestThread = new Thread(() -> {
            ArrayList<String> exchangeContractsToLoad = new ArrayList<String>();
            for (String exchangeID : this.mUserExchanges) {
                exchangeContractsToLoad.add(exchangeID);
            }
            this.mPendingExchangeContracts = new HashSet();
            this.mPendingExchangeContracts.addAll(exchangeContractsToLoad);
            for (String exchangeID : exchangeContractsToLoad) {
                MsgContractRequest reqMsg = new MsgContractRequest();
                reqMsg.ExchangeID = exchangeID;
                this.service.sendMessage(reqMsg);
            }
        });
        marketRequestThread.start();
    }

    public Market cacheMarket(Market market) {
        if (!market.isCachedMarket()) {
            this.mMarketCache.put(market.getMarketID(), market);
            return market;
        }
        Market cacheMarket = this.mMarketCache.get(market.getMarketID());
        if (cacheMarket != null && !cacheMarket.isCachedMarket()) {
            return cacheMarket;
        }
        this.mMarketCache.put(market.getMarketID(), market);
        return market;
    }

    private void processContractDetailsMulti(MsgContractDetailsMulti msg) {
        Log.v(TAG, "processContractDetailsMulti(), Processing contracts for exchange: " + msg.getExchangeID());
        this.saveContractDetailsMulti(msg);
        this.contractsLoadedEventBuffer.run(msg.getExchangeID());
        if (this.mPendingExchangeContracts != null) {
            this.mPendingExchangeContracts.remove(msg.getExchangeID());
        }
    }

    private void onContractsLoaded(Collection<String> exchangeIDs) {
        for (IMarketDataHandler cb : this.marketDataHandlers) {
            cb.onContractsLoaded(exchangeIDs);
        }
    }

    private Market processMarketDetails(MsgMarketDetails msg) {
        Market market = null;
        boolean complete = false;
        Contract contract = this.getContract(msg.ExchangeID, msg.ContractID);
        if (contract == null) {
            Log.e(TAG, "processMarketDetails(), Error. Contract " + Contract.getUniqueID(msg.ExchangeID, msg.ContractID) + " is not available.");
            return null;
        }
        if (!msg.StrategyType.equals(StrategyType.None)) {
            Market underlyingMarket;
            ArrayList<LegMarket> legMarkets = new ArrayList<LegMarket>();
            for (MsgMarketDetails.LegItem legItem : msg.Legs) {
                Market legFullMarket = this.getMarket(legItem.MarketID);
                if (legFullMarket != null) {
                    MsgMarketDetails legMsg = legFullMarket.Msg;
                    LegMarket legMarket = new LegMarket();
                    legMarket.ExchangeID = msg.ExchangeID;
                    legMarket.ContractID = msg.ContractID;
                    legMarket.MarketID = legItem.MarketID;
                    legMarket.IsRTS = false;
                    legMarket.ExchangeDescription = contract.Exchange.getDescription();
                    legMarket.ContractDescription = contract.getDescription();
                    legMarket.ClearingCode = contract.Msg.ClearingCode;
                    legMarket.ExpiryDate = legMsg.ExpiryDate;
                    legMarket.Details = legMsg.Details;
                    legMarket.ContractType = legMsg.ContractType;
                    legMarket.StrategyType = legMsg.StrategyType;
                    legMarket.Numerator = legMsg.Numerator;
                    legMarket.Denominator = legMsg.Denominator;
                    legMarket.PriceCode = legMsg.PriceCode;
                    legMarket.VTT = legMsg.VTT;
                    legMarket.TickValue = legMsg.TickValue;
                    legMarket.RealDecimals = legMsg.RealDecimals;
                    legMarket.ClearingDecimals = legMsg.ClearingDecimals;
                    legMarket.MinCabPrice = legMsg.MinCabPrice;
                    legMarket.StrikePrice = legMsg.StrikePrice;
                    legMarket.UnderlyingMarketID = legMsg.UnderlyingMarketID;
                    legMarkets.add(legMarket);
                    continue;
                }
                legMarkets.add(null);
                Log.e(TAG, "processMarketDetails(), Error. No market for leg: " + legItem.MarketID);
            }
            LegMarket underlyingLegMarket = null;
            if (msg.UnderlyingMarketID != null && msg.UnderlyingMarketID.length() > 0 && (underlyingMarket = this.getMarket(msg.UnderlyingMarketID)) != null) {
                underlyingLegMarket = new LegMarket();
                underlyingLegMarket.ExchangeID = underlyingMarket.getExchangeID();
                underlyingLegMarket.ContractID = underlyingMarket.getContractID();
                underlyingLegMarket.MarketID = underlyingMarket.getMarketID();
                underlyingLegMarket.IsRTS = false;
                underlyingLegMarket.ExchangeDescription = underlyingMarket.Contract.Exchange.getDescription();
                underlyingLegMarket.ContractDescription = underlyingMarket.Contract.getDescription();
                underlyingLegMarket.ClearingCode = underlyingMarket.Contract.Msg.ClearingCode;
                underlyingLegMarket.ExpiryDate = underlyingMarket.Msg.ExpiryDate;
                underlyingLegMarket.Details = underlyingMarket.Msg.Details;
                underlyingLegMarket.ContractType = underlyingMarket.Msg.ContractType;
                underlyingLegMarket.StrategyType = underlyingMarket.Msg.StrategyType;
                underlyingLegMarket.Numerator = underlyingMarket.Msg.Numerator;
                underlyingLegMarket.Denominator = underlyingMarket.Msg.Denominator;
                underlyingLegMarket.PriceCode = underlyingMarket.Msg.PriceCode;
                underlyingLegMarket.VTT = underlyingMarket.Msg.VTT;
                underlyingLegMarket.TickValue = underlyingMarket.Msg.TickValue;
                underlyingLegMarket.RealDecimals = underlyingMarket.Msg.RealDecimals;
                underlyingLegMarket.ClearingDecimals = underlyingMarket.Msg.ClearingDecimals;
                underlyingLegMarket.MinCabPrice = underlyingMarket.Msg.MinCabPrice;
                underlyingLegMarket.StrikePrice = underlyingMarket.Msg.StrikePrice;
                legMarkets.add(underlyingLegMarket);
            }
            market = new Market(msg, contract, legMarkets.toArray(new LegMarket[legMarkets.size()]), underlyingLegMarket);
            complete = true;
        } else {
            market = new Market(msg, contract, new LegMarket[0], null);
            complete = true;
        }
        if (market != null && complete) {
            MarketSubscription sub = (MarketSubscription)this.marketSubscriptions.get((market = this.cacheMarket(market)).getMarketID());
            if (sub != null) {
                sub.updateMarket(market);
                sub.updateSnapshot(null);
            } else {
                Log.e(TAG, "processMarketDetails(), No subscription found for market: " + market.getMarketID());
            }
            for (IMarketDataHandler cb : this.marketDataHandlers) {
                cb.onMarketDetails(market);
            }
        } else {
            Log.e(TAG, "processMarketDetails(), Error creating market from the market details. " + String.valueOf(msg));
        }
        return market;
    }

    private void processMarketDetailsMulti(MsgMarketDetailsMulti msg) {
        Log.w(TAG, String.format("processMarketDetailsMulti(), %s", msg));
    }

    private void processMarketDepthSubscribeReject(MsgMarketDepthSubscribeReject msg) {
        MsgMarketDepthD depthmsg = new MsgMarketDepthD();
        depthmsg.MarketIdent = msg.MarketIdent;
        depthmsg.MarketID = msg.MarketID;
        depthmsg.Numerator = 1;
        depthmsg.Depth = new MsgMarketDepthD.DepthData();
        depthmsg.DepthTrade = new MsgMarketDepthD.TradeData();
        depthmsg.DepthMode = new MsgMarketDepthD.ModeData();
        depthmsg.IncludedDepthLevels = DepthLevels.All;
        depthmsg.ChangeLevel = DepthLevels.BestOnly;
        depthmsg.ChangeBuffer = DepthBuffer.All;
        depthmsg.Time = msg.Time;
        depthmsg.DepthMode.Mode = msg.Mode;
        this.processMarketData(depthmsg.MarketID, depthmsg);
    }

    private void processMarketData(String marketID, Message msg) {
        MarketSubscription msub = (MarketSubscription)this.marketSubscriptions.get(marketID);
        if (msub != null) {
            Market tmpMarket;
            if (msub.getMarket().isCachedMarket() && (tmpMarket = this.getMarket(msub.getMarket().getMarketID())) != null) {
                msub.updateMarket(tmpMarket);
            }
            MarketDataSnapshot snapshot = null;
            if (msg.getMessageType() == MessageType.MarketDepthTradeD) {
                MsgMarketDepthTradeD tradeMsg = (MsgMarketDepthTradeD)msg;
                boolean tradeSummary = AppSettings.instance.MarketData.TradeSummary;
                if (tradeSummary || tradeMsg.OrderVolumes == null || tradeMsg.OrderVolumes.length <= 1) {
                    snapshot = msub.updateSnapshot(msg);
                } else {
                    int ttv = tradeMsg.TotalTradedVolume - tradeMsg.LastTradeVolume;
                    for (int vol : tradeMsg.OrderVolumes) {
                        MsgMarketDepthTradeD omsg = new MsgMarketDepthTradeD();
                        omsg.AtBidOrOffer = tradeMsg.AtBidOrOffer;
                        omsg.Delayed = tradeMsg.Delayed;
                        omsg.DueToSpread = tradeMsg.DueToSpread;
                        omsg.LastTradePrice = tradeMsg.LastTradePrice;
                        omsg.MarketID = tradeMsg.MarketID;
                        omsg.Time = tradeMsg.Time;
                        omsg.LastTradeVolume = vol;
                        omsg.TotalTradedVolume = ttv += vol;
                        omsg.TotalTradeCount = tradeMsg.TotalTradeCount;
                        snapshot = msub.updateSnapshot(omsg);
                    }
                }
            } else {
                snapshot = msub.updateSnapshot(msg);
            }
            MarketDepthTrade trade = null;
            if (msg.getMessageType() == MessageType.MarketDepthTradeD) {
                trade = new MarketDepthTrade((MsgMarketDepthTradeD)msg);
            }
            for (IMarketDataHandler cb : this.marketDataHandlers) {
                cb.onMarketUpdate(snapshot);
                if (trade == null) continue;
                cb.onMarketDepthTrade(trade);
            }
        }
    }

    private void processMarketByOrderReject(MsgMarketByOrderReject mboRejMsg) {
        Log.d(TAG, "processMarketByOrderReject(), Msg: %s", mboRejMsg);
    }

    private void processMarketByOrderSnapshot(MsgMarketByOrderSnapshot mboSnapMsg) {
        try {
            MarketSubscription msub = (MarketSubscription)this.marketSubscriptions.get(mboSnapMsg.MarketID);
            if (msub != null) {
                Market tmpMarket;
                if (msub.getMarket().isCachedMarket() && (tmpMarket = this.getMarket(msub.getMarket().getMarketID())) != null) {
                    msub.updateMarket(tmpMarket);
                }
                MBOSnapshot snapshot = new MBOSnapshot(mboSnapMsg);
                for (IMarketDataHandler cb : this.marketDataHandlers) {
                    cb.onMarketByOrderSnapshot(snapshot);
                }
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "processMarketByOrderSnapshot(), Msg: %s, Error: %s", mboSnapMsg, ex);
        }
    }

    private void processMarketByOrderUpdate(MsgMarketByOrderUpdate mboUpdateMsg) {
        try {
            MarketSubscription msub = (MarketSubscription)this.marketSubscriptions.get(mboUpdateMsg.MarketID);
            if (msub != null) {
                Market tmpMarket;
                if (msub.getMarket().isCachedMarket() && (tmpMarket = this.getMarket(msub.getMarket().getMarketID())) != null) {
                    msub.updateMarket(tmpMarket);
                }
                MBOUpdate update = new MBOUpdate(mboUpdateMsg);
                for (IMarketDataHandler cb : this.marketDataHandlers) {
                    cb.onMarketByOrderUpdate(update);
                }
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "processMarketByOrderUpdate(), Error", ex);
        }
    }

    private void processChartDataResponse(Message msg) {
        for (ChartDataHandler cb : this.chartDataHandlers) {
            cb.onChartDataResponse(msg);
        }
    }

    private void processCreateUDSResponse(MsgCreateUDSResponse msg) {
        try {
            if (this.pendingUDSRequests.containsKey(msg.RequestID)) {
                UDSSubmit udsSubmit = this.pendingUDSRequests.remove(msg.RequestID);
                if (udsSubmit != null) {
                    if (msg.Status.equals(UDSStatus.AlreadyExists)) {
                        Market rfqMarket = null;
                        for (Market market : this.mMarketCache.values()) {
                            if (!market.Msg.MarketRef.equals(msg.MarketRef)) continue;
                            rfqMarket = market;
                            break;
                        }
                        if (rfqMarket != null) {
                            OrderSubmit orderSubmit = new OrderSubmit(udsSubmit.Source, OrderSourceMethod.Unknown);
                            orderSubmit.add(udsSubmit.AccountID, rfqMarket, BuySell.Undefined, PriceType.RFQ, TimeType.Normal, 0, 0, null, null, null);
                            this.service.getAccountData().submitNewOrder(orderSubmit);
                        }
                    } else {
                        for (IMarketDataHandler cb : this.marketDataHandlers) {
                            cb.onCreateUDSResponse(msg);
                        }
                    }
                }
            } else {
                Log.d(TAG, "processCreateUDSResponse(), Request not found. RequestID: " + msg.RequestID);
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "processCreateUDSResponse(), Error: " + ex.toString());
        }
    }

    public Exchange getExchange(String exchangeID) {
        return this.cachedExchanges.get(exchangeID);
    }

    public Contract getContract(String exchangeID, String contractID) {
        Contract contract = null;
        if (this.service != null && this.service.getUserData() != null) {
            String ucid = Contract.getUniqueID(exchangeID, contractID);
            contract = this.cachedContracts.get(ucid);
            if (contract != null) {
                return contract;
            }
            Exchange exchg = this.getExchange(exchangeID);
            if (contract == null && this.service.getUserData().getServerType() == ServerType.Simulator && this.service.getUserData().getIsSimOverTwoWeeks() && !exchangeID.startsWith("DL")) {
                contract = this.getContract("DL" + exchangeID, contractID);
                Log.d(TAG, "getContract(), Sim Expired, Returning delayed version of exchange [" + exchangeID + "] contract [" + contractID + "]");
            }
            if (contract == null && (exchg == null || exchg.getDisabled() || !exchg.getHasPermission())) {
                contract = Contract.createUnavailable(exchg == null ? Exchange.createUnavailable(exchangeID) : exchg, contractID);
                Log.d(TAG, "getContract(), Contract/Exchange not found, Returning 'Unavailable' version of exchange [" + exchangeID + "] contract [" + contractID + "]");
                this.cachedContracts.put(ucid, contract);
                return contract;
            }
        }
        return contract;
    }

    public List<Exchange> searchExchanges(String searchString) {
        Log.v(TAG, "searchExchanges(), String: '%s', Contract Count: %d", searchString, this.cachedContracts.size());
        Stream<Contract> stream = this.cachedContracts.values().stream().filter(c -> c.Exchange.getHasPermission());
        String searchLower = searchString.toLowerCase();
        stream = searchLower.length() > 2 ? stream.filter(c -> c.getContractID().toLowerCase().startsWith(searchLower) || c.getDescription().toLowerCase().contains(searchLower)) : stream.filter(c -> c.getContractID().toLowerCase().startsWith(searchLower));
        List<Exchange> exchanges = stream.map(c -> c.Exchange).distinct().sorted(Comparator.comparing(Exchange::getDescription)).collect(Collectors.toList());
        Log.d(TAG, "searchExchanges(), String: '%s', Exchanges Found: %d", searchLower, exchanges.size());
        return exchanges;
    }

    public List<Contract> searchExchangeContracts(Exchange exchange, String searchString) {
        String searchStringLower = searchString.toLowerCase();
        return this.cachedContracts.values().stream().filter(contract -> contract.getExchangeID().equals(exchange.getExchangeID())).filter(contract -> {
            if (searchString.length() > 2) {
                return contract.getContractID().toLowerCase().startsWith(searchStringLower) || contract.getDescription().toLowerCase().contains(searchStringLower);
            }
            return contract.getContractID().toLowerCase().startsWith(searchStringLower);
        }).sorted(Comparator.comparing(Contract::getDescription)).collect(Collectors.toList());
    }

    public Market getMarket(String marketID) {
        Market market = this.mMarketCache.get(marketID);
        return market;
    }

    public Market getMarket(String exchangeID, String contractID, String marketID) {
        return this.getMarket(exchangeID, contractID, marketID, true);
    }

    public Market getMarket(MarketID marketID) {
        return this.getMarket(marketID.ExchangeID, marketID.ContractID, marketID.MarketID, true);
    }

    public Market getMarket(String exchangeID, String contractID, String marketID, boolean cache) {
        Market market = this.mMarketCache.get(marketID);
        if (market != null) {
            return market;
        }
        Contract contract = this.getContract(exchangeID, contractID);
        if (contract == null) {
            Log.e(TAG, "getMarket(), Error. Contract " + Contract.getUniqueID(exchangeID, contractID) + " is not available.");
            return null;
        }
        MsgMarketDetails marketDetails = this.marketsService.getMarketDefinition(exchangeID, contractID, marketID);
        if (marketDetails == null) {
            Log.d(TAG, "getMarket(), [e: %s, c: %s, m: %s], Market definition not found.", exchangeID, contractID, marketID);
            return null;
        }
        if (marketDetails.UnderlyingMarketID != null && marketDetails.UnderlyingMarketID.length() > 0) {
            this.getMarket(exchangeID, contractID, marketDetails.UnderlyingMarketID, true);
        }
        for (MsgMarketDetails.LegItem legItem : marketDetails.Legs) {
            if (legItem.MarketID == null || legItem.MarketID.length() <= 0) continue;
            this.getMarket(exchangeID, contractID, legItem.MarketID, true);
        }
        market = this.processMarketDetails(marketDetails);
        return market;
    }

    public Market getMarket(String exchangeID, String contractID, String marketID, ContractType contractType, StrategyType strategyType, Integer strikePrice) {
        Market market = this.mMarketCache.get(marketID);
        if (market != null) {
            return market;
        }
        Contract contract = this.getContract(exchangeID, contractID);
        if (contract == null) {
            Log.e(TAG, "getMarket(), Error. Contract " + Contract.getUniqueID(exchangeID, contractID) + " is not available.");
            return null;
        }
        market = this.getMarket(exchangeID, contractID, marketID);
        if (market == null && strategyType.equals(StrategyType.None) && contractType.equals(ContractType.Future)) {
            market = this.getFirstMarket(exchangeID, contractID, contractType, strategyType);
        } else if (market == null && strategyType.equals(StrategyType.Any) && contractType.equals(ContractType.Unknown) && contract.getContractType() != ContractType.Option) {
            market = this.getFirstMarket(exchangeID, contractID);
        }
        return market;
    }

    public Market getOutrightMarket(String exchangeID, String contractID, int expiryDate) {
        OutrightMarket outrightMkt = new OutrightMarket(exchangeID, contractID, expiryDate);
        Market market = this.mOutrightMarketCache.get(outrightMkt);
        if (market != null) {
            return market;
        }
        Contract contract = this.getContract(exchangeID, contractID);
        if (contract == null) {
            Log.e(TAG, "getOutrightMarket(), Error. Contract " + Contract.getUniqueID(exchangeID, contractID) + " is not available.");
            return null;
        }
        Market firstMarket = this.getFirstMarket(exchangeID, contractID, ContractType.Future, StrategyType.None);
        if (firstMarket == null) {
            return null;
        }
        market = firstMarket;
        while (market.getExpiryDate() < expiryDate) {
            Market nextMarket = this.getNextMarketExpiry(market);
            if (nextMarket == null || nextMarket.getExpiryDate() > expiryDate || nextMarket.getExpiryDate() == firstMarket.getExpiryDate()) {
                market = null;
                break;
            }
            market = nextMarket;
            if (market.getExpiryDate() != expiryDate) continue;
            break;
        }
        if (market != null) {
            this.mOutrightMarketCache.put(outrightMkt, market);
        }
        return market;
    }

    public Market getFirstMarket(String exchangeID, String contractID) {
        return this.getFirstMarket(exchangeID, contractID, null, null);
    }

    public Market getFirstMarket(String exchangeID, String contractID, ContractType contractType, StrategyType strategyType) {
        boolean cache = true;
        Contract contract = this.getContract(exchangeID, contractID);
        if (contract == null) {
            Log.d(TAG, "getFirstMarket(), [e: %s, c: %s, ct: %s, st: %s], Contract not found.", exchangeID, contractID, contractType, strategyType);
            return null;
        }
        MarketResponse firstMarket = this.marketsService.getFirstMarket(exchangeID, contractID, contractType, strategyType);
        if (firstMarket == null) {
            Log.d(TAG, "getFirstMarket(), [e: %s, c: %s, ct: %s, st: %s], Market not found.", exchangeID, contractID, contractType, strategyType);
            return null;
        }
        Market market = this.getMarket(firstMarket.ExchangeID, firstMarket.ContractID, firstMarket.MarketID);
        return market;
    }

    public Market getNextMarket(Market market) {
        boolean cache = true;
        Contract contract = this.getContract(market.getExchangeID(), market.getContractID());
        if (contract == null) {
            Log.d(TAG, "getNextMarket(), [m: %s], Contract not found.", market.getMarketID());
            return null;
        }
        MarketResponse nextMarket = this.marketsService.getNextMarket(market.getExchangeID(), market.getContractID(), market.getMarketID());
        if (nextMarket == null) {
            Log.d(TAG, "getNextMarket(), [m: %s], Market not found.", market.getMarketID());
            return null;
        }
        Market resultMarket = this.getMarket(nextMarket.ExchangeID, nextMarket.ContractID, nextMarket.MarketID);
        return resultMarket;
    }

    public Market getNextMarketExpiry(Market market) {
        boolean cache = true;
        Contract contract = this.getContract(market.getExchangeID(), market.getContractID());
        if (contract == null) {
            Log.d(TAG, "getNextMarketExpiry(), [m: %s], Contract not found.", market.getMarketID());
            return null;
        }
        MarketResponse nextMarket = this.marketsService.getNextExpiry(market.getExchangeID(), market.getContractID(), market.getMarketID());
        if (nextMarket == null) {
            Log.d(TAG, "getNextMarketExpiry(), [m: %s], Market not found.", market.getMarketID());
            return null;
        }
        Market resultMarket = this.getMarket(nextMarket.ExchangeID, nextMarket.ContractID, nextMarket.MarketID);
        return resultMarket;
    }

    public void requestMarketPickerList(final String exchangeID, final String contractID, final MarketPickerGroup group, final MarketPickerListHandler handler) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                MarketData.this.doRequestMarketPickerList(exchangeID, contractID, group, handler);
            }
        });
        thread.start();
    }

    private void doRequestMarketPickerList(String exchangeID, String contractID, MarketPickerGroup group, MarketPickerListHandler handler) {
        Contract contract = this.getContract(exchangeID, contractID);
        if (contract == null) {
            Log.d(TAG, "doRequestMarketPickerList(), Error. Contract " + Contract.getUniqueID(exchangeID, contractID) + " is not available.");
            if (handler != null) {
                handler.onMarketPickerListComplete(exchangeID, contractID, group, null);
            }
            return;
        }
        List<MarketPickerMarket> marketPickerMarkets = this.marketsService.requestMarketPickerList(exchangeID, contractID, group);
        if (handler != null) {
            handler.onMarketPickerListComplete(exchangeID, contractID, group, marketPickerMarkets);
        }
    }

    public void requestMarketPickerGroups(final String exchangeID, final String contractID, final MarketPickerListHandler handler) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                MarketData.this.doRequestMarketPickerGroups(exchangeID, contractID, handler);
            }
        });
        thread.start();
    }

    private void doRequestMarketPickerGroups(String exchangeID, String contractID, MarketPickerListHandler handler) {
        Contract contract = this.getContract(exchangeID, contractID);
        if (contract == null) {
            Log.d(TAG, "doRequestMarketPickerGroups(), Error. Contract " + Contract.getUniqueID(exchangeID, contractID) + " is not available.");
            if (handler != null) {
                handler.onMarketGroupsComplete(exchangeID, contractID, null);
            }
            return;
        }
        List<MarketPickerGroup> marketPickerGroups = this.marketsService.requestMarketPickerGroups(exchangeID, contractID);
        if (handler != null) {
            handler.onMarketGroupsComplete(exchangeID, contractID, marketPickerGroups);
        }
    }

    private HashSet<String> saveLoginExchanges(MsgLoginResponse2 msg) {
        this.cachedExchanges.clear();
        this.mUserExchanges = new HashSet();
        for (MsgLoginResponse2.Exchange exchg : msg.Exchanges) {
            Exchange exchange = new Exchange(exchg);
            this.cachedExchanges.put(exchange.getExchangeID(), exchange);
            if (!exchg.Disabled && exchg.HasPermission) {
                this.mUserExchanges.add(exchg.ExchangeID);
                continue;
            }
            Log.v(TAG, "saveLoginExchanges(), Ignoring non-user exchange: %s (Disabled: %s, HasPermission: %s)", exchg.ExchangeID, exchg.Disabled, exchg.HasPermission);
        }
        return this.mUserExchanges;
    }

    private void saveContractDetailsMulti(MsgContractDetailsMulti msg) {
        long startTime = System.nanoTime();
        msg.messages.stream().forEach(m -> {
            if (m.getMessageType().equals((Object)MessageType.ContractDetails2)) {
                MsgContractDetails2 details = (MsgContractDetails2)m;
                Exchange exchange = this.getExchange(details.ExchangeID);
                if (exchange != null) {
                    Contract contract = new Contract(exchange, details);
                    String ucid = Contract.getUniqueID(contract.getExchangeID(), contract.getContractID());
                    this.cachedContracts.put(ucid, contract);
                } else {
                    Log.e(TAG, "saveContractDetailsMulti(), Unable to save contract %s/%s. Exchange not found.", details.ExchangeID, details.ContractID);
                }
            }
        });
        long endTime = System.nanoTime();
        Log.v(TAG, String.format("saveContractDetailsMulti(), contract details (%s) persisted to database in %d ms", msg.getExchangeID(), (endTime - startTime) / 1000000L));
    }

    public void subscribeForMarketDepth(Market market, DepthBuffer bufferLevel, DepthLevels depthLevel, boolean mbo) {
        this.subscribeForMarketDepth(market, bufferLevel, depthLevel, true, mbo);
    }

    public void subscribeForMarketDepth(Market market, DepthBuffer bufferLevel, DepthLevels depthLevel, boolean refreshSubscription, boolean mbo) {
        if (market == null) {
            Log.e(TAG, "subscribeForMarketDepth(), Invalid (null) value passed for 'market' argument.");
            return;
        }
        MarketSubscription msub = (MarketSubscription)this.marketSubscriptions.get((market = this.cacheMarket(market)).getMarketID());
        if (msub != null) {
            MarketDataSnapshot snapshot;
            EnumSet<MarketSubscription.SubscriptionChange> subscriptionChange = msub.updateSubscriptionLevels(bufferLevel, depthLevel, mbo);
            if (!subscriptionChange.isEmpty()) {
                Log.d(TAG, "subscribeForMarketDepth(), Updating existing subscription: %s", msub);
            }
            if (subscriptionChange.contains((Object)MarketSubscription.SubscriptionChange.Depth)) {
                this.sendSubscriptionRequest(market, msub.getDepthBuffer(), msub.getDepthLevels());
            }
            if (refreshSubscription && msub.getDepthBuffer() != DepthBuffer.NoSubscription && (snapshot = msub.getSnapshot()) != null) {
                for (IMarketDataHandler cb : this.marketDataHandlers) {
                    cb.onMarketUpdate(snapshot);
                }
            }
            if (subscriptionChange.contains((Object)MarketSubscription.SubscriptionChange.MBO)) {
                this.sendMBOSubscriptionRequest(market, msub.getMBOSubscribed());
            }
        } else {
            Market tmpMarket;
            if (market.isCachedMarket() && (tmpMarket = this.mMarketCache.get(market.getMarketID())) != null) {
                market = tmpMarket;
            }
            Log.d(TAG, "subcribeForMarketDepth(), market: " + market.getMarketID() + ", isCached: " + market.isCachedMarket());
            msub = new MarketSubscription(market);
            msub.setSubscriptionLevels(bufferLevel, depthLevel, mbo);
            this.marketSubscriptions.put(market.getMarketID(), msub);
            Log.d(TAG, "subscribeForMarketDepth(), New subscription: %s", msub);
            this.sendSubscriptionRequest(market, msub.getDepthBuffer(), msub.getDepthLevels());
            if (mbo) {
                this.sendMBOSubscriptionRequest(market, mbo);
            }
        }
    }

    private void resubscribeAllMarkets() {
        for (MarketSubscription msub : this.marketSubscriptions.values()) {
            Log.d(TAG, "resubscribeAllMarkets(), Re-subscribing: " + String.valueOf(msub));
            this.sendSubscriptionRequest(msub.getMarket(), msub.getDepthBuffer(), msub.getDepthLevels());
        }
    }

    private void sendSubscriptionRequest(Market market, DepthBuffer bufferLevel, DepthLevels depthLevel) {
        MsgMarketDepthSubscribe msg = new MsgMarketDepthSubscribe();
        msg.ExchangeID = market.getExchangeID();
        msg.ContractID = market.getContractID();
        msg.MarketID = market.getMarketID();
        msg.Group = market.getGroup();
        msg.SubscriptionDepthBuffer = bufferLevel;
        msg.SubscriptionDepthLevels = depthLevel;
        msg.CreateMarket = false;
        msg.EnableHistory = true;
        msg.EnableTradeVolume = true;
        msg.DueToConnection = false;
        this.service.sendMessage(msg);
    }

    private void sendMBOSubscriptionRequest(Market market, boolean subscribe) {
        MsgMarketByOrderSubscribe msg = new MsgMarketByOrderSubscribe();
        msg.MarketID = market.getMarketID();
        msg.ExchangeID = market.getExchangeID();
        msg.ContractID = market.getContractID();
        msg.Group = market.getGroup();
        msg.Subscribe = subscribe;
        msg.DueToConnection = false;
        this.service.sendMessage(msg);
    }

    public String getFormattedDisplayPrice(Market market, Price price) {
        if (price == null || market == null) {
            return "";
        }
        PriceDisplayMode priceDisplayMode = AppSettings.instance.MarketData.PriceDisplay;
        MarketSubscription msub = (MarketSubscription)this.marketSubscriptions.get(market.getMarketID());
        if (msub != null) {
            return msub.getFormattedDisplayPrice(price, priceDisplayMode);
        }
        return PriceFormat.convertPriceToDisplayFormat(price, (IPriceFormatArgs)market, priceDisplayMode);
    }

    public String getFormattedNetChange(Market market, Price value) {
        String fmt = this.getFormattedDisplayPrice(market, value);
        if (!fmt.isEmpty() && value.compareTo(Price.Zero) > 0) {
            return "+" + fmt;
        }
        return fmt;
    }

    public String getFormattedMarketExpiryDescription(Market market) {
        if (market == null) {
            return "";
        }
        try {
            return this.mMarketFormatter.getFormattedMarketExpiryDescription(market, this);
        }
        catch (Exception ex) {
            return market.getExpiryDescription();
        }
    }

    public String getFormattedMarketDescription(Market market) {
        if (market == null) {
            return "";
        }
        try {
            return this.mMarketFormatter.getFormattedMarketDescription(market, this);
        }
        catch (Exception ex) {
            return market.getDescription();
        }
    }

    public NDateTime getRemoteTime() {
        return this.service.getRemoteTime();
    }

    public NDateTime getRemoteTime(NDateTime time) {
        return this.service.getRemoteTime(time);
    }

    public String requestChartDataBatch(String exchangeID, String contractID, String marketID, ChartDataType dataType, Range<NDateTime> tradeDates, SessionTimeRange session, ChartDataRequestApplication reqApplication) {
        MsgChartDataBatchRequest msg = new MsgChartDataBatchRequest();
        msg.RequestID = UUID.randomUUID().toString();
        msg.ExchangeID = exchangeID;
        msg.ContractID = contractID;
        msg.MarketID = marketID;
        msg.DataType = dataType;
        msg.TradeDateStart = tradeDates.start().getDate();
        msg.TradeDateEnd = tradeDates.end().getDate();
        msg.SessionStartTime = session.startTime().toDateTime(NDateTime.now());
        msg.SessionEndTime = session.endTime().toDateTime(NDateTime.now());
        msg.RequestingApplication = reqApplication;
        this.service.sendChartDataRequest(msg);
        return msg.RequestID;
    }

    public String requestChartData(DataLoadArgs args, Range<NDateTime> tradeDates, ChartDataRequestApplication reqApplication) {
        MsgChartAggregatedDataRequest msg = new MsgChartAggregatedDataRequest();
        msg.RequestID = UUID.randomUUID().toString();
        msg.ExchangeID = args.getExchangeID();
        msg.ContractID = args.getContractID();
        msg.MarketID = args.getMarketID();
        msg.ContinuationType = args.getContinuationType();
        msg.RolloverThreshold = args.getRolloverThreshold();
        msg.ForwardMonths = args.getForwardMonths();
        msg.ExpiryContractMonths = args.getExpiryContractMonths();
        msg.ChartType = args.getChartType();
        msg.BarInterval = args.getBarInterval();
        msg.BarIntervalSize = args.getBarPeriod();
        msg.BarResetInterval = args.getBarResetInterval();
        msg.ExConfig = args.getExConfig();
        msg.TradeDateStart = tradeDates.start().getDate();
        msg.TradeDateEnd = tradeDates.end().getDate();
        msg.SessionStartTime = args.getSessionStartTime();
        msg.SessionEndTime = args.getSessionEndTime();
        msg.RequestingApplication = reqApplication;
        this.service.sendChartDataRequest(msg);
        return msg.RequestID;
    }

    public void submitUDSRequest(UDSSubmit udsSubmit) {
        this.pendingUDSRequests.put(udsSubmit.RequestID, udsSubmit);
        MsgCreateUDS msg = new MsgCreateUDS();
        msg.RequestID = udsSubmit.RequestID;
        msg.AccountID = udsSubmit.AccountID;
        msg.Details = udsSubmit.MarketDetails;
        this.service.sendMessage(msg);
    }

    private static class OutrightMarket {
        public final String ExchangeID;
        public final String ContractID;
        public final int ExpiryDate;

        public OutrightMarket(String exchangeID, String contractID, int expiryDate) {
            this.ExchangeID = exchangeID;
            this.ContractID = contractID;
            this.ExpiryDate = expiryDate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutrightMarket that = (OutrightMarket)o;
            return this.ExpiryDate == that.ExpiryDate && this.ExchangeID.equals(that.ExchangeID) && this.ContractID.equals(that.ContractID);
        }

        public int hashCode() {
            return Objects.hash(this.ExchangeID, this.ContractID, this.ExpiryDate);
        }
    }
}

