/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Log;
import com.t4login.api.Contract;
import com.t4login.connection.ServerType;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.util.Pair;
import com.t4login.util.PerformanceTimer;
import com.t4login.util.Xml;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MarketCacheUpdateTimes {
    private static final String TAG = "MarketCacheUpdateTimes";
    public static final SimpleDateFormat UpdateTimeFormat = NDateTime.createDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS");
    public static final SimpleDateFormat UpdateTimeFormat2 = NDateTime.createDateFormat("yyyy-MM-dd HH:mm:ss");
    private final ServerType mServerType;
    private Map<Pair<String, String>, NDateTime> mUpdateTimes = new HashMap<Pair<String, String>, NDateTime>();
    private NDateTime mLastUpdated = NDateTime.MinValue;
    private static final String ns = null;

    public MarketCacheUpdateTimes(ServerType serverType) {
        this.mServerType = serverType;
    }

    public int getMinutesSinceLastUpdate() {
        NTimeSpan ts = NDateTime.now().Subtract(this.mLastUpdated);
        double minutes = ts.getTotalMinutes();
        return (int)minutes;
    }

    public NDateTime getLastContractUpdateTime(String exchangeID, String contractID) {
        return this.mUpdateTimes.get(Pair.create(exchangeID, contractID));
    }

    public NDateTime getLastContractUpdateTime(Contract contract) {
        return this.mUpdateTimes.get(Pair.create(contract.getExchangeID(), contract.getContractID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update() {
        boolean res = false;
        String[] urls = this.mServerType.getMarketDataURLs();
        PerformanceTimer timer = new PerformanceTimer(true);
        for (int i = 0; i < urls.length; ++i) {
            String dbURL = urls[i] + "updatetimes.zip";
            try {
                ZipEntry ze;
                URL url = new URL(dbURL);
                URLConnection ucon = url.openConnection();
                InputStream is = ucon.getInputStream();
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));
                while ((ze = zis.getNextEntry()) != null) {
                    if (ze.isDirectory()) continue;
                    try {
                        XmlPullParser parser = Xml.newPullParser();
                        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                        parser.setInput(zis, null);
                        parser.nextTag();
                        String name = parser.getName();
                        if (!name.equalsIgnoreCase("UpdateTimes")) continue;
                        this.readUpdateTimes(parser);
                    }
                    catch (XmlPullParserException ppex) {
                        Log.e(TAG, "Error.", ppex);
                    }
                    finally {
                        zis.closeEntry();
                    }
                }
                zis.close();
                is.close();
                res = true;
                break;
            }
            catch (IOException ex) {
                Log.d(TAG, "Error downloading file 'updatetimes.zip' from URL: [" + dbURL + "]", ex);
                continue;
            }
        }
        long ms = timer.stopMilliseconds();
        if (res) {
            Log.d(TAG, String.format("update(), Success. File 'updatetimes.zip' downloaded and parsed in %d ms.", ms));
            this.mLastUpdated = NDateTime.now();
        } else {
            Log.d(TAG, String.format("update(), Failed. File 'updatetimes.zip' download failed. Process time: %d ms.", ms));
        }
        return res;
    }

    private void readUpdateTimes(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "UpdateTimes");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equalsIgnoreCase("c")) {
                this.readContractUpdateTimes(parser);
            }
            MarketCacheUpdateTimes.skip(parser);
        }
    }

    private void readContractUpdateTimes(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "c");
        String exchangeID = parser.getAttributeValue(ns, "e");
        String contractID = parser.getAttributeValue(ns, "c");
        NDateTime updateTime = NDateTime.MinValue;
        try {
            updateTime = NDateTime.from(parser.getAttributeValue(ns, "u"), UpdateTimeFormat2);
        }
        catch (Exception ex) {
            updateTime = NDateTime.from(parser.getAttributeValue(ns, "u"), UpdateTimeFormat);
        }
        this.mUpdateTimes.put(Pair.create(exchangeID, contractID), updateTime);
    }

    public static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.nextToken()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }
}

