/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.api.Contract;
import com.t4login.api.Exchange;
import com.t4login.api.LegMarket;
import com.t4login.api.MarketData;
import com.t4login.api.MarketPriceFormatter;
import com.t4login.api.T4HostService;
import com.t4login.application.settings.AppSettings;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.DepthBuffer;
import com.t4login.definitions.OrderType;
import com.t4login.definitions.StrategyType;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.definitions.priceconversion.VPT;
import com.t4login.definitions.util.MarketUtil;
import com.t4login.messages.Message;
import com.t4login.messages.MsgMarketDetails;
import com.t4login.util.ValueCompare;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class Market
implements Comparable<Market>,
Serializable,
IMarketConversion {
    public static final String TAG = "Market";
    public static final Market Empty = new Market(new MsgMarketDetails(), com.t4login.api.Contract.Empty, new LegMarket[0], null);
    public Contract Contract;
    public MsgMarketDetails Msg;
    public LegMarket[] LegMarkets;
    private String mMarketDescription;
    private String mExpiryDescription;
    private VPT mVPT;
    private IPriceFormatArgs mPriceFormatArgs = null;
    public LegMarket UnderlyingMarket;

    private void writeObject(ObjectOutputStream aStream) throws IOException {
        aStream.writeObject(this.Contract);
        Message.writeMessage(aStream, this.Msg);
        aStream.writeInt(this.LegMarkets.length);
        for (LegMarket mLegMarket : this.LegMarkets) {
            aStream.writeObject(mLegMarket);
        }
        aStream.writeUTF(this.mMarketDescription);
        aStream.writeUTF(this.mExpiryDescription);
        if (this.mVPT != null) {
            aStream.writeInt(1);
            aStream.writeUTF(this.mVPT.spec);
            aStream.writeUTF(this.mVPT.marketID);
            aStream.writeObject(this.mVPT.baseIncrement.getDecimalValue());
            aStream.writeObject(this.mVPT.minCabPrice.getDecimalValue());
        } else {
            aStream.writeInt(0);
        }
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        this.Contract = (Contract)aStream.readObject();
        this.Msg = (MsgMarketDetails)Message.getMessage(aStream);
        int nLegs = aStream.readInt();
        this.LegMarkets = new LegMarket[nLegs];
        for (int i = 0; i < nLegs; ++i) {
            this.LegMarkets[i] = (LegMarket)aStream.readObject();
        }
        this.mMarketDescription = aStream.readUTF();
        this.mExpiryDescription = aStream.readUTF();
        int hasVTT = aStream.readInt();
        if (hasVTT == 1) {
            String vptSpec = aStream.readUTF();
            String marketID = aStream.readUTF();
            BigDecimal baseIncrement = (BigDecimal)aStream.readObject();
            BigDecimal minCabPrice = (BigDecimal)aStream.readObject();
            this.mVPT = new VPT(vptSpec, marketID, new Price(baseIncrement), minCabPrice != null ? new Price(minCabPrice) : null);
        } else {
            this.mVPT = null;
        }
    }

    public Market(MsgMarketDetails msg, Contract contract, LegMarket[] legMarkets, LegMarket underlyingMarket) {
        this.Contract = contract;
        this.Msg = msg;
        this.LegMarkets = legMarkets;
        this.UnderlyingMarket = underlyingMarket;
        String tmpDescr = this.Msg.Description.replace(this.Contract.getBaseDescription(), "~%~");
        this.mMarketDescription = tmpDescr.replace("~%~", this.Contract.getDescription());
        this.mExpiryDescription = this.Msg.Description.replace(this.Contract.getBaseDescription(), "");
        this.mVPT = msg.VTT != null && msg.VTT.length() > 0 || this.Msg.MinCabPrice != null ? new VPT(msg.VTT, this.Msg.MarketID, this.getMinPriceIncrement(), this.Msg.MinCabPrice) : null;
    }

    public boolean isCachedMarket() {
        return this.Msg.IsCachedDetails;
    }

    public Contract getContract() {
        return this.Contract;
    }

    public Exchange getExchange() {
        return this.Contract.Exchange;
    }

    public String getExchangeID() {
        return this.Msg.ExchangeID;
    }

    public String getContractID() {
        return this.Msg.ContractID;
    }

    @Override
    public String getMarketID() {
        return this.Msg.MarketID;
    }

    public String getMarketDetail() {
        return this.Msg.Details;
    }

    public String getGroup() {
        return this.Msg.Group;
    }

    public int getExpiryDate() {
        return this.Msg.ExpiryDate;
    }

    public NDateTime getLastTradingDate() {
        return this.Msg.LastTradingDate;
    }

    public String getExpiryDescription() {
        return this.Msg.Description.replace(this.Contract.getBaseDescription(), "");
    }

    public String getDescription() {
        String tmpDescr = this.Msg.Description.replace(this.Contract.getBaseDescription(), "~%~");
        return tmpDescr.replace("~%~", this.Contract.getDescription());
    }

    public boolean getEnabled() {
        return !this.Msg.Disabled;
    }

    public ContractType getContractType() {
        return this.Msg.ContractType;
    }

    public Price getStrikePrice() {
        return this.Msg.StrikePrice;
    }

    public StrategyType getStrategyType() {
        return this.Msg.StrategyType;
    }

    public int getNumerator() {
        return this.Msg.Numerator;
    }

    @Override
    public int getDenominator() {
        return this.Msg.Denominator;
    }

    @Override
    public String getPriceCode() {
        return this.Msg.PriceCode;
    }

    public double getTickValue() {
        return this.Msg.TickValue;
    }

    public Set<OrderType> getOrderTypes() {
        return this.Msg.OrderTypes;
    }

    public int getVolumeIncrement() {
        return this.Msg.VolumeIncrement;
    }

    public String getDetails() {
        return this.Msg.Details;
    }

    public String getVTTSpec() {
        return this.Msg.VTT;
    }

    public int getLegCount() {
        return this.Msg.Legs.size();
    }

    public Leg getLeg(int idx) {
        return new Leg(this.Msg.Legs.get(idx), idx, this.LegMarkets[idx]);
    }

    public Iterator<Leg> legs() {
        return new Iterator<Leg>(){
            private Leg nextLeg;
            {
                this.nextLeg = Market.this.Msg.Legs.size() > 0 ? new Leg(Market.this.Msg.Legs.get(0), 0, Market.this.LegMarkets[0]) : null;
            }

            @Override
            public boolean hasNext() {
                return this.nextLeg != null;
            }

            @Override
            public Leg next() {
                if (this.nextLeg == null) {
                    throw new NoSuchElementException("There is no next item in the collection.");
                }
                int i = this.nextLeg.getLegIndex() + 1;
                this.nextLeg = i < Market.this.Msg.Legs.size() ? new Leg(Market.this.Msg.Legs.get(i), i, Market.this.LegMarkets[i]) : null;
                return this.nextLeg;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public int compareTo(Market o) {
        if (o == null) {
            return -1;
        }
        if (this == o) {
            return 0;
        }
        int ret = this.Contract.compareTo(o.Contract);
        if (ret != 0) {
            return ret;
        }
        ret = Integer.valueOf(this.Msg.ExpiryDate).compareTo(o.Msg.ExpiryDate);
        if (ret != 0) {
            return ret;
        }
        if (this.Msg.ContractType.equals(ContractType.Option) && (o.Msg.ContractType.equals(ContractType.OptionCall) || o.Msg.ContractType.equals(ContractType.OptionPut))) {
            return 1;
        }
        if (o.Msg.ContractType.equals(ContractType.Option) && (this.Msg.ContractType.equals(ContractType.OptionCall) || this.Msg.ContractType.equals(ContractType.OptionPut))) {
            return -1;
        }
        Double detValA = null;
        Double detValB = null;
        try {
            detValA = Double.valueOf(this.Msg.Details);
            detValB = Double.valueOf(o.Msg.Details);
        }
        catch (NumberFormatException nfex) {
            detValA = null;
            detValB = null;
        }
        if (detValA != null && detValB != null && (ret = detValA.compareTo(detValB)) != 0) {
            return ret;
        }
        ret = this.Msg.Details.compareTo(o.Msg.Details);
        if (ret != 0) {
            return ret;
        }
        ret = this.Msg.ContractType.compareTo(o.Msg.ContractType);
        if (ret != 0) {
            return ret;
        }
        ret = this.Msg.StrategyType.compareTo(o.Msg.StrategyType);
        if (ret != 0) {
            return ret;
        }
        for (int i = 0; i < Math.min(this.Msg.Legs.size(), o.Msg.Legs.size()); ++i) {
            LegMarket leg1Mkt = this.LegMarkets[i];
            LegMarket leg2Mkt = o.LegMarkets[i];
            if (leg1Mkt == null || leg2Mkt == null || (ret = leg1Mkt.compareTo(leg2Mkt)) == 0) continue;
            return ret;
        }
        ret = ValueCompare.Compare(this.Msg.Legs.size(), o.Msg.Legs.size());
        if (ret != 0) {
            return ret;
        }
        return this.Msg.MarketID.compareTo(o.Msg.MarketID);
    }

    public boolean isOrderTypeSupported(OrderType ot) {
        return this.Msg.OrderTypes.contains(ot);
    }

    public static boolean isOrderTypeSupported(int types, OrderType ot) {
        int mask = types & ot.getValue();
        return mask == ot.getValue();
    }

    public static boolean isDepthBufferSet(DepthBuffer check, DepthBuffer buffer) {
        return MarketUtil.isDepthBufferSet(check, buffer);
    }

    public static MarketPriceFormatter createMarketPriceFormatter(final T4HostService host, final Market market) {
        if (host != null && market != null) {
            return new MarketPriceFormatter(){

                @Override
                public String formatPrice(Price price) {
                    if (market != null) {
                        MarketData md = host.getMarketData();
                        if (md != null) {
                            return md.getFormattedDisplayPrice(market, price);
                        }
                        return PriceFormat.convertPriceToDisplayFormat(price, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay);
                    }
                    return price.toString();
                }

                @Override
                public Market getMarket() {
                    return market;
                }
            };
        }
        return new MarketPriceFormatter(){

            @Override
            public String formatPrice(Price price) {
                return price.toString();
            }

            @Override
            public Market getMarket() {
                return null;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Market market = (Market)o;
        return this.Msg.MarketID.equals(market.Msg.MarketID);
    }

    public int hashCode() {
        return this.Msg.MarketID.hashCode();
    }

    @Override
    public Price getMinPriceIncrement() {
        return this.Msg.MinPriceIncrement;
    }

    @Override
    public VPT getVPT() {
        return this.mVPT;
    }

    @Override
    public Price getMinCabPrice() {
        return this.Msg.MinCabPrice;
    }

    @Override
    public int getRealDecimals() {
        return this.Msg.RealDecimals;
    }

    @Override
    public int getClearingDecimals() {
        return this.Msg.ClearingDecimals;
    }

    @Override
    public BigDecimal getPointValue() {
        return new BigDecimal(this.Msg.TickValue).divide(this.Msg.MinPriceIncrement.getDecimalValue(), 18, RoundingMode.HALF_EVEN);
    }

    @Override
    public Integer getYieldYears() {
        return this.Contract.Msg.YieldYears;
    }

    @Override
    public Double getYieldParValue() {
        return this.Contract.Msg.YieldParValue;
    }

    @Override
    public Double getYieldRate() {
        return this.Contract.Msg.YieldRate;
    }

    @Override
    public Integer getYieldValueDenominator() {
        return this.Contract.Msg.YieldValueDenominator;
    }

    @Override
    public Double getYieldRedemption() {
        return this.Contract.Msg.YieldRedemption;
    }

    @Override
    public Double getYieldPaymentsPerYear() {
        return this.Contract.Msg.YieldPaymentsPerYear;
    }

    @Override
    public Integer getYieldBasis() {
        return this.Contract.Msg.YieldBasis;
    }

    public static class Leg {
        MsgMarketDetails.LegItem mLeg;
        public final int mLegIndex;
        public final LegMarket LegMarket;

        public Leg(MsgMarketDetails.LegItem leg, int legIndex, LegMarket legMarket) {
            this.mLeg = leg;
            this.mLegIndex = legIndex;
            this.LegMarket = legMarket;
        }

        public String getMarketID() {
            return this.mLeg.MarketID;
        }

        public int getLegIndex() {
            return this.mLegIndex;
        }

        public String getMarketRef() {
            return this.mLeg.MarketRef;
        }

        public int getVolume() {
            return this.mLeg.Volume;
        }

        public String getDelta() {
            return this.mLeg.Delta;
        }

        public String getPrice() {
            return this.mLeg.Price;
        }
    }
}

