/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.MsgMarketByOrderUpdate;
import java.math.BigInteger;
import java.util.List;

public class MBOUpdate {
    private final MsgMarketByOrderUpdate _msg;

    MBOUpdate(MsgMarketByOrderUpdate msg) {
        this._msg = msg;
    }

    public int getMarketIdent() {
        return this._msg.MarketIdent;
    }

    public String getMarketID() {
        return this._msg.MarketID;
    }

    public NDateTime getTime() {
        return this._msg.Time;
    }

    public MarketMode getMode() {
        return this._msg.Mode;
    }

    public List<Update> getUpdates() {
        return this._msg.Updates.stream().map(Update::new).toList();
    }

    public static class Update {
        private final MsgMarketByOrderUpdate.Update _update;

        Update(MsgMarketByOrderUpdate.Update update) {
            this._update = update;
        }

        public UpdateType getUpdate() {
            return UpdateType.fromInteger(this._update.Update.ordinal());
        }

        public BigInteger getOrderID() {
            return this._update.OrderID;
        }

        public BidOffer getBidOffer() {
            return this._update.BidOffer;
        }

        public Price getPrice() {
            return this._update.Price;
        }

        public int getVolume() {
            return this._update.Volume;
        }

        public BigInteger getPriority() {
            return this._update.Priority;
        }
    }

    public static enum UpdateType {
        AddOrUpdate,
        Delete,
        Clear;


        public static UpdateType fromInteger(int x) {
            return switch (x) {
                case 0 -> AddOrUpdate;
                case 1 -> Delete;
                case 2 -> Clear;
                default -> null;
            };
        }
    }
}

