/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.MsgMarketByOrderSnapshot;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;

public class MBOSnapshot
implements Iterable<Order> {
    private final MsgMarketByOrderSnapshot _msg;

    MBOSnapshot(MsgMarketByOrderSnapshot msg) {
        this._msg = msg;
    }

    public int getMarketIdent() {
        return this._msg.MarketIdent;
    }

    public String getMarketID() {
        return this._msg.MarketID;
    }

    public NDateTime getTime() {
        return this._msg.Time;
    }

    public MarketMode getMode() {
        return this._msg.Mode;
    }

    public boolean getDueToConnection() {
        return this._msg.DueToConnection;
    }

    public List<Order> getOrders() {
        return this._msg.Orders.stream().map(Order::new).toList();
    }

    @Override
    public Iterator<Order> iterator() {
        return new Iterator<Order>(){
            int current = -1;

            @Override
            public boolean hasNext() {
                int count = MBOSnapshot.this._msg.Orders.size();
                return count > this.current + 1;
            }

            @Override
            public Order next() {
                ++this.current;
                return new Order(MBOSnapshot.this._msg.Orders.get(this.current));
            }
        };
    }

    public static class Order {
        private final MsgMarketByOrderSnapshot.Order _order;

        Order(MsgMarketByOrderSnapshot.Order order) {
            this._order = order;
        }

        public BigInteger getOrderID() {
            return this._order.OrderID;
        }

        public BidOffer getBidOffer() {
            return this._order.BidOffer;
        }

        public Price getPrice() {
            return this._order.Price;
        }

        public int getVolume() {
            return this._order.Volume;
        }

        public BigInteger getPriority() {
            return this._order.Priority;
        }
    }
}

