/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Log;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.StrategyType;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.util.EncodingUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;

public class LegMarket
implements Comparable<LegMarket>,
IPriceFormatArgs,
Serializable {
    public static final String TAG = "LegMarket";
    public String ExchangeID;
    public String ContractID;
    public String MarketID;
    public boolean IsRTS;
    public String ExchangeDescription;
    public String ContractDescription;
    public String ClearingCode;
    public int ExpiryDate;
    public String Details;
    public ContractType ContractType;
    public StrategyType StrategyType;
    public int Numerator;
    public int Denominator;
    public String PriceCode;
    public String VTT;
    public double TickValue;
    public int RealDecimals;
    public int ClearingDecimals;
    public Price MinCabPrice;
    public Price StrikePrice;
    public String UnderlyingMarketID;
    public LegMarket UnderlyingMarket;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LegMarket create(String marketID, byte[] bytes) {
        LegMarket legMarket = new LegMarket();
        legMarket.MarketID = marketID;
        if (bytes.length <= 0) return legMarket;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            legMarket.ExchangeID = Message.readString(in);
            legMarket.ContractID = Message.readString(in);
            legMarket.IsRTS = Message.readBoolean(in);
            legMarket.ExchangeDescription = Message.readString(in);
            legMarket.ContractDescription = Message.readString(in);
            legMarket.ExpiryDate = EncodingUtil.decode7BitInt(in);
            legMarket.Details = Message.readString(in);
            legMarket.ContractType = com.t4login.definitions.ContractType.get(EncodingUtil.decode7BitInt(in));
            legMarket.StrategyType = com.t4login.definitions.StrategyType.get(EncodingUtil.decode7BitInt(in));
            legMarket.Numerator = EncodingUtil.decode7BitInt(in);
            legMarket.Denominator = EncodingUtil.decode7BitInt(in);
            legMarket.PriceCode = Message.readString(in);
            legMarket.VTT = Message.readString(in);
            legMarket.TickValue = Message.readDouble(in);
            legMarket.RealDecimals = EncodingUtil.decode7BitInt(in);
            legMarket.ClearingDecimals = EncodingUtil.decode7BitInt(in);
            legMarket.ClearingCode = Message.readString(in);
            legMarket.MinCabPrice = Message.read7BitPriceN(in);
            legMarket.StrikePrice = Message.read7BitPriceN(in);
            legMarket.UnderlyingMarketID = Message.readString(in);
            if (in.available() <= 0) return legMarket;
        }
        catch (IOException ioex) {
            Log.e(TAG, "create(), Error.", ioex);
        }
        return legMarket;
    }

    @Override
    public int compareTo(LegMarket other) {
        Integer expB;
        if (other == null) {
            return -1;
        }
        if (this == other) {
            return 0;
        }
        int res = this.ExchangeID.compareTo(other.ExchangeID);
        if (res != 0) {
            return res;
        }
        res = this.ContractID.compareTo(other.ContractID);
        if (res != 0) {
            return res;
        }
        res = this.ExchangeDescription.compareTo(other.ExchangeDescription);
        if (res != 0) {
            return res;
        }
        res = this.ContractDescription.compareTo(other.ContractDescription);
        if (res != 0) {
            return res;
        }
        Integer expA = this.ExpiryDate;
        res = expA.compareTo(expB = Integer.valueOf(this.ExpiryDate));
        if (res != 0) {
            return res;
        }
        if (this.ContractType == com.t4login.definitions.ContractType.Option && (other.ContractType == com.t4login.definitions.ContractType.OptionCall || other.ContractType == com.t4login.definitions.ContractType.OptionPut)) {
            return 1;
        }
        if (other.ContractType == com.t4login.definitions.ContractType.Option && (this.ContractType == com.t4login.definitions.ContractType.OptionCall || this.ContractType == com.t4login.definitions.ContractType.OptionPut)) {
            return -1;
        }
        Double detValA = null;
        Double detValB = null;
        try {
            detValA = Double.valueOf(this.Details);
            detValB = Double.valueOf(other.Details);
        }
        catch (NumberFormatException nfex) {
            detValA = null;
            detValB = null;
        }
        if (detValA != null && detValB != null && (res = detValA.compareTo(detValB)) != 0) {
            return res;
        }
        res = this.Details.compareTo(other.Details);
        if (res != 0) {
            return res;
        }
        res = this.ContractType.compareTo(other.ContractType);
        if (res != 0) {
            return res;
        }
        res = this.StrategyType.compareTo(other.StrategyType);
        return res;
    }

    @Override
    public Price getMinCabPrice() {
        return this.MinCabPrice;
    }

    @Override
    public String getPriceCode() {
        return this.PriceCode;
    }

    @Override
    public int getDenominator() {
        return this.Denominator;
    }

    @Override
    public int getRealDecimals() {
        return this.RealDecimals;
    }

    @Override
    public int getClearingDecimals() {
        return this.ClearingDecimals;
    }
}

