/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.api.GetServersResponse;
import com.t4login.connection.ConnectionConfigXmlParser;
import com.t4login.connection.ServerType;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Locale;

public class GetServersXml {
    private static final String TAG = "T4GetServersXml";

    private GetServersXml() {
    }

    public static GetServersResponse getServers(String firm, ServerType serverType) {
        String firmEnc;
        try {
            firmEnc = URLEncoder.encode(firm, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e(TAG, "connectSocket.run(), Failed URL encoding firm or user name.");
            GetServersResponse errResp = new GetServersResponse();
            errResp.message = "Failed to retrieve remote servers list.";
            return errResp;
        }
        String path = "Servers/GetServers.aspx";
        if (!serverType.equals((Object)ServerType.Unknown)) {
            String yy = String.format(Locale.US, "%s?firm=%s&app=%s&sys=%d", path, firmEnc, Host.getApplicationName(serverType), serverType.getServerType());
            String[] urls = serverType.getUrls();
            for (int i = 0; i < urls.length; ++i) {
                String url = urls[i] + "/" + yy;
                url = url + String.format(Locale.ENGLISH, "&dt=%d", System.currentTimeMillis());
                Log.d(TAG, "connectSocket.run(), url: " + url);
                try {
                    URLConnection conn = new URL(url).openConnection();
                    ConnectionConfigXmlParser parser = new ConnectionConfigXmlParser();
                    parser.parse(conn.getInputStream());
                    return parser.asGetServersResponse();
                }
                catch (Exception ex) {
                    Log.e(TAG, "Error.", ex);
                    continue;
                }
            }
        } else {
            Log.e(TAG, "connectSocket.run(), Error. Unknown server type.");
        }
        GetServersResponse errResp = new GetServersResponse();
        errResp.message = "Failed to retrieve remote servers list.";
        return errResp;
    }

    public static GetServersResponse getServers(String firm, String userName, ServerType serverType, String deviceId) {
        String userNameEnc;
        String firmEnc;
        try {
            firmEnc = URLEncoder.encode(firm, "utf-8");
            userNameEnc = URLEncoder.encode(userName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e(TAG, "connectSocket.run(), Failed URL encoding firm or user name.");
            GetServersResponse errResp = new GetServersResponse();
            errResp.message = "Failed to retrieve remote servers list.";
            return errResp;
        }
        String path = "Servers/GetServers.aspx";
        if (!serverType.equals((Object)ServerType.Unknown)) {
            String yy = String.format(Locale.US, "%s?firm=%s&user=%s&app=%s&sys=%d", path, firmEnc, userNameEnc, Host.getApplicationName(serverType), serverType.getServerType());
            String[] urls = serverType.getUrls();
            for (int i = 0; i < urls.length; ++i) {
                String url = urls[i] + "/" + yy;
                url = url + String.format(Locale.ENGLISH, "&dt=%d", System.currentTimeMillis());
                Log.d(TAG, "connectSocket.run(), url: " + url);
                try {
                    URLConnection conn = new URL(url).openConnection();
                    ConnectionConfigXmlParser parser = new ConnectionConfigXmlParser();
                    parser.parse(conn.getInputStream());
                    return parser.asGetServersResponse();
                }
                catch (Exception ex) {
                    Log.e(TAG, "Error.", ex);
                    continue;
                }
            }
        } else {
            Log.e(TAG, "connectSocket.run(), Error. Unknown server type.");
        }
        GetServersResponse errResp = new GetServersResponse();
        errResp.message = "Failed to retrieve remote servers list.";
        return errResp;
    }
}

