/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Log;
import com.t4login.api.Contract;
import com.t4login.api.IAsyncHandler;
import com.t4login.api.IFirmDataHandler;
import com.t4login.api.Market;
import com.t4login.api.MarketData;
import com.t4login.api.StrikeMarkets;
import com.t4login.api.T4HostService;
import com.t4login.connection.IMessageHandler;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.definitions.Expiry;
import com.t4login.messages.FirmContract;
import com.t4login.messages.Message;
import com.t4login.messages.MsgFirmContract;
import com.t4login.messages.MsgFirmSnapshot;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class FirmData {
    private static final String TAG = "FirmData";
    private final T4HostService mT4Service;
    private List<IFirmDataHandler> dataHandlers = new CopyOnWriteArrayList<IFirmDataHandler>();
    private ConcurrentHashMap<String, FirmContract> firmContracts = new ConcurrentHashMap(10, 0.9f, 1);

    public FirmData(T4HostService s) {
        this.mT4Service = s;
        s.registerMessageHandler(new IMessageHandler(){

            @Override
            public void onMessage(Message msg) {
                FirmData.this.onMessage(msg);
            }
        });
    }

    public void registerForFirmData(IFirmDataHandler handler) {
        if (!this.dataHandlers.contains(handler)) {
            Log.d(TAG, "registerForFirmData(), Registering firm data handler '" + handler.getDescription() + "'");
            this.dataHandlers.add(handler);
        } else {
            Log.d(TAG, "registerForFirmData(), Firm data handler '" + handler.getDescription() + "' already registered!");
        }
    }

    public void unregisterForFirmData(IFirmDataHandler handler) {
        if (this.dataHandlers.contains(handler)) {
            Log.d(TAG, "unregisterForFirmData(), Unregistering firm data handler '" + handler.getDescription() + "'");
            this.dataHandlers.remove(handler);
        } else {
            Log.d(TAG, "unregisterForFirmData(), Firm data handler '" + handler.getDescription() + "' not registered!");
        }
    }

    public FirmContract getFirmContract(String exchangeID, String contractID) {
        return this.firmContracts.get(exchangeID + "_" + contractID);
    }

    public Market getActiveMarket(String exchangeID, String contractID) {
        FirmContract firmContract = this.getFirmContract(exchangeID, contractID);
        if (firmContract == null) {
            Log.d(TAG, "getActiveMarket(), %s / %s, FirmContract not found.", exchangeID, contractID);
            return null;
        }
        NDateTime now = this.mT4Service.getRemoteTime();
        Optional<Expiry> currentExpiry = firmContract.ActiveMonths.Expiries.stream().filter(exp -> now.compareTo(exp.Liquidation) < 0).min(Comparator.comparing(e -> e.Liquidation));
        if (!currentExpiry.isPresent()) {
            Log.d(TAG, "getActiveMarket(), %s / %s, Unable to determine current expiry for contract.", exchangeID, contractID);
            return null;
        }
        Market market = this.mT4Service.getMarketData().getOutrightMarket(exchangeID, contractID, currentExpiry.get().ExpiryDate);
        return market;
    }

    public void getActiveEventContractMarkets(final String exchangeID, final String contractID, final IAsyncHandler<StrikeMarkets> handler) {
        MarketData marketData = this.mT4Service.getMarketData();
        if (marketData == null) {
            Log.d(TAG, "getActiveEventContractMarkets(), MarketData not initialized.");
            handler.onComplete(null);
            return;
        }
        Contract contract = marketData.getContract(exchangeID, contractID);
        if (contract == null) {
            Log.d(TAG, "getActiveEventContractMarkets(), Contract not found. ExchangeID: %s, ContractID: %s", exchangeID, contractID);
            handler.onComplete(null);
            return;
        }
        if (!contract.getIsEventBased().booleanValue()) {
            Log.d(TAG, "getActiveEventContractMarkets(), Not an event-based contract. ExchangeID: %s, ContractID: %s", exchangeID, contractID);
            handler.onComplete(null);
            return;
        }
        Market firstMarket = marketData.getFirstMarket(exchangeID, contractID, null, null);
        if (firstMarket == null) {
            Log.d(TAG, "getActiveEventContractMarkets(), Markets not found for contract. ExchangeID: %s, ContractID: %s", exchangeID, contractID);
            handler.onComplete(null);
            return;
        }
        final int currentExpiry = firstMarket.getExpiryDate();
        marketData.getOptionContractStrikeMarkets(contract, currentExpiry, new IAsyncHandler<List<StrikeMarkets>>(){

            @Override
            public void onComplete(List<StrikeMarkets> result) {
                if (result != null && result.size() > 0) {
                    StrikeMarkets midStrike = result.get(result.size() / 2);
                    if (midStrike != null) {
                        Log.d(FirmData.TAG, "getActiveEventContractMarkets(), E: %s, C: %s, Expiry: %d, Strike: %s", exchangeID, contractID, midStrike.Expiry, midStrike.StrikePrice.toString());
                    }
                    handler.onComplete(midStrike);
                } else {
                    Log.d(FirmData.TAG, "getActiveEventContractMarkets(), No markets found for the contract/expiry. ExchangeID: %s, ContractID: %s, Expiry: %d", exchangeID, contractID, currentExpiry);
                    handler.onComplete(null);
                }
            }

            @Override
            public void onError(Exception ex) {
                Log.d(FirmData.TAG, "getActiveEventContractMarkets(), No markets found for the contract/expiry. ExchangeID: %s, ContractID: %s, Expiry: %d", exchangeID, contractID, currentExpiry);
                handler.onComplete(null);
            }
        });
    }

    public NDateTime getMarginAlertTime(Market market) {
        FirmContract firmContract = this.getFirmContract(market.getExchangeID(), market.getContractID());
        if (firmContract == null) {
            return null;
        }
        NDateTime liquidationTime = this.getAutoLiquidationTime(market);
        if (liquidationTime == null) {
            return null;
        }
        return liquidationTime.Subtract(firmContract.AutoLiquidate.AlertPeriod);
    }

    public NDateTime getAutoLiquidationTime(Market market) {
        FirmContract firmContract = this.getFirmContract(market.getExchangeID(), market.getContractID());
        if (firmContract == null) {
            return null;
        }
        NDateTime now = this.mT4Service.getRemoteTime();
        NDateTime tradeDate = market.Contract.getTradeDate(now);
        NDateTime marketCloseTime = market.getContract().getTradingSchedule().getNextClosedTime(now);
        NTimeSpan hardCutoffTimeValue = firmContract.AutoLiquidate.HardCutoff;
        NDateTime hardCutoffTime = null;
        if (hardCutoffTimeValue != null && hardCutoffTimeValue.getTicks() > 0L) {
            hardCutoffTime = tradeDate.Add(hardCutoffTimeValue);
        }
        NTimeSpan timeBeforeClose = firmContract.AutoLiquidate.TimeBeforeClose;
        NDateTime liquidationTime = marketCloseTime != null ? marketCloseTime.Subtract(timeBeforeClose) : hardCutoffTime;
        if (liquidationTime != null && hardCutoffTime != null && hardCutoffTime.compareTo(liquidationTime) < 0) {
            liquidationTime = hardCutoffTime;
        }
        return liquidationTime;
    }

    public BigDecimal getDayMargin(Market market) {
        FirmContract firmContract = this.getFirmContract(market.getExchangeID(), market.getContractID());
        if (firmContract != null) {
            return new BigDecimal(firmContract.Margin);
        }
        return null;
    }

    public BigDecimal getAdjustedFullMargin(Market market) {
        FirmContract firmContract = this.getFirmContract(market.getExchangeID(), market.getContractID());
        BigDecimal multiplier = BigDecimal.ONE;
        if (firmContract != null && firmContract.AutoLiquidate != null && firmContract.AutoLiquidate.MaintMarginMultiplier != null) {
            multiplier = firmContract.AutoLiquidate.MaintMarginMultiplier;
        }
        BigDecimal marginRate = new BigDecimal(market.Msg.MaintMargin);
        return marginRate.multiply(multiplier);
    }

    public NDateTime getExpiryLiquidationDateTime(Market market) {
        Optional<NDateTime> liquidationDateTime;
        FirmContract firmContract = this.getFirmContract(market.getExchangeID(), market.getContractID());
        if (firmContract != null && (liquidationDateTime = firmContract.ActiveMonths.Expiries.stream().filter(exp -> exp.ExpiryDate == market.getExpiryDate()).map(exp -> exp.Liquidation).findFirst()).isPresent()) {
            return liquidationDateTime.get();
        }
        return null;
    }

    private void onMessage(Message msg) {
        switch (msg.getMessageType()) {
            case FirmSnapshot: {
                this.processFirmSnapshot((MsgFirmSnapshot)msg);
                break;
            }
            case FirmContract: {
                this.processFirmContract((MsgFirmContract)msg);
            }
        }
    }

    private void processFirmSnapshot(MsgFirmSnapshot msg) {
        this.firmContracts.clear();
        HashMap<String, FirmContract> contracts = new HashMap<String, FirmContract>();
        for (FirmContract c : msg.Contracts) {
            this.firmContracts.put(c.getKey(), c);
            contracts.put(c.getKey(), c);
        }
        for (IFirmDataHandler cb : this.dataHandlers) {
            cb.onFirmContractsRefreshed(contracts);
        }
    }

    private void processFirmContract(MsgFirmContract msg) {
        this.firmContracts.put(msg.Contract.getKey(), msg.Contract);
        for (IFirmDataHandler cb : this.dataHandlers) {
            cb.onFirmContractUpdated(msg.Contract);
        }
    }
}

