/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Resource;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.MarketDataType;
import com.t4login.messages.MsgLoginResponse2;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class Exchange
implements Comparable<Exchange>,
Serializable {
    public static final Exchange Empty = new Exchange("", "", ContractType.Unknown, false, false, false, new HashSet<MarketDataType>(), "");
    public MsgLoginResponse2.Exchange Msg;

    private void writeObject(ObjectOutputStream aStream) throws IOException {
        aStream.writeObject(this.Msg);
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        this.Msg = (MsgLoginResponse2.Exchange)aStream.readObject();
    }

    public Exchange(String exchgid, String descr, ContractType ctype, boolean pm, boolean chartpm, boolean uds, Set<MarketDataType> mkttyp, String clrex) {
        this.Msg = new MsgLoginResponse2.Exchange();
        this.Msg.ExchangeID = exchgid;
        this.Msg.Description = descr;
        this.Msg.ContractType = ctype;
        this.Msg.HasPermission = pm;
        this.Msg.HasChartPermission = chartpm;
        this.Msg.UDS = uds;
        this.Msg.MarketDataType = mkttyp;
        this.Msg.ClearingExchange = clrex;
    }

    public Exchange(MsgLoginResponse2.Exchange msg) {
        this.Msg = msg;
    }

    @Override
    public int compareTo(Exchange o) {
        if (o == null) {
            return -1;
        }
        if (this == o) {
            return 0;
        }
        return this.Msg.Description.compareTo(o.Msg.Description);
    }

    public String getExchangeID() {
        return this.Msg.ExchangeID;
    }

    public String getDescription() {
        return this.Msg.Description;
    }

    public boolean getDisabled() {
        return this.Msg.Disabled;
    }

    public boolean getHasPermission() {
        return this.Msg.HasPermission;
    }

    public boolean getHasChartPermission() {
        return this.Msg.HasChartPermission;
    }

    public ContractType getContractType() {
        return this.Msg.ContractType;
    }

    public Set<MarketDataType> getMarketDataType() {
        return this.Msg.MarketDataType;
    }

    public boolean getIsDelayed() {
        return this.Msg.MarketDataType.contains(MarketDataType.Delayed);
    }

    public String toString() {
        return this.Msg.Description;
    }

    public static Exchange createUnavailable(String exchangeID) {
        MsgLoginResponse2.Exchange msg = new MsgLoginResponse2.Exchange();
        msg.ExchangeID = exchangeID;
        msg.Description = exchangeID + " " + Resource.localizeString("unavailable");
        msg.Disabled = true;
        msg.ContractType = ContractType.Unknown;
        msg.HasChartPermission = false;
        msg.HasPermission = false;
        return new Exchange(msg);
    }
}

