/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Resource;
import com.t4login.api.Exchange;
import com.t4login.api.MarketFormatter;
import com.t4login.api.TradeDate;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.TradingSchedule;
import com.t4login.messages.Message;
import com.t4login.messages.MsgContractDetails2;
import com.t4login.util.Range;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Contract
implements Comparable<Contract>,
Serializable {
    public static final String TAG = "Contract";
    public static final Contract Empty = new Contract(com.t4login.api.Exchange.Empty, new MsgContractDetails2());
    public Exchange Exchange;
    public MsgContractDetails2 Msg;
    private TradingSchedule _tradingSchedule;
    private transient TradeDate mTradeDate = null;
    private final String[] Prefixes = new String[]{"LV", "SIM", "DV", "D-30m", "D-12h", "D-1d", "D-2d", "D-3d", "D-4d", "D-5d"};

    private void writeObject(ObjectOutputStream aStream) throws IOException {
        aStream.writeObject(this.Exchange);
        Message.writeMessage(aStream, this.Msg);
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        this.Exchange = (Exchange)aStream.readObject();
        this.Msg = (MsgContractDetails2)Message.getMessage(aStream);
    }

    public Contract(Exchange exchg, MsgContractDetails2 msg) {
        this.Exchange = exchg;
        this.Msg = msg;
        this._tradingSchedule = TradingSchedule.fromPackedString(msg.TradingSchedule);
    }

    public boolean getDisabled() {
        return this.Msg.Disabled;
    }

    @Override
    public int compareTo(Contract o) {
        if (o == null) {
            return -1;
        }
        if (this == o) {
            return 0;
        }
        int ret = this.Exchange.compareTo(o.Exchange);
        if (ret == 0) {
            ret = this.Msg.Description.compareTo(o.Msg.Description);
        }
        return ret;
    }

    public String toString() {
        if (this.Msg != null) {
            return this.getDescription() + " (" + this.Msg.ContractID + ")";
        }
        return "";
    }

    public TradingSchedule getTradingSchedule() {
        return this._tradingSchedule;
    }

    public String getExchangeID() {
        return this.Msg.ExchangeID;
    }

    public String getContractID() {
        return this.Msg.ContractID;
    }

    public ContractType getContractType() {
        return this.Msg.ContractType;
    }

    public String getCurrency() {
        return this.Msg.Currency;
    }

    public Boolean getIsEventBased() {
        if (this.Msg != null && this.Msg.Details != null) {
            return this.Msg.Details.isEventBased;
        }
        return false;
    }

    public String getBaseDescription() {
        if (this.Msg != null) {
            return this.Msg.Description;
        }
        return "";
    }

    public String getDescription() {
        if (this.Msg != null) {
            return MarketFormatter.getFormattedContractDescription(this.Msg.ContractID, this.Msg.Description, this.Msg.ClearingCode, this.Exchange.getIsDelayed());
        }
        return "";
    }

    public synchronized NDateTime getTradeDate(NDateTime time) {
        if (this.mTradeDate == null) {
            this.mTradeDate = new TradeDate(this.Msg.DayChangeTime, this.Msg.DayChangeTimeExceptions);
        }
        return this.mTradeDate.getTradeDate(time);
    }

    public static Contract createUnavailable(Exchange exchg, String contractID) {
        MsgContractDetails2 msg = new MsgContractDetails2();
        msg.ExchangeID = exchg.getExchangeID();
        msg.ContractID = contractID;
        msg.ContractType = ContractType.Unknown;
        msg.Description = contractID + " " + Resource.localizeString("unavailable");
        msg.Disabled = true;
        return new Contract(exchg, msg);
    }

    public static String getUniqueID(String exchangeid, String contractid) {
        return exchangeid + "." + contractid;
    }

    public static String getUniqueID(Contract c) {
        return c.Msg.ExchangeID + "." + c.Msg.ContractID;
    }

    public static String contractIDToSafe(String contractID) {
        String safe = contractID.replaceAll(" ", "_SPACE_");
        safe = safe.replace(":", "_COLON_");
        safe = safe.replace("-", "_HYPHEN_");
        safe = safe.replace("=", "_EQUALS_");
        safe = safe.replace("/", "_FSLASH_");
        safe = safe.replace("\\\\", "_BSLASH_");
        return safe;
    }

    public static String safeToContractID(String safe) {
        String contractID = safe.replace("_SPACE_", " ");
        contractID = contractID.replace("_COLON_", ":");
        contractID = contractID.replace("_HYPHEN_", "-");
        contractID = contractID.replace("_EQUALS_", "=");
        contractID = contractID.replace("_FSLASH_", "/");
        contractID = contractID.replace("_BSLASH_", "\\");
        return contractID;
    }

    public List<Relation> getChartDataContractRelations(Range<NDateTime> dateRange) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        if (this.Msg.ContractType.equals(ContractType.Future)) {
            NDateTime tmpDate = new NDateTime(2100, 1, 1);
            for (MsgContractDetails2.Relation r : this.Msg.Relations) {
                if (this.Msg.ContractType != r.contractType || !r.endDate.isBefore(tmpDate) || r.priority >= 5 || !dateRange.contains(r.startDate) && !dateRange.contains(r.endDate)) continue;
                Relation relation = new Relation(r.exchangeID, r.contractID, Range.of(r.startDate, r.endDate));
                relations.add(relation);
            }
        }
        return relations;
    }

    public List<Relation> getOptionRelations() {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (MsgContractDetails2.Relation r : this.Msg.Relations) {
            if (r.contractType != ContractType.Option || r.priority < 5) continue;
            Relation relation = new Relation(r.exchangeID, r.contractID, Range.of(r.startDate, r.endDate));
            relations.add(relation);
        }
        return relations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contract contract = (Contract)o;
        return this.Msg.ExchangeID.equals(contract.Msg.ExchangeID) && this.Msg.ContractID.equals(contract.Msg.ContractID);
    }

    public int hashCode() {
        int result = this.Msg.ExchangeID.hashCode();
        result = 31 * result + this.Msg.ContractID.hashCode();
        return result;
    }

    public static class Relation {
        public final String ExchangeID;
        public final String ContractID;
        public final Range<NDateTime> ActiveDates;

        public Relation(String eid, String cid, Range<NDateTime> active) {
            this.ExchangeID = eid;
            this.ContractID = cid;
            this.ActiveDates = active;
        }
    }
}

