/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.api;

import com.t4login.Log;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.OrderType;
import com.t4login.definitions.StrategyType;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MsgMarketDetails;
import com.t4login.util.EncodingUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ClientMarketBuilder {
    private static final String TAG = "ClientMarketBuilder";
    private static final int EncodingVersion = 1;
    public String ExchangeID;
    public String ContractID;
    public String MarketID;
    public String Description;
    public int ExpiryDate;
    public ContractType ContractType;
    public StrategyType StrategyType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MsgMarketDetails createMsgMarketDetails(byte[] bytes) {
        MsgMarketDetails msg = new MsgMarketDetails(true);
        msg.ExchangeID = this.ExchangeID;
        msg.ContractID = this.ContractID;
        msg.MarketID = this.MarketID;
        msg.Description = this.Description;
        msg.ExpiryDate = this.ExpiryDate;
        msg.ContractType = this.ContractType;
        msg.StrategyType = this.StrategyType;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            msg.LastTradingDate = Message.readDateTime(in);
            msg.Numerator = EncodingUtil.decode7BitInt(in);
            msg.Denominator = EncodingUtil.decode7BitInt(in);
            msg.PriceCode = Message.readString(in);
            msg.VTT = Message.readString(in);
            msg.TickValue = Message.readDouble(in);
            msg.OrderTypes = OrderType.fromFlags(EncodingUtil.decode7BitInt(in));
            msg.VolumeIncrement = EncodingUtil.decode7BitInt(in);
            msg.Group = Message.readString(in);
            msg.Details = Message.readString(in);
            msg.RealDecimals = EncodingUtil.decode7BitInt(in);
            msg.ClearingDecimals = EncodingUtil.decode7BitInt(in);
            msg.MinCabPrice = EncodingUtil.decodePriceN(in);
            msg.StrikePrice = EncodingUtil.decodePriceN(in);
            msg.UnderlyingMarketID = Message.readString(in);
            msg.MinPriceIncrement = new Price(new BigDecimal(msg.Numerator).divide(new BigDecimal(msg.Denominator), 18, RoundingMode.HALF_EVEN));
            int nLegs = EncodingUtil.decode7BitInt(in);
            for (int i = 0; i < nLegs; ++i) {
                MsgMarketDetails.LegItem legItem = new MsgMarketDetails.LegItem();
                msg.Legs.add(legItem);
                EncodingUtil.decode7BitInt(in);
                legItem.MarketID = Message.readString(in);
                legItem.Volume = EncodingUtil.decode7BitInt(in);
                legItem.Delta = Message.readString(in);
                legItem.Price = Message.readString(in);
                legItem.Group = EncodingUtil.decode7BitInt(in);
            }
            if (in.available() <= 0) return msg;
        }
        catch (IOException ioex) {
            Log.e(TAG, "create(), Error.", ioex);
        }
        return msg;
    }
}

