/*
 * Decompiled with CFR 0.152.
 */
package com.t4login;

public class Log {
    public static Logger logger = new ConsoleLogger(false);
    private static LogLevel _level = LogLevel.Error;

    private Log() {
    }

    public static void setLogLevel(LogLevel level) {
        _level = level;
        logger.d("Log", String.format("setLogLevel(), Log level set to %s", new Object[]{_level}));
    }

    public static boolean debugMode() {
        if (logger != null) {
            return logger.debugMode();
        }
        return false;
    }

    public static void e(String tag, String msg) {
        if (logger != null && _level.isAtLeast(LogLevel.Error)) {
            logger.e(tag, msg);
        }
    }

    public static void e(String tag, String format, Object ... args) {
        if (logger != null && _level.isAtLeast(LogLevel.Error)) {
            String msg = String.format(format, args);
            logger.e(tag, msg);
        }
    }

    public static void e(String tag, String msg, Throwable tr) {
        if (logger != null && _level.isAtLeast(LogLevel.Error)) {
            logger.e(tag, msg, tr);
        }
    }

    public static void w(String tag, String msg) {
        if (logger != null && _level.isAtLeast(LogLevel.Warning)) {
            logger.w(tag, msg);
        }
    }

    public static void w(String tag, String format, Object ... args) {
        if (logger != null && _level.isAtLeast(LogLevel.Warning)) {
            String msg = String.format(format, args);
            logger.w(tag, msg);
        }
    }

    public static void w(String tag, String msg, Throwable tr) {
        if (logger != null && _level.isAtLeast(LogLevel.Warning)) {
            logger.w(tag, msg, tr);
        }
    }

    public static void d(String tag, String msg) {
        if (logger != null && _level.isAtLeast(LogLevel.Debug)) {
            logger.d(tag, msg);
        }
    }

    public static void d(String tag, String format, Object ... args) {
        if (logger != null && _level.isAtLeast(LogLevel.Debug)) {
            String msg = String.format(format, args);
            logger.d(tag, msg);
        }
    }

    public static void d(String tag, String msg, Throwable tr) {
        if (logger != null && _level.isAtLeast(LogLevel.Debug)) {
            logger.d(tag, msg, tr);
        }
    }

    public static void v(String tag, String msg) {
        if (logger != null && _level.isAtLeast(LogLevel.Verbose)) {
            logger.v(tag, msg);
        }
    }

    public static void v(String tag, String format, Object ... args) {
        if (logger != null && _level.isAtLeast(LogLevel.Verbose)) {
            String msg = String.format(format, args);
            logger.v(tag, msg);
        }
    }

    public static void v(String tag, String msg, Throwable tr) {
        if (logger != null && _level.isAtLeast(LogLevel.Verbose)) {
            logger.v(tag, msg, tr);
        }
    }

    public static enum LogLevel {
        Verbose(0, "Verbose"),
        Debug(1, "Debug"),
        Warning(2, "Warning"),
        Error(3, "Error"),
        Silent(4, "None");

        private final int _value;
        private final String _name;

        private LogLevel(int value, String name) {
            this._value = value;
            this._name = name;
        }

        public boolean isAtLeast(LogLevel level) {
            return level._value >= this._value;
        }

        public String toString() {
            return this._name;
        }
    }

    public static interface Logger {
        public boolean debugMode();

        public void e(String var1, String var2);

        public void e(String var1, String var2, Throwable var3);

        public void w(String var1, String var2);

        public void w(String var1, String var2, Throwable var3);

        public void d(String var1, String var2);

        public void d(String var1, String var2, Throwable var3);

        public void v(String var1, String var2);

        public void v(String var1, String var2, Throwable var3);
    }

    public static class ConsoleLogger
    implements Logger {
        private final boolean _debugMode;

        public ConsoleLogger(boolean debugMode) {
            this._debugMode = debugMode;
        }

        @Override
        public boolean debugMode() {
            return this._debugMode;
        }

        @Override
        public void e(String tag, String msg) {
            System.out.println("e [" + tag + "]: " + msg);
        }

        @Override
        public void e(String tag, String msg, Throwable tr) {
            System.out.println("e [" + tag + "]: " + msg + "; Error:" + String.valueOf(tr));
        }

        @Override
        public void w(String tag, String msg) {
            System.out.println("w [" + tag + "]: " + msg);
        }

        @Override
        public void w(String tag, String msg, Throwable tr) {
            System.out.println("w [" + tag + "]: " + msg + "; Error:" + String.valueOf(tr));
        }

        @Override
        public void d(String tag, String msg) {
            System.out.println("d [" + tag + "]: " + msg);
        }

        @Override
        public void d(String tag, String msg, Throwable tr) {
            System.out.println("d [" + tag + "]: " + msg + "; Error:" + String.valueOf(tr));
        }

        @Override
        public void v(String tag, String msg) {
            System.out.println("v [" + tag + "]: " + msg);
        }

        @Override
        public void v(String tag, String msg, Throwable tr) {
            System.out.println("v [" + tag + "]: " + msg + "; Error:" + String.valueOf(tr));
        }
    }
}

