/*
 * Decompiled with CFR 0.152.
 */
package com.t4login;

import com.t4login.Host;
import com.t4login.IHandler;
import com.t4login.IRemoteApi;
import com.t4login.Json;
import com.t4login.Log;
import com.t4login.MarketDataOptions;
import com.t4login.Resource;
import com.t4login.api.IAlertManager;
import com.t4login.api.IRecentLoginData;
import com.t4login.api.T4HostService;
import com.t4login.api.UserData;
import com.t4login.api.chartdata.request.IChartDataCacheManager;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.settings.DisplayTheme;
import com.t4login.connection.AndroidHostConnection;
import com.t4login.connection.ConnectionConfig;
import com.t4login.connection.IHostConnection;
import com.t4login.connection.ServerType;
import java.util.List;
import java.util.ResourceBundle;

public class JavaHost
implements Host.HostInterface {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("strings");
    private final String _applicationName;
    private final String _applicationLicense;
    private final String _applicationId;
    private final String _applicationVersion;
    private final String _osVersion;
    private final String _uniqueDeviceId;
    private final String _ipAddress;
    private final String _cacheDirectory;
    private final MarketDataOptions _marketDataOptions;
    private final boolean _debugMode;

    public JavaHost(String applicationName, String applicationLicense, String applicationId, String applicationVersion, String osVersion, String uniqueDeviceId, String ipAddress, String cacheDirectory, boolean debugMode) {
        this._applicationName = applicationName;
        this._applicationLicense = applicationLicense;
        this._applicationId = applicationId;
        this._applicationVersion = applicationVersion;
        this._osVersion = osVersion;
        this._uniqueDeviceId = uniqueDeviceId;
        this._ipAddress = ipAddress;
        this._cacheDirectory = cacheDirectory;
        this._marketDataOptions = MarketDataOptions.DEFAULT;
        this._debugMode = debugMode;
    }

    public JavaHost(String applicationName, String applicationLicense, String applicationId, String applicationVersion, String osVersion, String uniqueDeviceId, String ipAddress, String cacheDirectory, MarketDataOptions marketDataOptions, boolean debugMode) {
        this._applicationName = applicationName;
        this._applicationLicense = applicationLicense;
        this._applicationId = applicationId;
        this._applicationVersion = applicationVersion;
        this._osVersion = osVersion;
        this._uniqueDeviceId = uniqueDeviceId;
        this._ipAddress = ipAddress;
        this._cacheDirectory = cacheDirectory;
        this._marketDataOptions = marketDataOptions;
        this._debugMode = debugMode;
    }

    @Override
    public Resource.StringLocalizer getStringLocalizer() {
        return name -> resourceBundle.getString(name);
    }

    @Override
    public DisplayTheme getDisplayTheme() {
        return DisplayTheme.Auto;
    }

    @Override
    public boolean isDebugMode() {
        return this._debugMode;
    }

    @Override
    public String getApplicationName(ServerType serverType) {
        return this._applicationName;
    }

    @Override
    public String getApplicationLicense(ServerType serverType) {
        return this._applicationLicense;
    }

    @Override
    public String getApplicationID() {
        return this._applicationId;
    }

    @Override
    public String getApplicationVersion() {
        return this._applicationVersion;
    }

    @Override
    public String getAPIVersion() {
        return "4.7.71.18";
    }

    @Override
    public String getPlatformName() {
        return "Java";
    }

    @Override
    public String getOSVersion() {
        return this._osVersion;
    }

    @Override
    public int getSDKVersion() {
        return 0;
    }

    @Override
    public boolean getBatteryOptimizationEnabled() {
        return false;
    }

    @Override
    public String getUniqueDeviceID() {
        return this._uniqueDeviceId;
    }

    @Override
    public String getMessagingToken() {
        return "";
    }

    @Override
    public byte[] getMessagingPKey() {
        return new byte[0];
    }

    @Override
    public String getIPAddress(boolean b) {
        return this._ipAddress;
    }

    @Override
    public IHostConnection createConnection(String s, UserData userData, List<ConnectionConfig> list, IHostConnection.HostConnectionHandler hostConnectionHandler) {
        return new AndroidHostConnection(s, userData, list, hostConnectionHandler);
    }

    @Override
    public IHandler createHandler() {
        return runnable -> {
            Thread thread = new Thread(runnable);
            thread.start();
        };
    }

    @Override
    public IChartDataCacheManager createChartDataCacheManager(ServerType serverType) {
        return null;
    }

    @Override
    public IRecentLoginData createRecentLoginData() {
        return null;
    }

    @Override
    public IAlertManager createAlertManager(T4HostService t4HostService) {
        return null;
    }

    @Override
    public void saveLocalSettings(String s, String s1) {
    }

    @Override
    public String getLocalSavedSettings(String s) {
        return null;
    }

    @Override
    public MarketDataOptions getMarketDataOptions() {
        return this._marketDataOptions;
    }

    @Override
    public IRendererFactory getRendererFactory() {
        return null;
    }

    @Override
    public Log.Logger getLogger(boolean debugMode) {
        return new Log.ConsoleLogger(debugMode);
    }

    @Override
    public IRemoteApi getRemoteApi() {
        return null;
    }

    @Override
    public Json.JsonConverter getJsonConverter() {
        return null;
    }

    static {
        Resource.stringLocalizer = name -> resourceBundle.getString(name);
    }
}

