/*
 * Decompiled with CFR 0.152.
 */
package com.t4login;

import com.t4login.IHandler;
import com.t4login.IRemoteApi;
import com.t4login.Json;
import com.t4login.Log;
import com.t4login.MarketDataOptions;
import com.t4login.Resource;
import com.t4login.api.IAlertManager;
import com.t4login.api.IRecentLoginData;
import com.t4login.api.T4HostService;
import com.t4login.api.UserData;
import com.t4login.api.chartdata.request.IChartDataCacheManager;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.settings.DisplayTheme;
import com.t4login.connection.ConnectionConfig;
import com.t4login.connection.IHostConnection;
import com.t4login.connection.ServerType;
import java.util.List;

public class Host {
    private static HostInterface host = null;

    private Host() {
    }

    public static void registerHostInterface(HostInterface hostIface) {
        host = hostIface;
        Log.logger = host.getLogger(host.isDebugMode());
        Resource.stringLocalizer = host.getStringLocalizer();
        Json.jsonConverter = host.getJsonConverter();
    }

    public static IRemoteApi getRemoteApi() {
        if (host != null) {
            return host.getRemoteApi();
        }
        return null;
    }

    public static boolean useAggregatedChartData() {
        return false;
    }

    public static boolean isDebugMode() {
        if (host != null) {
            return host.isDebugMode();
        }
        return false;
    }

    public static String getApplicationName(ServerType serverType) {
        if (host != null) {
            return host.getApplicationName(serverType);
        }
        return "<host interface not registered>";
    }

    public static String getApplicationLicense(ServerType serverType) {
        if (host != null) {
            return host.getApplicationLicense(serverType);
        }
        return "<host interface not registered>";
    }

    public static String getApplicationID() {
        if (host != null) {
            return host.getApplicationID();
        }
        return "";
    }

    public static String getApplicationVersion() {
        if (host != null) {
            return host.getApplicationVersion();
        }
        return "<host interface not registered>";
    }

    public static String getAPIVersion() {
        if (host != null) {
            return host.getAPIVersion();
        }
        return "<host interface not registered>";
    }

    public static String getPlatformName() {
        if (host != null) {
            return host.getPlatformName();
        }
        return "<host interface not registered>";
    }

    public static String getOSVersion() {
        if (host != null) {
            return host.getOSVersion();
        }
        return "<host interface not registered>";
    }

    public static int getSDKVersion() {
        if (host != null) {
            return host.getSDKVersion();
        }
        return -1;
    }

    public static boolean getBatteryOptimizationEnabled() {
        if (host != null) {
            return host.getBatteryOptimizationEnabled();
        }
        return false;
    }

    public static String getUniqueDeviceID() {
        if (host != null) {
            return host.getUniqueDeviceID();
        }
        return "<host interface not registered>";
    }

    public static String getMessagingToken() {
        if (host != null) {
            return host.getMessagingToken();
        }
        return "<host interface not registered>";
    }

    public static byte[] getMessagingPKey() {
        if (host != null) {
            return host.getMessagingPKey();
        }
        return new byte[0];
    }

    public static String getIPAddress(boolean useIPv4) {
        if (host != null) {
            return host.getIPAddress(useIPv4);
        }
        return "<host interface not registered>";
    }

    public static IHostConnection createConnection(String description, UserData userData, List<ConnectionConfig> connections, IHostConnection.HostConnectionHandler hndlr) {
        if (host != null) {
            return host.createConnection(description, userData, connections, hndlr);
        }
        return null;
    }

    public static IHandler createHandler() {
        if (host != null) {
            return host.createHandler();
        }
        return null;
    }

    public static IChartDataCacheManager createChartDataCacheManager(ServerType serverType) {
        if (host != null) {
            return host.createChartDataCacheManager(serverType);
        }
        return null;
    }

    public static IRecentLoginData createRecentLoginData() {
        if (host != null) {
            return host.createRecentLoginData();
        }
        return null;
    }

    public static IAlertManager createAlertManager(T4HostService hostService) {
        if (host != null) {
            return host.createAlertManager(hostService);
        }
        return null;
    }

    public static void saveLocalSettings(String userIdentifier, String settingsXML) {
        if (host != null) {
            host.saveLocalSettings(userIdentifier, settingsXML);
        }
    }

    public static String getLocalSavedSettings(String userIdentifier) {
        if (host != null) {
            return host.getLocalSavedSettings(userIdentifier);
        }
        return null;
    }

    public static IRendererFactory getRendererFactory() {
        if (host != null) {
            return host.getRendererFactory();
        }
        return null;
    }

    public static DisplayTheme getDisplayTheme() {
        if (host != null) {
            return host.getDisplayTheme();
        }
        return DisplayTheme.Light;
    }

    public static MarketDataOptions getMarketDataOptions() {
        if (host != null) {
            return host.getMarketDataOptions();
        }
        return new MarketDataOptions(true, true, true);
    }

    public static interface HostInterface {
        public IRemoteApi getRemoteApi();

        public Json.JsonConverter getJsonConverter();

        public Resource.StringLocalizer getStringLocalizer();

        public Log.Logger getLogger(boolean var1);

        public IRendererFactory getRendererFactory();

        public DisplayTheme getDisplayTheme();

        public boolean isDebugMode();

        public String getApplicationName(ServerType var1);

        public String getApplicationLicense(ServerType var1);

        public String getApplicationID();

        public String getApplicationVersion();

        public String getAPIVersion();

        public String getPlatformName();

        public String getOSVersion();

        public int getSDKVersion();

        public boolean getBatteryOptimizationEnabled();

        public String getUniqueDeviceID();

        public String getMessagingToken();

        public byte[] getMessagingPKey();

        public String getIPAddress(boolean var1);

        public IHostConnection createConnection(String var1, UserData var2, List<ConnectionConfig> var3, IHostConnection.HostConnectionHandler var4);

        public IHandler createHandler();

        public IChartDataCacheManager createChartDataCacheManager(ServerType var1);

        public IRecentLoginData createRecentLoginData();

        public IAlertManager createAlertManager(T4HostService var1);

        public void saveLocalSettings(String var1, String var2);

        public String getLocalSavedSettings(String var1);

        public MarketDataOptions getMarketDataOptions();
    }
}

