/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.schedule;

import com.dxfeed.schedule.Session;
import com.dxfeed.schedule.SessionType;
import java.io.Serializable;

public class SessionFilter
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final SessionFilter ANY = new SessionFilter(null, null);
    public static final SessionFilter TRADING = new SessionFilter(null, true);
    public static final SessionFilter NON_TRADING = new SessionFilter(null, false);
    public static final SessionFilter NO_TRADING = new SessionFilter(SessionType.NO_TRADING, null);
    public static final SessionFilter PRE_MARKET = new SessionFilter(SessionType.PRE_MARKET, null);
    public static final SessionFilter REGULAR = new SessionFilter(SessionType.REGULAR, null);
    public static final SessionFilter AFTER_MARKET = new SessionFilter(SessionType.AFTER_MARKET, null);
    protected final SessionType type;
    protected final Boolean trading;

    public SessionFilter(SessionType type, Boolean trading) {
        this.type = type;
        this.trading = trading;
    }

    public boolean accept(Session session) {
        return !(this.type != null && this.type != session.getType() || this.trading != null && this.trading.booleanValue() != session.isTrading());
    }

    public int hashCode() {
        return (this.type == null ? 0 : this.type.hashCode()) + (this.trading == null ? 0 : this.trading.hashCode());
    }

    public boolean equals(Object object) {
        if (!(object instanceof SessionFilter)) {
            return false;
        }
        SessionFilter filter = (SessionFilter)object;
        return this.type == filter.type && this.trading == filter.trading;
    }

    public String toString() {
        return "SessionFilter(" + (Object)((Object)this.type) + ", " + this.trading + ")";
    }
}

