/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.schedule;

import com.dxfeed.schedule.Day;
import com.dxfeed.schedule.SessionFilter;
import com.dxfeed.schedule.SessionType;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.NoSuchElementException;

public final class Session {
    private final Day day;
    private final SessionType type;
    private final long startTime;
    private final long endTime;

    Session(Day day, SessionType type, long startTime, long endTime) {
        this.day = day;
        this.type = type;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Day getDay() {
        return this.day;
    }

    public SessionType getType() {
        return this.type;
    }

    public boolean isTrading() {
        return this.type.isTrading();
    }

    public boolean isEmpty() {
        return this.startTime >= this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean containsTime(long time) {
        return time >= this.startTime && time < this.endTime;
    }

    public Session getPrevSession(SessionFilter filter) {
        Session session = this.findPrevSession(filter);
        if (session != null) {
            return session;
        }
        throw new NoSuchElementException("could not find prev session before " + this.day.getYearMonthDay() + " for " + filter);
    }

    public Session getNextSession(SessionFilter filter) {
        Session session = this.findNextSession(filter);
        if (session != null) {
            return session;
        }
        throw new NoSuchElementException("could not find next session after " + this.day.getYearMonthDay() + " for " + filter);
    }

    public Session findPrevSession(SessionFilter filter) {
        List<Session> sessions = this.day.getSessions();
        int i = sessions.size();
        while (--i >= 0) {
            if (sessions.get(i) != this) continue;
            while (--i >= 0) {
                if (!filter.accept(sessions.get(i))) continue;
                return sessions.get(i);
            }
            break block0;
        }
        for (int k = 1; k <= 366; ++k) {
            sessions = this.day.getSchedule().getDayById(this.day.getDayId() - k).getSessions();
            int i2 = sessions.size();
            while (--i2 >= 0) {
                if (!filter.accept(sessions.get(i2))) continue;
                return sessions.get(i2);
            }
        }
        return null;
    }

    public Session findNextSession(SessionFilter filter) {
        List<Session> sessions = this.day.getSessions();
        int n = sessions.size();
        for (int i = 0; i < n; ++i) {
            if (sessions.get(i) != this) continue;
            while (++i < n) {
                if (!filter.accept(sessions.get(i))) continue;
                return sessions.get(i);
            }
            break;
        }
        for (int k = 1; k <= 366; ++k) {
            sessions = this.day.getSchedule().getDayById(this.day.getDayId() + k).getSessions();
            int n2 = sessions.size();
            for (int i = 0; i < n2; ++i) {
                if (!filter.accept(sessions.get(i))) continue;
                return sessions.get(i);
            }
        }
        return null;
    }

    public int hashCode() {
        return this.day.hashCode() + this.type.hashCode() + (int)this.startTime + (int)this.endTime;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Session)) {
            return false;
        }
        Session session = (Session)object;
        return this.day.equals(session.day) && this.type == session.type && this.startTime == session.startTime && this.endTime == session.endTime;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "Session(" + this.day.getYearMonthDay() + ", " + (Object)((Object)this.type) + ", " + this.isTrading() + ", " + sdf.format(this.startTime) + ", " + sdf.format(this.endTime) + ")";
    }
}

