/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.schedule;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.StreamCompression;
import com.devexperts.io.URLInputStream;
import com.devexperts.logging.Logging;
import com.devexperts.util.DayUtil;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.LogUtil;
import com.devexperts.util.LongHashMap;
import com.devexperts.util.LongHashSet;
import com.devexperts.util.LongIterator;
import com.devexperts.util.MathUtil;
import com.devexperts.util.QuickSort;
import com.devexperts.util.SynchronizedIndexedSet;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimePeriod;
import com.devexperts.util.TimeUtil;
import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.schedule.Day;
import com.dxfeed.schedule.Session;
import com.dxfeed.schedule.SessionFilter;
import com.dxfeed.schedule.SessionType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Schedule {
    private static final Logging log = Logging.getLogging(Schedule.class);
    private static final String CACHE_LIMIT_PROPERTY = "com.dxfeed.schedule.cache";
    private static final String DOWNLOAD_PROPERTY = "com.dxfeed.schedule.download";
    private static final String DOWNLOAD_AUTO = "http://downloads.dxfeed.com/schedule/schedule.zip,1d";
    private static final Pattern VENUE_PATTERN = Pattern.compile("(\\w*)\\([^()]*\\)");
    private static String downloadURL;
    private static long downloadPeriod;
    private static Thread downloadThread;
    private static final int CACHE_LIMIT;
    private static final int CACHE_RETAIN;
    private static final long DAY_LENGTH = 86400000L;
    private static final int MIN_YMD = 10103;
    private static final int MAX_YMD = 99991229;
    private static final int MIN_ID;
    private static final int MAX_ID;
    private static final long MIN_TIME;
    private static final long MAX_TIME;
    private static final Comparator<Day> USAGE_COMPARATOR;
    private static final Pattern STRATEGY_PATTERN;
    private static final Pattern SDS_EC_PATTERN;
    private static final Pattern HDS_JNTD_PATTERN;
    final String def;
    private String name;
    private Calendar calendar;
    private long rawOffset;
    private long dayOffset;
    private LongHashSet holidays;
    private LongHashSet shortdays;
    private long earlyClose;
    private int joinNextTradingDay;
    private DayDef[] weekDays;
    private LongHashMap<DayDef> specialDays;
    private final Object lock = new Object();
    private final IndexedSet<Integer, Day> idCache = IndexedSet.createInt(Day::getDayId);
    private final IndexedSet<Integer, Day> ymdCache = IndexedSet.createInt(Day::getYearMonthDay);
    private final AtomicLong creationCounter = new AtomicLong();
    private final AtomicLong usageCounter = new AtomicLong();
    private static final LongHashSet EMPTY_SET;
    private static final LongHashMap<DayDef> EMPTY_MAP;
    private static volatile Defaults DEFAULTS;
    private static final SynchronizedIndexedSet<String, Schedule> SCHEDULES;

    public static Schedule getInstance(InstrumentProfile profile) {
        return Schedule.getInstance(profile.getTradingHours());
    }

    public static Schedule getInstance(String scheduleDefinition) {
        int open = scheduleDefinition.indexOf(40, 0);
        int close = scheduleDefinition.indexOf(41, open + 1);
        if (open < 0 || close < 0) {
            throw new IllegalArgumentException("broken schedule " + scheduleDefinition);
        }
        int start = Math.max(scheduleDefinition.lastIndexOf(41, open - 1), scheduleDefinition.lastIndexOf(59, open - 1)) + 1;
        return Schedule.getSchedule(scheduleDefinition.substring(start, close + 1));
    }

    public static Schedule getInstance(InstrumentProfile profile, String venue) {
        String hours = profile.getTradingHours();
        int open = -1;
        while ((open = hours.indexOf(40, open + 1)) >= 0) {
            int close = hours.indexOf(41, open + 1);
            if (close < 0) {
                throw new IllegalArgumentException("broken schedule " + hours);
            }
            int start = Math.max(hours.lastIndexOf(41, open - 1), hours.lastIndexOf(59, open - 1)) + 1;
            if (open - start != venue.length() || !hours.regionMatches(start, venue, 0, venue.length())) continue;
            return Schedule.getSchedule(hours.substring(start, close + 1));
        }
        throw new NoSuchElementException("could not find schedule for trading venue " + venue + " in " + hours);
    }

    public static List<String> getTradingVenues(InstrumentProfile profile) {
        ArrayList<String> venues = new ArrayList<String>();
        Matcher m = VENUE_PATTERN.matcher(profile.getTradingHours());
        while (m.find()) {
            venues.add(m.group(1));
        }
        return venues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadDefaults(String downloadConfig) {
        if (downloadConfig == null) {
            downloadConfig = "";
        }
        if ((downloadConfig = downloadConfig.trim()).equalsIgnoreCase("auto")) {
            downloadConfig = DOWNLOAD_AUTO;
        }
        String[] config = downloadConfig.split(",");
        Class<Schedule> clazz = Schedule.class;
        synchronized (Schedule.class) {
            downloadURL = config[0].trim().length() > 0 ? config[0].trim() : null;
            downloadPeriod = config.length >= 2 ? Math.max(TimePeriod.valueOf(config[1]).getTime(), 0L) : 0L;
            LockSupport.unpark(downloadThread);
            if (downloadPeriod > 0L) {
                downloadThread = new Thread(Schedule::runDownload, "ScheduleDownloader");
                downloadThread.setDaemon(true);
                downloadThread.start();
            } else {
                downloadThread = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Schedule.doDownload();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void runDownload() {
        long next = 0L;
        while (true) {
            try {
                while (true) {
                    long time = System.currentTimeMillis();
                    Class<Schedule> clazz = Schedule.class;
                    // MONITORENTER : com.dxfeed.schedule.Schedule.class
                    if (downloadURL == null || downloadPeriod == 0L || downloadThread != Thread.currentThread()) {
                        // MONITOREXIT : clazz
                        return;
                    }
                    long newNext = time + (long)((double)downloadPeriod * (0.95 + 0.1 * Math.random()));
                    // MONITOREXIT : clazz
                    if (next == 0L) {
                        next = newNext;
                    }
                    if (time < next) {
                        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(next - time));
                        continue;
                    }
                    next = newNext;
                    Schedule.doDownload();
                }
            }
            catch (Throwable t) {
                log.error("Unexpected error", t);
                continue;
            }
            break;
        }
    }

    private static void doDownload() {
        byte[] data;
        String url = downloadURL;
        if (url == null) {
            return;
        }
        try {
            data = URLInputStream.readBytes(url);
        }
        catch (Throwable t) {
            log.error("Failed to download schedule defaults from " + LogUtil.hideCredentials(url), t);
            return;
        }
        try (InputStream in = StreamCompression.detectCompressionByHeaderAndDecompress(new ByteArrayInput(data));){
            String result = Schedule.setDefaults(in);
            log.info("Downloaded schedule defaults from " + LogUtil.hideCredentials(url) + " - they are " + result);
        }
        catch (Throwable t) {
            log.error("Unexpected error", t);
        }
    }

    public static void setDefaults(byte[] data) throws IOException {
        try (InputStream in = StreamCompression.detectCompressionByHeaderAndDecompress(new ByteArrayInput(data));){
            Schedule.setDefaults(in);
        }
    }

    public Session getSessionByTime(long time) {
        return this.getDayByTime(time).getSessionByTime(time);
    }

    public Day getDayByTime(long time) {
        Schedule.checkRange("time", time, MIN_TIME, MAX_TIME);
        this.usageCounter.incrementAndGet();
        Day d = this.getDay((int)MathUtil.div(time + this.rawOffset - this.dayOffset, 86400000L));
        while (d.getStartTime() > time) {
            d = this.getDay(d.getDayId() - 1);
        }
        while (d.getEndTime() <= time) {
            d = this.getDay(d.getDayId() + 1);
        }
        return d;
    }

    public Day getDayById(int dayId) {
        Schedule.checkRange("dayId", dayId, MIN_ID, MAX_ID);
        this.usageCounter.incrementAndGet();
        return this.getDay(dayId);
    }

    public Day getDayByYearMonthDay(int yearMonthDay) {
        Schedule.checkRange("yearMonthDay", yearMonthDay, 10103L, 99991229L);
        this.usageCounter.incrementAndGet();
        Day d = this.ymdCache.getByKey(yearMonthDay);
        if (d != null) {
            d.usageCounter = this.usageCounter.get();
            return d;
        }
        int year = yearMonthDay / 10000;
        int month = yearMonthDay / 100 % 100;
        int day = yearMonthDay % 100;
        if (day > 31) {
            ++month;
            day = 1;
        } else if (day < 1) {
            day = 1;
        }
        if (month > 12) {
            ++year;
            day = 1;
            month = 1;
        } else if (month < 1) {
            day = 1;
            month = 1;
        }
        d = this.ymdCache.getByKey(year * 10000 + month * 100 + day);
        if (d != null) {
            d.usageCounter = this.usageCounter.get();
            return d;
        }
        d = this.getDay(DayUtil.getDayIdByYearMonthDay(year, month, day));
        while (d.getYearMonthDay() > yearMonthDay) {
            d = this.getDay(d.getDayId() - 1);
        }
        while (d.getYearMonthDay() < yearMonthDay) {
            d = this.getDay(d.getDayId() + 1);
        }
        return d;
    }

    public Session getNearestSessionByTime(long time, SessionFilter filter) {
        Session session = this.findNearestSessionByTime(time, filter);
        if (session != null) {
            return session;
        }
        throw new NoSuchElementException("could not find session nearest to " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(time) + " for " + filter);
    }

    public Session findNearestSessionByTime(long time, SessionFilter filter) {
        Session session = this.getSessionByTime(time);
        if (filter.accept(session)) {
            return session;
        }
        Session prev = session.findPrevSession(filter);
        Session next = session.findNextSession(filter);
        if (prev == null) {
            return next;
        }
        if (next == null) {
            return prev;
        }
        return time - prev.getEndTime() < next.getStartTime() - time ? prev : next;
    }

    public String getName() {
        return this.name;
    }

    public String getDefinition() {
        return this.def;
    }

    public TimeZone getTimeZone() {
        return (TimeZone)this.calendar.getTimeZone().clone();
    }

    public String toString() {
        return "Schedule{" + this.def + "}";
    }

    private static void checkRange(String name, long value, long min, long max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("specified " + name + " falls outside of valid date range (from 0001-01-02 to 9999-12-30): " + value);
        }
    }

    static int dayOfWeek(int dayId) {
        return (dayId % 7 + 10) % 7 + 1;
    }

    private static Matcher getStrategy(String def, Map<String, String> props, String key, String name, Pattern pattern) {
        String value = props.get(key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        Matcher m = STRATEGY_PATTERN.matcher(value);
        if (m.matches()) {
            if (!m.group(1).equals(name)) {
                log.warn("Unknown " + key + " strategy " + m.group(1) + " for " + def);
                return null;
            }
            Matcher result = pattern.matcher(value);
            if (result.matches()) {
                return result;
            }
        }
        throw new IllegalArgumentException("broken " + key + " strategy for " + def);
    }

    private Schedule(String def) {
        this(def, DEFAULTS);
    }

    private Schedule(String def, Defaults defaults) {
        if (!VENUE_PATTERN.matcher(def).matches()) {
            throw new IllegalArgumentException("broken schedule " + def);
        }
        this.def = def;
        this.init(defaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Defaults defaults) {
        int i;
        String de;
        TimeZone timeZone;
        String tz;
        String venue = this.def.substring(0, this.def.indexOf(40));
        HashMap<String, String> props = new HashMap<String, String>();
        if (defaults.venues.containsKey(venue)) {
            props.putAll(defaults.venues.get(venue));
        }
        props.putAll(Schedule.readProps(this.def.substring(this.def.indexOf(40) + 1, this.def.length() - 1)));
        String name = (String)props.get("name");
        if (name == null) {
            name = venue;
        }
        if ((tz = (String)props.get("tz")) == null || tz.isEmpty()) {
            throw new IllegalArgumentException("missing time zone for " + this.def);
        }
        try {
            timeZone = TimeUtil.getTimeZone(tz);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("unknown time zone for " + this.def + ": " + tz);
        }
        LongHashSet holidays = Schedule.readDays("holiday", defaults.holidays, (String)props.get("hd"));
        LongHashSet shortdays = Schedule.readDays("short", defaults.shortdays, (String)props.get("sd"));
        Matcher ec = Schedule.getStrategy(this.def, props, "sds", "ec", SDS_EC_PATTERN);
        long earlyClose = ec == null ? 0L : new TimeDef(this.def, ec.group(1)).offset();
        Matcher jntd = Schedule.getStrategy(this.def, props, "hds", "jntd", HDS_JNTD_PATTERN);
        int joinNextTradingDay = jntd == null ? 0 : Integer.parseInt(jntd.group(1));
        String td = (String)props.get("td");
        if (td == null) {
            td = "12345";
        }
        if ((de = (String)props.get("de")) == null) {
            de = "+0000";
        }
        String rt = (String)props.get("rt");
        TimeDef dayEnd = new TimeDef(this.def, de);
        TimeDef dayStart = new TimeDef(dayEnd, -1);
        TimeDef resetTime = rt == null ? null : new TimeDef(this.def, rt);
        DayDef[] weekDays = new DayDef[9];
        for (i = 0; i <= 8; ++i) {
            String s = (String)props.get(String.valueOf(i));
            if (s == null) continue;
            weekDays[i] = new DayDef(this.def, dayStart, dayEnd, resetTime, s);
        }
        if (weekDays[8] == null) {
            DayDef d0 = weekDays[0];
            weekDays[8] = d0 == null ? new DayDef(this.def, dayStart, dayEnd, resetTime, "") : new DayDef(this.def, d0.dayStart, d0.dayEnd, d0.resetTime, "");
        }
        for (i = 1; i <= 7; ++i) {
            if (weekDays[i] != null || (weekDays[i] = weekDays[td.indexOf(48 + i) >= 0 ? 0 : 8]) != null) continue;
            throw new IllegalArgumentException("incomplete schedule for " + this.def);
        }
        LongHashMap<Object> specialDays = new LongHashMap();
        for (Map.Entry e : props.entrySet()) {
            if (((String)e.getKey()).length() != 8 || !((String)e.getKey()).matches("\\d{8}")) continue;
            specialDays.put(Integer.parseInt((String)e.getKey()), (Object)new DayDef(this.def, dayStart, dayEnd, resetTime, (String)e.getValue()));
        }
        if (specialDays.isEmpty()) {
            specialDays = EMPTY_MAP;
        }
        Object object = this.lock;
        synchronized (object) {
            this.name = name;
            this.calendar = Calendar.getInstance(timeZone);
            this.rawOffset = this.calendar.getTimeZone().getRawOffset();
            this.dayOffset = dayStart.offset();
            this.holidays = holidays;
            this.shortdays = shortdays;
            this.earlyClose = earlyClose;
            this.joinNextTradingDay = joinNextTradingDay;
            this.weekDays = weekDays;
            this.specialDays = specialDays;
            this.idCache.clear();
            this.ymdCache.clear();
            this.checkEarlyClose();
        }
    }

    private void checkEarlyClose() {
        if (this.earlyClose == 0L) {
            return;
        }
        LongIterator it = this.shortdays.longIterator();
        while (it.hasNext()) {
            long sd = it.nextLong();
            if (this.holidays.contains(sd) || !this.isTooShortForEarlyClose((int)sd)) continue;
            return;
        }
    }

    private boolean isTooShortForEarlyClose(int yearMonthDay) {
        long time;
        SessionDef session;
        int dayId = DayUtil.getDayIdByYearMonthDay(yearMonthDay);
        DayDef dayDef = this.getDayDef(dayId, yearMonthDay);
        int lastRegular = Schedule.getLastRegularSessionIndex(dayDef);
        if (lastRegular < dayDef.sessions.length && (session = dayDef.sessions[lastRegular]).isTooShort(this.calendar, time = this.getTimeByDayId(dayId), this.earlyClose)) {
            log.warn("Last regular session of short day " + yearMonthDay + " in " + this.def + " is too short for early close strategy. Day won't be shortened.");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Day getDay(int dayId) {
        Day day = this.idCache.getByKey(dayId);
        if (day == null) {
            Object object = this.lock;
            synchronized (object) {
                day = this.idCache.getByKey(dayId);
                if (day == null) {
                    this.checkCacheSize();
                    day = this.createDay(dayId);
                    this.idCache.put(day);
                    this.ymdCache.put(day);
                }
            }
        }
        day.usageCounter = this.usageCounter.get();
        return day;
    }

    private void checkCacheSize() {
        if (this.idCache.size() < CACHE_LIMIT) {
            return;
        }
        Day[] days = this.idCache.toArray(new Day[this.idCache.size()]);
        QuickSort.sort(days, USAGE_COMPARATOR);
        int i = days.length - CACHE_RETAIN;
        while (--i >= 0) {
            this.idCache.removeKey(days[i].getDayId());
            this.ymdCache.removeKey(days[i].getYearMonthDay());
        }
    }

    private long getTimeByDayId(int dayId) {
        return (long)dayId * 86400000L - this.rawOffset + 43200000L;
    }

    private void addTradingDaySessions(Day day, DayDef def, long time, boolean shortday, List<Session> sessions) {
        SessionDef session;
        int lastRegular;
        int n = lastRegular = shortday && this.earlyClose != 0L ? Schedule.getLastRegularSessionIndex(def) : def.sessions.length;
        if (lastRegular < def.sessions.length && (session = def.sessions[lastRegular]).isTooShort(this.calendar, time, this.earlyClose)) {
            lastRegular = def.sessions.length;
        }
        long shift = -this.earlyClose;
        for (int i = 0; i < def.sessions.length; ++i) {
            SessionDef session2 = def.sessions[i];
            if (i < lastRegular) {
                sessions.add(session2.create(day, this.calendar, time, 0L, 0L));
                continue;
            }
            if (i == lastRegular) {
                sessions.add(session2.create(day, this.calendar, time, 0L, shift));
                continue;
            }
            if (i < def.sessions.length - 1) {
                sessions.add(session2.create(day, this.calendar, time, shift, shift));
                continue;
            }
            sessions.add(session2.create(day, this.calendar, time, shift, 0L));
        }
        if (lastRegular == def.sessions.length - 1) {
            long endTime = sessions.get(sessions.size() - 1).getEndTime();
            sessions.add(new Session(day, SessionType.NO_TRADING, endTime, endTime - shift));
        }
    }

    private int getEarliestTradingHolidayOffset(int dayId, int maxOffset) {
        int earliestOffset = -1;
        for (int offset = 1; offset <= maxOffset; ++offset) {
            int yearMonthDay = DayUtil.getYearMonthDayByDayId(dayId - offset);
            boolean isHoliday = this.holidays.contains(yearMonthDay);
            boolean isTrading = this.getDayDef(dayId - offset, yearMonthDay).isTrading();
            if (!isHoliday && isTrading) {
                return earliestOffset;
            }
            if (!isHoliday || !isTrading) continue;
            earliestOffset = offset;
        }
        return earliestOffset;
    }

    private int getNextTradingDayOffset(int dayId, int maxOffset) {
        for (int offset = 0; offset <= maxOffset; ++offset) {
            int yearMonthDay = DayUtil.getYearMonthDayByDayId(dayId + offset);
            if (this.holidays.contains(yearMonthDay) || !this.getDayDef(dayId + offset, yearMonthDay).isTrading()) continue;
            return offset;
        }
        return -1;
    }

    private DayDef getDayDef(int dayId, int yearMonthDay) {
        DayDef dayDef = this.specialDays.get(yearMonthDay);
        if (dayDef == null) {
            dayDef = this.weekDays[Schedule.dayOfWeek(dayId)];
        }
        return dayDef;
    }

    private void createJntdDays(int startDayId, int endDayId) {
        int startYearMonthDay = DayUtil.getYearMonthDayByDayId(startDayId);
        int endYearMonthDay = DayUtil.getYearMonthDayByDayId(endDayId);
        DayDef startDef = this.getDayDef(startDayId, startYearMonthDay);
        DayDef endDef = this.getDayDef(endDayId, endYearMonthDay);
        long startTime = startDef.dayStart.get(this.calendar, this.getTimeByDayId(startDayId));
        for (int dayId = startDayId; dayId < endDayId; ++dayId) {
            int yearMonthDay = DayUtil.getYearMonthDayByDayId(dayId);
            Day day = new Day(this, dayId, yearMonthDay, this.holidays.contains(yearMonthDay), this.shortdays.contains(yearMonthDay), startTime);
            day.setSessions(Collections.singletonList(new Session(day, SessionType.NO_TRADING, startTime, startTime)));
            this.idCache.put(day);
            this.ymdCache.put(day);
        }
        boolean isShortday = this.shortdays.contains(endYearMonthDay);
        long resetTime = startDef.resetTime.get(this.calendar, this.getTimeByDayId(startDayId));
        Day endDay = new Day(this, endDayId, endYearMonthDay, false, isShortday, resetTime);
        ArrayList<Session> sessions = new ArrayList<Session>();
        this.addTradingDaySessions(endDay, startDef, this.getTimeByDayId(startDayId), false, sessions);
        for (int dayId = startDayId + 1; dayId < endDayId; ++dayId) {
            DayDef dayDef = this.getDayDef(dayId, DayUtil.getYearMonthDayByDayId(dayId));
            long time = this.getTimeByDayId(dayId);
            sessions.add(new Session(endDay, SessionType.NO_TRADING, dayDef.dayStart.get(this.calendar, time), dayDef.dayEnd.get(this.calendar, time)));
        }
        this.addTradingDaySessions(endDay, endDef, this.getTimeByDayId(endDayId), isShortday, sessions);
        sessions.trimToSize();
        endDay.setSessions(Collections.unmodifiableList(sessions));
        this.idCache.put(endDay);
        this.ymdCache.put(endDay);
    }

    private Day createDay(int dayId) {
        int endDayId;
        int earliestOffset;
        int tradingOffset;
        this.creationCounter.incrementAndGet();
        if (this.joinNextTradingDay != 0 && (tradingOffset = this.getNextTradingDayOffset(dayId, this.joinNextTradingDay)) >= 0 && (earliestOffset = this.getEarliestTradingHolidayOffset(endDayId = dayId + tradingOffset, this.joinNextTradingDay)) >= tradingOffset) {
            this.createJntdDays(endDayId - earliestOffset, endDayId);
            return this.idCache.getByKey(dayId);
        }
        long time = this.getTimeByDayId(dayId);
        int yearMonthDay = DayUtil.getYearMonthDayByDayId(dayId);
        boolean isHoliday = this.holidays.contains(yearMonthDay);
        boolean isShortDay = this.shortdays.contains(yearMonthDay);
        DayDef dayDef = this.getDayDef(dayId, yearMonthDay);
        Day day = new Day(this, dayId, yearMonthDay, isHoliday, isShortDay, dayDef.resetTime.get(this.calendar, time));
        if (isHoliday) {
            day.setSessions(Collections.singletonList(new Session(day, SessionType.NO_TRADING, dayDef.dayStart.get(this.calendar, time), dayDef.dayEnd.get(this.calendar, time))));
        } else {
            ArrayList<Session> sessions = new ArrayList<Session>();
            this.addTradingDaySessions(day, dayDef, time, isShortDay, sessions);
            sessions.trimToSize();
            day.setSessions(Collections.unmodifiableList(sessions));
        }
        return day;
    }

    private static int getLastRegularSessionIndex(DayDef def) {
        for (int i = def.sessions.length - 1; i >= 0; --i) {
            if (def.sessions[i].type != SessionType.REGULAR) continue;
            return i;
        }
        return def.sessions.length;
    }

    private static Schedule getSchedule(String def) {
        Schedule schedule = (Schedule)SCHEDULES.getByKey(def);
        if (schedule == null) {
            schedule = SCHEDULES.putIfAbsentAndGet(new Schedule(def));
        }
        return schedule;
    }

    private static String setDefaults(InputStream in) throws IOException {
        Object line;
        Defaults newDef = new Defaults();
        BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            while (((String)line).endsWith("\\")) {
                line = ((String)line).substring(0, ((String)line).length() - 1);
                String nextLine = br.readLine();
                if (nextLine == null) break;
                line = (String)line + nextLine;
            }
            if (((String)line).startsWith("date=")) {
                newDef.date = TimeFormat.GMT.parse(((String)line).substring("date=".length())).getTime();
                continue;
            }
            int dot = ((String)line).indexOf(46);
            int eq = ((String)line).indexOf(61);
            if (((String)line).isEmpty() || ((String)line).startsWith("#") || dot <= 0 || eq <= 0 || dot > eq) continue;
            String key = ((String)line).substring(0, eq);
            String subkey = key.substring(dot + 1);
            String value = ((String)line).substring(eq + 1);
            if (key.startsWith("hd.")) {
                if (newDef.holidays.put(subkey, Schedule.readDays("holiday", newDef.holidays, value)) == null) continue;
                throw new IllegalArgumentException("duplicate holiday list " + (String)line);
            }
            if (key.startsWith("sd.")) {
                if (newDef.shortdays.put(subkey, Schedule.readDays("short", newDef.shortdays, value)) == null) continue;
                throw new IllegalArgumentException("duplicate short day list " + (String)line);
            }
            if (!key.startsWith("tv.") || newDef.venues.put(subkey, Schedule.readProps(value)) == null) continue;
            throw new IllegalArgumentException("duplicate venue " + (String)line);
        }
        for (String venue : newDef.venues.keySet()) {
            new Schedule(venue + "(0=)", newDef);
        }
        Defaults oldDef = DEFAULTS;
        if (newDef.date < oldDef.date) {
            return "older than current - ignored";
        }
        DEFAULTS = newDef;
        if (newDef.holidays.equals(oldDef.holidays) && newDef.shortdays.equals(oldDef.shortdays) && newDef.venues.equals(oldDef.venues)) {
            return "identical to current";
        }
        for (Schedule schedule : SCHEDULES) {
            try {
                schedule.init(newDef);
            }
            catch (Throwable t) {
                log.error("Unexpected error", t);
            }
        }
        return "newer than current - applied";
    }

    private static LongHashSet readDays(String dayType, Map<String, LongHashSet> refs, String list) {
        if (list == null || list.isEmpty()) {
            return EMPTY_SET;
        }
        LongHashSet days = new LongHashSet();
        AbstractSet ref = null;
        for (String s : list.split(",")) {
            if (s.isEmpty()) continue;
            boolean minus = s.startsWith("-");
            boolean intersect = s.startsWith("*");
            if (minus || intersect) {
                s = s.substring(1);
            }
            if ((ref = refs.get(s)) == null) {
                try {
                    int d = Integer.parseInt(s);
                    if (minus) {
                        days.remove(d);
                        continue;
                    }
                    if (intersect) {
                        days.removeIf(day -> day != (long)d);
                        continue;
                    }
                    days.add(d);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("cannot find " + dayType + " day list " + s + " when parsing " + list);
                }
            }
            if (minus) {
                days.removeAll(ref);
                continue;
            }
            if (intersect) {
                days.retainAll(ref);
                continue;
            }
            days.addAll(ref);
        }
        if (days.isEmpty()) {
            return EMPTY_SET;
        }
        if (ref != null && ref.equals(days)) {
            return ref;
        }
        return days;
    }

    private static Map<String, String> readProps(String props) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String s : props.split(";")) {
            String[] ss = s.split("=", -1);
            for (int i = 0; i < ss.length - 1; ++i) {
                m.put(ss[i], ss[ss.length - 1]);
            }
        }
        return m;
    }

    static {
        CACHE_LIMIT = SystemProperties.getIntProperty(CACHE_LIMIT_PROPERTY, 25000, 100, 100000);
        CACHE_RETAIN = CACHE_LIMIT - CACHE_LIMIT / 4;
        MIN_ID = DayUtil.getDayIdByYearMonthDay(1, 1, 3);
        MAX_ID = DayUtil.getDayIdByYearMonthDay(9999, 12, 29);
        MIN_TIME = (long)MIN_ID * 86400000L;
        MAX_TIME = (long)MAX_ID * 86400000L + 86400000L;
        USAGE_COMPARATOR = (d1, d2) -> Long.compare(d1.usageCounter, d2.usageCounter);
        STRATEGY_PATTERN = Pattern.compile("([a-zA-Z_]+)([^a-zA-Z_].*)?");
        SDS_EC_PATTERN = Pattern.compile("ec([0-9]{4})");
        HDS_JNTD_PATTERN = Pattern.compile("jntd([0-9])");
        EMPTY_SET = new LongHashSet();
        EMPTY_MAP = new LongHashMap();
        DEFAULTS = new Defaults();
        SCHEDULES = SynchronizedIndexedSet.create(schedule -> schedule.def);
        try (InputStream in = Schedule.class.getResourceAsStream("schedule.properties");){
            if (in != null) {
                Schedule.setDefaults(in);
            }
        }
        catch (Throwable t) {
            log.error("Unexpected error", t);
        }
        Schedule.downloadDefaults(SystemProperties.getProperty(DOWNLOAD_PROPERTY, null));
    }

    private static class Defaults {
        long date;
        final Map<String, LongHashSet> holidays = new HashMap<String, LongHashSet>();
        final Map<String, LongHashSet> shortdays = new HashMap<String, LongHashSet>();
        final Map<String, Map<String, String>> venues = new HashMap<String, Map<String, String>>();

        Defaults() {
        }
    }

    private static final class DayDef {
        private static final Pattern GROUP_SEARCH = Pattern.compile("([a-zA-Z_]*)([^a-zA-Z_]+)");
        private static final Pattern MINUTE_SEARCH = Pattern.compile("([+-]*[0-9]{4})/?([+-]*[0-9]{4})");
        private static final Pattern MINUTE_MATCH = Pattern.compile("(" + MINUTE_SEARCH.pattern() + ")*");
        private static final Pattern SECOND_SEARCH = Pattern.compile("([+-]*[0-9]{6})/?([+-]*[0-9]{6})");
        private static final Pattern SECOND_MATCH = Pattern.compile("(" + SECOND_SEARCH.pattern() + ")*");
        final TimeDef dayStart;
        final TimeDef dayEnd;
        final TimeDef resetTime;
        final SessionDef[] sessions;

        DayDef(String scheduleDefinition, TimeDef dayStart, TimeDef dayEnd, TimeDef resetTime, String def) {
            ArrayList<SessionDef> s = new ArrayList<SessionDef>();
            Matcher m = GROUP_SEARCH.matcher(def);
            int matched = 0;
            while (m.find()) {
                Matcher mm;
                SessionType type;
                String key;
                if (matched == m.start()) {
                    matched = m.end();
                }
                if ((key = m.group(1)).equalsIgnoreCase("rt")) {
                    resetTime = new TimeDef(scheduleDefinition, m.group(2));
                    continue;
                }
                SessionType sessionType = key.equalsIgnoreCase("d") ? SessionType.NO_TRADING : (key.equalsIgnoreCase("p") ? SessionType.PRE_MARKET : (key.equalsIgnoreCase("r") ? SessionType.REGULAR : (key.equalsIgnoreCase("a") ? SessionType.AFTER_MARKET : (type = key.equalsIgnoreCase("") ? SessionType.REGULAR : null))));
                if (type == null) {
                    throw new IllegalArgumentException("unknown session type in " + def + " in " + scheduleDefinition);
                }
                Matcher matcher = MINUTE_MATCH.matcher(m.group(2)).matches() ? MINUTE_SEARCH.matcher(m.group(2)) : (mm = SECOND_MATCH.matcher(m.group(2)).matches() ? SECOND_SEARCH.matcher(m.group(2)) : null);
                if (mm == null) {
                    throw new IllegalArgumentException("unmatched data in " + def + " in " + scheduleDefinition);
                }
                while (mm.find()) {
                    TimeDef td2;
                    TimeDef td1 = new TimeDef(scheduleDefinition, mm.group(1));
                    if (td1.compareTo(td2 = new TimeDef(scheduleDefinition, mm.group(2))) > 0) {
                        throw new IllegalArgumentException("illegal session period " + mm.group() + " in " + def + " in " + scheduleDefinition);
                    }
                    if (type == SessionType.NO_TRADING) {
                        dayStart = td1;
                        dayEnd = td2;
                    } else {
                        s.add(new SessionDef(type, td1, td2));
                    }
                    type = SessionType.REGULAR;
                }
            }
            if (matched != def.length()) {
                throw new IllegalArgumentException("unmatched data in " + def + " in " + scheduleDefinition);
            }
            if (resetTime == null) {
                resetTime = dayStart;
            }
            if (resetTime.compareTo(dayStart) < 0 || resetTime.compareTo(dayEnd) >= 0) {
                throw new IllegalArgumentException("illegal reset time " + resetTime + " for " + dayStart + " and " + dayEnd + " in " + scheduleDefinition);
            }
            this.dayStart = dayStart;
            this.dayEnd = dayEnd;
            this.resetTime = resetTime;
            if (s.isEmpty()) {
                s.add(new SessionDef(SessionType.NO_TRADING, dayStart, dayEnd));
            } else {
                for (int i = 1; i < s.size(); ++i) {
                    DayDef.fillGap(scheduleDefinition, s, i, ((SessionDef)s.get((int)(i - 1))).end, ((SessionDef)s.get((int)i)).start);
                }
                DayDef.fillGap(scheduleDefinition, s, 0, dayStart, ((SessionDef)s.get((int)0)).start);
                DayDef.fillGap(scheduleDefinition, s, s.size(), ((SessionDef)s.get((int)(s.size() - 1))).end, dayEnd);
            }
            this.sessions = s.toArray(new SessionDef[s.size()]);
        }

        private static void fillGap(String scheduleDefinition, List<SessionDef> s, int index, TimeDef start, TimeDef end) {
            if (start.compareTo(end) > 0) {
                throw new IllegalArgumentException("illegal session order at " + index + " for " + start + " and " + end + " in " + scheduleDefinition);
            }
            if (start.compareTo(end) < 0) {
                s.add(index, new SessionDef(SessionType.NO_TRADING, start, end));
            }
        }

        boolean isTrading() {
            for (SessionDef session : this.sessions) {
                if (session.type == SessionType.NO_TRADING) continue;
                return true;
            }
            return false;
        }
    }

    private static final class SessionDef {
        final SessionType type;
        final TimeDef start;
        final TimeDef end;

        SessionDef(SessionType type, TimeDef start, TimeDef end) {
            this.type = type;
            this.start = start;
            this.end = end;
        }

        Session create(Day day, Calendar calendar, long time, long startShift, long endShift) {
            long end;
            long start = this.start.get(calendar, time) + startShift;
            if (start > (end = this.end.get(calendar, time) + endShift)) {
                throw new IllegalArgumentException("start=" + start + " > end=" + end);
            }
            return new Session(day, this.type, start, end);
        }

        boolean isTooShort(Calendar calendar, long time, long earlyClose) {
            return this.start.get(calendar, time) >= this.end.get(calendar, time) - earlyClose;
        }

        public String toString() {
            return (Object)((Object)this.type) + "(" + this.start + "," + this.end + ")";
        }
    }

    private static final class TimeDef {
        final int day;
        final int hour;
        final int minute;
        final int second;

        TimeDef(TimeDef source, int dayShift) {
            this.day = source.day + dayShift;
            this.hour = source.hour;
            this.minute = source.minute;
            this.second = source.second;
        }

        TimeDef(String scheduleDefinition, String def) {
            int i;
            int d = 0;
            for (i = 0; i < def.length(); ++i) {
                if (def.charAt(i) == '+') {
                    ++d;
                    continue;
                }
                if (def.charAt(i) != '-') break;
                --d;
            }
            this.day = d;
            if (def.length() != i + 4 && def.length() != i + 6) {
                throw new IllegalArgumentException("unmatched data in " + def + " in " + scheduleDefinition);
            }
            this.hour = this.parse2(def, i);
            this.minute = this.parse2(def, i + 2);
            int n = this.second = def.length() > i + 4 ? this.parse2(def, i + 4) : 0;
            if (this.hour == 24 && this.minute == 0 && this.second == 0) {
                log.warn("Deprecated time spec " + def + " in " + scheduleDefinition + ". Preferred spec: +0000");
            } else if (this.hour >= 24 || this.minute >= 60 || this.second >= 60) {
                throw new IllegalArgumentException("illegal time " + def + " in " + scheduleDefinition);
            }
        }

        private int parse2(String s, int pos) {
            return (s.charAt(pos) - 48) * 10 + (s.charAt(pos + 1) - 48);
        }

        long offset() {
            return (long)this.day * 86400000L + (long)(this.hour * 3600000) + (long)(this.minute * 60000) + (long)(this.second * 1000);
        }

        long get(Calendar calendar, long localTime) {
            calendar.setTimeInMillis(localTime);
            calendar.add(6, this.day);
            calendar.set(11, this.hour);
            calendar.set(12, this.minute);
            calendar.set(13, this.second);
            calendar.set(14, 0);
            return calendar.getTime().getTime();
        }

        public int compareTo(TimeDef other) {
            if (this.day != other.day) {
                return this.day - other.day;
            }
            if (this.hour != other.hour) {
                return this.hour - other.hour;
            }
            if (this.minute != other.minute) {
                return this.minute - other.minute;
            }
            return this.second - other.second;
        }

        public String toString() {
            return this.day + ":" + this.hour + ":" + this.minute + ":" + this.second;
        }
    }
}

