/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.schedule;

import com.dxfeed.schedule.Day;
import java.io.Serializable;

public class DayFilter
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final DayFilter ANY = new DayFilter(0, null, null, null);
    public static final DayFilter TRADING = new DayFilter(0, null, null, true);
    public static final DayFilter NON_TRADING = new DayFilter(0, null, null, false);
    public static final DayFilter HOLIDAY = new DayFilter(0, true, null, null);
    public static final DayFilter SHORT_DAY = new DayFilter(0, null, true, null);
    public static final DayFilter MONDAY = new DayFilter(2, null, null, null);
    public static final DayFilter TUESDAY = new DayFilter(4, null, null, null);
    public static final DayFilter WEDNESDAY = new DayFilter(8, null, null, null);
    public static final DayFilter THURSDAY = new DayFilter(16, null, null, null);
    public static final DayFilter FRIDAY = new DayFilter(32, null, null, null);
    public static final DayFilter SATURDAY = new DayFilter(64, null, null, null);
    public static final DayFilter SUNDAY = new DayFilter(128, null, null, null);
    public static final DayFilter WEEK_DAY = new DayFilter(62, null, null, null);
    public static final DayFilter WEEK_END = new DayFilter(192, null, null, null);
    protected final int dayOfWeekMask;
    protected final Boolean holiday;
    protected final Boolean shortDay;
    protected final Boolean trading;

    public DayFilter(int dayOfWeekMask, Boolean holiday, Boolean shortDay, Boolean trading) {
        this.dayOfWeekMask = dayOfWeekMask;
        this.holiday = holiday;
        this.shortDay = shortDay;
        this.trading = trading;
    }

    public boolean accept(Day day) {
        return !(this.dayOfWeekMask != 0 && (this.dayOfWeekMask & 1 << day.getDayOfWeek()) == 0 || this.holiday != null && this.holiday.booleanValue() != day.isHoliday() || this.shortDay != null && this.shortDay.booleanValue() != day.isShortDay() || this.trading != null && this.trading.booleanValue() != day.isTrading());
    }

    public int hashCode() {
        return this.dayOfWeekMask + (this.holiday == null ? 0 : this.holiday.hashCode() * 23) + (this.shortDay == null ? 0 : this.shortDay.hashCode() * 29) + (this.trading == null ? 0 : this.trading.hashCode() * 239);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DayFilter)) {
            return false;
        }
        DayFilter filter = (DayFilter)object;
        return this.dayOfWeekMask == filter.dayOfWeekMask && this.holiday == filter.holiday && this.shortDay == filter.shortDay && this.trading == filter.trading;
    }

    public String toString() {
        return "DayFilter(" + this.dayOfWeekMask + ", " + this.holiday + ", " + this.shortDay + ", " + this.trading + ")";
    }
}

