/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.schedule;

import com.dxfeed.schedule.DayFilter;
import com.dxfeed.schedule.Schedule;
import com.dxfeed.schedule.Session;
import com.dxfeed.schedule.SessionFilter;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.NoSuchElementException;

public final class Day {
    private final Schedule schedule;
    private final int dayId;
    private final int yearMonthDay;
    private final boolean holiday;
    private final boolean shortDay;
    private final long resetTime;
    private boolean trading;
    private long startTime;
    private long endTime;
    private List<Session> sessions;
    long usageCounter;

    Day(Schedule schedule, int dayId, int yearMonthDay, boolean holiday, boolean shortDay, long resetTime) {
        this.schedule = schedule;
        this.dayId = dayId;
        this.yearMonthDay = yearMonthDay;
        this.holiday = holiday;
        this.shortDay = shortDay;
        this.resetTime = resetTime;
    }

    void setSessions(List<Session> sessions) {
        this.trading = false;
        int n = sessions.size();
        for (int i = 0; i < n; ++i) {
            if (!sessions.get(i).isTrading()) continue;
            this.trading = true;
        }
        this.startTime = sessions.get(0).getStartTime();
        this.endTime = sessions.get(sessions.size() - 1).getEndTime();
        this.sessions = sessions;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public int getDayId() {
        return this.dayId;
    }

    public int getYearMonthDay() {
        return this.yearMonthDay;
    }

    public int getYear() {
        return this.yearMonthDay / 10000;
    }

    public int getMonthOfYear() {
        return this.yearMonthDay / 100 % 100;
    }

    public int getDayOfMonth() {
        return this.yearMonthDay % 100;
    }

    public int getDayOfWeek() {
        return Schedule.dayOfWeek(this.dayId);
    }

    public boolean isHoliday() {
        return this.holiday;
    }

    public boolean isShortDay() {
        return this.shortDay;
    }

    public boolean isTrading() {
        return this.trading;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean containsTime(long time) {
        return time >= this.startTime && time < this.endTime;
    }

    public long getResetTime() {
        return this.resetTime;
    }

    public List<Session> getSessions() {
        return this.sessions;
    }

    public Session getSessionByTime(long time) {
        int n = this.sessions.size();
        for (int i = 0; i < n; ++i) {
            if (!this.sessions.get(i).containsTime(time)) continue;
            return this.sessions.get(i);
        }
        throw new NoSuchElementException("could not find session in " + this.yearMonthDay + " for " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(time));
    }

    public Session getFirstSession(SessionFilter filter) {
        Session session = this.findFirstSession(filter);
        if (session != null) {
            return session;
        }
        throw new NoSuchElementException("could not find session in " + this.yearMonthDay + " for " + filter);
    }

    public Session getLastSession(SessionFilter filter) {
        Session session = this.findLastSession(filter);
        if (session != null) {
            return session;
        }
        throw new NoSuchElementException("could not find session in " + this.yearMonthDay + " for " + filter);
    }

    public Session findFirstSession(SessionFilter filter) {
        int n = this.sessions.size();
        for (int i = 0; i < n; ++i) {
            if (!filter.accept(this.sessions.get(i))) continue;
            return this.sessions.get(i);
        }
        return null;
    }

    public Session findLastSession(SessionFilter filter) {
        int i = this.sessions.size();
        while (--i >= 0) {
            if (!filter.accept(this.sessions.get(i))) continue;
            return this.sessions.get(i);
        }
        return null;
    }

    public Day getPrevDay(DayFilter filter) {
        Day day = this.findPrevDay(filter);
        if (day != null) {
            return day;
        }
        throw new NoSuchElementException("could not find prev day before " + this.yearMonthDay + " for " + filter);
    }

    public Day getNextDay(DayFilter filter) {
        Day day = this.findNextDay(filter);
        if (day != null) {
            return day;
        }
        throw new NoSuchElementException("could not find next day after " + this.yearMonthDay + " for " + filter);
    }

    public Day findPrevDay(DayFilter filter) {
        for (int k = 1; k <= 366; ++k) {
            Day day = this.schedule.getDayById(this.dayId - k);
            if (!filter.accept(day)) continue;
            return day;
        }
        return null;
    }

    public Day findNextDay(DayFilter filter) {
        for (int k = 1; k <= 366; ++k) {
            Day day = this.schedule.getDayById(this.dayId + k);
            if (!filter.accept(day)) continue;
            return day;
        }
        return null;
    }

    public int hashCode() {
        return this.schedule.hashCode() + this.dayId;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Day)) {
            return false;
        }
        Day day = (Day)object;
        return this.schedule.equals(day.schedule) && this.dayId == day.dayId;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "Day(" + this.yearMonthDay + ", " + this.trading + ", " + sdf.format(this.startTime) + ", " + sdf.format(this.endTime) + ", " + sdf.format(this.resetTime) + ")";
    }
}

