/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.promise;

import com.dxfeed.promise.Promise;
import com.dxfeed.promise.PromiseHandler;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

public final class Promises {
    private Promises() {
    }

    public static Promise<Void> allOf(Collection<? extends Promise<?>> promises) {
        return Promises.aggregationImpl(promises.toArray(new Promise[promises.size()]), false);
    }

    public static Promise<Void> allOf(Promise<?> ... promises) {
        return Promises.aggregationImpl((Promise[])promises.clone(), false);
    }

    public static <T> Promise<T> anyOf(Collection<? extends Promise<T>> promises) {
        return Promises.aggregationImpl(promises.toArray(new Promise[promises.size()]), true);
    }

    public static <T> Promise<T> anyOf(Promise<T> ... promises) {
        return Promises.aggregationImpl((Promise[])promises.clone(), true);
    }

    private static Promise aggregationImpl(Promise[] promises, boolean any) {
        Promise result = new Promise();
        if (promises.length == 0) {
            result.complete(null);
            return result;
        }
        AtomicInteger count = new AtomicInteger();
        PromiseHandler handler = promise -> {
            if (count.incrementAndGet() == (any ? 1 : promises.length)) {
                if (result.isDone()) {
                    return;
                }
                if (any) {
                    if (promise.hasException()) {
                        result.completeExceptionally(promise.getException());
                    } else {
                        result.complete(promise.getResult());
                    }
                } else {
                    result.complete(null);
                }
            }
        };
        for (Promise promise2 : promises) {
            promise2.whenDone(handler);
        }
        result.whenDone(promise -> {
            for (Promise p : promises) {
                p.cancelImpl("aggregated result promise had completed");
            }
        });
        return result;
    }
}

