/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.model.market;

import com.dxfeed.event.market.Scope;

public enum OrderBookModelFilter {
    COMPOSITE(Scope.COMPOSITE),
    REGIONAL(Scope.REGIONAL),
    AGGREGATE(Scope.AGGREGATE),
    ORDER(Scope.ORDER),
    COMPOSITE_REGIONAL(Scope.COMPOSITE, Scope.REGIONAL),
    COMPOSITE_REGIONAL_AGGREGATE(Scope.COMPOSITE, Scope.REGIONAL, Scope.AGGREGATE),
    ALL(Scope.values());

    private final int filter;

    private OrderBookModelFilter(Scope ... scopes) {
        int result = 0;
        for (Scope scope : scopes) {
            result |= 1 << scope.getCode();
        }
        this.filter = result;
    }

    public boolean allowScope(Scope scope) {
        return (this.filter & 1 << scope.getCode()) != 0;
    }
}

