/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.model.market;

import com.devexperts.util.SystemProperties;
import com.dxfeed.api.DXFeed;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import com.dxfeed.model.AbstractIndexedEventModel;
import com.dxfeed.model.ObservableListModel;
import com.dxfeed.model.market.CheckedTreeList;
import com.dxfeed.model.market.OrderBookCorrector;
import com.dxfeed.model.market.OrderBookList;
import com.dxfeed.model.market.OrderBookModelFilter;
import com.dxfeed.model.market.OrderBookModelListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;

public final class OrderBookModel
implements AutoCloseable {
    private final IndexedOrderModel indexedEvents = new IndexedOrderModel();
    private final OrderBookList buyOrders = new OrderBookList((Comparator<? super Order>)BUY_COMPARATOR);
    private final OrderBookList sellOrders = new OrderBookList((Comparator<? super Order>)SELL_COMPARATOR);
    private final List<OrderBookModelListener> listeners = new CopyOnWriteArrayList<OrderBookModelListener>();
    private final OrderBookModelListener.Change change = new OrderBookModelListener.Change(this);
    private OrderBookModelFilter filter = OrderBookModelFilter.ALL;
    private int lotSize = 1;
    private static final boolean CORRECT = SystemProperties.getBooleanProperty(OrderBookModel.class, "correct", false);
    private static final long KEEP_TTL = (long)SystemProperties.getIntProperty(OrderBookModel.class, "keepTTL", 86400) * 1000L;
    private static final long FLIP_TTL = (long)SystemProperties.getIntProperty(OrderBookModel.class, "flipTTL", 60) * 1000L;
    private OrderBookCorrector corrector;
    private static final Comparator<Order> ORDER_COMPARATOR = (o1, o2) -> {
        boolean ind2;
        boolean ind1 = o1.getScope() == Scope.ORDER;
        boolean bl = ind2 = o2.getScope() == Scope.ORDER;
        if (ind1 && ind2) {
            int c = OrderBookModel.compareLong(o1.getTimeSequence(), o2.getTimeSequence());
            if (c != 0) {
                return c;
            }
            c = OrderBookModel.compareLong(o1.getIndex(), o2.getIndex());
            return c;
        }
        if (ind1) {
            return 1;
        }
        if (ind2) {
            return -1;
        }
        int c = Double.compare(o2.getSizeAsDouble(), o1.getSizeAsDouble());
        if (c != 0) {
            return c;
        }
        c = OrderBookModel.compareLong(o1.getTimeSequence(), o2.getTimeSequence());
        if (c != 0) {
            return c;
        }
        c = o1.getScope().getCode() - o2.getScope().getCode();
        if (c != 0) {
            return c;
        }
        c = o1.getExchangeCode() - o2.getExchangeCode();
        if (c != 0) {
            return c;
        }
        c = OrderBookModel.compareString(o1.getMarketMaker(), o2.getMarketMaker());
        if (c != 0) {
            return c;
        }
        c = OrderBookModel.compareLong(o1.getIndex(), o2.getIndex());
        return c;
    };
    private static final Comparator<Order> BUY_COMPARATOR = (o1, o2) -> o1.getPrice() < o2.getPrice() ? 1 : (o1.getPrice() > o2.getPrice() ? -1 : ORDER_COMPARATOR.compare((Order)o1, (Order)o2));
    private static final Comparator<Order> SELL_COMPARATOR = (o1, o2) -> o1.getPrice() < o2.getPrice() ? -1 : (o1.getPrice() > o2.getPrice() ? 1 : ORDER_COMPARATOR.compare((Order)o1, (Order)o2));

    public OrderBookModel() {
        this.buyOrders.setFilter(this.filter);
        this.sellOrders.setFilter(this.filter);
    }

    public void attach(DXFeed feed) {
        this.indexedEvents.attach(feed);
    }

    public void detach(DXFeed feed) {
        this.indexedEvents.detach(feed);
    }

    @Override
    public void close() {
        this.indexedEvents.close();
        this.buyOrders.close();
        this.sellOrders.close();
        this.listeners.clear();
    }

    public Executor getExecutor() {
        return this.indexedEvents.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.indexedEvents.setExecutor(executor);
    }

    public void clear() {
        this.setSymbol(null);
    }

    public OrderBookModelFilter getFilter() {
        return this.filter;
    }

    public void setFilter(OrderBookModelFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        if (this.filter != filter) {
            this.filter = filter;
            this.buyOrders.setFilter(filter);
            this.sellOrders.setFilter(filter);
            this.updateAllOrders(1, 1);
        }
    }

    public String getSymbol() {
        return (String)this.indexedEvents.getSymbol();
    }

    public void setSymbol(String symbol) {
        if (Objects.equals(symbol, this.getSymbol())) {
            return;
        }
        if (CORRECT) {
            this.corrector = symbol != null && (symbol.startsWith("/") || symbol.startsWith("./") || symbol.startsWith("=")) ? new OrderBookCorrector(KEEP_TTL, FLIP_TTL, symbol) : null;
        }
        this.indexedEvents.setSymbol(symbol);
    }

    public int getLotSize() {
        return this.lotSize;
    }

    public void setLotSize(int lotSize) {
        if (lotSize < 1) {
            throw new IllegalArgumentException("Invalid lot size: " + lotSize);
        }
        if (this.lotSize != lotSize) {
            int oldLotSize = this.lotSize;
            this.lotSize = lotSize;
            this.updateAllOrders(lotSize, oldLotSize);
        }
    }

    public ObservableListModel<Order> getBuyOrders() {
        return this.buyOrders;
    }

    public ObservableListModel<Order> getSellOrders() {
        return this.sellOrders;
    }

    public void addListener(OrderBookModelListener listener) {
        if (this.indexedEvents.isClosed()) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(OrderBookModelListener listener) {
        this.listeners.remove(listener);
    }

    private void updateAllOrders(int mul, int div) {
        this.beginChange();
        ListIterator<CheckedTreeList.Node<Order>> it = this.indexedEvents.entryListIterator();
        while (it.hasNext()) {
            CheckedTreeList.Node<Order> node = it.next();
            Order order = (Order)node.getValue();
            this.correctOrderSize(order, mul, div);
            OrderBookList book = this.getBookForOrder(order);
            book.deleteOrderNode(node);
            if (!OrderBookModel.shallAddToBook(order)) continue;
            book.insertOrderNode(node);
        }
        this.endChange();
    }

    private void beginChange() {
        this.buyOrders.beginChange();
        this.sellOrders.beginChange();
    }

    private void endChange() {
        boolean modelChanged = false;
        if (this.buyOrders.endChange()) {
            modelChanged = true;
        }
        if (this.sellOrders.endChange()) {
            modelChanged = true;
        }
        if (modelChanged) {
            this.fireModelChanged();
        }
    }

    private void fireModelChanged() {
        for (OrderBookModelListener listener : this.listeners) {
            listener.modelChanged(this.change);
        }
    }

    private void correctOrderSize(Order order, int mul, int div) {
        if (order.getScope() != Scope.ORDER && mul != div) {
            order.setSizeAsDouble(order.getSizeAsDouble() * (double)mul / (double)div);
        }
    }

    private OrderBookList getBookForOrder(Order order) {
        return order.getOrderSide() == Side.BUY ? this.buyOrders : this.sellOrders;
    }

    private static boolean shallAddToBook(Order order) {
        return order.hasSize() || order.getScope() == Scope.COMPOSITE;
    }

    private static int compareLong(long l1, long l2) {
        return l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
    }

    private static int compareString(String s1, String s2) {
        return s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
    }

    private class IndexedOrderModel
    extends AbstractIndexedEventModel<Order, CheckedTreeList.Node<Order>> {
        List<Order> corrections;

        IndexedOrderModel() {
            super(Order.class);
        }

        @Override
        protected boolean isClosed() {
            return super.isClosed();
        }

        @Override
        protected ListIterator<CheckedTreeList.Node<Order>> entryListIterator() {
            return super.entryListIterator();
        }

        @Override
        protected CheckedTreeList.Node<Order> createEntry() {
            return new CheckedTreeList.Node<Order>();
        }

        @Override
        protected boolean isSnapshotEnd(Order event) {
            if (super.isSnapshotEnd(event)) {
                return true;
            }
            long index = event.getIndex();
            return (int)index == 0 && (!OrderSource.isSpecialSourceId((int)(index >> 48)) || (char)(index >> 32) == '\u0000');
        }

        @Override
        protected void modelChanged(List<CheckedTreeList.Node<Order>> changedEntries) {
            OrderBookModel.this.beginChange();
            if (OrderBookModel.this.corrector != null && this.corrections == null) {
                this.corrections = new ArrayList<Order>();
            }
            for (CheckedTreeList.Node<Order> node : changedEntries) {
                boolean accept;
                Order order = (Order)node.getValue();
                if (order != null) {
                    if (OrderBookModel.this.corrector != null) {
                        OrderBookModel.this.corrector.acceptEvent(OrderBookCorrector.copy(order, 0.0), null);
                    }
                    OrderBookModel.this.getBookForOrder(order).deleteOrderNode(node);
                }
                node.commitChange();
                order = (Order)node.getValue();
                if (order == null) continue;
                boolean bl = accept = OrderBookModel.this.corrector == null || this.processCorrections(order);
                if (!OrderBookModel.shallAddToBook(order) || !accept) continue;
                OrderBookModel.this.correctOrderSize(order, OrderBookModel.this.lotSize, 1);
                OrderBookModel.this.getBookForOrder(order).insertOrderNode(node);
            }
            OrderBookModel.this.endChange();
        }

        private boolean processCorrections(Order order) {
            boolean accept = OrderBookModel.this.corrector.acceptEvent(order, this.corrections);
            for (Order correction : this.corrections) {
                assert (!correction.hasSize());
                OrderBookList correctBook = OrderBookModel.this.getBookForOrder(correction);
                CheckedTreeList.Node<Order> oldNode = correctBook.getNode(correction);
                if (oldNode == null) continue;
                correctBook.deleteOrderNode(oldNode);
            }
            this.corrections.clear();
            return accept;
        }
    }
}

