/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.model.market;

import com.devexperts.util.IndexedSet;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Scope;
import com.dxfeed.model.ObservableListModel;
import com.dxfeed.model.ObservableListModelListener;
import com.dxfeed.model.market.CheckedTreeList;
import com.dxfeed.model.market.OrderBookModelFilter;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class OrderBookList
extends CheckedTreeList<Order>
implements ObservableListModel<Order> {
    private static final boolean DEBUG_TREE = false;
    private volatile boolean closed;
    private final List<ObservableListModelListener<? super Order>> listeners = new CopyOnWriteArrayList<ObservableListModelListener<? super Order>>();
    private OrderBookModelFilter filter;
    private boolean modelChanged;
    private final ObservableListModelListener.Change<Order> change = new ObservableListModelListener.Change<Order>(this);
    private CheckedTreeList.Node<Order> composite;
    private int nonCompositeCount;
    private CheckedTreeList.Node<Order>[] regionals = new CheckedTreeList.Node[128];
    private IndexedSet<String, MMIDEntry>[] aggregates = new IndexedSet[128];

    protected OrderBookList(Comparator<? super Order> c) {
        super(c);
    }

    void close() {
        this.closed = true;
        this.listeners.clear();
    }

    @Override
    public void addListener(ObservableListModelListener<? super Order> listener) {
        if (this.closed) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ObservableListModelListener<? super Order> listener) {
        this.listeners.remove(listener);
    }

    protected void setFilter(OrderBookModelFilter filter) {
        this.filter = filter;
    }

    @Override
    public void clear() {
        this.clearFilters();
        super.clear();
        this.modelChanged = true;
    }

    protected void clearFilters() {
        this.composite = null;
        this.nonCompositeCount = 0;
        for (int i = 0; i < 128; ++i) {
            this.regionals[i] = null;
            if (this.aggregates[i] == null) continue;
            this.aggregates[i].clear();
        }
    }

    protected CheckedTreeList.Node<Order> insertOrder(Order value) {
        return this.insertOrderNode(new CheckedTreeList.Node<Order>(value));
    }

    protected CheckedTreeList.Node<Order> insertOrderNode(CheckedTreeList.Node<Order> node) {
        this.insertNode(node);
        CheckedTreeList.Node<Order> oldNode = this.checkNode(node);
        if (oldNode != null && this.uncheck(oldNode) && ((Order)oldNode.getValue()).getScope() != Scope.COMPOSITE) {
            --this.nonCompositeCount;
        }
        this.modelChanged = true;
        return node;
    }

    protected void deleteOrderNode(CheckedTreeList.Node<Order> node) {
        if (node.isRemoved()) {
            return;
        }
        CheckedTreeList.Node<Order> newNode = this.uncheckNode(node);
        this.deleteNode(node);
        if (newNode != null && this.check(newNode) && ((Order)newNode.getValue()).getScope() != Scope.COMPOSITE) {
            ++this.nonCompositeCount;
        }
        this.modelChanged = true;
    }

    protected CheckedTreeList.Node<Order> updateOrderNode(CheckedTreeList.Node<Order> node) {
        this.deleteOrderNode(node);
        return this.insertOrderNode(node);
    }

    protected void beginChange() {
        this.modelChanged = false;
    }

    protected boolean endChange() {
        if (!this.modelChanged) {
            return false;
        }
        this.fireModelChanged();
        return true;
    }

    protected void fireModelChanged() {
        for (ObservableListModelListener<? super Order> listener : this.listeners) {
            listener.modelChanged(this.change);
        }
    }

    protected CheckedTreeList.Node<Order> checkNode(CheckedTreeList.Node<Order> node) {
        String marketMaker;
        MMIDEntry entry2;
        Scope scope = ((Order)node.getValue()).getScope();
        if (!this.filter.allowScope(scope)) {
            return null;
        }
        if (scope == Scope.COMPOSITE) {
            this.composite = node;
            if (this.nonCompositeCount == 0) {
                this.check(node);
            }
            return null;
        }
        char exchangeCode = ((Order)node.getValue()).getExchangeCode();
        IndexedSet<String, MMIDEntry> aggregate = this.aggregates[exchangeCode];
        if (scope == Scope.REGIONAL) {
            this.regionals[exchangeCode] = node;
            if (aggregate == null || aggregate.isEmpty()) {
                this.check(node);
                ++this.nonCompositeCount;
            }
            return this.composite;
        }
        if (aggregate == null) {
            this.aggregates[exchangeCode] = aggregate = IndexedSet.create(entry -> entry.mmid);
        }
        if ((entry2 = aggregate.getByKey(marketMaker = ((Order)node.getValue()).getMarketMaker())) == null) {
            entry2 = aggregate.putIfAbsentAndGet(new MMIDEntry(marketMaker));
        }
        CheckedTreeList.Node<Order> regional = this.regionals[exchangeCode];
        if (scope == Scope.AGGREGATE) {
            entry2.aggregate = node;
            if (entry2.orderCount == 0) {
                this.check(node);
                ++this.nonCompositeCount;
            }
            return regional != null ? regional : this.composite;
        }
        if (scope == Scope.ORDER) {
            ++entry2.orderCount;
            this.check(node);
            ++this.nonCompositeCount;
            return entry2.aggregate != null ? entry2.aggregate : (regional != null ? regional : this.composite);
        }
        return null;
    }

    protected CheckedTreeList.Node<Order> uncheckNode(CheckedTreeList.Node<Order> node) {
        boolean checked = this.uncheck(node);
        Scope scope = ((Order)node.getValue()).getScope();
        if (scope == Scope.COMPOSITE) {
            this.composite = null;
            return null;
        }
        if (checked) {
            assert (this.nonCompositeCount > 0);
            --this.nonCompositeCount;
        }
        char exchangeCode = ((Order)node.getValue()).getExchangeCode();
        if (scope == Scope.REGIONAL) {
            this.regionals[exchangeCode] = null;
            return !checked ? null : (this.nonCompositeCount == 0 ? this.composite : null);
        }
        IndexedSet<String, MMIDEntry> aggregate = this.aggregates[exchangeCode];
        if (aggregate == null) {
            return null;
        }
        String marketMaker = ((Order)node.getValue()).getMarketMaker();
        MMIDEntry entry = aggregate.getByKey(marketMaker);
        if (entry == null) {
            return null;
        }
        CheckedTreeList.Node<Order> regional = this.regionals[exchangeCode];
        if (scope == Scope.AGGREGATE) {
            entry.aggregate = null;
            if (entry.orderCount == 0) {
                aggregate.removeKey(marketMaker);
            }
            return !checked ? null : (regional != null ? regional : (this.nonCompositeCount == 0 ? this.composite : null));
        }
        if (scope == Scope.ORDER) {
            if (checked) {
                --entry.orderCount;
            }
            assert (entry.orderCount >= 0);
            if (entry.orderCount == 0 && entry.aggregate == null) {
                aggregate.removeKey(marketMaker);
            }
            return !checked ? null : (entry.orderCount > 0 ? null : (entry.aggregate != null ? entry.aggregate : (regional != null ? regional : (this.nonCompositeCount == 0 ? this.composite : null))));
        }
        return null;
    }

    private static class MMIDEntry {
        final String mmid;
        CheckedTreeList.Node<Order> aggregate;
        int orderCount;

        MMIDEntry(String mmid) {
            this.mmid = mmid == null ? "" : mmid;
        }
    }
}

