/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.model.market;

import com.devexperts.util.IndexedSet;
import com.devexperts.util.SynchronizedIndexedSet;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedEventListener;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderBase;
import com.dxfeed.event.market.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class OrderBookCorrector {
    private final DXFeedSubscription<Order> subscription = new DXFeedSubscription<Order>(Order.class);
    private final SynchronizedIndexedSet<String, Book> data = SynchronizedIndexedSet.create(book -> book.symbol);
    private final List<DXFeedEventListener<Order>> listeners = new CopyOnWriteArrayList<DXFeedEventListener<Order>>();
    private final long keepTTL;
    private final long flipTTL;

    public OrderBookCorrector(DXFeed feed) {
        this(feed, 86400000L, 60000L);
    }

    public OrderBookCorrector(DXFeed feed, long keepTTL, long flipTTL) {
        this.keepTTL = keepTTL;
        this.flipTTL = flipTTL;
        feed.attachSubscription(this.subscription);
        this.subscription.addEventListener(new DXFeedEventListener<Order>(){

            @Override
            public void eventsReceived(List<Order> events) {
                OrderBookCorrector.this.processEvents(events);
            }
        });
    }

    OrderBookCorrector(long keepTTL, long flipTTL, String symbol) {
        this.keepTTL = keepTTL;
        this.flipTTL = flipTTL;
        this.setSymbols(symbol);
    }

    public void close() {
        this.subscription.close();
        this.data.clear();
        this.listeners.clear();
    }

    public void setSymbols(Collection<String> symbols) {
        for (String symbol : symbols) {
            this.data.putIfAbsentAndGet(new Book(symbol));
        }
        IndexedSet<String, String> set = new IndexedSet<String, String>(symbols);
        Iterator it = this.data.iterator();
        while (it.hasNext()) {
            if (set.containsKey(((Book)it.next()).symbol)) continue;
            it.remove();
        }
        this.subscription.setSymbols(symbols);
    }

    public void setSymbols(String ... symbols) {
        this.setSymbols(Arrays.asList(symbols));
    }

    public void addEventListener(DXFeedEventListener<Order> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    public void removeEventListener(DXFeedEventListener<Order> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.remove(listener);
    }

    boolean acceptEvent(Order order, List<Order> corrections) {
        Book book = (Book)this.data.getByKey(order.getEventSymbol());
        if (book == null) {
            return true;
        }
        if (order.getScope() != Scope.AGGREGATE) {
            return true;
        }
        if (!order.hasSize()) {
            book.orders.removeKey(order.getIndex());
            return true;
        }
        for (Order better : book.orders) {
            if (!(better.getIndex() != order.getIndex() && better.getSizeAsDouble() > 0.0 && OrderBookCorrector.sameSlot(better, order) && better.getTime() > order.getTime() || better.getTime() > order.getTime() + this.keepTTL) && (!OrderBookCorrector.bidAskFlip(better, order) || better.getTime() <= order.getTime() + this.flipTTL)) continue;
            Order old = book.orders.put(OrderBookCorrector.copy(order, -order.getSizeAsDouble()));
            if (old != null && old.getSizeAsDouble() > 0.0) {
                corrections.add(OrderBookCorrector.copy(order, 0.0));
            }
            return false;
        }
        Order old = (Order)book.orders.getByKey(order.getIndex());
        if (old != null && old.getSizeAsDouble() < 0.0 && old.getOrderSide() == order.getOrderSide() && old.getPrice() == order.getPrice() && old.getTime() >= order.getTime()) {
            return false;
        }
        for (Order worse : book.orders) {
            if (!(worse.getIndex() != order.getIndex() && worse.getSizeAsDouble() > 0.0 && OrderBookCorrector.sameSlot(worse, order) && worse.getTime() <= order.getTime() || worse.getTime() <= order.getTime() - this.keepTTL) && (!OrderBookCorrector.bidAskFlip(worse, order) || worse.getTime() > order.getTime() - this.flipTTL)) continue;
            book.orders.put(OrderBookCorrector.copy(worse, -worse.getSizeAsDouble()));
            corrections.add(OrderBookCorrector.copy(worse, 0.0));
        }
        book.orders.put(order);
        return true;
    }

    private void processEvents(List<Order> events) {
        ArrayList<Order> filtered = new ArrayList<Order>(events.size() + 10);
        for (Order order : events) {
            if (!this.acceptEvent(order, filtered)) continue;
            filtered.add(order);
        }
        for (DXFeedEventListener dXFeedEventListener : this.listeners) {
            dXFeedEventListener.eventsReceived(filtered);
        }
    }

    private static boolean sameSlot(Order order1, Order order2) {
        return order1.getOrderSide() == order2.getOrderSide() && order1.getPrice() == order2.getPrice();
    }

    private static boolean bidAskFlip(Order order1, Order order2) {
        return order1.getOrderSide() != order2.getOrderSide() && Double.compare(order1.getPrice(), order2.getPrice()) * (order1.getOrderSide().getCode() - order2.getOrderSide().getCode()) <= 0;
    }

    static Order copy(Order old, double size) {
        Order order = new Order(old.getEventSymbol());
        order.setIndex(old.getIndex());
        order.setOrderSide(old.getOrderSide());
        order.setScope(old.getScope());
        order.setTime(old.getTime());
        order.setSequence(old.getSequence());
        order.setExchangeCode(old.getExchangeCode());
        order.setMarketMaker(old.getMarketMaker());
        order.setPrice(old.getPrice());
        order.setSizeAsDouble(size);
        return order;
    }

    private static final class Book {
        final String symbol;
        final SynchronizedIndexedSet<Long, Order> orders = SynchronizedIndexedSet.createLong(OrderBase::getIndex);

        Book(String symbol) {
            this.symbol = symbol;
        }
    }
}

