/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.model.market;

import com.dxfeed.model.AbstractIndexedEventModel;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class CheckedTreeList<E>
extends AbstractList<E> {
    private static final byte REMOVED = 0;
    private static final byte RED = 1;
    private static final byte BLACK = 2;
    private final Comparator<? super E> comparator;
    private final Node<E> nil = new Node();
    private Node<E> root;
    private int size;
    private int treeSize;
    private int modCount;

    CheckedTreeList(Comparator<? super E> c) {
        this.nil.parent = this.nil;
        this.nil.left = this.nil;
        this.nil.right = this.nil;
        this.nil.color = (byte)2;
        this.root = this.nil;
        this.size = 0;
        this.treeSize = 0;
        this.modCount = 0;
        this.comparator = c;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.treeSize = 0;
        this.root = this.nil;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        Node<E> node = this.getNodeByIndex(index);
        return node == this.nil ? null : (E)node.getValue();
    }

    @Override
    public boolean contains(Object value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public int indexOf(Object value) {
        return this.getIndex(value);
    }

    @Override
    public Iterator<E> iterator() {
        return new CheckedListIterator();
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    public Iterator<E> treeIterator() {
        return new TreeIterator();
    }

    public int treeSize() {
        return this.treeSize;
    }

    public E find(E value) {
        Node<E> node = this.getNode(value);
        return node == null ? null : (E)node.getValue();
    }

    public void insert(E value) {
        Node<E> node = new Node<E>(value);
        this.insertNode(node);
        this.check(node);
    }

    public E delete(E value) {
        Node<E> node = this.getNode(value);
        if (node == null) {
            return null;
        }
        Object oldValue = node.getValue();
        this.deleteNode(node);
        return (E)oldValue;
    }

    public boolean check(Node<E> node) {
        if (node.checked) {
            return false;
        }
        node.checked = true;
        this.incrementCount(node);
        return true;
    }

    public boolean uncheck(Node<E> node) {
        if (!node.checked) {
            return false;
        }
        node.checked = false;
        this.decrementCount(node);
        return true;
    }

    protected Node<E> getNode(E value) {
        Node<E> node = this.root;
        while (node != this.nil) {
            int cmp = this.comparator.compare(value, node.getValue());
            if (cmp == 0) {
                return node;
            }
            if (cmp < 0) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return null;
    }

    protected void insertNode(Node<E> newNode) {
        Node<E> parent;
        int cmp;
        newNode.left = this.nil;
        newNode.right = this.nil;
        newNode.childCount = 0;
        newNode.checked = false;
        newNode.color = (byte)2;
        Node<E> node = this.root;
        if (node == this.nil) {
            this.root = newNode;
            this.root.parent = this.nil;
            ++this.modCount;
            ++this.treeSize;
            return;
        }
        Object value = newNode.getValue();
        do {
            parent = node;
            cmp = this.comparator.compare(value, node.getValue());
            if (cmp != 0) continue;
            throw new IllegalArgumentException("node for value " + value + " is already present " + node.getValue());
        } while ((node = cmp < 0 ? node.left : node.right) != this.nil);
        node = newNode;
        assert (node != this.nil);
        node.parent = parent;
        if (cmp < 0) {
            parent.left = node;
        } else {
            parent.right = node;
        }
        ++this.modCount;
        ++this.treeSize;
        this.rebalanceAfterInsertion(node);
    }

    protected void deleteNode(Node<E> p) {
        Node replacement;
        ++this.modCount;
        --this.treeSize;
        if (p.left != this.nil && p.right != this.nil) {
            Node<E> s = this.successorNode(p);
            if (p.checked) {
                this.decrementCount(s.checked ? s : p);
            } else if (s.checked) {
                this.incrementCount(p);
                this.decrementCount(s);
            }
            this.swapForDeletion(p, s);
        } else if (p.checked) {
            this.decrementCount(p);
        }
        Node node = replacement = p.left != this.nil ? p.left : p.right;
        if (replacement != this.nil) {
            assert (replacement != this.nil);
            replacement.parent = p.parent;
            if (p.parent == this.nil) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = this.nil;
            p.right = p.parent;
            p.left = p.parent;
            if (p.color == 2) {
                this.rebalanceAfterDeletion(replacement);
            }
        } else if (p.parent == this.nil) {
            this.root = this.nil;
        } else {
            if (p.color == 2) {
                this.rebalanceAfterDeletion(p);
            }
            if (p.parent != this.nil) {
                if (p == p.parent.left) {
                    p.parent.left = this.nil;
                } else if (p == p.parent.right) {
                    p.parent.right = this.nil;
                }
                assert (p != this.nil);
                p.parent = this.nil;
            }
        }
        p.left = null;
        p.right = null;
        p.parent = null;
        p.color = 0;
    }

    protected int getIndex(Node<E> node) {
        if (!node.checked) {
            return -1;
        }
        int index = node.left.childCount;
        while (node != this.root) {
            Node parent = node.parent;
            if (parent.right == node) {
                index += parent.left.childCount + parent.nodeCount();
            }
            node = parent;
        }
        return index;
    }

    private Node<E> getNodeByIndex(int index) {
        Node<E> node = this.root;
        while (node != this.nil) {
            int leftCount = node.left.childCount;
            if (index == leftCount && node.checked) {
                return node;
            }
            if (index < leftCount) {
                node = node.left;
                continue;
            }
            index -= leftCount + node.nodeCount();
            node = node.right;
        }
        return this.nil;
    }

    private int getIndex(E value) {
        int index = 0;
        Node<E> node = this.root;
        while (node != this.nil) {
            index += node.left.childCount;
            int cmp = this.comparator.compare(value, node.getValue());
            if (cmp == 0) {
                return node.checked ? index : -1;
            }
            if (cmp < 0) {
                index -= node.left.childCount;
                node = node.left;
                continue;
            }
            index += node.nodeCount();
            node = node.right;
        }
        return -1;
    }

    private Node<E> firstNode() {
        Node<E> node = this.root;
        if (node != this.nil) {
            while (node.left != this.nil) {
                node = node.left;
            }
        }
        return node;
    }

    private Node<E> successorNode(Node<E> node) {
        if (node == this.nil) {
            return this.nil;
        }
        if (node.right != this.nil) {
            Node p = node.right;
            while (p.left != this.nil) {
                p = p.left;
            }
            return p;
        }
        Node p = node.parent;
        Node<E> child = node;
        while (p != this.nil && child == p.right) {
            child = p;
            p = p.parent;
        }
        return p;
    }

    private void incrementCount(Node<E> node) {
        ++this.modCount;
        ++this.size;
        while (node != this.nil) {
            ++node.childCount;
            node = node.parent;
        }
    }

    private void decrementCount(Node<E> node) {
        ++this.modCount;
        --this.size;
        while (node != this.nil) {
            --node.childCount;
            node = node.parent;
        }
    }

    private void rotateLeft(Node<E> p) {
        Node r = p.right;
        assert (r != this.nil);
        p.right = r.left;
        if (r.left != this.nil) {
            r.left.parent = p;
        }
        int rightCount = r.nodeCount() + r.right.childCount;
        int leftCount = p.nodeCount() + p.left.childCount;
        r.parent = p.parent;
        if (p.parent == this.nil) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
        p.childCount -= rightCount;
        r.childCount += leftCount;
    }

    private void rotateRight(Node<E> p) {
        Node l = p.left;
        assert (l != this.nil);
        p.left = l.right;
        if (l.right != this.nil) {
            l.right.parent = p;
        }
        int leftCount = l.nodeCount() + l.left.childCount;
        int rightCount = p.nodeCount() + p.right.childCount;
        l.parent = p.parent;
        if (p.parent == this.nil) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
        p.childCount -= leftCount;
        l.childCount += rightCount;
    }

    private void rebalanceAfterInsertion(Node<E> x) {
        x.color = 1;
        while (x != this.nil && x != this.root && x.parent.color == 1) {
            Node t;
            if (x.parent == x.parent.parent.left) {
                t = x.parent.parent.right;
                if (t.color == 1) {
                    x.parent.color = (byte)2;
                    t.color = (byte)2;
                    x.parent.parent.color = 1;
                    x = x.parent.parent;
                    continue;
                }
                if (x == x.parent.right) {
                    x = x.parent;
                    this.rotateLeft(x);
                }
                x.parent.color = (byte)2;
                x.parent.parent.color = 1;
                if (x.parent.parent == this.nil) continue;
                this.rotateRight(x.parent.parent);
                continue;
            }
            t = x.parent.parent.left;
            if (t.color == 1) {
                x.parent.color = (byte)2;
                t.color = (byte)2;
                x.parent.parent.color = 1;
                x = x.parent.parent;
                continue;
            }
            if (x == x.parent.left) {
                x = x.parent;
                this.rotateRight(x);
            }
            x.parent.color = (byte)2;
            x.parent.parent.color = 1;
            if (x.parent.parent == this.nil) continue;
            this.rotateLeft(x.parent.parent);
        }
        this.root.color = (byte)2;
    }

    private void swapChild(Node<E> child, Node<E> oldParent, Node<E> newParent) {
        if (child != this.nil && child.parent == oldParent) {
            child.parent = newParent;
        }
    }

    private void swapParent(Node<E> parent, Node<E> oldChild, Node<E> newChild) {
        if (parent == this.nil) {
            if (this.root == oldChild) {
                this.root = newChild;
            }
            return;
        }
        if (parent.left == oldChild) {
            parent.left = newChild;
        } else {
            parent.right = newChild;
        }
    }

    private void swapForDeletion(Node<E> p, Node<E> s) {
        this.swapParent(p.parent, p, s);
        if (p.right != s) {
            this.swapParent(s.parent, s, p);
        }
        this.swapChild(s.left, s, p);
        this.swapChild(s.right, s, p);
        this.swapChild(p.left, p, s);
        if (p.right != s) {
            this.swapChild(p.right, p, s);
        } else {
            p.right = p;
            assert (s != this.nil);
            s.parent = s;
        }
        Node parent = s.parent;
        assert (s != this.nil);
        s.parent = p.parent;
        assert (p != this.nil);
        p.parent = parent;
        Node left = s.left;
        s.left = p.left;
        p.left = left;
        Node right = s.right;
        s.right = p.right;
        p.right = right;
        int childCount = s.childCount;
        s.childCount = p.childCount;
        p.childCount = childCount;
        byte color = s.color;
        s.color = p.color;
        p.color = color;
    }

    private void rebalanceAfterDeletion(Node<E> x) {
        while (x != this.root && x.color == 2) {
            Node w;
            if (x == x.parent.left) {
                w = x.parent.right;
                if (w.color == 1) {
                    w.color = (byte)2;
                    x.parent.color = 1;
                    this.rotateLeft(x.parent);
                    w = x.parent.right;
                }
                if (w.left.color == 2 && w.right.color == 2) {
                    w.color = 1;
                    x = x.parent;
                    continue;
                }
                if (w.right.color == 2) {
                    w.left.color = (byte)2;
                    w.color = 1;
                    this.rotateRight(w);
                    w = x.parent.right;
                }
                w.color = x.parent.color;
                x.parent.color = (byte)2;
                w.right.color = (byte)2;
                this.rotateLeft(x.parent);
                x = this.root;
                continue;
            }
            w = x.parent.left;
            if (w.color == 1) {
                w.color = (byte)2;
                x.parent.color = 1;
                this.rotateRight(x.parent);
                w = x.parent.left;
            }
            if (w.right.color == 2 && w.left.color == 2) {
                w.color = 1;
                x = x.parent;
                continue;
            }
            if (w.left.color == 2) {
                w.right.color = (byte)2;
                w.color = 1;
                this.rotateLeft(w);
                w = x.parent.left;
            }
            w.color = x.parent.color;
            x.parent.color = (byte)2;
            w.left.color = (byte)2;
            this.rotateRight(x.parent);
            x = this.root;
        }
        x.color = (byte)2;
    }

    boolean validateTree() {
        assert (this.root != this.nil ^ this.treeSize == 0);
        assert (this.nil.parent == this.nil);
        assert (this.nil.left == this.nil);
        assert (this.nil.right == this.nil);
        assert (this.nil.childCount == 0);
        assert (!this.nil.checked);
        if (this.root != this.nil) {
            assert (this.root.parent == this.nil);
            assert (this.root.childCount == this.size);
            this.validateTree(this.root);
        }
        return true;
    }

    void validateTree(Node<E> node) {
        int childCount = node.nodeCount();
        if (node.left != this.nil) {
            assert (node.left.parent == node);
            assert (this.comparator.compare(node.left.getValue(), node.getValue()) < 0);
            childCount += node.left.childCount;
            this.validateTree(node.left);
        }
        if (node.right != this.nil) {
            assert (node.right.parent == node);
            assert (this.comparator.compare(node.getValue(), node.right.getValue()) < 0);
            childCount += node.right.childCount;
            this.validateTree(node.right);
        }
        assert (node.childCount >= 0);
        assert (node.childCount == childCount);
    }

    private class CheckedListIterator
    extends TreeListIterator {
        CheckedListIterator() {
            super(CheckedTreeList.this.getNodeByIndex(0));
        }

        @Override
        protected Node<E> nextNode(Node<E> node) {
            while ((node = CheckedTreeList.this.successorNode(node)) != CheckedTreeList.this.nil && !node.checked) {
            }
            return node;
        }
    }

    private class TreeIterator
    extends TreeListIterator {
        TreeIterator() {
            super(CheckedTreeList.this.firstNode());
        }

        @Override
        protected Node<E> nextNode(Node<E> node) {
            return CheckedTreeList.this.successorNode(node);
        }
    }

    private abstract class TreeListIterator
    implements Iterator<E> {
        int expectedModCount;
        Node<E> lastReturned;
        Node<E> next;

        TreeListIterator(Node<E> node) {
            this.expectedModCount = CheckedTreeList.this.modCount;
            this.lastReturned = CheckedTreeList.this.nil;
            this.next = node;
        }

        protected abstract Node<E> nextNode(Node<E> var1);

        @Override
        public boolean hasNext() {
            return this.next != CheckedTreeList.this.nil;
        }

        @Override
        public E next() {
            if (this.next == CheckedTreeList.this.nil) {
                throw new NoSuchElementException();
            }
            if (CheckedTreeList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = this.nextNode(this.next);
            return this.lastReturned.getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Node<E>
    extends AbstractIndexedEventModel.Entry<E> {
        Node<E> left;
        Node<E> right;
        Node<E> parent;
        int childCount;
        boolean checked;
        byte color;

        Node() {
        }

        Node(E value) {
            super(value);
        }

        int nodeCount() {
            return this.checked ? 1 : 0;
        }

        boolean isRemoved() {
            return this.color == 0;
        }

        public String toString() {
            if (this.left == this && this.right == this && this.parent == this && this.color == 2) {
                return "nil";
            }
            return this.getValue().toString();
        }
    }
}

