/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.model;

import com.dxfeed.event.IndexedEvent;
import com.dxfeed.model.AbstractIndexedEventModel;
import com.dxfeed.model.ObservableListModel;
import com.dxfeed.model.ObservableListModelListener;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class IndexedEventModel<E extends IndexedEvent<?>>
extends AbstractIndexedEventModel<E, AbstractIndexedEventModel.Entry<E>> {
    private final Events events = new Events();
    private final List<ObservableListModelListener<? super E>> listeners = new CopyOnWriteArrayList<ObservableListModelListener<? super E>>();
    private final ObservableListModelListener.Change<E> change = new ObservableListModelListener.Change(this.events);

    public IndexedEventModel(Class<? extends E> eventType) {
        super(eventType);
    }

    @Override
    public void close() {
        super.close();
        this.listeners.clear();
    }

    public ObservableListModel<E> getEventsList() {
        return this.events;
    }

    @Override
    protected AbstractIndexedEventModel.Entry<E> createEntry() {
        return new AbstractIndexedEventModel.Entry();
    }

    @Override
    protected void modelChanged(List<AbstractIndexedEventModel.Entry<E>> changedEntries) {
        changedEntries.forEach(AbstractIndexedEventModel.Entry::commitChange);
        for (ObservableListModelListener<E> listener : this.listeners) {
            listener.modelChanged(this.change);
        }
    }

    private class Events
    extends AbstractList<E>
    implements ObservableListModel<E> {
        private Events() {
        }

        @Override
        public int size() {
            return IndexedEventModel.this.size();
        }

        @Override
        public E get(int index) {
            return IndexedEventModel.this.get(index);
        }

        @Override
        public Iterator<E> iterator() {
            return IndexedEventModel.this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator() {
            return IndexedEventModel.this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return IndexedEventModel.this.listIterator(index);
        }

        @Override
        public void addListener(ObservableListModelListener<? super E> listener) {
            if (IndexedEventModel.this.isClosed()) {
                return;
            }
            IndexedEventModel.this.listeners.add(listener);
        }

        @Override
        public void removeListener(ObservableListModelListener<? super E> listener) {
            IndexedEventModel.this.listeners.remove(listener);
        }
    }
}

