/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.model;

import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedEventListener;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.impl.AbstractIndexedList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Executor;

public abstract class AbstractIndexedEventModel<E extends IndexedEvent<?>, N extends Entry<E>>
implements AutoCloseable {
    private final DXFeedSubscription<E> subscription;
    private final ArrayList<E> processEventsNow = new ArrayList();
    private final ArrayList<N> changedEntries = new ArrayList();
    private Source[] sources = new Source[1];
    private int nSources;
    private Object symbol;
    private int sizeLimit = Integer.MAX_VALUE;

    protected AbstractIndexedEventModel(Class<? extends E> eventType) {
        this.subscription = new DXFeedSubscription<E>(eventType);
        this.subscription.addEventListener(new Listener());
    }

    protected AbstractIndexedEventModel(DXFeed feed, Class<? extends E> eventType) {
        this(eventType);
        this.attach(feed);
    }

    public void attach(DXFeed feed) {
        feed.attachSubscription(this.subscription);
    }

    public void detach(DXFeed feed) {
        feed.detachSubscription(this.subscription);
    }

    protected boolean isClosed() {
        return this.subscription.isClosed();
    }

    @Override
    public void close() {
        this.subscription.close();
    }

    public Executor getExecutor() {
        return this.subscription.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.subscription.setExecutor(executor);
    }

    public void clear() {
        this.setSymbol(null);
    }

    public Object getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Object symbol) {
        if (Objects.equals(this.symbol, symbol)) {
            return;
        }
        if (this.symbol != null) {
            for (int i = 0; i < this.nSources; ++i) {
                this.sources[i].clearImpl();
            }
            this.notifyChanged(true);
        }
        this.symbol = symbol;
        if (symbol != null) {
            this.subscription.setSymbols(symbol);
        } else {
            this.subscription.clear();
        }
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        if (sizeLimit < 0) {
            throw new IllegalArgumentException();
        }
        this.sizeLimit = sizeLimit;
        this.enforceSizeLimit();
    }

    protected int size() {
        int size = 0;
        for (int i = 0; i < this.nSources; ++i) {
            size += this.sources[i].size();
        }
        return size;
    }

    protected E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int localIndex = index;
        for (int sourceIndex = 0; sourceIndex < this.nSources; ++sourceIndex) {
            Source source = this.sources[sourceIndex];
            int localSize = source.size();
            if (localIndex < localSize) {
                return (E)((IndexedEvent)((Entry)source.get((int)localIndex)).value);
            }
            localIndex -= localSize;
        }
        throw new IndexOutOfBoundsException();
    }

    protected ListIterator<E> listIterator() {
        return new Itr(false, 0, 0, 0);
    }

    protected ListIterator<E> listIterator(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int localIndex = index;
        for (int sourceIndex = 0; sourceIndex < this.nSources; ++sourceIndex) {
            Source source = this.sources[sourceIndex];
            int localSize = source.size();
            if (localIndex < localSize) {
                return new Itr(false, sourceIndex, localIndex, index);
            }
            localIndex -= localSize;
        }
        if (localIndex == 0) {
            return new Itr(false, this.nSources, 0, index);
        }
        throw new IndexOutOfBoundsException();
    }

    protected ListIterator<N> entryListIterator() {
        return new Itr(true, 0, 0, 0);
    }

    protected abstract N createEntry();

    protected abstract void modelChanged(List<N> var1);

    protected boolean isSnapshotEnd(E event) {
        return (event.getEventFlags() & 0x18) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChanged(boolean trimToSize) {
        if (this.changedEntries.isEmpty()) {
            return;
        }
        try {
            this.modelChanged(this.changedEntries);
        }
        finally {
            for (Entry entry : this.changedEntries) {
                entry.commitChange();
            }
            this.changedEntries.clear();
            if (trimToSize) {
                this.changedEntries.trimToSize();
            }
        }
    }

    private Source getSourceById(int sourceId) {
        Source source;
        int i = 0;
        int j = this.nSources;
        while (i < j) {
            int m = i + j >> 1;
            Source mSource = this.sources[m];
            int mSourceId = mSource.sourceId;
            if (sourceId < mSourceId) {
                j = m;
                continue;
            }
            if (sourceId > mSourceId) {
                i = m + 1;
                continue;
            }
            return mSource;
        }
        if (this.nSources == this.sources.length) {
            this.sources = Arrays.copyOf(this.sources, this.sources.length << 1);
        }
        System.arraycopy(this.sources, i, this.sources, i + 1, this.nSources - i);
        this.sources[i] = source = new Source(sourceId);
        ++this.nSources;
        return source;
    }

    private boolean processSnapshotAndTx(List<E> events) {
        Object expectedEventSymbol = this.getSymbol();
        if (expectedEventSymbol == null) {
            return false;
        }
        boolean trimToSize = false;
        Source source = null;
        for (IndexedEvent event : events) {
            if (!expectedEventSymbol.equals(event.getEventSymbol())) continue;
            int sourceId = event.getSource().id();
            if (source == null || source.sourceId != sourceId) {
                source = this.getSourceById(sourceId);
            }
            trimToSize |= source.processSnapshotAndTx(event);
        }
        return trimToSize;
    }

    private void processEventsNow() {
        Source source = null;
        for (IndexedEvent event : this.processEventsNow) {
            int sourceId = event.getSource().id();
            if (source == null || source.sourceId != sourceId) {
                source = this.getSourceById(sourceId);
            }
            source.processEvent(event);
        }
        this.enforceSizeLimit();
    }

    private void enforceSizeLimit() {
        int sourceIndex = 0;
        for (int size = this.size(); size > this.sizeLimit; --size) {
            while (this.sources[sourceIndex].isEmpty()) {
                ++sourceIndex;
            }
            this.sources[sourceIndex].removeImpl(0);
        }
    }

    public static class Entry<V> {
        V value;
        V newValue;
        boolean changed;

        public Entry() {
        }

        public Entry(V value) {
            this.value = value;
            this.newValue = value;
        }

        public V getValue() {
            return this.value;
        }

        public V getNewValue() {
            return this.newValue;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void commitChange() {
            if (!this.changed) {
                return;
            }
            this.value = this.newValue;
            this.changed = false;
        }
    }

    private class Itr
    implements ListIterator {
        final boolean entryIterator;
        int sourceIndex;
        int localIndex;
        int index;

        Itr(boolean entryIterator, int sourceIndex, int localIndex, int index) {
            this.entryIterator = entryIterator;
            this.sourceIndex = sourceIndex;
            this.localIndex = localIndex;
            this.index = index;
            this.initNext();
        }

        private void initNext() {
            while (this.sourceIndex < AbstractIndexedEventModel.this.nSources && this.localIndex >= AbstractIndexedEventModel.this.sources[this.sourceIndex].size()) {
                ++this.sourceIndex;
                this.localIndex = 0;
            }
        }

        private void initPrevious() {
            while (this.localIndex < 0 && this.sourceIndex > 0) {
                --this.sourceIndex;
                this.localIndex = AbstractIndexedEventModel.this.sources[this.sourceIndex].size() - 1;
            }
        }

        private Object current() {
            Source source = AbstractIndexedEventModel.this.sources[this.sourceIndex];
            Entry entry = (Entry)source.get(this.localIndex);
            return this.entryIterator ? entry : entry.value;
        }

        @Override
        public boolean hasNext() {
            return this.sourceIndex < AbstractIndexedEventModel.this.nSources;
        }

        @Override
        public Object next() {
            if (this.sourceIndex >= AbstractIndexedEventModel.this.nSources) {
                throw new NoSuchElementException();
            }
            Object result = this.current();
            ++this.localIndex;
            ++this.index;
            this.initNext();
            return result;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        public Object previous() {
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            --this.localIndex;
            --this.index;
            this.initPrevious();
            return this.current();
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private class Listener
    implements DXFeedEventListener<E> {
        private Listener() {
        }

        @Override
        public void eventsReceived(List<E> events) {
            boolean trimToSize = AbstractIndexedEventModel.this.processSnapshotAndTx(events);
            if (!AbstractIndexedEventModel.this.processEventsNow.isEmpty()) {
                AbstractIndexedEventModel.this.processEventsNow();
                AbstractIndexedEventModel.this.processEventsNow.clear();
                if (trimToSize) {
                    AbstractIndexedEventModel.this.processEventsNow.trimToSize();
                }
            }
            AbstractIndexedEventModel.this.notifyChanged(trimToSize);
        }
    }

    private class Source
    extends AbstractIndexedList<N> {
        int sourceId;
        boolean snapshotPart;
        boolean snapshotFull;
        boolean tx;
        final ArrayList<E> pendingEvents = new ArrayList();

        Source(int sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        protected long getIndex(N entry) {
            return ((IndexedEvent)((Entry)entry).newValue).getIndex();
        }

        @Override
        protected void removed(N entry) {
            this.makeChanged(entry);
            ((Entry)entry).newValue = null;
        }

        private boolean processSnapshotAndTx(E event) {
            int eventFlags = event.getEventFlags();
            boolean bl = this.tx = (eventFlags & 1) != 0;
            if ((eventFlags & 4) != 0) {
                this.snapshotPart = true;
                this.snapshotFull = false;
                this.pendingEvents.clear();
            }
            if (this.snapshotPart && AbstractIndexedEventModel.this.isSnapshotEnd(event)) {
                this.snapshotPart = false;
                this.snapshotFull = true;
            }
            if (this.tx || this.snapshotPart) {
                this.pendingEvents.add(event);
                return false;
            }
            boolean trimToSize = this.snapshotFull;
            if (this.snapshotFull) {
                this.clearImpl();
                this.snapshotFull = false;
            }
            if (!this.pendingEvents.isEmpty()) {
                AbstractIndexedEventModel.this.processEventsNow.addAll(this.pendingEvents);
                this.pendingEvents.clear();
                if (trimToSize) {
                    this.pendingEvents.trimToSize();
                }
            }
            AbstractIndexedEventModel.this.processEventsNow.add(event);
            return trimToSize;
        }

        private void makeChanged(N entry) {
            if (((Entry)entry).changed) {
                return;
            }
            ((Entry)entry).changed = true;
            ((Entry)entry).newValue = ((Entry)entry).value;
            AbstractIndexedEventModel.this.changedEntries.add(entry);
        }

        void processEvent(E event) {
            Entry<Object> entry;
            long index;
            int a;
            boolean remove;
            boolean bl = remove = (event.getEventFlags() & 2) != 0;
            if (!remove) {
                this.growIfNeededImpl();
            }
            if ((a = this.findIndex(index = event.getIndex())) < 0 && remove) {
                return;
            }
            if (a >= 0) {
                entry = (Entry)this.get(a);
            } else {
                entry = AbstractIndexedEventModel.this.createEntry();
                this.insertImpl(-a - 1, entry);
            }
            this.makeChanged(entry);
            if (remove) {
                this.removeImpl(a);
            } else {
                event.setEventFlags(0);
                entry.newValue = event;
            }
        }
    }
}

