/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf.option;

import com.devexperts.util.DayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public final class OptionSeries<T>
implements Cloneable,
Comparable<OptionSeries<T>> {
    int expiration;
    int lastTrade;
    double multiplier;
    double spc;
    String additionalUnderlyings;
    String mmy;
    String optionType;
    String expirationStyle;
    String settlementStyle;
    String cfi;
    private final SortedMap<Double, T> calls = new TreeMap<Double, T>();
    private final SortedMap<Double, T> puts = new TreeMap<Double, T>();
    private List<Double> strikes;

    OptionSeries() {
        this.additionalUnderlyings = "";
        this.mmy = "";
        this.optionType = "";
        this.expirationStyle = "";
        this.settlementStyle = "";
        this.cfi = "";
    }

    OptionSeries(OptionSeries<T> other) {
        this.expiration = other.expiration;
        this.lastTrade = other.lastTrade;
        this.multiplier = other.multiplier;
        this.spc = other.spc;
        this.additionalUnderlyings = other.additionalUnderlyings;
        this.mmy = other.mmy;
        this.optionType = other.optionType;
        this.expirationStyle = other.expirationStyle;
        this.settlementStyle = other.settlementStyle;
        this.cfi = other.cfi;
    }

    public OptionSeries<T> clone() {
        OptionSeries<T> clone = new OptionSeries<T>(this);
        clone.calls.putAll(this.calls);
        clone.puts.putAll(this.puts);
        return clone;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public int getLastTrade() {
        return this.lastTrade;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public double getSPC() {
        return this.spc;
    }

    public String getAdditionalUnderlyings() {
        return this.additionalUnderlyings;
    }

    public String getMMY() {
        return this.mmy;
    }

    public String getOptionType() {
        return this.optionType;
    }

    public String getExpirationStyle() {
        return this.expirationStyle;
    }

    public String getSettlementStyle() {
        return this.settlementStyle;
    }

    public String getCFI() {
        return this.cfi;
    }

    public SortedMap<Double, T> getCalls() {
        return this.calls;
    }

    public SortedMap<Double, T> getPuts() {
        return this.puts;
    }

    public List<Double> getStrikes() {
        if (this.strikes == null) {
            TreeSet<Double> strikesSet = new TreeSet<Double>(this.calls.keySet());
            strikesSet.addAll(this.puts.keySet());
            this.strikes = new ArrayList<Double>(strikesSet);
        }
        return this.strikes;
    }

    public List<Double> getNStrikesAround(int n, double strike) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        List<Double> strikes = this.getStrikes();
        int i = Collections.binarySearch(strikes, strike);
        if (i < 0) {
            i = -i - 1;
        }
        int from = Math.max(0, i - n / 2);
        int to = Math.min(strikes.size(), from + n);
        return strikes.subList(from, to);
    }

    @Override
    public int compareTo(OptionSeries<T> o) {
        if (this.expiration < o.expiration) {
            return -1;
        }
        if (this.expiration > o.expiration) {
            return 1;
        }
        if (this.lastTrade < o.lastTrade) {
            return -1;
        }
        if (this.lastTrade > o.lastTrade) {
            return 1;
        }
        int i = Double.compare(this.multiplier, o.multiplier);
        if (i != 0) {
            return i;
        }
        i = Double.compare(this.spc, o.spc);
        if (i != 0) {
            return i;
        }
        i = this.additionalUnderlyings.compareTo(o.additionalUnderlyings);
        if (i != 0) {
            return i;
        }
        i = this.mmy.compareTo(o.mmy);
        if (i != 0) {
            return i;
        }
        i = this.optionType.compareTo(o.optionType);
        if (i != 0) {
            return i;
        }
        i = this.expirationStyle.compareTo(o.expirationStyle);
        if (i != 0) {
            return i;
        }
        i = this.settlementStyle.compareTo(o.settlementStyle);
        if (i != 0) {
            return i;
        }
        return this.cfi.compareTo(o.cfi);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptionSeries)) {
            return false;
        }
        OptionSeries that = (OptionSeries)o;
        return this.expiration == that.expiration && this.lastTrade == that.lastTrade && Double.compare(that.multiplier, this.multiplier) == 0 && Double.compare(that.spc, this.spc) == 0 && this.additionalUnderlyings.equals(that.additionalUnderlyings) && this.expirationStyle.equals(that.expirationStyle) && this.mmy.equals(that.mmy) && this.optionType.equals(that.optionType) && this.cfi.equals(that.cfi) && this.settlementStyle.equals(that.settlementStyle);
    }

    public int hashCode() {
        int result = this.expiration;
        result = 31 * result + this.lastTrade;
        long temp = this.multiplier != 0.0 ? Double.doubleToLongBits(this.multiplier) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.spc != 0.0 ? Double.doubleToLongBits(this.spc) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.additionalUnderlyings.hashCode();
        result = 31 * result + this.mmy.hashCode();
        result = 31 * result + this.optionType.hashCode();
        result = 31 * result + this.expirationStyle.hashCode();
        result = 31 * result + this.settlementStyle.hashCode();
        result = 31 * result + this.cfi.hashCode();
        return result;
    }

    void addOption(boolean isCall, double strike, T option) {
        SortedMap<Double, T> map;
        SortedMap<Double, T> sortedMap = map = isCall ? this.calls : this.puts;
        if (map.put(strike, option) == null) {
            this.strikes = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("expiration=").append(DayUtil.getYearMonthDayByDayId(this.expiration));
        if (this.lastTrade != 0) {
            sb.append(", lastTrade=").append(DayUtil.getYearMonthDayByDayId(this.lastTrade));
        }
        if (this.multiplier != 0.0) {
            sb.append(", multiplier=").append(this.multiplier);
        }
        if (this.spc != 0.0) {
            sb.append(", spc=").append(this.spc);
        }
        if (this.additionalUnderlyings.length() > 0) {
            sb.append(", additionalUnderlyings=").append(this.additionalUnderlyings);
        }
        if (this.mmy.length() > 0) {
            sb.append(", mmy=").append(this.mmy);
        }
        if (this.optionType.length() > 0) {
            sb.append(", optionType=").append(this.optionType);
        }
        if (this.expirationStyle.length() > 0) {
            sb.append(", expirationStyle=").append(this.expirationStyle);
        }
        if (this.settlementStyle.length() > 0) {
            sb.append(", settlementStyle=").append(this.settlementStyle);
        }
        sb.append(", cfi=").append(this.cfi);
        return sb.toString();
    }
}

